/*
 * Decompiled with CFR 0.152.
 */
package idx3d;

import idx3d.idx3d_Color;
import idx3d.idx3d_Math;
import idx3d.idx3d_Texture;

public class idx3d_TextureFactory {
    public static final float pi = (float)Math.PI;
    public static final float deg2rad = (float)Math.PI / 180;
    private static float[][] noiseBuffer;
    private static boolean noiseBufferInitialized;
    static int minx;
    static int maxx;
    static int miny;
    static int maxy;

    private static float interpolatedNoise(float f, float f2, int n) {
        int n2 = (int)f;
        int n3 = (int)f2;
        float f3 = f - (float)n2;
        float f4 = f2 - (float)n3;
        float f5 = idx3d_Math.interpolate(idx3d_TextureFactory.noise(n2, n3, n), idx3d_TextureFactory.noise(n2 + 1, n3, n), f3);
        float f6 = idx3d_Math.interpolate(idx3d_TextureFactory.noise(n2, n3 + 1, n), idx3d_TextureFactory.noise(n2 + 1, n3 + 1, n), f3);
        return idx3d_Math.interpolate(f5, f6, f4);
    }

    public static idx3d_Texture WOOD(int n, int n2, float f) {
        int[] nArray = new int[]{0x332211, 5386529, 0x996633};
        return idx3d_TextureFactory.GRAIN(n, n2, 0.5f, 3.0f * f, 3, 8, 1024).colorize(idx3d_Color.makeGradient(nArray, 1024));
    }

    private idx3d_TextureFactory() {
    }

    public static idx3d_Texture CHECKERBOARD(int n, int n2, int n3, int n4, int n5) {
        idx3d_Texture idx3d_Texture2 = new idx3d_Texture(n, n2);
        int n6 = 0;
        int n7 = 0;
        while (n7 < n2) {
            int n8 = 0;
            while (n8 < n) {
                idx3d_Texture2.pixel[n6++] = ((n8 >> n3) + (n7 >> n3) & 1) == 0 ? n5 : n4;
                ++n8;
            }
            ++n7;
        }
        return idx3d_Texture2;
    }

    private static float smoothNoise(int n, int n2, int n3) {
        return (idx3d_TextureFactory.noise(n - 1, n2 - 1, n3) + idx3d_TextureFactory.noise(n + 1, n2 - 1, n3) + idx3d_TextureFactory.noise(n - 1, n2 + 1, n3) + idx3d_TextureFactory.noise(n + 1, n2 + 1, n3)) / 16.0f + (idx3d_TextureFactory.noise(n - 1, n2, n3) + idx3d_TextureFactory.noise(n + 1, n2, n3) + idx3d_TextureFactory.noise(n, n2 - 1, n3) + idx3d_TextureFactory.noise(n, n2 + 1, n3)) / 8.0f + idx3d_TextureFactory.noise(n, n2, n3) / 4.0f;
    }

    private static float noise(int n, int n2, int n3) {
        return noiseBuffer[n3 & 3][n + n2 * 57 & 0x1FFF];
    }

    private static float noise(int n, int n2) {
        int n3 = n2 & 3;
        int n4 = n << 13 ^ n;
        if (n3 == 0) {
            return 1.0f - (float)(n4 * (n4 * n4 * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) * 9.313226E-10f;
        }
        if (n3 == 1) {
            return 1.0f - (float)(n4 * (n4 * n4 * 12497 + 604727) + 1345679039 & Integer.MAX_VALUE) * 9.313226E-10f;
        }
        if (n3 == 2) {
            return 1.0f - (float)(n4 * (n4 * n4 * 19087 + 659047) + 1345679627 & Integer.MAX_VALUE) * 9.313226E-10f;
        }
        return 1.0f - (float)(n4 * (n4 * n4 * 16267 + 694541) + 1345679501 & Integer.MAX_VALUE) * 9.313226E-10f;
    }

    public static idx3d_Texture RANDOM(int n, int n2) {
        int n3 = (int)idx3d_Math.random(2.0f, 6.0f);
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = idx3d_Color.random();
            ++n4;
        }
        float f = idx3d_Math.random(0.4f, 0.9f);
        float f2 = idx3d_Math.random(0.5f, 3.0f);
        int n5 = (int)idx3d_Math.random(1.0f, 7.0f);
        return idx3d_TextureFactory.PERLIN(n, n2, f, f2, n5, 1024).colorize(idx3d_Color.makeGradient(nArray, 1024));
    }

    public static idx3d_Texture SKY(int n, int n2, float f) {
        int[] nArray = new int[]{13209, 0xFFFFFF};
        return idx3d_TextureFactory.PERLIN(n, n2, 0.5f, 2.8f * f, 8, 1024).colorize(idx3d_Color.makeGradient(nArray, 1024));
    }

    public static idx3d_Texture MARBLE(int n, int n2, float f) {
        int[] nArray = new int[]{0x111111, 6905968, 0xFFFFFF};
        return idx3d_TextureFactory.WAVE(n, n2, 0.5f, 0.64f * f, 6, 1024).colorize(idx3d_Color.makeGradient(nArray, 1024));
    }

    public static idx3d_Texture WAVE(int n, int n2, float f, float f2, int n3, int n4) {
        idx3d_TextureFactory.initNoiseBuffer();
        idx3d_Texture idx3d_Texture2 = new idx3d_Texture(n, n2);
        int n5 = 0;
        float f3 = (float)(n > n2 ? n : n2) / f2;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = 0;
            while (n7 < n) {
                idx3d_Texture2.pixel[n5++] = (int)((double)n4 * (Math.sin(32.0f * idx3d_TextureFactory.perlin2d(n7, n6, f3, f, n3)) * 0.5 + 0.5));
                ++n7;
            }
            ++n6;
        }
        return idx3d_Texture2;
    }

    public static idx3d_Texture GRAIN(int n, int n2, float f, float f2, int n3, int n4, int n5) {
        idx3d_TextureFactory.initNoiseBuffer();
        idx3d_Texture idx3d_Texture2 = new idx3d_Texture(n, n2);
        int n6 = 0;
        float f3 = (float)(n > n2 ? n : n2) / f2;
        int n7 = 0;
        while (n7 < n2) {
            int n8 = 0;
            while (n8 < n) {
                float f4 = (float)n4 * idx3d_TextureFactory.perlin2d(n8, n7, f3, f, n3);
                idx3d_Texture2.pixel[n6++] = (int)((float)n5 * (f4 - (float)((int)f4)));
                ++n8;
            }
            ++n7;
        }
        return idx3d_Texture2;
    }

    public static idx3d_Texture PERLIN(int n, int n2, float f, float f2, int n3, int n4) {
        idx3d_TextureFactory.initNoiseBuffer();
        idx3d_Texture idx3d_Texture2 = new idx3d_Texture(n, n2);
        int n5 = 0;
        float f3 = (float)(n > n2 ? n : n2) / f2;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = 0;
            while (n7 < n) {
                idx3d_Texture2.pixel[n5++] = (int)((float)n4 * idx3d_TextureFactory.perlin2d(n7, n6, f3, f, n3));
                ++n7;
            }
            ++n6;
        }
        return idx3d_Texture2;
    }

    private static void initNoiseBuffer() {
        if (noiseBufferInitialized) {
            return;
        }
        noiseBuffer = new float[4][8192];
        int n = 0;
        do {
            int n2 = 0;
            do {
                idx3d_TextureFactory.noiseBuffer[n][n2] = idx3d_TextureFactory.noise(n2, n);
            } while (++n2 < 8192);
        } while (++n < 4);
        noiseBufferInitialized = true;
    }

    private static float perlin2d(float f, float f2, float f3, float f4, int n) {
        float f5 = 0.0f;
        float f6 = 1.0f / f3;
        float f7 = f4;
        float f8 = 0.0f;
        int n2 = 0;
        while (n2 < n) {
            f5 += f7 * idx3d_TextureFactory.interpolatedNoise(f * f6, f2 * f6, n2);
            f8 += f7;
            f7 *= f4;
            f6 *= 2.0f;
            ++n2;
        }
        return idx3d_Math.crop(f5 / f4 * 0.5f + 0.5f, 0.0f, 1.0f);
    }
}

