/*
 * Decompiled with CFR 0.152.
 */
package BioDynPackage;

import BioDynPackage.BioDyn;
import BioDynPackage.Environnement;
import BioDynPackage.MoteurInfluence;
import BioDynPackage.Reaxel;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedWriter;
import java.util.ArrayList;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JSlider;

public class MoteurInfluenceMigration
extends MoteurInfluence {
    private JSlider jSlider_k;
    public JEditorPane _description = new JEditorPane();
    double _proba_migrer = 0.5;
    boolean _inversion = false;
    int _dependance_distance = 0;
    public String TypeMigration = new String("Somme");
    public String Migrante = new String("");
    public String Objectif = new String("");

    public MoteurInfluenceMigration() {
        this.initComponents();
        this.button_move.setVisible(false);
        this.button_display_relations.setVisible(false);
        this.button_timer.setVisible(false);
        this.boxManipulated.setVisible(false);
        this.boxNames.setVisible(false);
        this.boxRelais.setVisible(false);
    }

    private void initComponents() {
        this.jSlider_k = new JSlider();
        this.setBackground(new Color(155, 251, 208));
        this.jSlider_k.setBackground(new Color(155, 251, 208));
        this.jSlider_k.setPaintLabels(true);
        this.jSlider_k.setPaintTicks(true);
        this.jSlider_k.setToolTipText("Modifie l'intensite de la migration");
        this.jSlider_k.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                MoteurInfluenceMigration.this.jSlider_kMouseDragged(evt);
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                MoteurInfluenceMigration.this.jSlider_kMouseMoved(evt);
            }
        });
        this.jSlider_k.addInputMethodListener(new InputMethodListener(){

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
                MoteurInfluenceMigration.this.jSlider_kCaretPositionChanged(evt);
            }

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
            }
        });
        this.add(this.jSlider_k);
        this.jSlider_k.setBounds(1, 26, 237, 38);
    }

    private void jSlider_kMouseDragged(MouseEvent evt) {
        this._proba_migrer = (double)this.jSlider_k.getValue() / 100.0;
        String str = this.getEtiquettes() + ", p=" + Double.valueOf(this._proba_migrer).toString();
        this.setTitre(str);
    }

    private void jSlider_kCaretPositionChanged(InputMethodEvent evt) {
        this._proba_migrer = (double)this.jSlider_k.getValue() / 100.0;
        String str = this.getEtiquettes() + ", p=" + Double.valueOf(this._proba_migrer).toString();
        this.setTitre(str);
    }

    private void jSlider_kMouseMoved(MouseEvent evt) {
    }

    @Override
    public void BioDynExec_Principale(String msg, ArrayList<BioDyn> lstManip) {
        super.BioDynExec_Principale(msg, lstManip);
        this.Influencer();
        this._env.decrementer_nb_processus_a_traiter();
    }

    void Influencer() {
        Environnement bd_ctrl = this._env;
        this.Simuler(bd_ctrl);
    }

    public void Simuler(Environnement bd_ctrl) {
        int j;
        int i;
        Reaxel c;
        int pos_in_list;
        if (this.TypeMigration.equals("Plus proche (borne)")) {
            for (pos_in_list = 0; pos_in_list < bd_ctrl._liste_reaxels.size(); ++pos_in_list) {
                Reaxel cube_copain;
                c = bd_ctrl._liste_reaxels.get(pos_in_list);
                if (c == null || !c._nom.equals(this.Migrante) || (cube_copain = this.plusProche(i = c._x, j = c._y, bd_ctrl)) == null) continue;
                double proba = this._proba_migrer;
                if (this._dependance_distance >= 1) {
                    double dist = this._env.distance(c, cube_copain);
                    proba /= Math.pow(dist, this._dependance_distance);
                }
                double intensite = 1.0 * proba;
                double angle = Math.atan2(cube_copain._y - j, cube_copain._x - i);
                if (!this._inversion) {
                    double[] dArray = bd_ctrl._matrice_migration_fx[i];
                    int n = j;
                    dArray[n] = dArray[n] + intensite * Math.cos(angle);
                    double[] dArray2 = bd_ctrl._matrice_migration_fy[i];
                    int n2 = j;
                    dArray2[n2] = dArray2[n2] + intensite * Math.sin(angle);
                    continue;
                }
                double[] dArray = bd_ctrl._matrice_migration_fx[i];
                int n = j;
                dArray[n] = dArray[n] + intensite * Math.cos(angle -= Math.PI);
                double[] dArray3 = bd_ctrl._matrice_migration_fy[i];
                int n3 = j;
                dArray3[n3] = dArray3[n3] + intensite * Math.sin(angle);
            }
        }
        if (this.TypeMigration.equals("Somme")) {
            for (pos_in_list = 0; pos_in_list < bd_ctrl._liste_reaxels.size(); ++pos_in_list) {
                c = bd_ctrl._liste_reaxels.get(pos_in_list);
                if (c == null || !c._nom.equals(this.Migrante)) continue;
                i = c._x;
                j = c._y;
                for (int p = 0; p < bd_ctrl._liste_reaxels.size(); ++p) {
                    Reaxel cube_copain = bd_ctrl._liste_reaxels.get(p);
                    if (c == cube_copain || !cube_copain._nom.equals(this.Objectif)) continue;
                    double proba = this._proba_migrer;
                    if (this._dependance_distance >= 1) {
                        double dist = this._env.distance(c, cube_copain);
                        proba /= Math.pow(dist, this._dependance_distance);
                    }
                    double intensite = 1.0 * proba;
                    double angle = Math.PI * 2 + Math.atan2(cube_copain._y - j, cube_copain._x - i);
                    if (!this._inversion) {
                        double[] dArray = bd_ctrl._matrice_migration_fx[i];
                        int n = j;
                        dArray[n] = dArray[n] + intensite * Math.cos(angle);
                        double[] dArray4 = bd_ctrl._matrice_migration_fy[i];
                        int n4 = j;
                        dArray4[n4] = dArray4[n4] + intensite * Math.sin(angle);
                        continue;
                    }
                    double[] dArray = bd_ctrl._matrice_migration_fx[i];
                    int n = j;
                    dArray[n] = dArray[n] + intensite * Math.cos(angle -= Math.PI);
                    double[] dArray5 = bd_ctrl._matrice_migration_fy[i];
                    int n5 = j;
                    dArray5[n5] = dArray5[n5] + intensite * Math.sin(angle);
                }
            }
        }
    }

    private Reaxel plusProche(int i0, int j0, Environnement bd_ctrl) {
        Reaxel plus_proche = null;
        double dist_min = -1.0;
        double dist = 0.0;
        ArrayList<Integer> lst_int = this._env.liste_entiers_melanges(bd_ctrl._liste_reaxels.size());
        Point P0 = new Point();
        for (int pos_in_list = 0; pos_in_list < bd_ctrl._liste_reaxels.size(); ++pos_in_list) {
            Reaxel c = bd_ctrl._liste_reaxels.get(lst_int.get(pos_in_list));
            if (c == null || !c._nom.equals(this.Objectif) || c._x == i0 && c._y == j0) continue;
            P0.x = i0;
            P0.y = j0;
            dist = this._env.distance(P0, c);
            if (!(dist < dist_min) && dist_min != -1.0) continue;
            plus_proche = c;
            dist_min = dist;
        }
        return plus_proche;
    }

    @Override
    public void sauvegarder(String abs_path, BufferedWriter saveStream) {
        super.sauvegarder(abs_path, saveStream);
        try {
            saveStream.write("\tTypeMigration:" + this.TypeMigration + "\n");
            saveStream.write("\tMigrante:" + this.Migrante + "\n");
            saveStream.write("\tObjectif:" + this.Objectif + "\n");
            saveStream.write("\tProbaMigrer:" + new Double(this.get_k()).toString() + "\n");
            saveStream.write("\tInversion:" + new Boolean(this._inversion).toString() + "\n");
            saveStream.write("\tDistancePow:" + new Integer(this._dependance_distance).toString() + "\n");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e);
        }
    }

    public double get_k() {
        return this._proba_migrer;
    }

    public void set_k(double k) {
        this._proba_migrer = k;
        int val = (int)(k * 100.0);
        this.jSlider_k.setValue(val);
        this.setTitre(this.getEtiquettes() + ", k=" + Double.valueOf(k).toString());
    }
}

