/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import gui.ImageGenerator;
import gui.Settings;
import java.awt.Color;
import java.awt.FontMetrics;
import java.util.Iterator;

public class ChronColumn
extends DataColumn {
    public static String CHRON_NORMAL_STYLE = "stroke-width: 0; fill: black;";
    public static String CHRON_REVERSED_STYLE = "stroke-width: 0; fill: white;";
    public static String CHRON_UNKNOWN_STYLE = "stroke-width: 0; fill: url(#ChronColumn_Unknown);";
    public static String CHRON_UNKNOWN_PATTERN_LINE_STYLE = "stroke-width: 1; stroke: black; fill: none;";
    public static String CHRON_UNKNOWN_PATTERN_BACKGROUND_STYLE = "stroke-width: 0; fill: rgb(192, 192, 192);";
    public static final Color defaultBackground = new Color(192, 192, 192);

    public static void setupPatterns(ImageGenerator ig) {
        ig.pushPattern("ChronColumn_Unknown", 10.0, 10.0);
        ig.drawRect(0.0, 0.0, 10.0, 10.0, CHRON_UNKNOWN_PATTERN_BACKGROUND_STYLE);
        ig.drawLine(10.0, -5.0, -5.0, 10.0, CHRON_UNKNOWN_PATTERN_LINE_STYLE);
        ig.drawLine(15.0, 0.0, 0.0, 15.0, CHRON_UNKNOWN_PATTERN_LINE_STYLE);
        ig.popPattern();
    }

    public ChronColumn(String colName) {
        super(colName);
        this.setWidth(40.0);
        this.color = new Coloring(defaultBackground);
    }

    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        super.drawData(ig, startx, starty, width, height, settings);
        Iterator iter = this.getData();
        double curTop = settings.topAge;
        double curBase = settings.baseAge;
        double ageLabelHeight = 0.0;
        if (this.drawAgeLabel) {
            FontMetrics fm = ig.getFontMetrics(this.fonts.getFont(1));
            ageLabelHeight = fm.getAscent();
        }
        while (iter.hasNext() && curTop + 1.0E-6 < settings.baseAge) {
            Datapoint p = (Datapoint)iter.next();
            if (p.baseAge - 1.0E-6 < settings.topAge) continue;
            if (p.breaker) {
                curTop = p.baseAge;
                continue;
            }
            curBase = p.baseAge;
            if (curBase + 1.0E-6 > settings.baseAge) {
                curBase = settings.baseAge;
            }
            String styleToUse = CHRON_UNKNOWN_STYLE;
            if (p.value.toString().compareToIgnoreCase("R") == 0) {
                styleToUse = CHRON_REVERSED_STYLE;
            } else if (p.value.toString().compareToIgnoreCase("N") == 0) {
                styleToUse = CHRON_NORMAL_STYLE;
            }
            ig.drawRectYear(startx, curTop, width, curBase - curTop, styleToUse, starty);
            if (this.drawAgeLabel) {
                ig.drawString(ig.getSWIOneLine(DataColumn.getAgeLabel(p.baseAge), this.fonts.getFont(1), 1), startx + 2.0, (curBase - settings.topAge) * settings.unitsPerMY + starty - ageLabelHeight, 20.0, ageLabelHeight, 3, 0.0, 12, Coloring.getStyle(this.color.getColor(p.baseAge, p.baseAge)));
            }
            if (p.popup != null && settings.doPopups) {
                ig.pushGrouping();
                ig.doPopupThings(p.popup);
                ig.drawRectYear(startx, curTop, width, curBase - curTop, "stroke-width: 0; opacity: 0.5; fill: red;", starty);
                ig.popGrouping();
            }
            curTop = curBase;
        }
        this.drawOverlays(ig, startx, starty, width, height, settings);
    }
}

