/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import gui.ImageGenerator;
import gui.Settings;
import java.awt.Color;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Coloring {
    public SortedSet colorSet;
    public boolean useNamed = false;
    public static final int LEVEL_SUPEREON = 0;
    public static final int LEVEL_EON = 1;
    public static final int LEVEL_ERA = 2;
    public static final int LEVEL_SUBERA = 3;
    public static final int LEVEL_PERIOD = 4;
    public static final int LEVEL_SUBPERIOD = 5;
    public static final int LEVEL_EPOCH = 6;
    public static final int LEVEL_STAGE = 7;
    public static final int LEVEL_ALL = 100;
    public Color oneColor;
    public static Color baseColor = Color.white;
    public static Coloring USGS;
    public static Coloring NAMED_USGS;
    public static Coloring UNESCO;
    public static Coloring NAMED_UNESCO;

    static {
        NAMED_USGS = USGS = new Coloring(baseColor);
        NAMED_UNESCO = UNESCO = new Coloring(baseColor);
    }

    protected Coloring() {
    }

    public Coloring(Color c) {
        this.oneColor = c;
    }

    public Coloring(Coloring c) {
        this.set(c);
    }

    public Coloring(SortedSet ss) {
        this.colorSet = ss;
    }

    public void set(Coloring c) {
        this.colorSet = c.colorSet;
        this.oneColor = c.oneColor;
        this.useNamed = c.useNamed;
    }

    public void writeSettings(Element element, Document doc) {
        if (this.colorSet != null && this.colorSet.size() > 0) {
            element.setAttribute("standardized", "true");
        }
        if (this.oneColor != null) {
            Settings.setNodeTextContent(element, Coloring.getColorStyle(this.oneColor), doc);
        }
        element.setAttribute("useNamed", "" + this.useNamed);
    }

    public static Coloring readSettings(Element element, Settings settings) {
        String varS = element.getAttribute("standardized");
        boolean var = false;
        String namedS = element.getAttribute("useNamed");
        boolean named = false;
        try {
            if (varS != null) {
                var = Boolean.valueOf(varS);
            }
            if (namedS != null) {
                named = Boolean.valueOf(namedS);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (var) {
            if (named) {
                return settings.variableNamedColoring;
            }
            return settings.variableColoring;
        }
        Color c = Coloring.getColorFromStyle(Settings.getNodeTextContent(element));
        if (c == null) {
            return null;
        }
        return new Coloring(c);
    }

    public static String getColorStyle(Color c) {
        if (c == null) {
            return null;
        }
        return "rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")";
    }

    public static Color getColorFromStyle(String text) {
        if (text == null || text.length() < 1) {
            return null;
        }
        if (text.compareToIgnoreCase("black") == 0) {
            return Color.BLACK;
        }
        if (text.compareToIgnoreCase("white") == 0) {
            return Color.WHITE;
        }
        try {
            String values = text.substring(text.indexOf(40) + 1, text.lastIndexOf(41));
            StringTokenizer st = new StringTokenizer(values, ",");
            int r = Integer.parseInt(st.nextToken().trim());
            int g = Integer.parseInt(st.nextToken().trim());
            int b = Integer.parseInt(st.nextToken().trim());
            return new Color(r, g, b);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected NamedColor addNamedColor(String name, Color color, double topAge, double baseAge, boolean nameOnly, int level, NamedColor parent) {
        if (this.colorSet == null) {
            return null;
        }
        NamedColor nc = new NamedColor();
        nc.name = name;
        nc.color = color;
        nc.topAge = topAge;
        nc.baseAge = baseAge;
        nc.nameOnly = nameOnly;
        nc.level = level;
        nc.parent = parent;
        this.colorSet.add(nc);
        System.out.println("added " + name + " to level " + level);
        return nc;
    }

    protected NamedColor replaceNamedColor(String name, Color newColor) {
        NamedColor nc = this.getNamedColor(name, true);
        if (nc == null) {
            return null;
        }
        nc.color = newColor;
        return nc;
    }

    public NamedColor getNamedColor(String name) {
        return this.getNamedColor(name, false);
    }

    public NamedColor getNamedColor(String name, boolean noParent) {
        if (this.colorSet == null || name == null || name.length() == 0) {
            return null;
        }
        Iterator iter = this.colorSet.iterator();
        NamedColor nc = null;
        block0: while (iter.hasNext()) {
            nc = (NamedColor)iter.next();
            if (nc != null && nc.name != null) {
                StringTokenizer st = new StringTokenizer(nc.name, ",");
                while (st.hasMoreTokens()) {
                    String n = st.nextToken().trim();
                    if (n.compareToIgnoreCase(name) == 0) break block0;
                }
            }
            nc = null;
        }
        if (!noParent) {
            while (nc != null && nc.color == null) {
                nc = nc.parent;
            }
        }
        return nc;
    }

    public Color getColor(String name) {
        NamedColor nc = this.getNamedColor(name);
        if (nc == null) {
            return null;
        }
        return nc.color;
    }

    public static void drawDefaultColoring(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        Coloring c = new Coloring(baseColor);
        c.drawColoring(ig, startx, starty, width, height, settings, 100);
    }

    public void drawColoring(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings, int maxLevel) {
        if (this.oneColor != null) {
            ig.drawRect(startx, starty, width, height, Coloring.getStyle(this.oneColor));
        } else if (this.colorSet != null) {
            Iterator iter = this.getColorIter();
            double curTop = settings.topAge;
            double curBase = settings.topAge;
            while (iter.hasNext()) {
                Color c;
                NamedColor nc = (NamedColor)iter.next();
                if (nc.baseAge < settings.topAge || nc.topAge > settings.baseAge || (c = nc.color) == null || nc.level > maxLevel || nc.nameOnly) continue;
                curTop = Math.max(nc.topAge, settings.topAge);
                curBase = Math.min(nc.baseAge, settings.baseAge);
                ig.drawRectYear(startx, curTop, width, curBase - curTop, Coloring.getStyle(c), starty);
            }
            if (curBase < settings.baseAge) {
                ig.drawRectYear(startx, curBase, width, settings.baseAge - curBase, Coloring.getStyle(baseColor), starty);
            }
        }
    }

    public Color getColor(double top, double base) {
        if (this.oneColor != null) {
            return this.oneColor;
        }
        Iterator iter = this.colorSet.iterator();
        NamedColor ret = null;
        double retHeight = 9.99999999E8;
        while (iter.hasNext()) {
            double curHeight;
            NamedColor nc = (NamedColor)iter.next();
            if (nc.nameOnly || nc.color == null || !(nc.topAge - 1.0E-6 <= top) || !(nc.baseAge + 1.0E-6 >= base) || nc.nameOnly || !((curHeight = nc.baseAge - nc.topAge) < retHeight) && (!Settings.isEqual(curHeight, retHeight) || nc.level <= ret.level)) continue;
            ret = nc;
            retHeight = curHeight;
        }
        if (ret == null) {
            return null;
        }
        return ret.color;
    }

    protected Iterator getColorIter() {
        if (this.oneColor != null) {
            return null;
        }
        Iterator iter = this.colorSet.iterator();
        return iter;
    }

    public static String getFillStyle(Color c) {
        return "fill: rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ");";
    }

    public static String getStyle(Color c) {
        return "stroke-width:0; fill: rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ");";
    }

    public static Color parseColor(String s) {
        if (s == null) {
            return null;
        }
        int slashIndex = (s = s.replaceAll(" ", "")).indexOf(47);
        if (slashIndex < 0) {
            slashIndex = s.indexOf(44);
        }
        if (slashIndex < 0) {
            return null;
        }
        String c = s.substring(0, slashIndex);
        int r = Integer.parseInt(c);
        if (slashIndex == s.length() - 1) {
            return null;
        }
        if ((slashIndex = (s = s.substring(slashIndex + 1)).indexOf(47)) < 0) {
            slashIndex = s.indexOf(44);
        }
        if (slashIndex < 0) {
            return null;
        }
        c = s.substring(0, slashIndex);
        int g = Integer.parseInt(c);
        if (slashIndex == s.length() - 1) {
            return null;
        }
        s = s.substring(slashIndex + 1);
        int b = Integer.parseInt(s);
        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
            return null;
        }
        return new Color(r, g, b);
    }

    public static Coloring getColoring(String s) {
        return new Coloring(Coloring.parseColor(s));
    }

    public static void readColoring(InputStream in) throws Exception {
        DOMParser parser = new DOMParser();
        parser.parse(new InputSource(in));
        Document document = parser.getDocument();
        Element root = document.getDocumentElement();
        NodeList nl = root.getChildNodes();
        int nodeIndex = 0;
        while (nodeIndex < nl.getLength()) {
            String name;
            Element e;
            String tag;
            Node node = nl.item(nodeIndex);
            if (node.getNodeType() == 1 && (tag = (e = (Element)node).getTagName()).compareToIgnoreCase("chronostrat") == 0 && (name = e.getAttribute("name")) != null) {
                String sAges = e.getAttribute("ages");
                Coloring ages = null;
                if (sAges != null) {
                    if (sAges.compareToIgnoreCase("USGS") == 0) {
                        ages = USGS;
                    } else if (sAges.compareToIgnoreCase("UNESCO") == 0) {
                        ages = UNESCO;
                    }
                }
                Coloring c = null;
                if (name.compareToIgnoreCase("USGS") == 0) {
                    if (ages == USGS) {
                        ages = null;
                    }
                    c = USGS;
                } else if (name.compareToIgnoreCase("UNESCO") == 0) {
                    if (ages == UNESCO) {
                        ages = null;
                    }
                    c = UNESCO;
                }
                if (c != null) {
                    if (ages != null) {
                        c.copyNullColors(ages);
                    } else {
                        c.oneColor = null;
                        c.colorSet = Collections.synchronizedSortedSet(new TreeSet(new NamedColor()));
                    }
                    c.readChronostrat(e, ages);
                    if (c == USGS) {
                        NAMED_USGS = new Coloring(c);
                        Coloring.NAMED_USGS.useNamed = true;
                    }
                    if (c == UNESCO) {
                        NAMED_UNESCO = new Coloring(c);
                        Coloring.NAMED_UNESCO.useNamed = true;
                    }
                }
            }
            ++nodeIndex;
        }
    }

    protected void readChronostrat(Element element, Coloring ages) throws Exception {
        NodeList nl = element.getChildNodes();
        int elementIndex = 0;
        while (elementIndex < nl.getLength()) {
            Node node = nl.item(elementIndex);
            if (node.getNodeType() == 1) {
                Element zone = (Element)node;
                if (zone.getTagName().compareToIgnoreCase("zone") == 0) {
                    this.readZone(zone, null, 0);
                } else if (zone.getTagName().compareToIgnoreCase("replaceColor") == 0) {
                    this.readReplaceColor(zone);
                }
            }
            ++elementIndex;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void readZone(Element element, NamedColor parent, int level) throws Exception {
        nl = element.getChildNodes();
        name = element.getAttribute("name");
        sBaseAge = element.getAttribute("base");
        sTopAge = element.getAttribute("top");
        rgb = element.getAttribute("rgb");
        baseAge = 0.0;
        topAge = 0.0;
        thisNC = null;
        if (name != null && name.length() > 0 || sBaseAge != null && sBaseAge.length() > 0 && sTopAge != null && sTopAge.length() > 0) {
            v0 = nameOnly = sBaseAge == null || sBaseAge.length() == 0 || sTopAge == null || sTopAge.length() == 0;
            if (!nameOnly) {
                try {
                    if (sBaseAge != null && sBaseAge.length() > 0) {
                        baseAge = Double.parseDouble(sBaseAge);
                    }
                    if (sTopAge == null || sBaseAge.length() <= 0) ** GOTO lbl22
                    topAge = Double.parseDouble(sTopAge);
                }
                catch (NumberFormatException e) {
                    throw new Exception("\"" + name + "\": invalid number: " + e.getMessage());
                }
            } else if (sBaseAge != null && sBaseAge.length() > 0 || sTopAge != null && sTopAge.length() > 0) {
                throw new Exception("\"" + name + "\": either both top and base ages must be defined, or neither.");
            }
lbl22:
            // 4 sources

            thisNC = this.addNamedColor(name, Coloring.parseColor(rgb), topAge, baseAge, nameOnly, level, parent);
        } else {
            thisNC = parent;
        }
        elementIndex = 0;
        while (elementIndex < nl.getLength()) {
            node = nl.item(elementIndex);
            if (node.getNodeType() == 1 && (zone = (Element)node).getTagName().compareToIgnoreCase("zone") == 0) {
                this.readZone(zone, thisNC, level + 1);
            }
            ++elementIndex;
        }
    }

    protected void readReplaceColor(Element element) throws Exception {
        String name = element.getAttribute("name");
        String rgb = element.getAttribute("rgb");
        if (name != null && rgb != null && this.replaceNamedColor(name, Coloring.parseColor(rgb)) == null) {
            throw new Exception("\"" + name + "\": ages not found.");
        }
    }

    protected void copyNullColors(Coloring source) {
        NamedColor nc;
        this.oneColor = null;
        this.colorSet = Collections.synchronizedSortedSet(new TreeSet(new NamedColor()));
        Iterator iter = source.colorSet.iterator();
        while (iter.hasNext()) {
            NamedColor sourceNC = (NamedColor)iter.next();
            nc = new NamedColor(sourceNC);
            this.colorSet.add(nc);
        }
        iter = this.colorSet.iterator();
        while (iter.hasNext()) {
            nc = (NamedColor)iter.next();
            if (nc.parent == null) {
                nc.color = null;
                continue;
            }
            Iterator parentIter = this.colorSet.iterator();
            while (parentIter.hasNext()) {
                NamedColor parent = (NamedColor)parentIter.next();
                if (nc.parent != parent.createdFrom) continue;
                nc.parent = parent;
                nc.color = null;
            }
        }
        iter = this.colorSet.iterator();
        while (iter.hasNext()) {
            nc = (NamedColor)iter.next();
            if (nc.color == null) continue;
            System.out.println("COLOR'S PARENT NOT FOUND: " + nc.name);
        }
    }

    public static class NamedColor
    implements Comparator {
        public String name;
        public Color color;
        public double topAge;
        public double baseAge;
        public int level = 0;
        public boolean nameOnly = false;
        public NamedColor parent = null;
        public NamedColor createdFrom = null;

        public NamedColor() {
        }

        public NamedColor(NamedColor other) {
            this.name = other.name;
            this.color = other.color;
            this.topAge = other.topAge;
            this.baseAge = other.baseAge;
            this.level = other.level;
            this.parent = other.parent;
            this.createdFrom = other;
        }

        public int compare(Object arg0, Object arg1) {
            NamedColor left = (NamedColor)arg0;
            NamedColor right = (NamedColor)arg1;
            if (left == null || right == null) {
                return 0;
            }
            if (left.nameOnly && right.nameOnly) {
                return arg0.toString().compareToIgnoreCase(arg1.toString());
            }
            if (left.nameOnly) {
                return 1;
            }
            if (right.nameOnly) {
                return -1;
            }
            double result = left.topAge - right.topAge;
            if (result == 0.0 || result > 0.0 && result < 1.0E-6 || result < 0.0 && result > -1.0E-6) {
                result = right.baseAge - left.baseAge;
                if (result == 0.0 || result > 0.0 && result < 1.0E-6 || result < 0.0 && result > -1.0E-6) {
                    return arg0.toString().compareToIgnoreCase(arg1.toString());
                }
                if (result < 0.0) {
                    return -1;
                }
                return 1;
            }
            if (result < 0.0) {
                return -1;
            }
            return 1;
        }
    }
}

