/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.Coloring;
import datastore.Datapoint;
import datastore.MetaColumn;
import gui.FontManager;
import gui.FontOptions;
import gui.ImageGenerator;
import gui.Settings;
import gui.SpreadSheetTableModel;
import gui.StringWrappingInfo;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataColumn
extends DefaultMutableTreeNode {
    public SortedSet data;
    public double minAge = Double.POSITIVE_INFINITY;
    public double maxAge = Double.NEGATIVE_INFINITY;
    public String id;
    public String name;
    public Coloring color;
    public Coloring defaultColor = null;
    public Coloring guiColor = new Coloring(Color.white);
    public int maxChronostratLevel = 100;
    public boolean useNamedColor = false;
    public boolean placeHolder;
    public boolean isLoaded = false;
    public boolean drawTitle = true;
    public boolean drawAgeLabel = false;
    public String popup = null;
    FontManager fonts;
    public List underlays = null;
    public List overlays = null;
    public static final int SHOW_COL = 1;
    public static final int HIDE_COL = 2;
    public static final int DEFAULT_SHOW_COL = 3;
    public JPanel panel;
    protected JCheckBox checkbox;
    protected JLabel label;
    protected double myWidth = 100.0;
    protected double myHeaderHeight = -1.0;
    protected double myOwnHeaderHeight = -1.0;
    protected StringWrappingInfo nameWrap;
    public boolean grayedOut = false;
    public double MIN_COL_WIDTH = 10.0;
    public static final double AGE_LABEL_WIDTH = 20.0;
    public static final double AGE_LABEL_MARGIN = 2.0;
    public JPanel optionsPanel = null;
    static /* synthetic */ Class class$0;

    public void setLoaded(boolean l) {
        this.isLoaded = l;
    }

    public void readSettings(Element element, Settings settings) {
        this.fonts.resetFonts();
        this.optionsPanel = null;
        NodeList nl = element.getChildNodes();
        int nodeIndex = 0;
        while (nodeIndex < nl.getLength()) {
            Node node = nl.item(nodeIndex);
            if (node.getNodeType() == 1) {
                if (node.getNodeName().compareToIgnoreCase("fonts") == 0) {
                    this.fonts.readSettings((Element)node);
                }
                if (node.getNodeName().compareToIgnoreCase("setting") == 0) {
                    Element setting = (Element)node;
                    try {
                        this.readOneSetting(setting, settings);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
            ++nodeIndex;
        }
        this.isLoaded = true;
    }

    public void readOneSetting(Element setting, Settings settings) {
        String name = setting.getAttribute("name");
        if (name != null) {
            if (name.compareToIgnoreCase("title") == 0) {
                this.setName(Settings.getNodeTextContent(setting).trim());
                settings.nodeChanged(this);
            } else if (name.compareToIgnoreCase("backgroundColor") == 0) {
                this.color = Coloring.readSettings(setting, settings);
            } else if (name.compareToIgnoreCase("customColor") == 0) {
                this.guiColor = Coloring.readSettings(setting, settings);
            } else if (name.compareToIgnoreCase("useNamedColor") == 0) {
                this.useNamedColor = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("placeHolder") == 0) {
                this.placeHolder = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("drawTitle") == 0) {
                this.drawTitle = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("drawAgeLabel") == 0) {
                this.drawAgeLabel = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("isSelected") == 0) {
                this.setSelected(Boolean.valueOf(Settings.getNodeTextContent(setting)));
            } else if (name.compareToIgnoreCase("width") == 0) {
                this.myWidth = Double.parseDouble(Settings.getNodeTextContent(setting));
            }
        }
    }

    public void writeSettings(Element element, Document doc) {
        element.setAttribute("id", this.id);
        element.appendChild(Settings.createSimpleSetting(doc, "title", this.getName()));
        element.appendChild(Settings.createSimpleSetting(doc, "useNamedColor", "" + this.useNamedColor));
        element.appendChild(Settings.createSimpleSetting(doc, "placeHolder", "" + this.placeHolder));
        element.appendChild(Settings.createSimpleSetting(doc, "drawTitle", "" + this.drawTitle));
        element.appendChild(Settings.createSimpleSetting(doc, "drawAgeLabel", "" + this.drawAgeLabel));
        element.appendChild(Settings.createSimpleSetting(doc, "isSelected", "" + this.isSelected()));
        element.appendChild(Settings.createSimpleSetting(doc, "width", "" + this.myWidth));
        Element colorE = Settings.createSimpleSetting(doc, "backgroundColor", null);
        if (this.color != null) {
            this.color.writeSettings(colorE, doc);
        }
        element.appendChild(colorE);
        colorE = Settings.createSimpleSetting(doc, "customColor", null);
        if (this.guiColor != null) {
            this.guiColor.writeSettings(colorE, doc);
        }
        element.appendChild(colorE);
        Element fontsE = doc.createElement("fonts");
        this.fonts.writeSettings(fontsE, doc);
        element.appendChild(fontsE);
    }

    public DataColumn(String colName, boolean ph) {
        this.id = String.valueOf(this.getClass().toString()) + ":" + colName;
        this.data = Collections.synchronizedSortedSet(new TreeSet(new Datapoint.Comparator()));
        this.name = colName;
        this.placeHolder = ph;
        this.checkbox = new JCheckBox();
        this.label = new JLabel(this.name);
        this.setSelected(true);
        this.panel = new JPanel(new FlowLayout());
        this.panel.add(this.checkbox);
        this.panel.add(this.label);
        this.checkbox.setBorder(BorderFactory.createEmptyBorder());
        this.panel.setBorder(BorderFactory.createEmptyBorder());
        this.label.setBorder(BorderFactory.createEmptyBorder());
        this.fonts = new FontManager();
        super.setAllowsChildren(false);
    }

    public DataColumn(String colName) {
        this(colName, false);
    }

    public void setColor(Coloring colColor) {
        if (this.defaultColor == null) {
            this.defaultColor = colColor;
        }
        this.color = colColor;
        if (this.color != null && this.color.oneColor != null) {
            this.guiColor = this.color;
        }
        this.useNamedColor = this.color == Coloring.NAMED_USGS || this.color == Coloring.NAMED_UNESCO;
    }

    public void addData(Datapoint dp) {
        if (dp.label != null) {
            dp.label = dp.label.trim();
        }
        this.data.add(dp);
        if (dp.baseAge > this.maxAge) {
            this.maxAge = dp.baseAge;
        }
        if (dp.baseAge < this.minAge) {
            this.minAge = dp.baseAge;
        }
    }

    public boolean grayOutIfEmpty(double topAge, double baseAge, boolean en) {
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("datastore.DataColumn");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            this.grayedOut = false;
            return this.grayedOut;
        }
        boolean lastGO = this.grayedOut;
        this.grayedOut = en ? this.maxAge < topAge || this.minAge > baseAge : false;
        if (lastGO != this.grayedOut) {
            this.setName(this.name);
        }
        return this.grayedOut;
    }

    public SortedSet getData(double start, double end) {
        return this.data.subSet(new Datapoint(start), new Datapoint(end));
    }

    public SortedSet getData(double start) {
        return this.data.tailSet(new Datapoint(start));
    }

    public Iterator getData() {
        return this.data.iterator();
    }

    public int getNumSeries() {
        return 1;
    }

    public boolean canAlterSeries() {
        return false;
    }

    public SpreadSheetTableModel getSeriesModel(int which) {
        if (which != 0) {
            return null;
        }
        return new SpreadSheetTableModel();
    }

    public String getSeriesName(int which) {
        if (which != 0) {
            return null;
        }
        return this.getName();
    }

    public String toString() {
        return this.name;
    }

    public static String getAgeLabel(double age) {
        return Double.toString(new BigDecimal(age).setScale(2, 4).doubleValue());
    }

    public void setSelected(boolean newCheck) {
        this.checkbox.setSelected(newCheck);
    }

    public boolean isSelected() {
        return this.checkbox.isSelected();
    }

    public boolean shouldDraw() {
        return this.checkbox.isSelected() && !this.grayedOut;
    }

    public boolean willThisCheck(Point p) {
        return this.checkbox.getBounds().contains(p);
    }

    public void enableCheckbox(boolean tf) {
        this.checkbox.setEnabled(tf);
    }

    public JPanel getOptionsPanel(Settings s) {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
        }
        return this.optionsPanel;
    }

    public FontOptions getFontOptionsPanel() {
        FontOptions fo = new FontOptions(this.fonts);
        JPanel p = fo.getAddPanel();
        p.setBorder(BorderFactory.createTitledBorder("Font Options for \"" + this.getName() + "\""));
        fo.addOptions(FontManager.getRelevantFonts(this.getClass()), true);
        return fo;
    }

    public int[] getRelevantFonts() {
        return FontManager.getRelevantFonts(this.getClass());
    }

    public MetaColumn getColParent() {
        return (MetaColumn)this.getParent();
    }

    public double getWidth(Settings s, ImageGenerator ig) {
        return this.myWidth;
    }

    public double getMyWidth() {
        return this.myWidth;
    }

    public void setWidth(double newWidth) {
        if (newWidth < this.MIN_COL_WIDTH) {
            newWidth = this.MIN_COL_WIDTH;
        }
        this.myWidth = newWidth;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String nt) {
        this.name = nt;
        if (this.grayedOut) {
            this.checkbox.setEnabled(false);
            this.label.setText("<html><font size=\"-6\" color=\"red\">(NO DATA IN TIME INTERVAL)</font> <i>" + this.name + "</i></html>");
        } else {
            this.checkbox.setEnabled(true);
            this.label.setText(this.name);
        }
    }

    public void setParentFontManager(FontManager parentFM) {
        this.fonts.setParent(parentFM);
    }

    public void setVariableColoring(Settings s) {
        if (this.color == Coloring.NAMED_USGS || this.color == Coloring.NAMED_UNESCO) {
            this.color = s.variableNamedColoring;
        }
        if (this.color == Coloring.USGS || this.color == Coloring.UNESCO) {
            this.color = s.variableColoring;
        }
    }

    public double getHeaderHeight(Settings settings, ImageGenerator ig) {
        this.nameWrap = ig.wrapString(this.name, this.myWidth, this.fonts.getFont(0));
        if (this.name.length() != 0 && this.drawTitle) {
            Rectangle2D textBounds = ig.getStringBounds(this.nameWrap);
            this.myOwnHeaderHeight = textBounds.getHeight();
        } else {
            this.myOwnHeaderHeight = 0.0;
        }
        this.myHeaderHeight = this.myOwnHeaderHeight;
        return this.myHeaderHeight;
    }

    public void setHeaderHeight(double newHeaderHeight) {
        this.myHeaderHeight = newHeaderHeight;
    }

    public void drawHeader(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        if (this.myWidth < 0.0) {
            this.myWidth = this.getWidth(settings, ig);
        }
        if (this.myHeaderHeight < 0.0) {
            this.myHeaderHeight = this.getHeaderHeight(settings, ig);
        }
        if (this.name.length() > 0 && this.drawTitle) {
            ig.drawString(this.nameWrap, startx, starty, width, height, 3);
        }
        if (this.popup != null && settings.doPopups) {
            ig.pushGrouping();
            ig.doPopupThings(this.popup);
            ig.drawRect(startx, starty, width, height, "stroke-width: 0; opacity: 0.5; fill: red;");
            ig.popGrouping();
        }
    }

    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        if (this.myWidth < 0.0) {
            this.myWidth = this.getWidth(settings, ig);
        }
        if (this.myHeaderHeight < 0.0) {
            this.myHeaderHeight = this.getHeaderHeight(settings, ig);
        }
        if (this.color != null) {
            this.color.drawColoring(ig, startx, starty, width, height, settings, this.maxChronostratLevel);
        } else {
            Coloring.drawDefaultColoring(ig, startx, starty, width, height, settings);
        }
        this.drawUnderlays(ig, startx, starty, width, height, settings);
    }

    public void addOverlay(DataColumn overlay) {
        if (this.overlays == null) {
            this.overlays = new LinkedList();
        }
        this.overlays.add(overlay);
        overlay.setParentFontManager(this.fonts);
        if (overlay.minAge < this.minAge) {
            this.minAge = overlay.minAge;
        }
        if (overlay.maxAge > this.maxAge) {
            this.maxAge = overlay.maxAge;
        }
    }

    public void addUnderlay(DataColumn underlay) {
        if (this.underlays == null) {
            this.underlays = new LinkedList();
        }
        this.underlays.add(underlay);
        underlay.setParentFontManager(this.fonts);
        if (underlay.minAge < this.minAge) {
            this.minAge = underlay.minAge;
        }
        if (underlay.maxAge > this.maxAge) {
            this.maxAge = underlay.maxAge;
        }
    }

    public void drawOverlays(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        if (this.overlays == null) {
            return;
        }
        Iterator iter = this.overlays.iterator();
        while (iter.hasNext()) {
            DataColumn col = (DataColumn)iter.next();
            col.drawData(ig, startx, starty, width, height, settings);
        }
    }

    public void drawUnderlays(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        if (this.underlays == null) {
            return;
        }
        Iterator iter = this.underlays.iterator();
        while (iter.hasNext()) {
            DataColumn col = (DataColumn)iter.next();
            col.drawData(ig, startx, starty, width, height, settings);
        }
    }
}

