/*
 * Decompiled with CFR 0.152.
 */
package datastore;

public class Datapoint {
    public static final int SOLID_LINE = 1;
    public static final int DASHED_LINE = 2;
    public static final int DOTTED_LINE = 3;
    public double baseAge;
    public String label;
    public Object value;
    public Object parameter;
    public String direction;
    public String popup;
    public int lineType;
    public String series;
    public boolean breaker;
    protected static int serial = 0;
    protected int mySerial;

    public Datapoint() {
        this.mySerial = serial++;
    }

    public Datapoint(double age) {
        this.baseAge = age;
        this.mySerial = serial++;
    }

    public Datapoint(Datapoint other) {
        this.label = other.label;
        this.baseAge = other.baseAge;
        this.lineType = other.lineType;
        this.breaker = other.breaker;
        this.series = other.series;
        this.mySerial = serial++;
    }

    public String toString() {
        return this.label;
    }

    public static class Comparator
    implements java.util.Comparator {
        public int compare(Object arg0, Object arg1) {
            Datapoint left = (Datapoint)arg0;
            Datapoint right = (Datapoint)arg1;
            if (left == null || right == null) {
                return 0;
            }
            double result = left.baseAge - right.baseAge;
            if (result == 0.0 || result > 0.0 && result < 1.0E-6 || result < 0.0 && result > -1.0E-6) {
                return left.mySerial - right.mySerial;
            }
            if (result < 0.0) {
                return -1;
            }
            return 1;
        }
    }
}

