/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.CollisionAvoider;
import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import gui.ImageGenerator;
import gui.Settings;
import gui.SpreadSheetTableModel;
import gui.StringWrappingInfo;
import gui.TSCreator;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EventColumn
extends DataColumn {
    public static String LINE_STYLE = "stroke-width: 0.5; stroke: black; fill: none;";
    public static String ARROW_STYLE = "stroke-width: 1; stroke: black; fill: black;";
    public static double LINE_WIDTH = 0.5;
    public static int FAD_ARROW_HEIGHT = 5;
    public static int LAD_ARROW_HEIGHT = 5;
    public static double ARROW_FIRST_STEP = 6.0;
    public static double ARROW_SECOND_STEP = 12.0;
    public static double ARROW_EVENT_STEP = 13.0;
    public static double ARROW_WIDTH = 5.0;
    public static double ARROW_HEIGHT = 4.0;
    public static double TEXT_MARGIN_WIDTH = 18.0;
    public static int FAD = 1;
    public static int LAD = 2;
    public static int EVENT = 2;
    public static int DRAW_EVENTS = 1;
    public static int DRAW_RANGES = 2;
    public static int orientation = 1;
    public int type = DRAW_EVENTS;
    public double eventsWidthBackup;
    public static final String RANGE_LINE_STYLE = "stroke-width: 2; stroke: black;";
    public static final double RANGE_LINE_THICKNESS = 2.0;
    public static final double RANGE_LABEL_BOTTOM_MARGIN = 1.0;
    public static final double RANGE_LABEL_TOP_MARGIN = 2.0;
    public static final double RANGE_LABEL_PADDING = 2.0;
    public static final double RANGE_ARROW_STALK_LENGTH = 10.0;
    public static final double RANGE_ARROW_HEAD_LENGTH = 4.0;
    public static final double RANGE_ARROW_HEAD_WIDTH = 4.0;
    double rangeWidth = 12.0;
    double maxRangeLabelHeight;
    SortedSet ranges = null;
    public int rangeSort = 1;
    protected int rangeSerial = 0;

    public EventColumn(String colName) {
        super(colName);
        this.setWidth(250.0);
        this.setColor(new Coloring(Color.white));
        this.setSelected(false);
    }

    public JPanel getOptionsPanel(Settings s) {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
            this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
            final EventColumn thisEC = this;
            URL imgURL = TSCreator.getURL("icons/events.gif");
            JRadioButton eventsR = new JRadioButton("<html><table cellpadding=0><tr><td><img src=\"" + imgURL.toString() + "\"></td><td width=5></td><td>Events</td></tr></table></html>");
            imgURL = TSCreator.getURL("icons/ranges.gif");
            JRadioButton rangesR = new JRadioButton("<html><table cellpadding=0><tr><td><img src=\"" + imgURL.toString() + "\"></td><td width=5></td><td>Ranges</td></tr></table></html>");
            ButtonGroup group = new ButtonGroup();
            group.add(eventsR);
            group.add(rangesR);
            this.optionsPanel.add(eventsR);
            this.optionsPanel.add(rangesR);
            JPanel sortPanel = new JPanel();
            sortPanel.setLayout(new BoxLayout(sortPanel, 1));
            sortPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
            final JRadioButton firstR = new JRadioButton("First Occurrence");
            final JRadioButton lastR = new JRadioButton("Last Occurrence");
            final JRadioButton alphaR = new JRadioButton("Alphabetical");
            group = new ButtonGroup();
            group.add(firstR);
            group.add(lastR);
            group.add(alphaR);
            sortPanel.add(new JLabel("<html>sort by:</html>"));
            sortPanel.add(firstR);
            sortPanel.add(lastR);
            sortPanel.add(alphaR);
            this.optionsPanel.add(sortPanel);
            this.optionsPanel.add(new JLabel("<html>Note: Ranges will set column width automatically.</html>"));
            eventsR.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent ie) {
                    if (((JRadioButton)ie.getItem()).isSelected()) {
                        thisEC.type = DRAW_EVENTS;
                        firstR.setEnabled(false);
                        lastR.setEnabled(false);
                        alphaR.setEnabled(false);
                    }
                }
            });
            rangesR.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent ie) {
                    if (((JRadioButton)ie.getItem()).isSelected()) {
                        thisEC.type = DRAW_RANGES;
                        firstR.setEnabled(true);
                        lastR.setEnabled(true);
                        alphaR.setEnabled(true);
                    }
                }
            });
            firstR.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent ie) {
                    if (((JRadioButton)ie.getItem()).isSelected()) {
                        thisEC.rangeSort = 1;
                    }
                }
            });
            lastR.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent ie) {
                    if (((JRadioButton)ie.getItem()).isSelected()) {
                        thisEC.rangeSort = 2;
                    }
                }
            });
            alphaR.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent ie) {
                    if (((JRadioButton)ie.getItem()).isSelected()) {
                        thisEC.rangeSort = 3;
                    }
                }
            });
            if (this.type == DRAW_EVENTS) {
                eventsR.setSelected(true);
            } else {
                rangesR.setSelected(true);
            }
            switch (this.rangeSort) {
                case 1: {
                    firstR.setSelected(true);
                    break;
                }
                case 2: {
                    lastR.setSelected(true);
                    break;
                }
                case 3: {
                    alphaR.setSelected(true);
                }
            }
        }
        return this.optionsPanel;
    }

    public double getHeaderHeight(Settings settings, ImageGenerator ig) {
        super.getHeaderHeight(settings, ig);
        this.maxRangeLabelHeight = 0.0;
        if (this.type == DRAW_RANGES) {
            Iterator iter = this.ranges.iterator();
            int rangeCount = 0;
            while (iter.hasNext()) {
                Range r = (Range)iter.next();
                StringWrappingInfo testLabelSWI = ig.getSWIOneLine(r.name, this.fonts.getFont(8), 4);
                this.maxRangeLabelHeight = Math.max(this.maxRangeLabelHeight, testLabelSWI.getHeight());
                ++rangeCount;
            }
            this.myOwnHeaderHeight += this.maxRangeLabelHeight + 1.0 + 2.0;
        }
        this.myHeaderHeight = this.myOwnHeaderHeight;
        return this.myHeaderHeight;
    }

    public void drawHeader(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        if (this.myWidth < 0.0) {
            this.myWidth = this.getWidth(settings, ig);
        }
        if (this.myHeaderHeight < 0.0) {
            this.myHeaderHeight = this.getHeaderHeight(settings, ig);
        }
        if (this.name.length() > 0 && this.drawTitle) {
            ig.drawString(this.nameWrap, startx, starty, width, height - this.maxRangeLabelHeight, 3);
        }
        if (this.type == DRAW_RANGES) {
            Iterator iter = this.ranges.iterator();
            int rangeCount = 0;
            while (iter.hasNext()) {
                Range r = (Range)iter.next();
                StringWrappingInfo labelSWI = ig.getSWIOneLine(r.name, this.fonts.getFont(8), 4);
                ig.drawString(labelSWI, startx + (double)rangeCount * this.rangeWidth, starty + height - 1.0 - this.maxRangeLabelHeight, this.rangeWidth, this.maxRangeLabelHeight, 3);
                if (r.popup != null && settings.doPopups) {
                    ig.pushGrouping();
                    ig.doPopupThings(r.popup);
                    ig.drawRect(startx + (double)rangeCount * this.rangeWidth, starty + height - 1.0 - this.maxRangeLabelHeight, this.rangeWidth, this.maxRangeLabelHeight, "stroke-width: 0; opacity: 0.5; fill: red;");
                    ig.popGrouping();
                }
                ++rangeCount;
            }
        }
        if (this.popup != null && settings.doPopups) {
            ig.pushGrouping();
            ig.doPopupThings(this.popup);
            ig.drawRect(startx, starty, width, height, "stroke-width: 0; opacity: 0.5; fill: red;");
            ig.popGrouping();
        }
    }

    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        super.drawData(ig, startx, starty, width, height, settings);
        if (this.type == DRAW_RANGES) {
            this.drawRange(ig, startx, starty, width, height, settings);
            return;
        }
        Iterator iter = this.getData();
        double unitToAgeFactor = height / (settings.baseAge - settings.topAge);
        double halfSpread = 1.0E-6;
        double ageLabelHeight = 0.0;
        if (this.drawAgeLabel) {
            FontMetrics fm = ig.getFontMetrics(this.fonts.getFont(1));
            ageLabelHeight = fm.getAscent();
        }
        CollisionAvoider fad_ca = new CollisionAvoider(0.0, height, Math.max((double)FAD_ARROW_HEIGHT, ageLabelHeight), width / 2.0 - TEXT_MARGIN_WIDTH, width / 2.0 - TEXT_MARGIN_WIDTH);
        CollisionAvoider lad_ca = new CollisionAvoider(0.0, height, Math.max((double)LAD_ARROW_HEIGHT, ageLabelHeight), width / 2.0 - TEXT_MARGIN_WIDTH, width / 2.0 - TEXT_MARGIN_WIDTH);
        fad_ca.setPrefBorrowDir(2);
        lad_ca.setPrefBorrowDir(3);
        while (iter.hasNext()) {
            Datapoint p = (Datapoint)iter.next();
            if (p.baseAge - 1.0E-6 <= settings.topAge) continue;
            if (p.baseAge + 1.0E-6 >= settings.baseAge) break;
            CollisionAvoider cur_ca = ((String)p.value).compareToIgnoreCase("LAD") == 0 ? lad_ca : fad_ca;
            cur_ca.add(p, unitToAgeFactor * (p.baseAge - halfSpread - settings.topAge), unitToAgeFactor * (p.baseAge + halfSpread - settings.topAge), p.baseAge - halfSpread, p.baseAge + halfSpread, ig.getSWI(p.label, this.fonts.getFont(4), orientation));
        }
        boolean ladFull = false;
        boolean fadFull = false;
        if (fad_ca.getNumNodes() == 0) {
            lad_ca.setWidths(width - TEXT_MARGIN_WIDTH, width - TEXT_MARGIN_WIDTH);
            ladFull = true;
        } else if (lad_ca.getNumNodes() == 0) {
            fad_ca.setWidths(width - TEXT_MARGIN_WIDTH, width - TEXT_MARGIN_WIDTH);
            fadFull = true;
        }
        fad_ca.fillHoles();
        fad_ca.pack();
        lad_ca.fillHoles();
        lad_ca.pack();
        if (!fadFull) {
            this.drawItems(ig, startx, starty, width / 2.0, height, settings, fad_ca, FAD, ageLabelHeight);
        } else {
            this.drawItems(ig, startx, starty, width, height, settings, fad_ca, FAD, ageLabelHeight);
        }
        if (!ladFull) {
            this.drawItems(ig, startx + width / 2.0, starty, width / 2.0, height, settings, lad_ca, LAD, ageLabelHeight);
        } else {
            this.drawItems(ig, startx, starty, width, height, settings, lad_ca, LAD, ageLabelHeight);
        }
        this.drawOverlays(ig, startx, starty, width, height, settings);
    }

    public void drawItems(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings, CollisionAvoider ca, int type, double ageLabelHeight) {
        if (ca.getNumNodes() < 1) {
            return;
        }
        int i = 0;
        while (i < ca.getNumNodes()) {
            CollisionAvoider.Node node = ca.getAt(i);
            if (node.dp != null && !node.dp.breaker) {
                this.drawItem(ig, startx, starty, width, height, settings, node, type, ageLabelHeight);
            }
            ++i;
        }
    }

    protected void drawItem(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings, CollisionAvoider.Node node, int type, double ageLabelHeight) {
        double labelX;
        int align;
        double[] tabX = new double[4];
        double[] tabY = new double[4];
        double[] arrowX = new double[3];
        double[] arrowY = new double[3];
        if (node.dp.value.toString().compareToIgnoreCase("EVENT") == 0) {
            tabX[0] = startx;
            tabX[1] = startx + ARROW_FIRST_STEP;
            tabX[2] = startx + ARROW_SECOND_STEP;
            tabX[3] = startx + ARROW_EVENT_STEP;
            tabY[0] = tabY[1] = starty + node.origBase;
            tabY[2] = tabY[3] = starty + (node.calcBase + node.calcTop) / 2.0;
            arrowX[0] = arrowX[1] = tabX[3];
            arrowX[2] = arrowX[0] + ARROW_HEIGHT;
            arrowY[0] = tabY[3] + ARROW_WIDTH / 2.0;
            arrowY[1] = tabY[3] - ARROW_WIDTH / 2.0;
            arrowY[2] = (arrowY[0] + arrowY[1]) / 2.0;
            align = 1;
            labelX = startx + TEXT_MARGIN_WIDTH;
            if (this.drawAgeLabel) {
                ig.drawString(ig.getSWIOneLine(DataColumn.getAgeLabel(node.origBaseAge), this.fonts.getFont(1), 1), tabX[3] + 2.0, starty + node.calcBase - ageLabelHeight, 20.0, ageLabelHeight, 3);
            }
        } else if (type == FAD) {
            tabX[0] = startx;
            tabX[1] = startx + ARROW_FIRST_STEP;
            tabX[2] = startx + ARROW_SECOND_STEP;
            tabX[3] = Math.max(startx + width * 0.5, tabX[2]);
            tabY[0] = tabY[1] = starty + node.origBase;
            tabY[2] = tabY[3] = starty + node.calcBase;
            arrowX[0] = tabX[3];
            arrowX[1] = arrowX[0] - ARROW_WIDTH;
            arrowX[2] = (arrowX[0] + arrowX[1]) / 2.0;
            arrowY[0] = arrowY[1] = tabY[3];
            arrowY[2] = arrowY[0] - ARROW_HEIGHT;
            align = 1;
            labelX = startx + TEXT_MARGIN_WIDTH;
            if (this.drawAgeLabel) {
                ig.drawString(ig.getSWIOneLine(DataColumn.getAgeLabel(node.origBaseAge), this.fonts.getFont(1), 1), tabX[2] + 2.0, tabY[2] - ageLabelHeight, 20.0, ageLabelHeight, 3);
            }
        } else {
            tabX[0] = startx + width;
            tabX[1] = startx + width - ARROW_FIRST_STEP;
            tabX[2] = startx + width - ARROW_SECOND_STEP;
            tabX[3] = Math.min(startx + width * 0.5, tabX[2]);
            tabY[0] = tabY[1] = starty + node.origBase;
            tabY[2] = tabY[3] = starty + node.calcTop;
            arrowX[0] = tabX[3];
            arrowX[1] = arrowX[0] + ARROW_WIDTH;
            arrowX[2] = (arrowX[0] + arrowX[1]) / 2.0;
            arrowY[0] = arrowY[1] = tabY[3];
            arrowY[2] = arrowY[0] + ARROW_HEIGHT;
            align = 3;
            labelX = startx;
            if (this.drawAgeLabel) {
                StringWrappingInfo ageLabel = ig.getSWIOneLine(DataColumn.getAgeLabel(node.origBaseAge), this.fonts.getFont(1), 1);
                ig.drawString(ageLabel, tabX[2] - ageLabel.getWidth() - 2.0, tabY[2] + LINE_WIDTH, ageLabel.getWidth(), ageLabelHeight, 1);
            }
        }
        ig.drawPolyline(tabX, tabY, String.valueOf(LINE_STYLE) + Settings.getStroke(node.dp == null ? 1 : node.dp.lineType));
        ig.drawPolygon(arrowX, arrowY, ARROW_STYLE);
        if (node.dp.value.toString().compareToIgnoreCase("EVENT") == 0) {
            ig.drawString(node.swi, labelX, node.calcTop + starty, node.swi.getWidth(), node.getCalcHeight(), align);
        } else {
            ig.drawString(node.swi, labelX, node.calcTop + starty, width - TEXT_MARGIN_WIDTH, node.getCalcHeight(), align);
        }
        if (node.dp.popup != null && settings.doPopups) {
            ig.pushGrouping();
            ig.doPopupThings(node.dp.popup);
            if (node.dp.value.toString().compareToIgnoreCase("EVENT") == 0) {
                ig.drawRect(labelX, node.calcTop + starty, node.swi.getWidth(), node.getCalcHeight(), "stroke-width: 0; opacity: 0.5; fill: red;");
            } else {
                ig.drawRect(labelX, node.calcTop + starty, width - TEXT_MARGIN_WIDTH, node.getCalcHeight(), "stroke-width: 0; opacity: 0.5; fill: red;");
            }
            ig.popGrouping();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void drawRange(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        iter = this.ranges.iterator();
        rangeCount = 0;
        while (iter.hasNext()) {
            block7: {
                r = (Range)iter.next();
                rangeStart = startx + (double)rangeCount * this.rangeWidth;
                rangeX = rangeStart + this.rangeWidth / 2.0;
                top = (r.top - settings.topAge) * settings.unitsPerMY + starty;
                base = (r.base - settings.topAge) * settings.unitsPerMY + starty;
                if (Double.isNaN(r.base) || Double.isNaN(r.top)) break block7;
                ig.drawLineYear(rangeX, r.base, rangeX, r.top, "stroke-width: 2; stroke: black;", starty);
                ** GOTO lbl38
            }
            if (Double.isNaN(r.base) && Double.isNaN(r.top)) {
                System.out.println("How the heck! Both ends are NaN!");
            } else {
                if (Double.isNaN(r.base)) {
                    top = (r.top - settings.topAge) * settings.unitsPerMY + starty;
                    base = Math.min(top + 10.0, starty + height);
                    ig.drawLine(rangeX, base, rangeX, top, "stroke-width: 2; stroke: black;");
                    headWidth = Math.min(2.0, (this.rangeWidth - 2.0) / 2.0);
                    ig.drawLine(rangeX, base, rangeX - headWidth, base - 4.0, "stroke-width: 2; stroke: black;");
                    ig.drawLine(rangeX, base, rangeX + headWidth, base - 4.0, "stroke-width: 2; stroke: black;");
                } else if (Double.isNaN(r.top)) {
                    base = (r.base - settings.topAge) * settings.unitsPerMY + starty;
                    top = Math.max(base - 10.0, starty);
                    ig.drawLine(rangeX, base, rangeX, top, "stroke-width: 2; stroke: black;");
                    headWidth = Math.min(2.0, (this.rangeWidth - 2.0) / 2.0);
                    ig.drawLine(rangeX, top, rangeX - headWidth, top + 4.0, "stroke-width: 2; stroke: black;");
                    ig.drawLine(rangeX, top, rangeX + headWidth, top + 4.0, "stroke-width: 2; stroke: black;");
                }
lbl38:
                // 5 sources

                if (r.popup != null && settings.doPopups) {
                    ig.pushGrouping();
                    ig.doPopupThings(r.popup);
                    ig.drawRect(rangeStart, top, this.rangeWidth, base - top, "stroke-width: 0; opacity: 0.5; fill: red;");
                    ig.popGrouping();
                }
            }
            ++rangeCount;
        }
    }

    public void cleanupDrawing() {
        if (this.type == DRAW_RANGES) {
            this.myWidth = this.eventsWidthBackup;
        }
    }

    public void findRanges(int sortBy, double baseClip, double topClip) {
        RangeEndpoint re;
        Vector<RangeEndpoint> endpoints = new Vector<RangeEndpoint>(this.data.size());
        this.ranges = Collections.synchronizedSortedSet(new TreeSet(new RangeComparator(sortBy)));
        Iterator iter = this.getData();
        while (iter.hasNext()) {
            Datapoint p = (Datapoint)iter.next();
            StringTokenizer st = new StringTokenizer(p.label, ",");
            while (st.hasMoreTokens()) {
                String l = st.nextToken().trim();
                if (l.length() < 1) continue;
                RangeEndpoint re2 = new RangeEndpoint();
                re2.age = p.baseAge;
                re2.name = l;
                re2.popup = p.popup;
                String pType = (String)p.value;
                if (pType.compareToIgnoreCase("LAD") == 0) {
                    re2.top = true;
                } else {
                    if (pType.compareToIgnoreCase("FAD") != 0) continue;
                    re2.top = false;
                }
                endpoints.add(re2);
            }
        }
        iter = endpoints.iterator();
        while (iter.hasNext()) {
            re = (RangeEndpoint)iter.next();
            if (re.used) continue;
            Iterator matchIter = endpoints.iterator();
            while (matchIter.hasNext()) {
                RangeEndpoint match = (RangeEndpoint)matchIter.next();
                if (match.used || match.name.compareToIgnoreCase(re.name) != 0) continue;
                Range r = null;
                if (!re.top && match.top) {
                    r = new Range();
                    r.base = re.age;
                    r.top = match.age;
                    r.name = re.name;
                    r.popup = this.getPopup(re, match);
                }
                if (re.top && !match.top) {
                    r = new Range();
                    r.base = match.age;
                    r.top = re.age;
                    r.name = re.name;
                    r.popup = this.getPopup(re, match);
                }
                if (r == null) continue;
                re.used = true;
                match.used = true;
                if (r.base < topClip || r.top > baseClip) continue;
                if (r.base > baseClip) {
                    r.base = baseClip;
                }
                if (r.top < topClip) {
                    r.top = topClip;
                }
                this.ranges.add(r);
            }
        }
        iter = endpoints.iterator();
        while (iter.hasNext()) {
            re = (RangeEndpoint)iter.next();
            if (re.used || re.age < topClip || re.age > baseClip) continue;
            Range r = new Range();
            if (re.top) {
                r.top = re.age;
                r.base = Double.NaN;
            } else {
                r.base = re.age;
                r.top = Double.NaN;
            }
            r.name = re.name;
            r.popup = this.getPopup(re, null);
            re.used = true;
            this.ranges.add(r);
        }
    }

    protected String getPopup(RangeEndpoint p1, RangeEndpoint p2) {
        String first = null;
        String last = null;
        if (p1 != null && p1.popup != null && p1.popup.trim().length() > 0) {
            if (!p1.top) {
                first = "First Occurance:\r\n" + p1.popup;
            } else {
                last = "Last Occurance:\r\n" + p1.popup;
            }
        }
        if (p2 != null && p2.popup != null && p2.popup.trim().length() > 0) {
            if (!p2.top) {
                first = "First Occurance:\r\n" + p2.popup;
            } else {
                last = "Last Occurance:\r\n" + p2.popup;
            }
        }
        if (first != null && last != null) {
            return String.valueOf(first) + "\r\n---\r\n" + last;
        }
        if (first != null && last == null) {
            return first;
        }
        if (first == null && last != null) {
            return last;
        }
        return null;
    }

    public int getNumSeries() {
        return 3;
    }

    public boolean canAlterSeries() {
        return false;
    }

    public SpreadSheetTableModel getSeriesModel(int which) {
        if (which < 0 || which > 2) {
            return null;
        }
        return new SpreadSheetTableModel();
    }

    public String getSeriesName(int which) {
        switch (which) {
            case 0: {
                return "FAD";
            }
            case 1: {
                return "LAD";
            }
            case 2: {
                return "EVENT";
            }
        }
        return null;
    }

    public double getWidth(Settings settings, ImageGenerator ig) {
        if (this.type != DRAW_RANGES) {
            return this.myWidth;
        }
        this.eventsWidthBackup = this.myWidth;
        this.findRanges(this.rangeSort, settings.baseAge, settings.topAge);
        StringWrappingInfo testLabelSWI = ig.getSWIOneLine("The quick brown fox jumped over the lazy dog.", this.fonts.getFont(8), 4);
        this.rangeWidth = testLabelSWI.getWidth() + 2.0;
        this.myWidth = Math.ceil((double)this.ranges.size() * this.rangeWidth);
        if (this.myWidth < 20.0) {
            this.myWidth = 20.0;
        }
        return this.myWidth;
    }

    public void readOneSetting(Element setting, Settings settings) {
        super.readOneSetting(setting, settings);
        String name = setting.getAttribute("name");
        if (name != null) {
            if (name.compareToIgnoreCase("type") == 0) {
                String t = Settings.getNodeTextContent(setting);
                this.type = t.compareToIgnoreCase("ranges") == 0 ? DRAW_RANGES : DRAW_EVENTS;
            } else if (name.compareToIgnoreCase("rangeSort") == 0) {
                String t = Settings.getNodeTextContent(setting);
                this.rangeSort = t.compareToIgnoreCase("first occurance") == 0 ? 1 : (t.compareToIgnoreCase("last occurance") == 0 ? 2 : (t.compareToIgnoreCase("alphabetical") == 0 ? 3 : 0));
            }
        }
    }

    public void writeSettings(Element element, Document doc) {
        super.writeSettings(element, doc);
        Element typeE = Settings.createSimpleSetting(doc, "type", null);
        if (this.type == DRAW_EVENTS) {
            Settings.setNodeTextContent(typeE, "events", doc);
        } else {
            Settings.setNodeTextContent(typeE, "ranges", doc);
        }
        element.appendChild(typeE);
        Element rangeSortE = Settings.createSimpleSetting(doc, "rangeSort", null);
        switch (this.rangeSort) {
            case 1: {
                Settings.setNodeTextContent(rangeSortE, "first occurance", doc);
                break;
            }
            case 2: {
                Settings.setNodeTextContent(rangeSortE, "last occurance", doc);
                break;
            }
            case 3: {
                Settings.setNodeTextContent(rangeSortE, "alphabetical", doc);
                break;
            }
            default: {
                Settings.setNodeTextContent(rangeSortE, "other", doc);
            }
        }
        element.appendChild(rangeSortE);
    }

    public class RangeEndpoint {
        double age;
        String name;
        String popup;
        boolean top = false;
        boolean used = false;
    }

    public class Range {
        double base = Double.NaN;
        double top = Double.NaN;
        String name;
        String popup;
        int mySerial;

        public Range() {
            this.mySerial = EventColumn.this.rangeSerial++;
        }
    }

    public static class RangeComparator
    implements Comparator {
        public static final int FIRST_OCCURANCE = 1;
        public static final int LAST_OCCURANCE = 2;
        public static final int ALPHABETICAL = 3;
        public static final int OTHER = 0;
        int type;

        public RangeComparator(int type) {
            this.type = type;
        }

        public int compare(Object arg0, Object arg1) {
            Range left = (Range)arg0;
            Range right = (Range)arg1;
            if (left == null || right == null) {
                return 0;
            }
            int result = this.compareByType(left, right, this.type);
            if (result == 0 && this.type == 1) {
                result = -this.compareByType(left, right, 2);
            } else if (result == 0 && this.type == 2) {
                result = -this.compareByType(left, right, 1);
            }
            if (result == 0 && this.type != 3) {
                result = this.compareByType(left, right, 3);
            }
            if (result == 0) {
                result = this.compareByType(left, right, 0);
            }
            return result;
        }

        public int compareByType(Range left, Range right, int type) {
            if (type == 1) {
                if (Double.isNaN(left.base) && Double.isNaN(right.base)) {
                    return 0;
                }
                if (Double.isNaN(left.base)) {
                    return -1;
                }
                if (Double.isNaN(right.base)) {
                    return 1;
                }
                double result = right.base - left.base;
                if (result > -1.0E-6 && result < 1.0E-6) {
                    return 0;
                }
                if (result > 0.0) {
                    return 1;
                }
                return -1;
            }
            if (type == 2) {
                if (Double.isNaN(left.top) && Double.isNaN(right.top)) {
                    return 0;
                }
                if (Double.isNaN(left.top)) {
                    return -1;
                }
                if (Double.isNaN(right.top)) {
                    return 1;
                }
                double result = left.top - right.top;
                if (result > -1.0E-6 && result < 1.0E-6) {
                    return 0;
                }
                if (result > 0.0) {
                    return 1;
                }
                return -1;
            }
            if (type == 3) {
                return left.name.compareToIgnoreCase(right.name);
            }
            return left.mySerial - right.mySerial;
        }
    }
}

