/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import gui.ImageGenerator;
import gui.Settings;
import gui.TSCreator;
import java.awt.Color;
import java.awt.FontMetrics;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JPanel;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FaciesColumn
extends DataColumn {
    public static String patternsFilename = "FaciesPatterns.xml";
    public static final Color defaultBackground = new Color(255, 255, 255);
    public static Hashtable patterns = new Hashtable();

    public FaciesColumn(String colName) {
        super(colName);
        this.setWidth(60.0);
        this.color = new Coloring(defaultBackground);
    }

    public JPanel getOptionsPanel(Settings s) {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
        }
        return this.optionsPanel;
    }

    public static void setupPatterns(ImageGenerator ig) {
        FaciesColumn.readPatterns(TSCreator.getURL(patternsFilename).toString());
        FaciesColumn.writePatterns(ig);
    }

    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        super.drawData(ig, startx, starty, width, height, settings);
        Iterator iter = this.getData();
        double curTop = settings.topAge;
        double curBase = settings.baseAge;
        double ageLabelHeight = 0.0;
        if (this.drawAgeLabel) {
            FontMetrics fm = ig.getFontMetrics(this.fonts.getFont(1));
            ageLabelHeight = fm.getAscent();
        }
        while (iter.hasNext() && curTop + 1.0E-6 < settings.baseAge) {
            Datapoint p = (Datapoint)iter.next();
            if (p.baseAge - 1.0E-6 < settings.topAge) continue;
            if (p.breaker) {
                curTop = p.baseAge;
                continue;
            }
            curBase = p.baseAge;
            if (curBase + 1.0E-6 > settings.baseAge) {
                curBase = settings.baseAge;
            }
            String styleToUse = FaciesColumn.getPatternStyle(p.value.toString());
            ig.drawRectYear(startx, curTop, width, curBase - curTop, styleToUse, starty);
            if (this.drawAgeLabel) {
                ig.drawString(ig.getSWIOneLine(DataColumn.getAgeLabel(p.baseAge), this.fonts.getFont(1), 1), startx + 2.0, (curBase - settings.topAge) * settings.unitsPerMY + starty - ageLabelHeight, 20.0, ageLabelHeight, 3, 0.0, 12, Coloring.getStyle(this.color.getColor(p.baseAge, p.baseAge)));
            }
            if (p.popup != null && settings.doPopups) {
                ig.pushGrouping();
                ig.doPopupThings(p.popup);
                ig.drawRectYear(startx, curTop, width, curBase - curTop, "stroke-width: 0; opacity: 0.5; fill: red;", starty);
                ig.popGrouping();
            }
            curTop = curBase;
        }
        this.drawOverlays(ig, startx, starty, width, height, settings);
    }

    public static String getPatternFill(String name) {
        Object p = patterns.get(name = name.replace(' ', '_'));
        if (p == null) {
            return "white";
        }
        return "url(#FaciesColumn_" + name + ")";
    }

    public static String getPatternStyle(String name) {
        Object p = patterns.get(name = name.replace(' ', '_'));
        if (p == null) {
            return "stroke-width: 0.5; stroke: black; fill: white;";
        }
        return "stroke-width: 0.5; stroke: black; fill: url(#FaciesColumn_" + name + ");";
    }

    public static void readPatterns(String filePath) {
        DOMParser parser = new DOMParser();
        try {
            parser.parse(filePath);
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        Document document = parser.getDocument();
        Element root = document.getDocumentElement();
        NodeList nl = root.getChildNodes();
        int nodeIndex = 0;
        while (nodeIndex < nl.getLength()) {
            String name;
            Node node = nl.item(nodeIndex);
            if (node.getNodeType() == 1 && (name = node.getNodeName()).compareToIgnoreCase("lithologyPatterns") == 0) {
                NodeList pat_nl = node.getChildNodes();
                int patIndex = 0;
                while (patIndex < pat_nl.getLength()) {
                    String pat_name;
                    Node pat_node = pat_nl.item(patIndex);
                    if (pat_node.getNodeType() == 1 && (pat_name = pat_node.getNodeName()).compareToIgnoreCase("pattern") == 0) {
                        FaciesColumn.readPattern((Element)pat_node);
                    }
                    ++patIndex;
                }
            }
            ++nodeIndex;
        }
    }

    public static void readPattern(Element p) {
        String name = p.getAttribute("id");
        patterns.put(name, p);
    }

    public static void writePatterns(ImageGenerator ig) {
        Enumeration e = patterns.elements();
        while (e.hasMoreElements()) {
            String name;
            Element p = (Element)e.nextElement();
            if (p.getTagName().compareToIgnoreCase("pattern") != 0 || (name = p.getAttribute("id")) == null || name.length() == 0) continue;
            p.setAttribute("id", "FaciesColumn_" + name);
            ig.pushPatternCopy(p);
            ig.popPattern();
        }
    }
}

