/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.Coloring;
import datastore.DataColumn;
import datastore.FaciesColumn;
import gui.ImageGenerator;
import gui.SVGStyleParser;
import gui.Settings;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class FreehandColumn
extends DataColumn {
    public DataColumn underlay = null;
    public double xLow = 0.0;
    public double xHigh = 100.0;
    public List primitives = new Vector();

    public FreehandColumn(String colName, DataColumn underlayCol) {
        super(colName);
        this.xHigh = this.myWidth;
        this.setColor(new Coloring(Color.white));
        this.underlay = underlayCol;
    }

    public void setWidth(double newWidth) {
        super.setWidth(newWidth);
        this.xHigh = this.myWidth;
    }

    public void addPrimitive(Primitive p) {
        this.primitives.add(p);
        if (p.baseAge > this.maxAge) {
            this.maxAge = p.baseAge;
        }
        if (p.topAge < this.minAge) {
            this.minAge = p.topAge;
        }
    }

    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        if (this.underlay == null) {
            super.drawData(ig, startx, starty, width, height, settings);
        }
        String cp = ig.pushClipPath();
        ig.drawRect(startx, starty, width, height, null);
        ig.popClipPath();
        ig.pushGrouping();
        ig.setClipPath(cp);
        Iterator iter = this.primitives.iterator();
        while (iter.hasNext()) {
            Primitive prim = (Primitive)iter.next();
            if (!(prim.getBase(ig, settings, starty) > starty) && !(prim.getTop(ig, settings, starty) < starty + height)) continue;
            prim.draw(ig, startx, starty, width, height, settings);
        }
        ig.popGrouping();
        this.drawOverlays(ig, startx, starty, width, height, settings);
    }

    public static class Primitive {
        double topAge = Double.POSITIVE_INFINITY;
        double baseAge = Double.NEGATIVE_INFINITY;
        double topUnitsAdd;
        double baseUnitsAdd;
        String popup;
        Map style;
        double strokeWidth = 1.0;
        String stroke = "black";
        String fill = "none";
        String faciesFill = null;

        public void draw(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        }

        public double getTop(ImageGenerator ig, Settings settings, double starty) {
            return (this.topAge - settings.topAge) * settings.unitsPerMY - this.topUnitsAdd + starty;
        }

        public double getBase(ImageGenerator ig, Settings settings, double starty) {
            return (this.baseAge - settings.topAge) * settings.unitsPerMY + this.baseUnitsAdd + starty;
        }

        public void setStyle(String SVGStyle) {
            this.style = SVGStyleParser.parseSVGStyle(SVGStyle);
            this.strokeWidth = SVGStyleParser.getDouble(this.style, "stroke-width", this.strokeWidth);
            this.stroke = SVGStyleParser.getString(this.style, "stroke", this.stroke);
            this.fill = SVGStyleParser.getString(this.style, "fill", this.fill);
            this.style.remove("stroke-width");
            this.style.remove("stroke");
            this.style.remove("fill");
            this.topUnitsAdd = this.baseUnitsAdd = this.strokeWidth / 2.0;
        }

        public String getStyleString() {
            String ret = SVGStyleParser.getStyleString(this.style);
            ret = String.valueOf(ret) + SVGStyleParser.getStyleString("stroke-width", "" + this.strokeWidth);
            ret = String.valueOf(ret) + SVGStyleParser.getStyleString("stroke", this.stroke);
            if (this.faciesFill != null) {
                this.fill = FaciesColumn.getPatternFill(this.faciesFill);
            }
            ret = String.valueOf(ret) + SVGStyleParser.getStyleString("fill", this.fill);
            return ret;
        }
    }

    public class Polygon
    extends Primitive {
        public boolean smoothed = true;
        public boolean closed = true;
        public List points = new Vector();

        public void addPoint(double x, double y, boolean smooth) {
            Point p = new Point();
            p.x = x;
            p.y = y;
            p.smooth = smooth;
            this.points.add(p);
            if (y > this.baseAge) {
                this.baseAge = y;
            }
            if (y < this.topAge) {
                this.topAge = y;
            }
        }

        public int getNumPoints() {
            return this.points.size();
        }

        public void setPattern(String pat) {
            this.faciesFill = pat;
        }

        public void draw(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
            if (this.points.size() < 2) {
                return;
            }
            double[] x = new double[this.points.size()];
            double[] y = new double[this.points.size()];
            boolean[] sharp = new boolean[this.points.size()];
            int i = 0;
            while (i < this.points.size()) {
                Point p = (Point)this.points.get(i);
                x[i] = (p.x - FreehandColumn.this.xLow) * width / (FreehandColumn.this.xHigh - FreehandColumn.this.xLow) + startx;
                y[i] = ImageGenerator.getYFromYear(p.y, starty, settings);
                sharp[i] = !p.smooth;
                ++i;
            }
            ig.drawSmoothPolyline(x, y, sharp, this.getStyleString(), this.closed);
            if (this.popup != null && settings.doPopups) {
                ig.pushGrouping();
                ig.doPopupThings(this.popup);
                ig.drawSmoothPolyline(x, y, sharp, "stroke-width: 0; opacity: 0.5; fill: red;", true);
                ig.popGrouping();
            }
        }

        public class Point {
            double x;
            double y;
            boolean smooth = true;
        }
    }
}

