/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import datastore.SequenceColumn;
import gui.ImageGenerator;
import gui.Settings;
import gui.SpringUtilities;
import gui.StringWrappingInfo;
import gui.TSCreator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PointColumn
extends DataColumn {
    public boolean drawPoints = true;
    public int pointType = 1;
    public boolean drawLine = true;
    public boolean drawSmooth = false;
    public boolean drawFill = true;
    public Color fillColor = new Color(64, 233, 191);
    public boolean doNotSetWindowAuto = false;
    public double minWindow = 0.0;
    public double maxWindow = 0.0;
    public double maxMag = Double.NEGATIVE_INFINITY;
    public double minMag = Double.POSITIVE_INFINITY;
    public boolean drawScale = false;
    public double scaleStart = 0.0;
    public double scaleStep = 1.0;
    public static final double scaleTickLength = 5.0;
    public static final double SCALE_DEFAULT_STEP_RATIO = 0.2;
    public static final String SCALE_TICK_STYLE = "stroke-width: 1; stroke: black; fill: none;";
    public static final double SCALE_TICK_LABEL_MARGIN = 1.0;
    public static final double SCALE_LABEL_TITLE_MARGIN = 2.0;
    public static final double SCALE_LABEL_TEXT_MARGIN = 2.0;
    public static final double MARGIN = 0.1;
    public static final String POINT_LINE_STYLE = "stroke-width: 1; stroke: black; fill: none;";

    public PointColumn(String colName) {
        super(colName);
        this.setColor(new Coloring(Color.white));
    }

    public static double getMag(Datapoint p) {
        return (Double)p.value;
    }

    public void addData(Datapoint dp) {
        super.addData(dp);
        if (dp != null) {
            double mag = PointColumn.getMag(dp);
            if (mag > this.maxMag) {
                this.maxMag = mag;
            }
            if (mag < this.minMag) {
                this.minMag = mag;
            }
            double margin = (this.maxMag - this.minMag) * 0.1;
            if (!this.doNotSetWindowAuto) {
                this.minWindow = this.minMag - margin / 2.0;
                this.maxWindow = this.maxMag + margin / 2.0;
                this.scaleStep = (this.maxWindow - this.minWindow) * 0.2;
            }
        }
    }

    public double getXFromMag(double mag, double startx, double width) {
        double percent = (mag - this.minWindow) / (this.maxWindow - this.minWindow);
        double ret = startx + width - width * percent;
        if (ret < startx) {
            return startx;
        }
        if (ret > startx + width) {
            return startx + width;
        }
        return ret;
    }

    public double getUnclippedXFromMag(double mag, double startx, double width) {
        double percent = (mag - this.minWindow) / (this.maxWindow - this.minWindow);
        double ret = startx + width - width * percent;
        return ret;
    }

    public double getIntersectionMag(Datapoint top, Datapoint base, double cutAge) {
        double magBase;
        if (top == null || base == null) {
            return -1.0;
        }
        if (base.baseAge < top.baseAge) {
            Datapoint temp = top;
            top = base;
            base = temp;
        }
        if (top.baseAge > cutAge || base.baseAge < cutAge) {
            return -1.0;
        }
        double magTop = PointColumn.getMag(top);
        if (Settings.isEqual(magTop, magBase = PointColumn.getMag(base))) {
            return magTop;
        }
        double slope = (magTop - magBase) / (top.baseAge - base.baseAge);
        double ret = magBase + (cutAge - base.baseAge) * slope;
        return ret;
    }

    public JPanel getOptionsPanel(Settings s) {
        if (this.optionsPanel == null) {
            this.optionsPanel = new PCOptionsPanel(this);
        }
        return this.optionsPanel;
    }

    public void readTextFieldsFromPanel() {
        if (this.optionsPanel == null) {
            return;
        }
        PCOptionsPanel op = (PCOptionsPanel)this.optionsPanel;
        String s = op.tfMinWin.getText();
        try {
            this.minWindow = Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            this.minWindow = this.minMag;
        }
        s = op.tfMaxWin.getText();
        try {
            this.maxWindow = Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            this.maxWindow = this.maxMag;
        }
        s = op.tfScaleStart.getText();
        try {
            this.scaleStart = Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            this.scaleStart = 0.0;
        }
        s = op.tfScaleStep.getText();
        try {
            this.scaleStep = Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            this.scaleStep = (this.maxWindow - this.minWindow) * 0.2;
        }
        op.readTextFieldsFromColumn();
    }

    public double getHeaderHeight(Settings settings, ImageGenerator ig) {
        super.getHeaderHeight(settings, ig);
        if (this.drawScale) {
            StringWrappingInfo testLabelSWI = ig.getSWIOneLine("0123456789.", this.fonts.getFont(7), 1);
            double scaleTextHeight = testLabelSWI.getHeight();
            this.myOwnHeaderHeight += scaleTextHeight + 1.0 + 2.0 + 5.0;
        }
        this.myHeaderHeight = this.myOwnHeaderHeight;
        return this.myHeaderHeight;
    }

    public void drawHeader(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        this.readTextFieldsFromPanel();
        if (this.myWidth < 0.0) {
            this.myWidth = this.getWidth(settings, ig);
        }
        if (this.myHeaderHeight < 0.0) {
            this.myHeaderHeight = this.getHeaderHeight(settings, ig);
        }
        double scaleHeight = 0.0;
        if (this.drawScale) {
            StringWrappingInfo testLabelSWI = ig.getSWIOneLine("0123456789.", this.fonts.getFont(7), 1);
            double scaleTextHeight = testLabelSWI.getHeight();
            scaleHeight = scaleTextHeight + 1.0 + 2.0 + 5.0;
        }
        if (this.name.length() > 0 && this.drawTitle) {
            ig.drawString(this.nameWrap, startx, starty, width, height - scaleHeight, 3);
        }
        if (this.drawScale) {
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMinimumFractionDigits(0);
            double lastLabelLeft = startx + width;
            double scaleX = 0.0;
            scaleX = this.scaleStart > this.minWindow ? this.scaleStart - Math.floor((this.scaleStart - this.minWindow) / this.scaleStep) * this.scaleStep : this.scaleStart + Math.ceil((this.minWindow - this.scaleStart) / this.scaleStep) * this.scaleStep;
            while (scaleX < this.maxWindow) {
                double labelRight;
                ig.drawLine(this.getXFromMag(scaleX, startx, width), starty + height - 5.0, this.getXFromMag(scaleX, startx, width), starty + height, "stroke-width: 1; stroke: black; fill: none;");
                String label = nf.format(scaleX);
                StringWrappingInfo labelSWI = ig.getSWIOneLine(label, this.fonts.getFont(7), 1);
                double labelHeight = labelSWI.getHeight();
                double labelWidth = labelSWI.getWidth();
                if (!(lastLabelLeft < this.getXFromMag(scaleX, startx, width)) && !((labelRight = Math.min(lastLabelLeft - 2.0, this.getXFromMag(scaleX, startx, width) + labelWidth / 2.0)) - labelWidth < startx)) {
                    ig.drawString(labelSWI, labelRight - labelWidth, starty + height - 5.0 - 1.0 - labelHeight, labelWidth, labelHeight, 2);
                    lastLabelLeft = labelRight - labelWidth;
                }
                scaleX += this.scaleStep;
            }
        }
    }

    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        boolean[] smoothNextB;
        double[] coordY;
        double[] coordX;
        super.drawData(ig, startx, starty, width, height, settings);
        this.readTextFieldsFromPanel();
        Iterator iter = this.getData();
        Datapoint p = null;
        Datapoint lastP = null;
        boolean setupTop = true;
        Vector<Double> x = new Vector<Double>();
        Vector<Double> y = new Vector<Double>();
        Vector<Boolean> lineTo = new Vector<Boolean>();
        Datapoint start = null;
        Datapoint oneAfterStart = null;
        Datapoint end = null;
        double minMag = Double.POSITIVE_INFINITY;
        while (iter.hasNext()) {
            p = (Datapoint)iter.next();
            if (p.baseAge - 1.0E-6 < settings.topAge) {
                lastP = p;
                start = oneAfterStart;
                oneAfterStart = p;
                if (start == null) {
                    start = p;
                }
                minMag = Math.min(PointColumn.getMag(start), PointColumn.getMag(oneAfterStart));
                continue;
            }
            if (start == null) {
                start = p;
            }
            minMag = Math.min(minMag, PointColumn.getMag(p));
            if (p.baseAge + 1.0E-6 > settings.baseAge) break;
            lastP = p;
        }
        if (Double.isInfinite(minMag)) {
            minMag = this.minWindow;
        }
        if ((end = p) == null) {
            end = lastP;
        }
        if (iter.hasNext()) {
            end = (Datapoint)iter.next();
        }
        if (start == end) {
            return;
        }
        iter = this.getData();
        boolean reachedStart = false;
        while (iter.hasNext()) {
            p = (Datapoint)iter.next();
            if (!reachedStart && p != start) continue;
            reachedStart = true;
            if (setupTop) {
                x.add(new Double(Math.max(startx + width, this.getUnclippedXFromMag(minMag, startx, width))));
                y.add(new Double(ImageGenerator.getYFromYear(p.baseAge, starty, settings)));
                lineTo.add(new Boolean(true));
                setupTop = false;
            }
            double mag = PointColumn.getMag(p);
            double curX = this.getUnclippedXFromMag(mag, startx, width);
            double curY = ImageGenerator.getYFromYear(p.baseAge, starty, settings);
            x.add(new Double(curX));
            y.add(new Double(curY));
            lineTo.add(new Boolean(p == start));
            if (p == end) break;
        }
        x.add(new Double(Math.max(startx + width, this.getUnclippedXFromMag(minMag, startx, width))));
        y.add(new Double(ImageGenerator.getYFromYear(p.baseAge, starty, settings)));
        lineTo.add(new Boolean(true));
        String cp = ig.pushClipPath();
        ig.drawRect(startx, starty, width, height, null);
        ig.popClipPath();
        ig.pushGrouping();
        ig.setClipPath(cp);
        if (this.drawFill) {
            coordX = SequenceColumn.getDoubleArray(x);
            coordY = SequenceColumn.getDoubleArray(y);
            smoothNextB = SequenceColumn.getBooleanArray(lineTo);
            ig.drawSmoothVerticalPolyline(coordX, coordY, smoothNextB, "stroke-width: 0;" + Coloring.getFillStyle(this.fillColor));
        }
        if (this.drawPoints || this.drawLine) {
            coordX = SequenceColumn.getDoubleArray(x, 1, x.size() - 1);
            coordY = SequenceColumn.getDoubleArray(y, 1, y.size() - 1);
            smoothNextB = SequenceColumn.getBooleanArray(lineTo, 1, lineTo.size() - 1);
            if (this.drawLine) {
                ig.drawSmoothVerticalPolyline(coordX, coordY, smoothNextB, "stroke-width: 1; stroke: black; fill: none;");
            }
            if (this.drawPoints) {
                ig.drawPoints(coordX, coordY, this.pointType, null);
            }
        }
        ig.popGrouping();
        this.drawOverlays(ig, startx, starty, width, height, settings);
    }

    public void readOneSetting(Element setting, Settings settings) {
        super.readOneSetting(setting, settings);
        String name = setting.getAttribute("name");
        if (name != null && name.compareToIgnoreCase("drawPoints") != 0) {
            if (name.compareToIgnoreCase("drawLine") == 0) {
                this.drawLine = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("drawSmooth") == 0) {
                this.drawSmooth = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("drawFill") == 0) {
                this.drawFill = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("fillColor") == 0) {
                this.fillColor = Coloring.getColorFromStyle(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("doNotSetWindowAuto") == 0) {
                this.doNotSetWindowAuto = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("minWindow") == 0) {
                this.minWindow = Double.parseDouble(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("maxWindow") == 0) {
                this.maxWindow = Double.parseDouble(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("scaleStart") == 0) {
                this.scaleStart = Double.parseDouble(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("scaleStep") == 0) {
                this.scaleStep = Double.parseDouble(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("pointType") == 0) {
                String pt = setting.getAttribute("pointType");
                this.pointType = pt.compareToIgnoreCase("round") == 0 ? 2 : (pt.compareToIgnoreCase("rect") == 0 ? 1 : 3);
            }
        }
    }

    public void writeSettings(Element element, Document doc) {
        super.writeSettings(element, doc);
        this.readTextFieldsFromPanel();
        element.appendChild(Settings.createSimpleSetting(doc, "drawPoints", "" + this.drawPoints));
        element.appendChild(Settings.createSimpleSetting(doc, "drawLine", "" + this.drawLine));
        element.appendChild(Settings.createSimpleSetting(doc, "drawSmooth", "" + this.drawSmooth));
        element.appendChild(Settings.createSimpleSetting(doc, "drawFill", "" + this.drawFill));
        element.appendChild(Settings.createSimpleSetting(doc, "fillColor", Coloring.getColorStyle(this.fillColor)));
        element.appendChild(Settings.createSimpleSetting(doc, "doNotSetWindowAuto", "" + this.doNotSetWindowAuto));
        element.appendChild(Settings.createSimpleSetting(doc, "minWindow", "" + this.minWindow));
        element.appendChild(Settings.createSimpleSetting(doc, "maxWindow", "" + this.maxWindow));
        element.appendChild(Settings.createSimpleSetting(doc, "drawScale", "" + this.drawScale));
        element.appendChild(Settings.createSimpleSetting(doc, "scaleStart", "" + this.scaleStart));
        element.appendChild(Settings.createSimpleSetting(doc, "scaleStep", "" + this.scaleStep));
        Element ptE = Settings.createSimpleSetting(doc, "pointType", "");
        switch (this.pointType) {
            case 1: {
                ptE.setAttribute("pointType", "rect");
                break;
            }
            case 2: {
                ptE.setAttribute("pointType", "round");
                break;
            }
            default: {
                ptE.setAttribute("pointType", "tick");
            }
        }
        element.appendChild(ptE);
    }

    public class PCOptionsPanel
    extends JPanel
    implements ActionListener,
    ItemListener {
        PointColumn pc;
        JCheckBox bTicks = new JCheckBox("Points:");
        JRadioButton tickRect = new JRadioButton("<html><img src=\"" + TSCreator.getURL("rect.gif").toString() + "\"</html>");
        JRadioButton tickRound = new JRadioButton("<html><img src=\"" + TSCreator.getURL("round.gif").toString() + "\"</html>");
        JRadioButton tickTick = new JRadioButton("<html><img src=\"" + TSCreator.getURL("tick.gif").toString() + "\"</html>");
        JCheckBox bLine = new JCheckBox("Line");
        JCheckBox bSmooth = new JCheckBox("Smoothed");
        JCheckBox bFill = new JCheckBox("Fill:");
        JButton colorPick = new JButton("Choose");
        JPanel colorPreview = new JPanel();
        JLabel rangeLabel = new JLabel("Range:");
        JLabel toLabel = new JLabel("to");
        JTextField tfMinWin = new JTextField();
        JTextField tfMaxWin = new JTextField();
        JButton autoWin = new JButton("auto");
        JTextField tfScaleStart = new JTextField();
        JTextField tfScaleStep = new JTextField();
        JLabel scaleStartLabel = new JLabel("Start:");
        JLabel scaleStepLabel = new JLabel("Step:");
        JCheckBox bDrawScale = new JCheckBox("Show Scale:");

        public PCOptionsPanel(PointColumn pc) {
            this.pc = pc;
            ButtonGroup tickGroup = new ButtonGroup();
            tickGroup.add(this.tickRect);
            tickGroup.add(this.tickRound);
            tickGroup.add(this.tickTick);
            this.bTicks.addItemListener(this);
            this.tickRect.addItemListener(this);
            this.tickRound.addItemListener(this);
            this.tickTick.addItemListener(this);
            this.bLine.addItemListener(this);
            this.bSmooth.addItemListener(this);
            this.bFill.addItemListener(this);
            this.colorPick.addActionListener(this);
            this.autoWin.addActionListener(this);
            this.bDrawScale.addItemListener(this);
            SpringLayout layout = new SpringLayout();
            this.setLayout(layout);
            JPanel tickPanel = new JPanel(new GridLayout(1, 4));
            tickPanel.setLayout(new BoxLayout(tickPanel, 0));
            Dimension d = this.bTicks.getPreferredSize();
            this.bTicks.setMinimumSize(d);
            tickPanel.add(this.bTicks);
            tickPanel.add(this.tickRect);
            tickPanel.add(this.tickRound);
            tickPanel.add(this.tickTick);
            this.add(tickPanel);
            layout.putConstraint("East", (Component)tickPanel, -5, "East", (Component)this);
            layout.putConstraint("West", (Component)tickPanel, 5, "West", (Component)this);
            layout.putConstraint("North", (Component)tickPanel, 0, "North", (Component)this);
            this.add(this.bLine);
            layout.putConstraint("West", (Component)this.bLine, 5, "West", (Component)this);
            layout.putConstraint("North", (Component)this.bLine, 5, "South", (Component)tickPanel);
            JPanel fillPanel = new JPanel();
            this.colorPreview.setPreferredSize(new Dimension(20, 20));
            fillPanel.add(this.bFill);
            fillPanel.add(this.colorPick);
            fillPanel.add(this.colorPreview);
            this.add(fillPanel);
            layout.putConstraint("West", (Component)fillPanel, 0, "West", (Component)this);
            layout.putConstraint("North", (Component)fillPanel, 0, "South", (Component)this.bLine);
            this.add(this.bSmooth);
            layout.putConstraint("West", (Component)this.bSmooth, 5, "West", (Component)this);
            layout.putConstraint("North", (Component)this.bSmooth, 5, "South", (Component)fillPanel);
            d = this.tfMinWin.getPreferredSize();
            d.width = 40;
            this.tfMinWin.setPreferredSize(d);
            d = this.tfMaxWin.getPreferredSize();
            d.width = 40;
            this.tfMaxWin.setPreferredSize(d);
            d = this.tfScaleStart.getPreferredSize();
            d.width = 40;
            this.tfScaleStart.setPreferredSize(d);
            d = this.tfScaleStep.getPreferredSize();
            d.width = 40;
            this.tfScaleStep.setPreferredSize(d);
            JPanel minMaxPanel = new JPanel();
            minMaxPanel.add(this.rangeLabel);
            minMaxPanel.add(this.tfMinWin);
            minMaxPanel.add(this.toLabel);
            minMaxPanel.add(this.tfMaxWin);
            minMaxPanel.add(this.autoWin);
            this.add(minMaxPanel);
            layout.putConstraint("West", (Component)minMaxPanel, 5, "West", (Component)this);
            layout.putConstraint("North", (Component)minMaxPanel, 5, "South", (Component)this.bSmooth);
            this.add(this.bDrawScale);
            layout.putConstraint("West", (Component)this.bDrawScale, 5, "West", (Component)this);
            layout.putConstraint("North", (Component)this.bDrawScale, 5, "South", (Component)minMaxPanel);
            JPanel scalePanel = new JPanel(new SpringLayout());
            scalePanel.add(this.scaleStartLabel);
            scalePanel.add(this.tfScaleStart);
            scalePanel.add(this.scaleStepLabel);
            scalePanel.add(this.tfScaleStep);
            SpringUtilities.makeCompactGrid(scalePanel, 2, 2, 0, 0, 5, 5, true);
            this.add(scalePanel);
            layout.putConstraint("West", (Component)scalePanel, 5, "East", (Component)this.bDrawScale);
            layout.putConstraint("North", (Component)scalePanel, 0, "North", (Component)this.bDrawScale);
            layout.putConstraint("South", (Component)this, 0, "South", (Component)scalePanel);
            this.readDataFromPC();
        }

        public void readTextFieldsFromColumn() {
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setGroupingUsed(false);
            nf.setMinimumFractionDigits(0);
            this.tfMinWin.setText(nf.format(this.pc.minWindow));
            this.tfMaxWin.setText(nf.format(this.pc.maxWindow));
            this.tfScaleStart.setText(nf.format(this.pc.scaleStart));
            this.tfScaleStep.setText(nf.format(this.pc.scaleStep));
        }

        public void doGraying() {
            boolean enTicks = this.bTicks.isSelected();
            this.tickRect.setEnabled(enTicks);
            this.tickRound.setEnabled(enTicks);
            this.tickTick.setEnabled(enTicks);
            boolean enFill = this.bFill.isSelected();
            this.colorPick.setEnabled(enFill);
            this.colorPreview.setEnabled(enFill);
            boolean enScale = this.bDrawScale.isSelected();
            this.tfScaleStart.setEnabled(enScale);
            this.tfScaleStep.setEnabled(enScale);
            this.scaleStartLabel.setEnabled(enScale);
            this.scaleStepLabel.setEnabled(enScale);
        }

        public void readDataFromPC() {
            this.bTicks.setSelected(this.pc.drawPoints);
            this.bLine.setSelected(this.pc.drawLine);
            this.bSmooth.setSelected(this.pc.drawSmooth);
            this.bFill.setSelected(this.pc.drawFill);
            switch (this.pc.pointType) {
                case 1: {
                    this.tickRect.setSelected(true);
                    break;
                }
                case 2: {
                    this.tickRound.setSelected(true);
                    break;
                }
                default: {
                    this.tickTick.setSelected(true);
                }
            }
            this.colorPreview.setBackground(this.pc.fillColor);
            this.bDrawScale.setSelected(this.pc.drawScale);
            this.readTextFieldsFromColumn();
            this.doGraying();
        }

        public void actionPerformed(ActionEvent e) {
            Color chosenColor;
            Object source = e.getSource();
            if (source == this.autoWin) {
                double margin = (this.pc.maxMag - this.pc.minMag) * 0.1;
                this.pc.minWindow = this.pc.minMag - margin / 2.0;
                this.pc.maxWindow = this.pc.maxMag + margin / 2.0;
                this.pc.scaleStart = 0.0;
                this.pc.scaleStep = (this.pc.maxWindow - this.pc.minWindow) * 0.2;
                this.readTextFieldsFromColumn();
            } else if (source == this.colorPick && (chosenColor = JColorChooser.showDialog(this, "Choose Graph's Fill Color", this.pc.fillColor)) != null) {
                this.pc.fillColor = chosenColor;
                this.colorPreview.setBackground(chosenColor);
            }
        }

        public void itemStateChanged(ItemEvent ie) {
            Object source = ie.getSource();
            if (source == this.bTicks) {
                this.pc.drawPoints = this.bTicks.isSelected();
                this.doGraying();
            } else if (source == this.bLine) {
                this.pc.drawLine = this.bLine.isSelected();
                this.doGraying();
            } else if (source == this.bSmooth) {
                this.pc.drawSmooth = this.bSmooth.isSelected();
            } else if (source == this.bFill) {
                this.pc.drawFill = this.bFill.isSelected();
                this.doGraying();
            } else if (source == this.tickRect) {
                this.pc.pointType = 1;
            } else if (source == this.tickRound) {
                this.pc.pointType = 2;
            } else if (source == this.tickTick) {
                this.pc.pointType = 3;
            } else if (source == this.bDrawScale) {
                this.pc.drawScale = this.bDrawScale.isSelected();
                this.doGraying();
            }
        }
    }
}

