/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.CollisionAvoider;
import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import gui.ImageGenerator;
import gui.Settings;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SequenceColumn
extends DataColumn {
    public static final double SEQ_MINOR = 0.25;
    public static final double SEQ_MEDIUM = 0.5;
    public static final double SEQ_MAJOR = 0.75;
    public static final double TR_MINOR = 0.33;
    public static final double TR_MEDIUM = 0.66;
    public static final double TR_MAJOR = 1.0;
    public static final int SEQUENCE = 1;
    public static final int TREND = 2;
    public static final String SEQUENCE_STYLE = "stroke-width: 0; fill: rgb(64, 191, 233);";
    public static final String TREND_STYLE = "stroke-width: 1; stroke: black; fill: rgb(64, 191, 233);";
    public static final String MFS_LINE_STYLE = "stroke-width: 0.5; stroke: black;stroke-dasharray:10,5;";
    public static final String MINOR_LINE_STYLE = "stroke-width: 1; stroke: black;";
    public static final String MEDIUM_LINE_STYLE = "stroke-width: 2; stroke: black;";
    public static final String MAJOR_LINE_STYLE = "stroke-width: 3; stroke: black;";
    public static final double LABEL_MARGIN_SIZE_LEFT = 5.0;
    public static final double LABEL_MARGIN_SIZE_RIGHT = 5.0;
    public static final double LABEL_MARGIN_SIZE_LEFT_WITH_AGE = 25.0;
    public double labelMarginLeft = 5.0;
    public double labelMarginRight = 5.0;
    public String graphStyle = "stroke-width: 0; fill: rgb(64, 191, 233);";
    public int type = 1;
    public boolean drawNameLabel;

    public static double roundMag(double mag, int colType) {
        if (colType == 1) {
            if (mag < 0.375) {
                return 0.25;
            }
            if (mag < 0.875) {
                return 0.5;
            }
            return 0.75;
        }
        if (mag < 0.495) {
            return 0.33;
        }
        if (mag < 1.1600000000000001) {
            return 0.66;
        }
        return 1.0;
    }

    public double getXFromMag(double mag, String dir, double startx, double width) {
        if (dir.compareToIgnoreCase("SB") == 0) {
            return width + startx;
        }
        return startx + width - width * mag;
    }

    public static double getMag(Datapoint p) {
        return (Double)p.value;
    }

    public double getGraphMag(double mag, String direction) {
        if (direction.compareToIgnoreCase("SB") == 0) {
            return 0.0;
        }
        return mag;
    }

    public double getIntersectionMag(Datapoint top, Datapoint base, double cutAge) {
        double magBase;
        if (top == null || base == null) {
            return -1.0;
        }
        if (base.baseAge < top.baseAge) {
            Datapoint temp = top;
            top = base;
            base = temp;
        }
        if (top.baseAge > cutAge || base.baseAge < cutAge) {
            return -1.0;
        }
        double magTop = this.getGraphMag(SequenceColumn.getMag(top), top.direction);
        if (Settings.isEqual(magTop, magBase = this.getGraphMag(SequenceColumn.getMag(base), base.direction))) {
            return magTop;
        }
        double slope = (magTop - magBase) / (top.baseAge - base.baseAge);
        double ret = magBase + (cutAge - base.baseAge) * slope;
        return ret;
    }

    public static double[] getDoubleArray(Vector v) {
        return SequenceColumn.getDoubleArray(v, 0, v.size());
    }

    public static double[] getDoubleArray(Vector v, int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end < start) {
            end = start;
        }
        if (end > v.size()) {
            end = v.size();
        }
        double[] ret = new double[end - start];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (Double)v.elementAt(i + start);
            ++i;
        }
        return ret;
    }

    public static boolean[] getBooleanArray(Vector v) {
        return SequenceColumn.getBooleanArray(v, 0, v.size());
    }

    public static boolean[] getBooleanArray(Vector v, int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end < start) {
            end = start;
        }
        if (end > v.size()) {
            end = v.size();
        }
        boolean[] ret = new boolean[end - start];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (Boolean)v.elementAt(i + start);
            ++i;
        }
        return ret;
    }

    public SequenceColumn(String colName, int type) {
        super(colName);
        if (type == 2) {
            this.type = 2;
            this.graphStyle = TREND_STYLE;
            this.setColor(new Coloring(new Color(245, 204, 131)));
        } else {
            this.type = 1;
            this.graphStyle = SEQUENCE_STYLE;
            this.setColor(new Coloring(Color.WHITE));
        }
    }

    public JPanel getOptionsPanel(Settings s) {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
            this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
            final SequenceColumn thisSC = this;
            JCheckBox nameLabelCB = new JCheckBox("Show Name Labels");
            nameLabelCB.setSelected(this.drawNameLabel);
            nameLabelCB.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent ie) {
                    thisSC.drawNameLabel = ((JCheckBox)ie.getItem()).isSelected();
                }
            });
            this.optionsPanel.add(nameLabelCB);
        }
        return this.optionsPanel;
    }

    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        CollisionAvoider.Node node;
        int i;
        double textToAddBase;
        double mag;
        super.drawData(ig, startx, starty, width, height, settings);
        Iterator iter = this.getData();
        Datapoint p = null;
        Datapoint lastP = null;
        boolean setupTop = true;
        boolean drawBaseClipped = false;
        Vector<Double> x = new Vector<Double>();
        Vector<Double> y = new Vector<Double>();
        Vector<Datapoint> trendLinesToDraw = new Vector<Datapoint>();
        double unitToAgeFactor = height / (settings.baseAge - settings.topAge);
        CollisionAvoider text_ca = new CollisionAvoider(0.0, height, 0.0, width - this.labelMarginLeft - this.labelMarginRight, width - this.labelMarginLeft - this.labelMarginRight);
        CollisionAvoider al_ca = new CollisionAvoider(0.0, height, 0.0, 20.0, 20.0);
        double textToAddTop = settings.topAge;
        double textToAddCenter = settings.topAge;
        Datapoint textToAddPoint = null;
        if (this.drawAgeLabel) {
            this.labelMarginLeft = 25.0;
        }
        while (iter.hasNext()) {
            String s;
            p = (Datapoint)iter.next();
            if (p.baseAge - 1.0E-6 < settings.topAge) {
                lastP = p;
                continue;
            }
            if (p.baseAge + 1.0E-6 > settings.baseAge) {
                drawBaseClipped = true;
                break;
            }
            if (setupTop) {
                if (lastP != null) {
                    mag = this.getIntersectionMag(lastP, p, settings.topAge);
                    if (mag < 0.0) {
                        mag = 0.0;
                    }
                    x.add(new Double(startx + width));
                    y.add(new Double(starty));
                    x.add(new Double(this.getXFromMag(mag, "MFS", startx, width)));
                    y.add(new Double(starty));
                } else {
                    x.add(new Double(startx + width));
                    y.add(new Double(ImageGenerator.getYFromYear(p.baseAge, starty, settings)));
                }
                setupTop = false;
            }
            mag = SequenceColumn.getMag(p);
            double curX = this.getXFromMag(this.getGraphMag(mag, p.direction), p.direction, startx, width);
            double curY = ImageGenerator.getYFromYear(p.baseAge, starty, settings);
            x.add(new Double(curX));
            y.add(new Double(curY));
            if (this.type == 1) {
                if (p.direction.compareToIgnoreCase("SB") == 0) {
                    s = mag == 0.25 ? MINOR_LINE_STYLE : (mag == 0.5 ? MEDIUM_LINE_STYLE : MAJOR_LINE_STYLE);
                    ig.drawLine(startx, curY, curX, curY, s);
                } else {
                    ig.drawLine(startx, curY, curX, curY, MFS_LINE_STYLE);
                }
            } else {
                s = mag == 0.33 ? MINOR_LINE_STYLE : (mag == 0.66 ? MEDIUM_LINE_STYLE : MAJOR_LINE_STYLE);
                Datapoint tlp = new Datapoint(curY);
                tlp.label = s;
                trendLinesToDraw.add(tlp);
            }
            if (this.drawNameLabel) {
                if (p.direction.compareToIgnoreCase("SB") == 0) {
                    if (textToAddPoint != null) {
                        textToAddBase = (textToAddCenter + p.baseAge) / 2.0;
                        text_ca.add(textToAddPoint, unitToAgeFactor * (textToAddTop - settings.topAge), unitToAgeFactor * (textToAddBase - settings.topAge), textToAddTop, textToAddBase, ig.getSWI(textToAddPoint.label, this.fonts.getFont(3), 1));
                        al_ca.add(textToAddPoint, unitToAgeFactor * (textToAddTop - settings.topAge), unitToAgeFactor * (textToAddBase - settings.topAge), textToAddTop, textToAddBase, ig.getSWI(DataColumn.getAgeLabel(textToAddPoint.baseAge), this.fonts.getFont(1), 1));
                        textToAddTop = textToAddBase;
                        textToAddPoint = null;
                    }
                    textToAddPoint = p;
                    textToAddCenter = p.baseAge;
                } else {
                    if (textToAddPoint != null) {
                        textToAddBase = p.baseAge;
                        text_ca.add(textToAddPoint, unitToAgeFactor * (textToAddTop - settings.topAge), unitToAgeFactor * (textToAddBase - settings.topAge), textToAddTop, textToAddBase, ig.getSWI(textToAddPoint.label, this.fonts.getFont(3), 1));
                        al_ca.add(textToAddPoint, unitToAgeFactor * (textToAddTop - settings.topAge), unitToAgeFactor * (textToAddBase - settings.topAge), textToAddTop, textToAddBase, ig.getSWI(DataColumn.getAgeLabel(textToAddPoint.baseAge), this.fonts.getFont(1), 1));
                        textToAddPoint = null;
                    }
                    textToAddTop = p.baseAge;
                }
            }
            lastP = p;
        }
        if (p == null) {
            return;
        }
        if (setupTop) {
            if (lastP != null) {
                mag = this.getIntersectionMag(lastP, p, settings.topAge);
                if (mag < 0.0) {
                    mag = 0.0;
                }
                x.add(new Double(startx + width));
                y.add(new Double(starty));
                x.add(new Double(this.getXFromMag(mag, "MFS", startx, width)));
                y.add(new Double(starty));
            } else {
                x.add(new Double(startx + width));
                y.add(new Double(ImageGenerator.getYFromYear(p.baseAge, starty, settings)));
            }
            setupTop = false;
        }
        if (drawBaseClipped) {
            mag = this.getIntersectionMag(lastP, p, settings.baseAge);
            if (mag < 0.0) {
                mag = 0.0;
            }
            x.add(new Double(this.getXFromMag(mag, "MFS", startx, width)));
            y.add(new Double(starty + height));
            x.add(new Double(startx + width));
            y.add(new Double(starty + height));
        } else {
            x.add(new Double(startx + width));
            y.add(new Double(ImageGenerator.getYFromYear(p.baseAge, starty, settings)));
        }
        double[] coordX = SequenceColumn.getDoubleArray(x);
        double[] coordY = SequenceColumn.getDoubleArray(y);
        ig.drawPolygon(coordX, coordY, this.graphStyle);
        if (this.type != 1) {
            iter = ((AbstractList)trendLinesToDraw).iterator();
            while (iter.hasNext()) {
                p = (Datapoint)iter.next();
                ig.drawLine(startx, p.baseAge, startx + width, p.baseAge, p.label);
            }
        }
        if (this.drawNameLabel) {
            if (textToAddPoint != null) {
                textToAddBase = settings.baseAge;
                text_ca.add(textToAddPoint, unitToAgeFactor * (textToAddTop - settings.topAge), unitToAgeFactor * (textToAddBase - settings.topAge), textToAddTop, textToAddBase, ig.getSWI(textToAddPoint.label, this.fonts.getFont(3), 1));
                al_ca.add(textToAddPoint, unitToAgeFactor * (textToAddTop - settings.topAge), unitToAgeFactor * (textToAddBase - settings.topAge), textToAddTop, textToAddBase, ig.getSWI(DataColumn.getAgeLabel(textToAddPoint.baseAge), this.fonts.getFont(1), 1));
                textToAddPoint = null;
            }
            text_ca.scaleToFit();
            i = 0;
            while (i < text_ca.getNumNodes()) {
                node = text_ca.getAt(i);
                if (node.dp != null && !node.dp.breaker) {
                    ig.drawString(node.swi, startx + this.labelMarginLeft, node.calcTop + starty, width - this.labelMarginLeft - this.labelMarginRight, node.getCalcHeight(), 4, ImageGenerator.getYFromYear(node.dp.baseAge, starty, settings), 12, Coloring.getStyle(this.color.getColor(node.dp.baseAge, node.dp.baseAge)));
                    if (node.dp.popup != null && settings.doPopups) {
                        ig.pushGrouping();
                        ig.doPopupThings(node.dp.popup);
                        ig.drawRect(startx + this.labelMarginLeft, node.calcTop + starty, width - this.labelMarginLeft - this.labelMarginRight, node.getCalcHeight(), "stroke-width: 0; opacity: 0.5; fill: red;");
                        ig.popGrouping();
                    }
                }
                ++i;
            }
        }
        if (this.drawAgeLabel) {
            al_ca.scaleToFit();
            i = 0;
            while (i < al_ca.getNumNodes()) {
                node = al_ca.getAt(i);
                if (node.dp != null && !node.dp.breaker) {
                    ig.drawString(node.swi, startx + 2.0, node.calcTop + starty, 20.0, node.getCalcHeight(), 4, ImageGenerator.getYFromYear(node.dp.baseAge, starty, settings), 12, Coloring.getStyle(this.color.getColor(node.dp.baseAge, node.dp.baseAge)));
                }
                ++i;
            }
        }
        this.drawOverlays(ig, startx, starty, width, height, settings);
    }

    public void readOneSetting(Element setting, Settings settings) {
        super.readOneSetting(setting, settings);
        String name = setting.getAttribute("name");
        if (name != null) {
            if (name.compareToIgnoreCase("labelMarginLeft") == 0) {
                this.labelMarginLeft = Integer.parseInt(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("labelMarginRight") == 0) {
                this.labelMarginRight = Integer.parseInt(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("graphStyle") == 0) {
                this.graphStyle = Settings.getNodeTextContent(setting);
            } else if (name.compareToIgnoreCase("type") == 0) {
                String t = setting.getAttribute("type");
                this.type = t.compareToIgnoreCase("sequence") == 0 ? 1 : 2;
            } else if (name.compareToIgnoreCase("drawNameLabel") == 0) {
                this.drawNameLabel = Boolean.valueOf(Settings.getNodeTextContent(setting));
            }
        }
    }

    public void writeSettings(Element element, Document doc) {
        super.writeSettings(element, doc);
        element.appendChild(Settings.createSimpleSetting(doc, "labelMarginLeft", "" + this.labelMarginLeft));
        element.appendChild(Settings.createSimpleSetting(doc, "labelMarginRight", "" + this.labelMarginRight));
        element.appendChild(Settings.createSimpleSetting(doc, "graphStyle", this.graphStyle));
        element.appendChild(Settings.createSimpleSetting(doc, "drawNameLabel", "" + this.drawNameLabel));
        Element typeE = Settings.createSimpleSetting(doc, "type", null);
        if (this.type == 1) {
            typeE.setAttribute("type", "sequence");
        } else {
            typeE.setAttribute("type", "trend");
        }
        element.appendChild(typeE);
    }
}

