/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.macos;

import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.IBrowserLaunching;
import edu.stanford.ejalbert.launching.macos.MacOsBrowserLaunching;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MacOs2_1BrowserLaunching
extends MacOsBrowserLaunching
implements IBrowserLaunching {
    private static final String FINDER_TYPE = "FNDR";
    private Object kSystemFolderType;
    private Method findFolder;
    private Method getFileCreator;
    private Method getFileType;
    private String browser;
    static /* synthetic */ Class class$0;

    public void initialize() throws BrowserLaunchingInitializingException {
        try {
            Class<?> mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
            Class<?> mrjOSTypeClass = Class.forName("com.apple.mrj.MRJOSType");
            Field systemFolderField = mrjFileUtilsClass.getDeclaredField("kSystemFolderType");
            this.kSystemFolderType = systemFolderField.get(null);
            this.findFolder = mrjFileUtilsClass.getDeclaredMethod("findFolder", mrjOSTypeClass);
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.io.File");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            this.getFileCreator = mrjFileUtilsClass.getDeclaredMethod("getFileCreator", classArray);
            Class[] classArray2 = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.io.File");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[0] = clazz2;
            this.getFileType = mrjFileUtilsClass.getDeclaredMethod("getFileType", classArray2);
        }
        catch (Exception e) {
            throw new BrowserLaunchingInitializingException(e);
        }
    }

    private String getBrowser() throws BrowserLaunchingInitializingException {
        File systemFolder;
        if (this.browser != null) {
            return this.browser;
        }
        try {
            systemFolder = (File)this.findFolder.invoke(null, this.kSystemFolderType);
        }
        catch (Exception e) {
            throw new BrowserLaunchingInitializingException(e);
        }
        String[] systemFolderFiles = systemFolder.list();
        int i = 0;
        while (i < systemFolderFiles.length) {
            try {
                Object fileCreator;
                Object fileType;
                File file = new File(systemFolder, systemFolderFiles[i]);
                if (file.isFile() && FINDER_TYPE.equals((fileType = this.getFileType.invoke(null, file)).toString()) && "MACS".equals((fileCreator = this.getFileCreator.invoke(null, file)).toString())) {
                    this.browser = file.toString();
                    return this.browser;
                }
            }
            catch (Exception e) {
                throw new BrowserLaunchingInitializingException(e);
            }
            ++i;
        }
        throw new BrowserLaunchingInitializingException("Unable to find finder");
    }

    public void openUrl(String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        String browser = this.getBrowser();
        try {
            Runtime.getRuntime().exec(new String[]{browser, urlString});
        }
        catch (IOException e) {
            throw new BrowserLaunchingExecutionException(e);
        }
    }

    public void openUrl(String browser, String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        this.openUrl(urlString);
    }

    public List getBrowserList() {
        ArrayList<String> browserList = new ArrayList<String>(1);
        browserList.add("Default");
        return browserList;
    }
}

