/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.macos;

import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.IBrowserLaunching;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public class MacOs3_0BrowserLaunching
implements IBrowserLaunching {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void initialize() throws BrowserLaunchingInitializingException {
        try {
            Class<?> linker = Class.forName("com.apple.mrj.jdirect.Linker");
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Constructor<?> constructor = linker.getConstructor(classArray);
            Object[] objectArray = new Object[1];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("edu.stanford.ejalbert.BrowserLauncher");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            objectArray[0] = clazz2;
            Object linkage = constructor.newInstance(objectArray);
        }
        catch (Exception e) {
            throw new BrowserLaunchingInitializingException(e);
        }
    }

    public void openUrl(String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        int[] instance = new int[1];
        int result = MacOs3_0BrowserLaunching.ICStart(instance, 0);
        if (result == 0) {
            int[] selectionStart = new int[1];
            byte[] urlBytes = urlString.getBytes();
            int[] selectionEnd = new int[]{urlBytes.length};
            result = MacOs3_0BrowserLaunching.ICLaunchURL(instance[0], new byte[1], urlBytes, urlBytes.length, selectionStart, selectionEnd);
            if (result != 0) {
                throw new BrowserLaunchingExecutionException("Unable to launch URL: " + result);
            }
        } else {
            throw new BrowserLaunchingExecutionException("Unable to create an Internet Config instance: " + result);
        }
        MacOs3_0BrowserLaunching.ICStop(instance);
    }

    public void openUrl(String browser, String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        this.openUrl(urlString);
    }

    public List getBrowserList() {
        ArrayList<String> browserList = new ArrayList<String>(1);
        browserList.add("Default");
        return browserList;
    }

    private static native int ICStart(int[] var0, int var1);

    private static native int ICStop(int[] var0);

    private static native int ICLaunchURL(int var0, byte[] var1, byte[] var2, int var3, int[] var4, int[] var5);
}

