/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter {
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    private String description;
    private boolean allowDirectories;
    private Hashtable extensionsTable = new Hashtable();
    private boolean allowAll = false;

    public ExtensionFileFilter(boolean allowDirectories) {
        this.allowDirectories = allowDirectories;
    }

    public ExtensionFileFilter() {
        this(true);
    }

    public static String getFileName(String initialDirectory, String description, String extension) {
        String[] extensions = new String[]{extension};
        return ExtensionFileFilter.getFileName(initialDirectory, description, extensions, 0);
    }

    public static String getFileName(String initialDirectory, String description, String extension, int mode) {
        String[] extensions = new String[]{extension};
        return ExtensionFileFilter.getFileName(initialDirectory, description, extensions, mode);
    }

    public static String getFileName(String initialDirectory, String description, String[] extensions) {
        return ExtensionFileFilter.getFileName(initialDirectory, description, extensions, 0);
    }

    public static String getFileName(String initialDirectory, String description, String[] extensions, int mode) {
        int selectVal;
        ExtensionFileFilter filter = new ExtensionFileFilter();
        filter.setDescription(description);
        int i = 0;
        while (i < extensions.length) {
            String extension = extensions[i];
            filter.addExtension(extension, true);
            ++i;
        }
        JFileChooser chooser = new JFileChooser(initialDirectory);
        chooser.setFileFilter(filter);
        int n = selectVal = mode == 1 ? chooser.showSaveDialog(null) : chooser.showOpenDialog(null);
        if (selectVal == 0) {
            String path = chooser.getSelectedFile().getAbsolutePath();
            return path;
        }
        JOptionPane.showMessageDialog(null, "No file selected.");
        return null;
    }

    public void addExtension(String extension, boolean caseInsensitive) {
        if (caseInsensitive) {
            extension = extension.toLowerCase();
        }
        if (!this.extensionsTable.containsKey(extension)) {
            this.extensionsTable.put(extension, new Boolean(caseInsensitive));
            if (extension.equals("*") || extension.equals("*.*") || extension.equals(".*")) {
                this.allowAll = true;
            }
        }
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return this.allowDirectories;
        }
        if (this.allowAll) {
            return true;
        }
        String name = file.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1 || dotIndex == name.length() - 1) {
            return false;
        }
        String extension = name.substring(dotIndex + 1);
        if (this.extensionsTable.containsKey(extension)) {
            return true;
        }
        Enumeration keys = this.extensionsTable.keys();
        while (keys.hasMoreElements()) {
            String possibleExtension = (String)keys.nextElement();
            Boolean caseFlag = (Boolean)this.extensionsTable.get(possibleExtension);
            if (caseFlag == null || !caseFlag.equals(Boolean.FALSE) || !possibleExtension.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }
}

