/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.FontManager;
import gui.ModifyTextField;
import gui.SpringUtilities;
import gui.TSCFont;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SpringLayout;

public class FontOptions
extends JPanel {
    protected FontManager fm;
    protected JPanel addPanel = this;

    public FontOptions(FontManager fm) {
        this.fm = fm;
        this.setLayout(new BoxLayout(this, 1));
    }

    public JPanel getAddPanel() {
        return this.addPanel;
    }

    public JPanel addNestedAddPanel() {
        JPanel oldAddPanel = this.addPanel;
        this.addPanel = new JPanel();
        oldAddPanel.add(this.addPanel);
        return this.addPanel;
    }

    public void addOptions(int[] relevantFonts, boolean bindToBottom) {
        JPanel p = new JPanel(new SpringLayout());
        p.add(new JLabel("Change Font"));
        p.add(new JLabel("Font"));
        p.add(new JLabel("Size"));
        p.add(new JLabel());
        p.add(new JLabel());
        p.add(new JLabel());
        int i = 0;
        while (i < relevantFonts.length) {
            new SingleFontOptions(this.fm, relevantFonts[i], p);
            ++i;
        }
        SpringUtilities.makeCompactGrid(p, relevantFonts.length + 1, 6, 5, 5, 5, 5, bindToBottom);
        this.addPanel.add(p);
    }

    public class SingleFontOptions
    implements ActionListener {
        public FontManager fm;
        public int whichFont;
        public TSCFont chosenFont;
        JCheckBox overrideDefaultCB;
        JComboBox fontNameCB;
        ModifyTextField fontSizeTF;
        JToggleButton boldCB;
        JToggleButton italicCB;
        JLabel preview;

        public SingleFontOptions(FontManager fm, int whichFont, JComponent comp) {
            this.fm = fm;
            this.whichFont = whichFont;
            this.chosenFont = new TSCFont(fm.getFont(whichFont));
            this.overrideDefaultCB = new JCheckBox(String.valueOf(FontManager.fontFunctions[whichFont]) + ": ");
            String[] fontFamilies = new String[]{"Arial", "Courier", "Verdana"};
            this.fontNameCB = new JComboBox<String>(fontFamilies);
            Dimension d = this.fontNameCB.getPreferredSize();
            d.width = 100;
            this.fontNameCB.setMaximumSize(d);
            int selIndex = 0;
            int i = 0;
            while (i < fontFamilies.length) {
                if (fontFamilies[i].equals(this.chosenFont.getFamily())) {
                    selIndex = i;
                    break;
                }
                ++i;
            }
            this.fontNameCB.setSelectedIndex(selIndex);
            this.fontNameCB.addActionListener(this);
            this.fontSizeTF = new ModifyTextField(true, true);
            d = this.fontSizeTF.getPreferredSize();
            d.width = 40;
            this.fontSizeTF.setPreferredSize(d);
            this.fontSizeTF.setMaximumSize(d);
            this.fontSizeTF.setText("" + fm.getFont(whichFont).getSizeInt());
            this.fontSizeTF.addActionListener(this);
            this.boldCB = new JToggleButton("B");
            this.boldCB.setSelected(fm.getFont(whichFont).isBold());
            this.boldCB.setFont(new Font("Times", 1, 12));
            this.boldCB.addActionListener(this);
            this.italicCB = new JToggleButton("I");
            this.italicCB.setSelected(fm.getFont(whichFont).isItalic());
            this.italicCB.setFont(new Font("Times", 2, 12));
            this.italicCB.addActionListener(this);
            JPanel panel = new JPanel(new SpringLayout());
            this.preview = new JLabel("Sample text");
            d = this.fontSizeTF.getPreferredSize();
            d.width = 100;
            panel.setPreferredSize(d);
            panel.add(this.preview);
            comp.add(this.overrideDefaultCB);
            comp.add(this.fontNameCB);
            comp.add(this.fontSizeTF);
            comp.add(this.boldCB);
            comp.add(this.italicCB);
            comp.add(panel);
            this.preview.setFont(this.chosenFont.getFont());
            this.overrideDefaultCB.addActionListener(this);
            if (fm.chosenFonts[whichFont] == null) {
                this.overrideDefaultCB.setSelected(false);
                this.setEnabled(false);
            } else {
                this.overrideDefaultCB.setSelected(true);
                this.setEnabled(true);
            }
        }

        public void actionPerformed(ActionEvent ae) {
            Object source = ae.getSource();
            if (source == this.fontNameCB) {
                this.chosenFont.family = (String)this.fontNameCB.getSelectedItem();
                this.fm.setFont(this.whichFont, this.chosenFont);
            } else if (source == this.fontSizeTF) {
                try {
                    this.chosenFont.size = Double.parseDouble(this.fontSizeTF.getText());
                }
                catch (Exception e) {
                    this.chosenFont.size = 1.0;
                }
                this.fm.setFont(this.whichFont, this.chosenFont);
            } else if (source == this.boldCB) {
                int type = this.chosenFont.getStyle();
                type = this.boldCB.isSelected() ? (type |= 1) : (type &= 0xFFFFFFFE);
                this.chosenFont.setStyle(type);
                this.fm.setFont(this.whichFont, this.chosenFont);
            } else if (source == this.italicCB) {
                int type = this.chosenFont.getStyle();
                type = this.italicCB.isSelected() ? (type |= 2) : (type &= 0xFFFFFFFD);
                this.chosenFont.setStyle(type);
                this.fm.setFont(this.whichFont, this.chosenFont);
            } else if (source == this.overrideDefaultCB) {
                if (!this.overrideDefaultCB.isSelected()) {
                    this.fm.resetFont(this.whichFont);
                    this.setEnabled(false);
                } else {
                    this.fm.setFont(this.whichFont, this.chosenFont);
                    this.setEnabled(true);
                }
            }
            this.preview.setFont(this.fm.getFont(this.whichFont).getFont());
        }

        public void setEnabled(boolean en) {
            this.fontNameCB.setEnabled(en);
            this.fontSizeTF.setEnabled(en);
            this.boldCB.setEnabled(en);
            this.italicCB.setEnabled(en);
        }
    }
}

