/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datastore.ChronColumn;
import datastore.Coloring;
import datastore.DataColumn;
import datastore.FaciesColumn;
import gui.RichText;
import gui.Settings;
import gui.StringWrappingInfo;
import gui.TSCFont;
import gui.Vector2D;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.apache.fop.svg.PDFTranscoder;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.svg.SVGDocument;

public class ImageGenerator {
    public DataColumn rootCol;
    public Settings settings;
    public DOMImplementation impl;
    public SVGDocument doc;
    public Element svgRoot;
    public SVGGraphics2D g;
    protected String svgNS;
    protected Element curElement;
    protected Stack groupings;
    protected int clipPathNum = 0;
    protected boolean allowNegatives;
    protected double canvasWidth;
    protected double canvasHeight;
    public static final String BORDER_STYLE = "stroke-width:" + Settings.BORDER_WIDTH + "; fill: none; stroke: black;";
    public static final int TOP = 1;
    public static final int CENTER = 2;
    public static final int BOTTOM = 3;
    public static final int PREFERRED = 4;
    public static final int ONLY_TEXT = 10;
    public static final int ONLY_BACKGROUND = 11;
    public static final int TEXT_AND_BACKGROUND = 12;
    public static final int POINT_RECT = 1;
    public static final int POINT_ROUND = 2;
    public static final int POINT_TICK = 3;
    public static final int POINT_DIMENSION = 4;
    public static final double CONTROL_POINT_LENGTH = 0.4;
    public static final double MAX_CONTROL_POINT_LENGTH = 10.0;
    protected Vector popups;

    public static boolean includesText(int i) {
        return i == 10 || i == 12;
    }

    public static boolean includesBackground(int i) {
        return i == 11 || i == 12;
    }

    public ImageGenerator(DataColumn col, Settings s) {
        this.rootCol = col;
        this.settings = s;
        this.reset();
    }

    public void reset() {
        this.impl = SVGDOMImplementation.getDOMImplementation();
        this.svgNS = "http://www.w3.org/2000/svg";
        this.doc = (SVGDocument)this.impl.createDocument(this.svgNS, "svg", null);
        this.g = new SVGGraphics2D(this.doc);
        this.groupings = new Stack();
        this.popups = new Vector();
        this.curElement = this.svgRoot = this.doc.getDocumentElement();
        this.loadPatterns();
    }

    public void loadPatterns() {
        ChronColumn.setupPatterns(this);
        FaciesColumn.setupPatterns(this);
    }

    public void setAllowNegatives(boolean tf) {
        this.allowNegatives = tf;
    }

    public boolean getAllowNegatives() {
        return this.allowNegatives;
    }

    public void write(Writer w) throws TranscoderException {
        SVGTranscoder st = new SVGTranscoder();
        TranscoderOutput to = new TranscoderOutput(w);
        TranscoderInput ti = new TranscoderInput(this.doc);
        st.transcode(ti, to);
    }

    public void writePDF(OutputStream os) throws TranscoderException {
        PDFTranscoder pt = new PDFTranscoder();
        pt.addTranscodingHint(SVGAbstractTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, new Float(33.333332f));
        TranscoderOutput to = new TranscoderOutput(os);
        TranscoderInput ti = new TranscoderInput(this.doc);
        pt.transcode(ti, to);
    }

    public void setCanvasSize(double width, double height) {
        this.svgRoot.setAttributeNS(null, "width", String.valueOf(this.round(width / 30.0)) + "cm");
        this.svgRoot.setAttributeNS(null, "height", String.valueOf(this.round(height / 30.0)) + "cm");
        this.svgRoot.setAttributeNS(null, "viewBox", "0 0 " + this.round(width) + " " + this.round(height));
        this.canvasWidth = width;
        this.canvasHeight = height;
    }

    public Element pushGrouping() {
        this.groupings.push(this.curElement);
        Element newG = this.doc.createElementNS(this.svgNS, "g");
        this.curElement.appendChild(newG);
        this.curElement = newG;
        return newG;
    }

    protected Element pushElement(Element e) {
        this.groupings.push(this.curElement);
        this.curElement = e;
        return e;
    }

    public void popGrouping() {
        this.curElement = (Element)this.groupings.pop();
    }

    public String pushClipPath() {
        String id = "clipPath" + this.clipPathNum++;
        this.pushClipPath(id);
        return id;
    }

    public void pushClipPath(String id) {
        this.groupings.push(this.curElement);
        Element newCP = this.doc.createElementNS(this.svgNS, "clipPath");
        newCP.setAttribute("id", id);
        this.curElement.appendChild(newCP);
        this.curElement = newCP;
    }

    public void setClipPath(String id) {
        this.curElement.setAttribute("clip-path", "url(#" + id + ")");
    }

    public void pushPattern(String id, double width, double height) {
        this.groupings.push(this.curElement);
        Element newPattern = this.doc.createElementNS(this.svgNS, "pattern");
        newPattern.setAttributeNS(null, "id", id);
        newPattern.setAttributeNS(null, "x", "0");
        newPattern.setAttributeNS(null, "y", "0");
        newPattern.setAttributeNS(null, "width", this.round(width));
        newPattern.setAttributeNS(null, "height", this.round(height));
        newPattern.setAttributeNS(null, "patternUnits", "userSpaceOnUse");
        this.curElement.appendChild(newPattern);
        this.curElement = newPattern;
        this.setAllowNegatives(true);
    }

    public void pushPatternCopy(Element pattern) {
        this.groupings.push(this.curElement);
        this.curElement = this.addElementCopy(pattern);
        this.setAllowNegatives(true);
    }

    public void popPattern() {
        this.curElement = (Element)this.groupings.pop();
        if (this.curElement.getNodeName().compareToIgnoreCase("pattern") != 0) {
            this.setAllowNegatives(false);
        }
    }

    public void popClipPath() {
        this.popGrouping();
    }

    public FontMetrics getFontMetrics(TSCFont f) {
        return this.g.getFontMetrics(f.getFont());
    }

    public Rectangle2D getStringBounds(TSCFont f, String s) {
        return this.getFontMetrics(f).getStringBounds(s, this.g);
    }

    public Rectangle2D getStringBounds(StringWrappingInfo swi) {
        Rectangle2D.Double size = new Rectangle2D.Double();
        size.width = swi.getWidth();
        size.height = swi.getHeight();
        return size;
    }

    protected String round(double d) {
        if (d == 0.0) {
            return "0";
        }
        if (!this.allowNegatives && d < 0.0) {
            return "0";
        }
        String s = Double.toString(d += 5.0E-6);
        int end = Math.min(s.length(), s.indexOf(46) + 6);
        if (end < s.length()) {
            s = s.substring(0, end);
        }
        return s;
    }

    public Element drawLine(double x1, double y1, double x2, double y2, String style) {
        Element line = this.doc.createElementNS(this.svgNS, "line");
        line.setAttributeNS(null, "x1", this.round(x1));
        line.setAttributeNS(null, "y1", this.round(y1));
        line.setAttributeNS(null, "x2", this.round(x2));
        line.setAttributeNS(null, "y2", this.round(y2));
        if (style != null) {
            line.setAttributeNS(null, "style", style);
        }
        this.curElement.appendChild(line);
        return line;
    }

    public Element drawLineYear(double x1, double y1, double x2, double y2, String style, double baseY) {
        return this.drawLine(x1, (y1 - this.settings.topAge) * this.settings.unitsPerMY + baseY, x2, (y2 - this.settings.topAge) * this.settings.unitsPerMY + baseY, style);
    }

    public Element drawRect(double x, double y, double width, double height, String style) {
        Element rect = this.doc.createElementNS(this.svgNS, "rect");
        rect.setAttributeNS(null, "x", this.round(x));
        rect.setAttributeNS(null, "y", this.round(y));
        rect.setAttributeNS(null, "width", this.round(width));
        rect.setAttributeNS(null, "height", this.round(height));
        if (style != null) {
            rect.setAttributeNS(null, "style", style);
        }
        this.curElement.appendChild(rect);
        return rect;
    }

    public Element drawCircle(double x, double y, double radius, String style) {
        Element circ = this.doc.createElementNS(this.svgNS, "circle");
        circ.setAttributeNS(null, "cx", this.round(x));
        circ.setAttributeNS(null, "cy", this.round(y));
        circ.setAttributeNS(null, "r", this.round(radius));
        if (style != null) {
            circ.setAttributeNS(null, "style", style);
        }
        this.curElement.appendChild(circ);
        return circ;
    }

    public Element drawRectYear(double x, double y, double width, double height, String style, double baseY) {
        return this.drawRect(x, (y - this.settings.topAge) * this.settings.unitsPerMY + baseY, width, height * this.settings.unitsPerMY, style);
    }

    public Element drawPolygon(double[] x, double[] y, String style, String popup) {
        Element e = this.drawPolygon(x, y, style);
        this.doPopupThings(e, popup);
        return e;
    }

    public Element drawPolygon(double[] x, double[] y, String style) {
        int numPoints = Math.min(x.length, y.length);
        if (numPoints == 2) {
            return this.drawLine(x[0], y[0], x[1], y[1], style);
        }
        if (numPoints < 2) {
            return null;
        }
        Element line = this.doc.createElementNS(this.svgNS, "polygon");
        String points = "";
        int i = 0;
        while (i < numPoints) {
            points = String.valueOf(points) + this.round(x[i]) + "," + this.round(y[i]) + " ";
            ++i;
        }
        line.setAttributeNS(null, "points", points);
        if (style != null) {
            line.setAttributeNS(null, "style", style);
        }
        this.curElement.appendChild(line);
        return line;
    }

    public Element drawPolyline(double[] x, double[] y, String style) {
        int numPoints = Math.min(x.length, y.length);
        if (numPoints == 2) {
            return this.drawLine(x[0], y[0], x[1], y[1], style);
        }
        if (numPoints < 2) {
            return null;
        }
        Element line = this.doc.createElementNS(this.svgNS, "polyline");
        String points = "";
        int i = 0;
        while (i < numPoints) {
            points = String.valueOf(points) + this.round(x[i]) + "," + this.round(y[i]) + " ";
            ++i;
        }
        line.setAttributeNS(null, "points", points);
        if (style != null) {
            line.setAttributeNS(null, "style", style);
        }
        this.curElement.appendChild(line);
        return line;
    }

    public Element drawSmoothVerticalPolyline(double[] x, double[] y, boolean[] lineTo, String style) {
        int numPoints = Math.min(x.length, y.length);
        if (numPoints == 2) {
            return this.drawLine(x[0], y[0], x[1], y[1], style);
        }
        if (numPoints < 2) {
            return null;
        }
        Element line = this.doc.createElementNS(this.svgNS, "path");
        String points = "M" + this.round(x[0]) + "," + this.round(y[0]);
        int i = 1;
        while (i < numPoints) {
            if (lineTo[i]) {
                points = String.valueOf(points) + " L" + this.round(x[i]) + "," + this.round(y[i]);
            } else {
                double[] c1 = this.getControlPointForVerticalCurves(x, y, lineTo, i - 1, 1);
                double[] c2 = this.getControlPointForVerticalCurves(x, y, lineTo, i, -1);
                points = String.valueOf(points) + " C" + this.round(c1[0]) + "," + this.round(c1[1]) + " " + this.round(c2[0]) + "," + this.round(c2[1]) + " " + this.round(x[i]) + "," + this.round(y[i]);
            }
            ++i;
        }
        line.setAttributeNS(null, "d", points);
        if (style != null) {
            line.setAttributeNS(null, "style", style);
        }
        this.curElement.appendChild(line);
        return line;
    }

    protected double[] getControlPointForVerticalCurves(double[] x, double[] y, boolean[] lineTo, int i, int dir) {
        double derivative;
        double[] ret = new double[2];
        if (i == 0 || lineTo[i]) {
            double derivative2 = (x[1] - x[0]) / (y[1] - y[0]);
            ret[1] = y[i] * 0.6 + y[i + 1] * 0.4;
            ret[0] = x[i] * 0.6 + x[i + 1] * 0.4;
            return ret;
        }
        if (i >= x.length - 1 || lineTo[i + 1]) {
            ret[1] = y[i] * 0.6 + y[i - 1] * 0.4;
            ret[0] = x[i] * 0.6 + x[i - 1] * 0.4;
            return ret;
        }
        double prevx = x[i - 1];
        double prevy = y[i - 1];
        double nextx = x[i + 1];
        double nexty = y[i + 1];
        double prevdiff = prevx - x[i];
        double nextdiff = nextx - x[i];
        if (prevdiff * nextdiff > 0.0) {
            derivative = Double.POSITIVE_INFINITY;
        } else {
            derivative = (nextx - prevx) / (nexty - prevy);
            double derivativeNext = (nextx - x[i]) / (nexty - y[i]);
            double derivativePrev = (x[i] - prevx) / (y[i] - prevy);
            if (derivative < 0.0) {
                derivative = Math.max(derivative, derivativeNext);
            }
            if (derivative > 0.0) {
                derivative = Math.max(derivative, derivativePrev);
            }
        }
        if (dir > 0) {
            if (Double.isInfinite(derivative)) {
                ret[1] = y[i] * 0.6 + y[i + 1] * 0.4;
                ret[0] = x[i];
            } else {
                ret[1] = y[i] * 0.6 + y[i + 1] * 0.4;
                ret[0] = x[i] + derivative * (ret[1] - y[i]);
            }
        } else if (Double.isInfinite(derivative)) {
            ret[1] = y[i] * 0.6 + y[i - 1] * 0.4;
            ret[0] = x[i];
        } else {
            ret[1] = y[i] * 0.6 + y[i - 1] * 0.4;
            ret[0] = x[i] + derivative * (ret[1] - y[i]);
        }
        return ret;
    }

    public Element drawSmoothPolyline(double[] x, double[] y, boolean[] sharp, String style, boolean closed) {
        int numPoints = Math.min(x.length, y.length);
        if (numPoints == 2) {
            return this.drawLine(x[0], y[0], x[1], y[1], style);
        }
        if (numPoints < 2) {
            return null;
        }
        Element line = this.doc.createElementNS(this.svgNS, "path");
        String points = "M" + this.round(x[0]) + "," + this.round(y[0]);
        int i = 1;
        while (i < numPoints || closed && i <= numPoints) {
            Vector2D c1 = this.getControlPoint(x, y, sharp, i - 1, 1, closed);
            Vector2D c2 = this.getControlPoint(x, y, sharp, i % numPoints, -1, closed);
            points = String.valueOf(points) + " C" + this.round(c1.x) + "," + this.round(c1.y) + " " + this.round(c2.x) + "," + this.round(c2.y) + " " + this.round(x[i % numPoints]) + "," + this.round(y[i % numPoints]);
            ++i;
        }
        if (closed) {
            points = String.valueOf(points) + "z";
        }
        line.setAttributeNS(null, "d", points);
        if (style != null) {
            line.setAttributeNS(null, "style", style);
        }
        this.curElement.appendChild(line);
        return line;
    }

    protected Vector2D getControlPoint(double[] x, double[] y, boolean[] sharpA, int i, int dir, boolean closed) {
        Vector2D end2;
        Vector2D end1;
        boolean sharp = sharpA[i];
        if (i == 0 && !closed) {
            dir = 1;
            sharp = true;
        }
        if (i == x.length - 1 && !closed) {
            dir = -1;
            sharp = true;
        }
        int previ = (i - 1 + x.length) % x.length;
        int nexti = (i + 1) % x.length;
        Vector2D prev = new Vector2D(x[previ] - x[i], y[previ] - y[i]);
        Vector2D next = new Vector2D(x[nexti] - x[i], y[nexti] - y[i]);
        double prevLength = prev.length();
        double nextLength = next.length();
        if (Settings.isEqual(prevLength, 0.0)) {
            prev = new Vector2D(0.0, 1.0);
            prevLength = 1.0;
        }
        if (Settings.isEqual(nextLength, 0.0)) {
            next = new Vector2D(1.0, 0.0);
            nextLength = 1.0;
        }
        if (sharp) {
            if (dir > 0) {
                next.setLength(Math.min(nextLength * 0.4, 10.0));
                next.add(x[i], y[i]);
                return next;
            }
            prev.setLength(Math.min(prevLength * 0.4, 10.0));
            prev.add(x[i], y[i]);
            return prev;
        }
        prev.normalize();
        next.normalize();
        Vector2D mid = prev.add(next);
        if (mid.length() > 0.01) {
            mid.normalize();
            mid.perpSlope();
            end1 = mid;
            end2 = new Vector2D(end1);
            end2.mul(-1.0);
        } else {
            Vector2D minus = new Vector2D(next);
            minus.mul(-1.0);
            end1 = minus.add(prev);
            end2 = new Vector2D(end1);
            end2.mul(-1.0);
        }
        if (prev.dotProduct(end1) > 0.0) {
            end1.setLength(Math.min(prevLength * 0.4, 10.0));
            end2.setLength(Math.min(nextLength * 0.4, 10.0));
            end1.add(x[i], y[i]);
            end2.add(x[i], y[i]);
            if (dir > 0) {
                return end2;
            }
            return end1;
        }
        end2.setLength(Math.min(prevLength * 0.4, 10.0));
        end1.setLength(Math.min(nextLength * 0.4, 10.0));
        end1.add(x[i], y[i]);
        end2.add(x[i], y[i]);
        if (dir > 0) {
            return end1;
        }
        return end2;
    }

    public void drawPoints(double[] x, double[] y, int type, boolean[] shouldDraw) {
        int numPoints = Math.min(x.length, y.length);
        if (numPoints < 1) {
            return;
        }
        this.pushGrouping();
        int i = 0;
        while (i < numPoints) {
            if (shouldDraw == null || shouldDraw[i]) {
                switch (type) {
                    case 1: {
                        this.drawRect(x[i] - 2.0, y[i] - 2.0, 4.0, 4.0, "fill: black;");
                        break;
                    }
                    case 2: {
                        this.drawCircle(x[i], y[i], 2.0, "fill: black;");
                        break;
                    }
                    default: {
                        this.drawLine(x[i] - 2.0, y[i], x[i] + 2.0, y[i], "stroke-width: 1; stroke: black");
                        this.drawLine(x[i], y[i] - 2.0, x[i], y[i] + 2.0, "stroke-width: 1; stroke: black");
                    }
                }
            }
            ++i;
        }
        this.popGrouping();
    }

    public static double getYFromYear(double y, double baseY, Settings settings) {
        return (y - settings.topAge) * settings.unitsPerMY + baseY;
    }

    public StringWrappingInfo wrapString(String s, double windowWidth, TSCFont fontToUse) {
        StringWrappingInfo swi = new StringWrappingInfo(this.g);
        swi.wrapString(new RichText(s), windowWidth, fontToUse);
        return swi;
    }

    public StringWrappingInfo getSWI(RichText s, TSCFont fontToUse, int orientation) {
        return new StringWrappingInfo(this.g, s, fontToUse, orientation);
    }

    public StringWrappingInfo getSWI(String s, TSCFont fontToUse, int orientation) {
        return new StringWrappingInfo(this.g, new RichText(s), fontToUse, orientation);
    }

    public StringWrappingInfo getSWIOneLine(String s, TSCFont fontToUse, int orientation) {
        StringWrappingInfo ret = new StringWrappingInfo(this.g, new RichText(s), fontToUse, orientation);
        ret.makeOneLine();
        return ret;
    }

    public Element drawString(StringWrappingInfo swi, double startx, double starty, double width, double height, int verticalPlacement) {
        return this.drawString(swi, startx, starty, width, height, verticalPlacement, starty, 10, null);
    }

    public Element drawString(StringWrappingInfo swi, double startx, double starty, double width, double height, int verticalPlacement, double prefLoc) {
        return this.drawString(swi, startx, starty, width, height, verticalPlacement, prefLoc, 10, null);
    }

    public Element drawString(StringWrappingInfo swi, double startx, double starty, double width, double height, int verticalPlacement, double prefLoc, int background, String backgroundStyle) {
        double drawWidth;
        double verticalTop;
        Element text = null;
        double translateX = 0.0;
        double translateY = 0.0;
        double swiHeight = swi.getHeight();
        double swiWidth = swi.getWidth();
        switch (verticalPlacement) {
            case 2: {
                verticalTop = starty + (height - swiHeight) / 2.0;
                break;
            }
            case 3: {
                verticalTop = starty + height - swiHeight;
                break;
            }
            case 1: {
                verticalTop = starty;
            }
            case 4: {
                verticalTop = prefLoc - swiHeight / 2.0;
                if (verticalTop < starty) {
                    verticalTop = starty;
                    break;
                }
                if (!(verticalTop + swiHeight > starty + height)) break;
                verticalTop = starty + height - swiHeight;
                break;
            }
            default: {
                return null;
            }
        }
        translateX = startx;
        translateY = verticalTop;
        switch (swi.getRotateDegrees()) {
            case 90: {
                drawWidth = swiHeight;
                translateX += swiWidth + (width - swiWidth) / 2.0;
                translateY -= swiHeight;
                break;
            }
            case 180: {
                drawWidth = width;
                translateX += swiWidth;
                translateY -= swiHeight;
                break;
            }
            case 270: {
                drawWidth = swiHeight;
                translateX += (width - swiWidth) / 2.0;
                translateY += swiHeight;
                break;
            }
            default: {
                drawWidth = width;
            }
        }
        ImageGenerator.includesBackground(background);
        if (ImageGenerator.includesText(background)) {
            text = this.doc.createElementNS(this.svgNS, "text");
            text.setAttributeNS(null, "x", this.round(0.0));
            text.setAttributeNS(null, "y", this.round(0.0));
            if (swi.getRotateDegrees() != 0) {
                text.setAttributeNS(null, "transform", "translate(" + this.round(translateX) + ", " + this.round(translateY) + ") " + "rotate(" + swi.getRotateDegrees() + ", " + this.round(0.0) + ", " + this.round(0.0) + ") ");
            } else {
                text.setAttributeNS(null, "transform", "translate(" + this.round(translateX) + ", " + this.round(translateY) + ") ");
            }
            if (swi.font != null) {
                String color = this.getTextColor(backgroundStyle);
                text.setAttributeNS(null, "style", String.valueOf(swi.font.getSVGStyleNoColor()) + " fill: " + color + ";");
            }
        }
        int i = 0;
        while (i < swi.getNumLines()) {
            double x = (drawWidth - swi.widths[i]) / 2.0;
            double y = (double)(i + 1) * swi.lineHeight - swi.descent;
            RichText.Line line = swi.s.getLine(i);
            int j = 0;
            while (j < line.elements.size()) {
                RichText.Element elem = (RichText.Element)line.elements.get(j);
                if (elem instanceof RichText.StringElement) {
                    if (ImageGenerator.includesBackground(background)) {
                        this.drawRect(x, y - (swi.lineHeight - swi.descent), swi.widths[i], swi.lineHeight, backgroundStyle);
                        if (swi.getRotateDegrees() != 0) {
                            ((Element)this.curElement.getLastChild()).setAttributeNS(null, "transform", "translate(" + this.round(translateX) + ", " + this.round(translateY) + ") " + "rotate(" + swi.getRotateDegrees() + ", " + this.round(0.0) + ", " + this.round(0.0) + ") ");
                        } else {
                            ((Element)this.curElement.getLastChild()).setAttributeNS(null, "transform", "translate(" + this.round(translateX) + ", " + this.round(translateY) + ") ");
                        }
                    }
                    if (ImageGenerator.includesText(background)) {
                        Element tspan = this.doc.createElementNS(this.svgNS, "tspan");
                        tspan.setAttributeNS(null, "x", this.round(x));
                        tspan.setAttributeNS(null, "y", this.round(y));
                        Text t = this.doc.createTextNode(elem.visibleString());
                        this.pushElement(tspan);
                        int numPops = 1;
                        Iterator tagIter = ((RichText.StringElement)elem).openTags.iterator();
                        while (tagIter.hasNext()) {
                            RichText.BeginTagElement beginTag = (RichText.BeginTagElement)tagIter.next();
                            Element tagE = this.doc.createElementNS(this.svgNS, beginTag.tagName);
                            if (beginTag.styleChanges != null) {
                                tagE.setAttribute("style", beginTag.styleChanges);
                            }
                            Iterator attribIter = beginTag.attributes.keySet().iterator();
                            while (attribIter.hasNext()) {
                                String key = attribIter.next().toString();
                                tagE.setAttributeNS("http://www.w3.org/1999/xlink", key, beginTag.attributes.get(key).toString());
                            }
                            this.curElement.appendChild(tagE);
                            this.pushElement(tagE);
                            ++numPops;
                        }
                        this.curElement.appendChild(t);
                        int k = 0;
                        while (k < numPops) {
                            this.popGrouping();
                            ++k;
                        }
                        text.appendChild(tspan);
                        x += elem.width;
                    }
                }
                ++j;
            }
            ++i;
        }
        ImageGenerator.includesBackground(background);
        if (ImageGenerator.includesText(background)) {
            this.curElement.appendChild(text);
        }
        return text;
    }

    public Element drawString(String s, double x, double y, String style) {
        Element text = this.doc.createElementNS(this.svgNS, "text");
        text.setAttributeNS(null, "x", this.round(x));
        text.setAttributeNS(null, "y", this.round(y));
        if (style != null) {
            text.setAttributeNS(null, "style", style);
        }
        Text t = this.doc.createTextNode(s);
        text.appendChild(t);
        this.curElement.appendChild(text);
        return text;
    }

    public static String replace(String s, String pat, String rep) {
        System.out.println("replace: " + s + " (pat: " + pat + "   rep: " + rep);
        StringBuffer result = new StringBuffer();
        int start = 0;
        int end = 0;
        while ((end = s.indexOf(pat, start)) >= 0) {
            result.append(s.substring(start, end));
            result.append(rep);
            start = end + pat.length();
        }
        result.append(s.substring(start));
        return result.toString();
    }

    public Element drawStringYear(String s, double x, double y, String style, double baseY) {
        return this.drawString(s, x, (y - this.settings.topAge) * this.settings.unitsPerMY + baseY, style);
    }

    public Element drawStringYearPlusOffsetNoClip(String s, double x, double year, double offset, String style, double baseY) {
        double y = (year - this.settings.topAge) * this.settings.unitsPerMY + baseY + offset;
        if (y < baseY + offset) {
            y = baseY + offset;
        }
        return this.drawString(s, x, y, style);
    }

    public String getTextColor(String backgroundStyle) {
        if (backgroundStyle == null) {
            return "black";
        }
        Pattern pat = Pattern.compile("(color|fill):\\s*[^\\;]*\\;");
        Matcher matcher = pat.matcher(backgroundStyle);
        if (!matcher.find()) {
            return "black";
        }
        String match = matcher.group();
        String color = match.replaceFirst("color:", "").replaceFirst("fill:", "").replaceAll(";", "").trim();
        Color c = Coloring.getColorFromStyle(color);
        if (c == null) {
            return "black";
        }
        double grey = (double)c.getRed() * 0.3 + (double)c.getGreen() * 0.59 + (double)c.getBlue() * 0.11;
        if (grey > 120.0) {
            return "black";
        }
        return "white";
    }

    public void addDeclaration(String d) {
    }

    public void addElement(Element e) {
        this.curElement.appendChild(e);
    }

    public Element addElementCopy(Element orig) {
        Element e = this.doc.createElementNS(this.svgNS, orig.getTagName());
        NamedNodeMap nnm = orig.getAttributes();
        int i = 0;
        while (i < nnm.getLength()) {
            Node n = nnm.item(i);
            if (n.getNodeType() == 2) {
                String name = n.getNodeName();
                String value = n.getNodeValue();
                e.setAttribute(name, value);
            }
            ++i;
        }
        NodeList nl = orig.getChildNodes();
        int i2 = 0;
        while (i2 < nl.getLength()) {
            Node n = nl.item(i2);
            if (n.getNodeType() == 1) {
                Element backup = this.curElement;
                this.curElement = e;
                this.addElementCopy((Element)n);
                this.curElement = backup;
            }
            ++i2;
        }
        this.curElement.appendChild(e);
        return e;
    }

    public SVGDocument drawImage() {
        double colWidth = this.rootCol.getWidth(this.settings, this);
        double colHeaderHeight = this.rootCol.getHeaderHeight(this.settings, this);
        double dataHeight = (this.settings.baseAge - this.settings.topAge) * this.settings.unitsPerMY;
        double borderWidth = Settings.BORDER_WIDTH;
        double halfBorderWidth = borderWidth / 2.0;
        this.rootCol.setVariableColoring(this.settings);
        this.rootCol.drawHeader(this, borderWidth, borderWidth, colWidth, colHeaderHeight, this.settings);
        this.rootCol.drawData(this, borderWidth, borderWidth + colHeaderHeight + borderWidth, colWidth, dataHeight, this.settings);
        this.drawRect(halfBorderWidth, halfBorderWidth, borderWidth + colWidth + halfBorderWidth - 1.0, borderWidth + colHeaderHeight + borderWidth + dataHeight + halfBorderWidth - 1.0, BORDER_STYLE);
        this.drawLine(0.0, borderWidth + colHeaderHeight + halfBorderWidth, borderWidth + colWidth + borderWidth, borderWidth + colHeaderHeight + halfBorderWidth, BORDER_STYLE);
        this.setCanvasSize(colWidth + 2.0 * borderWidth + 1.0, colHeaderHeight + dataHeight + 3.0 * borderWidth + 1.0);
        if (this.settings.doPopups) {
            if ((double)this.settings.popupHeight > this.canvasHeight) {
                this.settings.popupHeight = (int)this.canvasHeight;
            }
            if ((double)this.settings.popupWidth > this.canvasWidth) {
                this.settings.popupWidth = (int)this.canvasWidth;
            }
            this.addMouseOverTexts(this.settings);
            this.addMouseOverStaticStuff(this.settings);
        }
        return this.doc;
    }

    public PopupInfo addPopup(RichText text) {
        PopupInfo pi = new PopupInfo(text);
        this.popups.add(pi);
        return pi;
    }

    public void appendPopupAttributes(Element node, String spawnerID, String popupID) {
        node.setAttributeNS(null, "onmouseover", "doMOHover(evt, '" + spawnerID + "', '" + popupID + "')");
        node.setAttributeNS(null, "onmouseout", "doMOOut(evt)");
        node.setAttributeNS(null, "onclick", "doMOClick(evt, '" + spawnerID + "', '" + popupID + "')");
        node.setAttributeNS(null, "id", spawnerID);
        node.setAttributeNS(null, "opacity", "0");
    }

    public void doPopupThings(String text) {
        this.doPopupThings(this.curElement, text);
    }

    public void doPopupThings(Element node, String text) {
        if (node == null || text == null || text.length() == 0) {
            return;
        }
        PopupInfo pi = this.addPopup(new RichText(text, true));
        this.appendPopupAttributes(node, pi.spawnerID, pi.id);
    }

    public void addMouseOverTexts(Settings settings) {
        int i = 0;
        while (i < this.popups.size()) {
            PopupInfo pi = (PopupInfo)this.popups.get(i);
            StringWrappingInfo swi = this.getSWI(pi.text, settings.fonts.getFont(5), 1);
            swi.wrap(settings.getPopupViewportWidth());
            Element t = this.drawString(swi, 0.0, 0.0, swi.getWidth(), swi.getHeight(), 1);
            t.setAttributeNS(null, "id", pi.id);
            t.setAttributeNS(null, "visibility", "hidden");
            t.setAttributeNS(null, "transform", "translate(" + (100.0 + this.canvasWidth) + ",0)");
            t.setAttributeNS(null, "tscreatorcanvasheight", "" + swi.getHeight());
            ++i;
        }
    }

    public void addMouseOverStaticStuff(Settings settings) {
        double yBase;
        Element oldCur = null;
        this.addMouseOverScript(settings);
        Element rect = this.doc.createElementNS(this.svgNS, "rect");
        rect.setAttributeNS(null, "x", "0");
        rect.setAttributeNS(null, "y", "0");
        rect.setAttributeNS(null, "width", "100%");
        rect.setAttributeNS(null, "height", "100%");
        rect.setAttributeNS(null, "id", "coordConverter");
        rect.setAttributeNS(null, "visibility", "hidden");
        this.curElement.appendChild(rect);
        this.pushGrouping();
        this.curElement.setAttributeNS(null, "id", "popup");
        this.curElement.setAttributeNS(null, "transform", "translate(0,0)");
        this.curElement.setAttributeNS(null, "visibility", "hidden");
        Element clipPath = this.doc.createElementNS(this.svgNS, "clipPath");
        clipPath.setAttributeNS(null, "id", "popupClip");
        this.curElement.appendChild(clipPath);
        oldCur = this.curElement;
        this.curElement = clipPath;
        this.drawRect(settings.popupMargin, settings.popupScrollButtonHeight + 2 * settings.popupMargin, settings.getPopupViewportWidth(), settings.getPopupViewportHeight(), null);
        this.curElement = oldCur;
        rect = this.doc.createElementNS(this.svgNS, "rect");
        rect.setAttributeNS(null, "x", "0");
        rect.setAttributeNS(null, "y", "0");
        rect.setAttributeNS(null, "width", "" + settings.popupWidth);
        rect.setAttributeNS(null, "height", "" + settings.popupHeight);
        rect.setAttributeNS(null, "style", "stroke-width: 1; stroke: black; fill: #FFFFAA");
        rect.setAttributeNS(null, "onclick", "doMOClosePopup(evt)");
        this.curElement.appendChild(rect);
        this.pushGrouping();
        this.curElement.setAttributeNS(null, "clip-path", "url(#popupClip)");
        this.pushGrouping();
        this.curElement.setAttributeNS(null, "transform", "translate(" + settings.popupMargin + ", " + (settings.popupScrollButtonHeight + 2 * settings.popupMargin) + ")");
        this.pushGrouping();
        this.curElement.setAttributeNS(null, "id", "popupCanvas");
        this.popGrouping();
        this.popGrouping();
        this.popGrouping();
        int scrollButtonWidth = settings.popupWidth - 2 * settings.popupMargin;
        int topScrollButtonY = settings.popupMargin;
        int bottomScrollButtonY = settings.popupHeight - settings.popupScrollButtonHeight - settings.popupMargin;
        rect = this.doc.createElementNS(this.svgNS, "rect");
        rect.setAttributeNS(null, "x", "" + settings.popupMargin);
        rect.setAttributeNS(null, "y", "" + topScrollButtonY);
        rect.setAttributeNS(null, "width", "" + scrollButtonWidth);
        rect.setAttributeNS(null, "height", "" + settings.popupScrollButtonHeight);
        rect.setAttributeNS(null, "style", "stroke-width: 1; stroke: black; fill: #FFFF55");
        rect.setAttributeNS(null, "onclick", "doMOScrollUp(evt)");
        this.curElement.appendChild(rect);
        rect = this.doc.createElementNS(this.svgNS, "rect");
        rect.setAttributeNS(null, "x", "" + settings.popupMargin);
        rect.setAttributeNS(null, "y", "" + bottomScrollButtonY);
        rect.setAttributeNS(null, "width", "" + scrollButtonWidth);
        rect.setAttributeNS(null, "height", "" + settings.popupScrollButtonHeight);
        rect.setAttributeNS(null, "style", "stroke-width: 1; stroke: black; fill: #FFFF55");
        rect.setAttributeNS(null, "onclick", "doMOScrollDown(evt)");
        this.curElement.appendChild(rect);
        double arrowHeight = settings.popupScrollButtonHeight - 2 * settings.popupMargin;
        double arrowHeightMargin = ((double)settings.popupScrollButtonHeight - arrowHeight) / 2.0;
        double arrowWidth = arrowHeight;
        if (arrowWidth > (double)scrollButtonWidth) {
            arrowWidth = scrollButtonWidth;
        }
        double arrowWidthMargin = ((double)scrollButtonWidth - arrowWidth) / 2.0;
        double[] x = new double[3];
        double[] y = new double[3];
        x[0] = (double)settings.popupMargin + arrowWidthMargin;
        x[1] = (double)settings.popupMargin + (double)scrollButtonWidth / 2.0;
        x[2] = (double)(settings.popupMargin + scrollButtonWidth) - arrowWidthMargin;
        double yPoint = (double)topScrollButtonY + arrowHeightMargin;
        y[0] = yBase = (double)(topScrollButtonY + settings.popupScrollButtonHeight) - arrowHeightMargin;
        y[1] = yPoint;
        y[2] = y[0];
        this.drawPolyline(x, y, "stroke-width: 1; stroke: black; fill: black");
        yPoint = yPoint - (double)topScrollButtonY + (double)bottomScrollButtonY;
        yBase = yBase - (double)topScrollButtonY + (double)bottomScrollButtonY;
        y[0] = yPoint;
        y[1] = yBase;
        y[2] = y[0];
        this.drawPolyline(x, y, "stroke-width: 1; stroke: black; fill: black");
        this.popGrouping();
    }

    public void addMouseOverScript(Settings settings) {
        Element script = this.doc.createElementNS(this.svgNS, "script");
        script.setAttributeNS(null, "type", "text/ecmascript");
        CDATASection t = this.doc.createCDATASection("\nvar popup = document.getElementById(\"popup\");\nvar popupCanvas = document.getElementById(\"popupCanvas\");\nvar curHoverElemID = 0;\nvar curHoverTextID = 0;\nvar regularPopupTransform = \"translate(0,0)\";\n\n// for scrolling the popup\nvar tx = 0;\nvar ty = 0;\nvar canvasHeight = 0;\nvar viewportHeight = " + settings.getPopupViewportHeight() + "; // this is dynamic\n" + "var popupWidth = " + settings.popupWidth + "; // this is dynamic\n" + "var popupHeight = " + settings.popupHeight + "; // this is dynamic\n" + "var svgWidth = " + this.round(this.canvasWidth) + "; // this is dynamic\n" + "var svgHeight = " + this.round(this.canvasHeight) + "; // this is dynamic\n" + "\n" + "function getPopupTransform(elemID, evt)\n" + "{\n" + "\tvar point = getUserCoordEvent(evt);\n" + "\tvar x = point.x;\n" + "\tvar y = point.y;\n" + "\tif (x < 0)\n" + "\t\tx = 0;\n" + "\tif (y < 0)\n" + "\t\ty = 0;\n" + "\tif (x > svgWidth - popupWidth)\n" + "\t\tx = svgWidth - popupWidth;\n" + "\tif (y > svgHeight - popupHeight)\n" + "\t\ty = svgHeight - popupHeight;\n" + "\n" + "\treturn \"translate(\" + x + \", \" + y + \")\";\n" + "}\n" + "\n" + "function doMOHover(evt, elemID, textID) {\n" + "\tvar e = document.getElementById(elemID);\n" + "\tvar bounds = e.getBBox();\n" + "\n" + "\te.setAttribute(\"opacity\", \"1\");\n" + "\n" + "\tcurHoverElemID = elemID;\n" + "\tcurHoverTextID = textID;\n" + "}\n" + "\n" + "function doMOOut(evt) {\n" + "\tdocument.getElementById(curHoverElemID).setAttribute(\"opacity\", \"0\");\n" + "}\n" + "\n" + "function doMOClick(evt, elemID, textID) {\n" + "\tsanitizePopup();\n" + "\tpopup.setAttribute(\"visibility\", \"visible\");\n" + "\tregularPopupTransform = getPopupTransform(elemID, evt);\n" + "\tpopup.setAttribute(\"transform\", regularPopupTransform);\n" + "\tsanitizePopup();\n" + "\n" + "\t// scroll to the very top\n" + "\ttx = ty = 0;\n" + "\tpopupCanvas.setAttribute(\"transform\", \"translate(\" + tx + \", \" + ty + \")\");\n" + "\n" + "\t// add the text to the popup\n" + "\tvar text = document.getElementById(textID).cloneNode(true);\n" + "\twhile (popupCanvas.childNodes.length > 0)\n" + "\t\tpopupCanvas.removeChild(popupCanvas.lastChild);\n" + "\tpopupCanvas.appendChild(text);\n" + "\ttext.setAttribute(\"visibility\", \"visible\");\n" + "\ttext.setAttribute(\"transform\", \"translate(0,0)\");\n" + "\t\n" + "\t// make it so clicking on the text will also close the popup\n" + "\taddAllChildrensListener(popupCanvas, \"click\", doMOClosePopup);\n" + "\n" + "\t// set the height for scrolling\n" + "\tcanvasHeight = parseInt(text.getAttribute(\"tscreatorcanvasheight\"));\n" + "}\n" + "\n" + "function doMOClosePopup(evt) {\n" + "\twhile (popupCanvas.childNodes.length > 0)\n" + "\t\tpopupCanvas.removeChild(popupCanvas.lastChild);\n" + "\tpopup.setAttribute(\"visibility\", \"hidden\");\n" + "}\n" + "\n" + "function doMOScrollUp(evt) {\n" + "\tty = ty + 10;\n" + "\tif (ty > 0)\n" + "\t\tty = 0;\n" + "\n" + "\tpopupCanvas.setAttribute(\"transform\", \"translate(\" + tx + \", \" + ty + \")\");\n" + "}\n" + "\n" + "function doMOScrollDown(evt) {\n" + "\tty = ty - 10;\n" + "\tif (ty + canvasHeight < viewportHeight)\n" + "\t\tty = viewportHeight - canvasHeight;\n" + "\tif (ty > 0)\n" + "\t\tty = 0;\n" + "\tpopupCanvas.setAttribute(\"transform\", \"translate(\" + tx + \", \" + ty + \")\");\n" + "}\n" + "\n" + "function setAllChildrensAttribute(node, attr, val)\n" + "{\n" + "\tfor (var i = 0; i < node.childNodes.length; i++)\n" + "\t{\n" + "\t\tvar child = node.childNodes.item(i);\n" + "\t\tchild.setAttribute(attr, val);\n" + "\t\tsetAllChildrensAttribute(child, attr, val);\n" + "\t}\n" + "}\n" + "\n" + "function addAllChildrensListener(node, e, func)\n" + "{\n" + "\tfor (var i = 0; i < node.childNodes.length; i++)\n" + "\t{\n" + "\t\tvar child = node.childNodes.item(i);\n" + "\t\tif (child.tagName != \"a\") {\n" + "\t\t\tchild.addEventListener(e, func, false);\n" + "\t\t\taddAllChildrensListener(child, e, func);\n" + "\t\t}\n" + "\t}\n" + "}\n" + "function sanitizePopup()\n" + "{\n" + "\tvar p0 = document.documentElement.createSVGPoint();\n" + "\tvar p1 = document.documentElement.createSVGPoint();\n" + "\tp0.x = 0; p0.y = 0;\n" + "\tp1.x = 1; p1.y = 1;\n" + "\tvar convP0 = getUserCoord(p0);\n" + "\tvar convP1 = getUserCoord(p1);\n" + "\tvar sx = (convP1.x-convP0.x);\n" + "\tvar sy = (convP1.y-convP0.y);\n" + "\tpopupWidth = " + settings.popupWidth + " * sx\n" + "\tpopupHeight = " + settings.popupHeight + " * sy\n" + "\n" + "\tvar b = document.getElementById(\"popup\");\n" + "\tb.setAttribute(\"transform\", regularPopupTransform + \" scale(\" + sx + \",\" + sy + \")\");\n" + "}\n" + "\n" + "function getUserCoordEvent(evt)\n" + "{\n" + "\tvar svgPoint = document.documentElement.createSVGPoint();\n" + "\tsvgPoint.x = evt.clientX;\n" + "\tsvgPoint.y = evt.clientY;\n" + "\treturn getUserCoord(svgPoint)\n" + "}\n" + "\n" + "function getUserCoord(clientPoint)\n" + "{\n" + "\tvar target = document.getElementById(\"coordConverter\");\n" + "\tif (!document.documentElement.getScreenCTM) {\n" + "\t\tvar matrix = getTransformToElement(target);\n" + "\t\treturn clientPoint.matrixTransform(matrix.inverse().multiply(this.m));\n" + "\t}\n" + "\telse {\n" + "\t\tvar matrix = target.getScreenCTM();\n" + "\t\treturn clientPoint.matrixTransform(matrix.inverse());\n" + "\t}\n" + "}\n" + "\n" + "\n");
        script.appendChild(t);
        this.curElement.appendChild(script);
        this.svgRoot.setAttribute("onzoom", "sanitizePopup();");
    }

    public static class PopupInfo {
        static int count = 0;
        public RichText text;
        public String id;
        public String spawnerID;

        public PopupInfo(RichText t) {
            this.text = t;
            this.id = "id" + count;
            this.spawnerID = "spawner" + count;
            ++count;
        }
    }
}

