/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datastore.AgeAgeColumn;
import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import datastore.Datastore;
import datastore.FreehandColumn;
import datastore.MetaColumn;
import datastore.PointColumn;
import datastore.RulerColumn;
import gui.ColumnDataEditor;
import gui.ExtensionFileFilter;
import gui.FontManager;
import gui.FontOptions;
import gui.ModifyTextField;
import gui.TSCLinkActivationListener;
import gui.TSCreator;
import gui.tree.CheckboxTreeCellEditor;
import gui.tree.CheckboxTreeCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SpringLayout;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Settings
extends JDialog
implements TreeSelectionListener,
ItemListener,
ActionListener {
    private JPanel jContentPane = null;
    private JTabbedPane tabbedPane = null;
    private JPanel buttonPanel = null;
    private JButton loadButton = null;
    private JButton saveButton = null;
    private JButton okButton = null;
    private JButton generateButton = null;
    private JLabel errorLabel = null;
    private TSCreator.TSCAction generateAction = null;
    private JPanel timesPanel = null;
    private JPanel zonesPanel = null;
    private JPanel fontTabPanel = null;
    private FontOptions fontPanel = null;
    private JLabel topLabel = null;
    private JRadioButton topStageRadio = null;
    private JRadioButton topMYRadio = null;
    private ModifyTextField topMY = null;
    private JComboBox topStage = null;
    private JLabel baseLabel = null;
    private JRadioButton baseStageRadio = null;
    private JRadioButton baseMYRadio = null;
    private ModifyTextField baseMY = null;
    private JComboBox baseStage = null;
    private JLabel previewLabel = null;
    private JSVGCanvas preview = null;
    private JPanel zoneOptionsPanel = null;
    private JTree zoneTree = null;
    private JRadioButton variableColorRadio = null;
    private JButton resetColorButton = null;
    private JRadioButton customRadio = null;
    private JLabel colorLabel = null;
    private JButton customColor = null;
    private JPanel customColorBox = null;
    private JLabel widthLabel = null;
    private ModifyTextField widthTF = null;
    private JLabel titleLabel = null;
    private JCheckBox showTitleCB = null;
    private ModifyTextField titleTF = null;
    private JCheckBox showAgeLabelsCB = null;
    private JButton fontOptionsB = null;
    private JButton dataEditB = null;
    private JPanel colPanel = null;
    private JPanel colOptionsPanel = null;
    private JPanel colInfoPanel = null;
    private JEditorPane colInfoLabel = null;
    private JButton moveUp = null;
    private JButton moveDown = null;
    private JSeparator belowColorSep = null;
    private JSeparator belowFontsSep = null;
    private JSeparator belowWidthSep = null;
    private JSeparator belowArrowsSep = null;
    private JCheckBox popupCheck = null;
    private JCheckBox skipEmptyColumnsCheck = null;
    private JRadioButton USGSRadio = null;
    private JRadioButton UNESCORadio = null;
    public Coloring variableColoring = new Coloring(Coloring.USGS);
    public Coloring variableNamedColoring = new Coloring(Coloring.NAMED_USGS);
    private ModifyTextField unitsPerMaTF = null;
    private DataColumn curSelectDC = null;
    private Datastore ds = null;
    private boolean noData = true;
    public boolean isValid = false;
    public final int ERROR = 1;
    public final int WARNING = 2;
    public final int OK = 3;
    public double topAge;
    public double baseAge;
    public double unitsPerMY = 30.0;
    public boolean isPopulated = false;
    public boolean doPopups = false;
    public boolean skipEmptyColumns = true;
    public int popupWidth = 200;
    public int popupHeight = 100;
    public int popupScrollButtonHeight = 8;
    public int popupMargin = 2;
    public int popupMinWidth = 20;
    public int popupMinHeight = 2 * this.popupScrollButtonHeight + 4 * this.popupMargin + 10;
    public static final double EQUAL_MARGIN = 1.0E-6;
    public static double BORDER_WIDTH = 2.0;
    public FontManager fonts = new FontManager();
    public static final String SOLID_STROKE = "";
    public static final String DASHED_STROKE = "stroke-dasharray:10,5;";
    public static final String DOTTED_STROKE = "stroke-dasharray:5,5;";
    public static final String POPUP_HIGHLIGHT = "stroke-width: 0; opacity: 0.5; fill: red;";
    boolean ignoreGrayOut = false;

    public static String getStroke(int which) {
        if (which == 2) {
            return DASHED_STROKE;
        }
        if (which == 3) {
            return DOTTED_STROKE;
        }
        return SOLID_STROKE;
    }

    public static boolean isEqual(double left, double right) {
        double result = left - right;
        return result == 0.0 || result > 0.0 && result < 1.0E-6 || result < 0.0 && result > -1.0E-6;
    }

    public static boolean isMultiple(double num, double factor) {
        double quotient = num / factor;
        double i = Math.round(quotient);
        return Settings.isEqual(quotient, i);
    }

    public static String formatDouble(double d) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumFractionDigits(0);
        return nf.format(d);
    }

    public Settings(Datastore ds) throws HeadlessException {
        this.initialize(ds);
    }

    public void setGenerateAction(TSCreator.TSCAction a) {
        this.generateAction = a;
    }

    private void initialize(Datastore ds) {
        this.ds = ds;
        this.setModal(false);
        this.setTitle("Settings");
        this.setContentPane(this.getJContentPane());
        this.setSize(700, 720);
        this.noData = true;
    }

    public void showGenerating(boolean gen) {
        if (gen) {
            this.tabbedPane.setEnabled(false);
            this.loadButton.setEnabled(false);
            this.generateButton.setEnabled(false);
            this.setErrorString("<html><strong>Settings disabled while generating!</strong></html>", 1);
        } else {
            this.tabbedPane.setEnabled(true);
            this.loadButton.setEnabled(true);
            this.generateButton.setEnabled(true);
            this.setErrorString(SOLID_STROKE, 3);
        }
    }

    public void populate(Datastore ds) {
        this.isPopulated = true;
        this.ds = ds;
        DataColumn stageCol = ds.getColumnByName("Stage");
        this.zoneTree.setRootVisible(true);
        this.topStage.removeAllItems();
        this.baseStage.removeAllItems();
        ds.rootColumn.enableCheckbox(false);
        String units = ds.getUnits();
        if (stageCol != null) {
            Iterator stages = stageCol.data.iterator();
            double top = 0.0;
            while (stages.hasNext()) {
                Datapoint dataP = (Datapoint)stages.next();
                if (dataP.breaker) continue;
                Datapoint boxTopP = new Datapoint();
                Datapoint boxBaseP = new Datapoint();
                boxTopP.label = top == 0.0 ? "Present (" + top + " " + units + ")" : String.valueOf(dataP.label) + " (" + top + " " + units + " start)";
                boxBaseP.label = String.valueOf(dataP.label) + " (" + dataP.baseAge + " " + units + " end)";
                boxTopP.baseAge = top;
                boxBaseP.baseAge = dataP.baseAge;
                boxTopP.parameter = this.topStage;
                boxBaseP.parameter = this.baseStage;
                this.topStage.addItem(boxTopP);
                this.baseStage.addItem(boxBaseP);
                top = dataP.baseAge;
            }
        } else {
            this.topStage.setEnabled(false);
            this.baseStage.setEnabled(false);
            this.topStageRadio.setEnabled(false);
            this.baseStageRadio.setEnabled(false);
            this.topMYRadio.setSelected(true);
            this.baseMYRadio.setSelected(true);
        }
        int i = 0;
        while (i < this.zoneTree.getRowCount()) {
            if (this.zoneTree.getPathForRow(i).getPathCount() <= 1) {
                this.zoneTree.expandRow(i);
            }
            ++i;
        }
        this.zoneTree.setRowHeight(0);
        if (!this.topStageRadio.isSelected() && !this.topMYRadio.isSelected()) {
            this.topStageRadio.setSelected(true);
        }
        if (!this.baseStageRadio.isSelected() && !this.baseMYRadio.isSelected()) {
            this.baseStageRadio.setSelected(true);
        }
        this.isValid();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getTabbedPane(), "Center");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab("Choose Time Interval", null, this.getTimesPanel(), null);
            this.tabbedPane.addTab("Choose Zonations", null, this.getZonesPanel(), null);
            this.fontTabPanel = new JPanel(new GridLayout(1, 1));
            this.fontTabPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.fontTabPanel.add(this.getFontPanel());
            this.tabbedPane.addTab("Font Options", null, this.fontTabPanel, null);
        }
        return this.tabbedPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout());
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel p = new JPanel();
            p.add(this.getLoadButton());
            p.add(this.getSaveButton());
            p.add(this.getOkButton());
            p.add(this.getGenerateButton());
            this.buttonPanel.add((Component)p, "East");
            this.buttonPanel.add((Component)this.getErrorLabel(), "Center");
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("Close");
            this.okButton.addActionListener(this);
        }
        return this.okButton;
    }

    private JButton getGenerateButton() {
        if (this.generateButton == null) {
            this.generateButton = new JButton();
            this.generateButton.setText("<html><strong>Generate</strong></html>");
            this.generateButton.addActionListener(this);
        }
        return this.generateButton;
    }

    private JButton getLoadButton() {
        if (this.loadButton == null) {
            this.loadButton = new JButton();
            this.loadButton.setText("Load...");
            this.loadButton.addActionListener(this);
        }
        return this.loadButton;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton();
            this.saveButton.setText("Save...");
            this.saveButton.addActionListener(this);
        }
        return this.saveButton;
    }

    private JLabel getErrorLabel() {
        if (this.errorLabel == null) {
            this.errorLabel = new JLabel();
        }
        return this.errorLabel;
    }

    private JPanel getTimesPanel() {
        if (this.timesPanel == null) {
            this.previewLabel = new JLabel();
            this.baseLabel = new JLabel();
            this.topLabel = new JLabel();
            this.timesPanel = new JPanel();
            SpringLayout layout = new SpringLayout();
            this.timesPanel.setLayout(layout);
            this.topLabel.setText("Top of Interval");
            this.baseLabel.setText("Base of Interval");
            this.previewLabel.setText("Preview");
            this.previewLabel.setVisible(false);
            this.timesPanel.add((Component)this.topLabel, null);
            this.timesPanel.add((Component)this.getTopStageRadio(), null);
            this.timesPanel.add((Component)this.getTopMYRadio(), null);
            this.timesPanel.add((Component)this.getTopMY(), null);
            this.timesPanel.add((Component)this.baseLabel, null);
            this.timesPanel.add((Component)this.getBaseStageRadio(), null);
            this.timesPanel.add((Component)this.getBaseMYRadio(), null);
            this.timesPanel.add((Component)this.getBaseMY(), null);
            this.timesPanel.add((Component)this.previewLabel, null);
            this.timesPanel.add((Component)this.getPreview(), null);
            this.timesPanel.add((Component)this.getBaseStage(), null);
            this.timesPanel.add((Component)this.getTopStage(), null);
            JPanel zoomPanel = new JPanel();
            zoomPanel.add(new JLabel("Vertical Scale:"));
            zoomPanel.add(this.getUnitsPerMaTF());
            this.unitsPerMaTF.addActionListener(this);
            zoomPanel.add(new JLabel("cm per data unit (eg. 1 cm per Myr)"));
            this.timesPanel.add(zoomPanel);
            this.timesPanel.add(this.getSkipEmptyColumnsCheck());
            JSeparator afterTimesSep = new JSeparator(0);
            this.timesPanel.add(afterTimesSep);
            JPanel colorPanel = new JPanel();
            colorPanel.setLayout(new BoxLayout(colorPanel, 1));
            colorPanel.add(new JLabel("Standardized time scale colors: "));
            colorPanel.add((Component)this.getUNESCORadio(), null);
            colorPanel.add((Component)this.getUSGSRadio(), null);
            ButtonGroup group = new ButtonGroup();
            group.add(this.USGSRadio);
            group.add(this.UNESCORadio);
            this.timesPanel.add(colorPanel);
            JSeparator afterColorSep = new JSeparator(0);
            this.timesPanel.add(afterColorSep);
            this.timesPanel.add(this.getPopupCheck());
            layout.putConstraint("West", (Component)this.preview, 50, "East", (Component)this.timesPanel);
            layout.putConstraint("East", (Component)this.preview, 5, "East", (Component)this.timesPanel);
            layout.putConstraint("South", (Component)this.preview, 5, "South", (Component)this.timesPanel);
            layout.putConstraint("North", (Component)this.preview, 5, "South", (Component)this.previewLabel);
            layout.putConstraint("North", (Component)this.previewLabel, 5, "North", (Component)this.timesPanel);
            layout.putConstraint("West", (Component)this.previewLabel, 5, "West", (Component)this.preview);
            layout.putConstraint("West", (Component)this.topLabel, 5, "West", (Component)this.timesPanel);
            layout.putConstraint("North", (Component)this.topLabel, 5, "North", (Component)this.timesPanel);
            layout.putConstraint("West", (Component)this.topStageRadio, 5, "West", (Component)this.timesPanel);
            layout.putConstraint("West", (Component)this.topMYRadio, 5, "West", (Component)this.timesPanel);
            layout.putConstraint("North", (Component)this.topStageRadio, 5, "South", (Component)this.topLabel);
            layout.putConstraint("North", (Component)this.topMYRadio, 5, "South", (Component)this.topStageRadio);
            group = new ButtonGroup();
            group.add(this.topStageRadio);
            group.add(this.topMYRadio);
            layout.putConstraint("East", (Component)this.topStage, -10, "West", (Component)this.preview);
            layout.putConstraint("West", (Component)this.topStage, 5, "East", (Component)this.topStageRadio);
            layout.putConstraint("West", (Component)this.topMY, 5, "East", (Component)this.topMYRadio);
            layout.putConstraint("North", (Component)this.topStage, 0, "North", (Component)this.topStageRadio);
            layout.putConstraint("North", (Component)this.topMY, 0, "North", (Component)this.topMYRadio);
            layout.putConstraint("West", (Component)this.baseLabel, 5, "West", (Component)this.timesPanel);
            layout.putConstraint("North", (Component)this.baseLabel, 30, "South", (Component)this.topMYRadio);
            layout.putConstraint("West", (Component)this.baseStageRadio, 5, "West", (Component)this.timesPanel);
            layout.putConstraint("West", (Component)this.baseMYRadio, 5, "West", (Component)this.timesPanel);
            layout.putConstraint("North", (Component)this.baseStageRadio, 5, "South", (Component)this.baseLabel);
            layout.putConstraint("North", (Component)this.baseMYRadio, 5, "South", (Component)this.baseStageRadio);
            group = new ButtonGroup();
            group.add(this.baseStageRadio);
            group.add(this.baseMYRadio);
            layout.putConstraint("East", (Component)this.baseStage, -10, "West", (Component)this.preview);
            layout.putConstraint("West", (Component)this.baseStage, 5, "East", (Component)this.baseStageRadio);
            layout.putConstraint("West", (Component)this.baseMY, 5, "East", (Component)this.baseMYRadio);
            layout.putConstraint("North", (Component)this.baseStage, 0, "North", (Component)this.baseStageRadio);
            layout.putConstraint("North", (Component)this.baseMY, 0, "North", (Component)this.baseMYRadio);
            layout.putConstraint("West", (Component)zoomPanel, 5, "West", (Component)this.timesPanel);
            layout.putConstraint("North", (Component)zoomPanel, 45, "South", (Component)this.baseMY);
            layout.putConstraint("West", (Component)this.skipEmptyColumnsCheck, 5, "West", (Component)this.timesPanel);
            layout.putConstraint("North", (Component)this.skipEmptyColumnsCheck, 10, "South", (Component)zoomPanel);
            layout.putConstraint("East", (Component)afterTimesSep, -5, "East", (Component)this.timesPanel);
            layout.putConstraint("West", (Component)afterTimesSep, 5, "West", (Component)this.timesPanel);
            layout.putConstraint("North", (Component)afterTimesSep, 10, "South", (Component)this.skipEmptyColumnsCheck);
            layout.putConstraint("West", (Component)colorPanel, 5, "West", (Component)this.timesPanel);
            layout.putConstraint("North", (Component)colorPanel, 10, "South", (Component)afterTimesSep);
            layout.putConstraint("East", (Component)afterColorSep, -5, "East", (Component)this.timesPanel);
            layout.putConstraint("West", (Component)afterColorSep, 5, "West", (Component)this.timesPanel);
            layout.putConstraint("North", (Component)afterColorSep, 10, "South", (Component)colorPanel);
            layout.putConstraint("West", (Component)this.popupCheck, 5, "West", (Component)this.timesPanel);
            layout.putConstraint("North", (Component)this.popupCheck, 10, "South", (Component)afterColorSep);
        }
        return this.timesPanel;
    }

    private JPanel getZonesPanel() {
        if (this.zonesPanel == null) {
            this.zonesPanel = new JPanel();
            this.zonesPanel.setLayout(new BorderLayout());
            this.zonesPanel.add((Component)this.getZoneOptionsPanel(), "East");
            this.zonesPanel.add((Component)new JScrollPane(this.getZoneTree()), "Center");
        }
        return this.zonesPanel;
    }

    private FontOptions getFontPanel() {
        if (this.fontPanel == null) {
            this.fontPanel = new FontOptions(this.fonts);
            JPanel p = new JPanel(new GridLayout(1, 1));
            p.add(new JLabel("<html>These are the default systemwide fonts.<br>Changing one here will affect the entire chart. To make a change, check the checkbox for that font. Uncheck it to go back to system defaults.<br><br><b>NOTE:</b> These settings can be overriden on a column-by-column basis by using the Font button for each column under \"Choose Zonations\".<br></html>"));
            this.fontPanel.add(p);
            this.fontPanel.addOptions(FontManager.getRelevantFonts(null), false);
        }
        return this.fontPanel;
    }

    private JRadioButton getTopStageRadio() {
        if (this.topStageRadio == null) {
            this.topStageRadio = new JRadioButton();
            this.topStageRadio.setText("Stage Name");
            this.topStageRadio.addItemListener(this);
        }
        return this.topStageRadio;
    }

    private JRadioButton getTopMYRadio() {
        if (this.topMYRadio == null) {
            this.topMYRadio = new JRadioButton();
            this.topMYRadio.setText("Millions of Years");
            this.topMYRadio.addItemListener(this);
        }
        return this.topMYRadio;
    }

    private ModifyTextField getTopMY() {
        if (this.topMY == null) {
            this.topMY = new ModifyTextField(false, true);
            Dimension d = this.topMY.getPreferredSize();
            d.width = 50;
            this.topMY.setPreferredSize(d);
            this.topMY.addActionListener(this);
        }
        return this.topMY;
    }

    private JComboBox getTopStage() {
        if (this.topStage == null) {
            this.topStage = new JComboBox();
            this.topStage.addItemListener(this);
        }
        return this.topStage;
    }

    private JRadioButton getBaseStageRadio() {
        if (this.baseStageRadio == null) {
            this.baseStageRadio = new JRadioButton();
            this.baseStageRadio.setText("Stage Name");
            this.baseStageRadio.addItemListener(this);
        }
        return this.baseStageRadio;
    }

    private JRadioButton getBaseMYRadio() {
        if (this.baseMYRadio == null) {
            this.baseMYRadio = new JRadioButton();
            this.baseMYRadio.setText("Millions of Years");
            this.baseMYRadio.addItemListener(this);
        }
        return this.baseMYRadio;
    }

    private ModifyTextField getBaseMY() {
        if (this.baseMY == null) {
            this.baseMY = new ModifyTextField(false, true);
            Dimension d = this.baseMY.getPreferredSize();
            d.width = 50;
            this.baseMY.setPreferredSize(d);
            this.baseMY.addActionListener(this);
        }
        return this.baseMY;
    }

    private JComboBox getBaseStage() {
        if (this.baseStage == null) {
            this.baseStage = new JComboBox();
            this.baseStage.addItemListener(this);
        }
        return this.baseStage;
    }

    private JSVGCanvas getPreview() {
        if (this.preview == null) {
            this.preview = new JSVGCanvas();
            this.preview.setPreferredSize(new Dimension(0, 0));
        }
        return this.preview;
    }

    private JTree getZoneTree() {
        if (this.zoneTree == null) {
            this.zoneTree = new JTree(this.ds.rootColumn);
            this.zoneTree.setCellRenderer(new CheckboxTreeCellRenderer());
            this.zoneTree.setCellEditor(new CheckboxTreeCellEditor(this.zoneTree));
            this.zoneTree.setEditable(true);
            this.zoneTree.getSelectionModel().setSelectionMode(1);
            this.zoneTree.addTreeSelectionListener(this);
        }
        return this.zoneTree;
    }

    private JPanel getZoneOptionsPanel() {
        if (this.zoneOptionsPanel == null) {
            this.zoneOptionsPanel = new JPanel();
            SpringLayout layout = new SpringLayout();
            this.zoneOptionsPanel.setLayout(layout);
            this.colorLabel = new JLabel();
            this.colorLabel.setText("Background Color:");
            this.customColorBox = new JPanel();
            this.customColorBox.setPreferredSize(new Dimension(20, 20));
            this.zoneOptionsPanel.add((Component)this.colorLabel, null);
            this.zoneOptionsPanel.add((Component)this.getVariableColorRadio(), null);
            this.zoneOptionsPanel.add((Component)this.getCustomRadio(), null);
            this.zoneOptionsPanel.add((Component)this.getColorResetButton(), null);
            this.zoneOptionsPanel.add((Component)this.getCustomColor(), null);
            this.zoneOptionsPanel.add((Component)this.customColorBox, null);
            this.zoneOptionsPanel.add((Component)this.getFontOptionsB(), null);
            this.zoneOptionsPanel.add((Component)this.getDataEditB(), null);
            this.widthLabel = new JLabel();
            this.widthLabel.setText("Width:");
            this.zoneOptionsPanel.add((Component)this.widthLabel, null);
            this.zoneOptionsPanel.add((Component)this.getWidthTF(), null);
            this.widthTF.addActionListener(this);
            this.titleLabel = new JLabel();
            this.titleLabel.setText("Edit Title:");
            this.zoneOptionsPanel.add((Component)this.titleLabel, null);
            this.zoneOptionsPanel.add((Component)this.getTitleTF(), null);
            this.titleTF.addActionListener(this);
            this.zoneOptionsPanel.add((Component)this.getShowTitleCB(), null);
            this.zoneOptionsPanel.add((Component)this.getShowAgeLabelsCB(), null);
            this.zoneOptionsPanel.add((Component)this.getMoveUp(), null);
            this.zoneOptionsPanel.add((Component)this.getMoveDown(), null);
            this.belowColorSep = new JSeparator(0);
            this.belowFontsSep = new JSeparator(0);
            this.belowWidthSep = new JSeparator(0);
            this.belowArrowsSep = new JSeparator(0);
            this.zoneOptionsPanel.add((Component)this.belowColorSep, null);
            this.zoneOptionsPanel.add((Component)this.belowFontsSep, null);
            this.zoneOptionsPanel.add((Component)this.belowWidthSep, null);
            this.zoneOptionsPanel.add((Component)this.belowArrowsSep, null);
            this.colPanel = new JPanel(new BorderLayout());
            this.colOptionsPanel = new JPanel(new BorderLayout());
            this.colPanel.add((Component)this.colOptionsPanel, "North");
            this.colInfoPanel = new JPanel(new BorderLayout());
            this.colInfoPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            JPanel borderPanel = new JPanel(new BorderLayout());
            borderPanel.setBorder(BorderFactory.createTitledBorder("Information and References"));
            this.colInfoLabel = new JEditorPane();
            this.colInfoLabel.setEditable(false);
            this.colInfoLabel.setContentType("text/html");
            this.colInfoLabel.addHyperlinkListener(new TSCLinkActivationListener());
            this.colInfoLabel.setBackground(null);
            JScrollPane sp = new JScrollPane(this.colInfoLabel);
            sp.setBorder(null);
            borderPanel.add(sp);
            this.colInfoPanel.add((Component)borderPanel, "Center");
            this.colPanel.add((Component)this.colInfoPanel, "Center");
            this.zoneOptionsPanel.add((Component)this.colPanel, null);
            ButtonGroup group = new ButtonGroup();
            group.add(this.getVariableColorRadio());
            group.add(this.getCustomRadio());
            layout.putConstraint("West", (Component)this.colorLabel, 5, "West", (Component)this.zoneOptionsPanel);
            layout.putConstraint("West", (Component)this.variableColorRadio, 5, "West", (Component)this.colorLabel);
            layout.putConstraint("West", (Component)this.customRadio, 5, "West", (Component)this.colorLabel);
            layout.putConstraint("West", (Component)this.customColor, 5, "East", (Component)this.customRadio);
            layout.putConstraint("West", (Component)this.customColorBox, 5, "East", (Component)this.customColor);
            layout.putConstraint("West", (Component)this.resetColorButton, 5, "East", (Component)this.customColorBox);
            layout.putConstraint("West", (Component)this.fontOptionsB, 5, "West", (Component)this.colorLabel);
            layout.putConstraint("East", (Component)this.dataEditB, -5, "East", (Component)this.zoneOptionsPanel);
            layout.putConstraint("West", (Component)this.titleLabel, 0, "West", (Component)this.colorLabel);
            layout.putConstraint("West", (Component)this.widthLabel, 0, "West", (Component)this.colorLabel);
            layout.putConstraint("West", (Component)this.showTitleCB, 0, "West", (Component)this.colorLabel);
            layout.putConstraint("West", (Component)this.showAgeLabelsCB, 0, "West", (Component)this.colorLabel);
            layout.putConstraint("East", (Component)this.titleTF, -5, "East", (Component)this.zoneOptionsPanel);
            layout.putConstraint("West", (Component)this.titleTF, 5, "East", (Component)this.titleLabel);
            layout.putConstraint("West", (Component)this.widthTF, 5, "East", (Component)this.widthLabel);
            layout.putConstraint("West", (Component)this.moveUp, 5, "West", (Component)this.colorLabel);
            layout.putConstraint("West", (Component)this.moveDown, 5, "East", (Component)this.moveUp);
            layout.putConstraint("East", (Component)this.colPanel, -5, "East", (Component)this.zoneOptionsPanel);
            layout.putConstraint("West", (Component)this.colPanel, 5, "West", (Component)this.zoneOptionsPanel);
            layout.putConstraint("East", (Component)this.belowColorSep, -5, "East", (Component)this.zoneOptionsPanel);
            layout.putConstraint("East", (Component)this.belowFontsSep, -5, "East", (Component)this.zoneOptionsPanel);
            layout.putConstraint("East", (Component)this.belowWidthSep, -5, "East", (Component)this.zoneOptionsPanel);
            layout.putConstraint("East", (Component)this.belowArrowsSep, -5, "East", (Component)this.zoneOptionsPanel);
            layout.putConstraint("West", (Component)this.belowColorSep, 5, "West", (Component)this.zoneOptionsPanel);
            layout.putConstraint("West", (Component)this.belowFontsSep, 5, "West", (Component)this.zoneOptionsPanel);
            layout.putConstraint("West", (Component)this.belowWidthSep, 5, "West", (Component)this.zoneOptionsPanel);
            layout.putConstraint("West", (Component)this.belowArrowsSep, 5, "West", (Component)this.zoneOptionsPanel);
            layout.putConstraint("North", (Component)this.variableColorRadio, 5, "South", (Component)this.colorLabel);
            layout.putConstraint("North", (Component)this.customRadio, 5, "South", (Component)this.variableColorRadio);
            layout.putConstraint("North", (Component)this.customColor, 0, "North", (Component)this.customRadio);
            layout.putConstraint("South", (Component)this.customColorBox, 0, "South", (Component)this.customColor);
            layout.putConstraint("North", (Component)this.customColorBox, 0, "North", (Component)this.customColor);
            layout.putConstraint("North", (Component)this.resetColorButton, 0, "North", (Component)this.customColor);
            layout.putConstraint("North", (Component)this.belowColorSep, 10, "South", (Component)this.customColor);
            layout.putConstraint("North", (Component)this.fontOptionsB, 10, "South", (Component)this.belowColorSep);
            layout.putConstraint("North", (Component)this.dataEditB, 0, "North", (Component)this.fontOptionsB);
            layout.putConstraint("North", (Component)this.belowFontsSep, 10, "South", (Component)this.fontOptionsB);
            layout.putConstraint("North", (Component)this.titleLabel, 10, "South", (Component)this.belowFontsSep);
            layout.putConstraint("North", (Component)this.titleTF, 0, "North", (Component)this.titleLabel);
            layout.putConstraint("North", (Component)this.showTitleCB, 5, "South", (Component)this.titleTF);
            layout.putConstraint("North", (Component)this.widthLabel, 5, "South", (Component)this.showTitleCB);
            layout.putConstraint("North", (Component)this.widthTF, 0, "North", (Component)this.widthLabel);
            layout.putConstraint("North", (Component)this.widthTF, 0, "North", (Component)this.widthLabel);
            layout.putConstraint("North", (Component)this.showAgeLabelsCB, 5, "South", (Component)this.widthTF);
            layout.putConstraint("North", (Component)this.belowWidthSep, 10, "South", (Component)this.showAgeLabelsCB);
            layout.putConstraint("North", (Component)this.moveUp, 10, "South", (Component)this.belowWidthSep);
            layout.putConstraint("North", (Component)this.moveDown, 0, "North", (Component)this.moveUp);
            layout.putConstraint("North", (Component)this.belowArrowsSep, 10, "South", (Component)this.moveDown);
            layout.putConstraint("South", (Component)this.colPanel, 0, "South", (Component)this.zoneOptionsPanel);
            layout.putConstraint("North", (Component)this.colPanel, 10, "South", (Component)this.belowArrowsSep);
            layout.putConstraint("West", (Component)this.zoneOptionsPanel, 5, "West", (Component)this.colorLabel);
            layout.putConstraint("East", (Component)this.zoneOptionsPanel, 250, "West", (Component)this.zoneOptionsPanel);
            this.updateZoneSelectRadios();
        }
        return this.zoneOptionsPanel;
    }

    private JRadioButton getUSGSRadio() {
        if (this.USGSRadio == null) {
            this.USGSRadio = new JRadioButton();
            URL imgURL = TSCreator.getURL("USGS.gif");
            this.USGSRadio.setText("<html><table cellpadding=0><tr><td><img src=\"" + imgURL.toString() + "\"></td><td width=5></td><td>USGS</td></tr></table></html>");
            this.USGSRadio.setSelected(true);
            this.USGSRadio.addItemListener(this);
        }
        return this.USGSRadio;
    }

    private JRadioButton getUNESCORadio() {
        if (this.UNESCORadio == null) {
            this.UNESCORadio = new JRadioButton();
            URL imgURL = TSCreator.getURL("UNESCO.gif");
            this.UNESCORadio.setText("<html><table cellpadding=0><tr><td><img src=\"" + imgURL.toString() + "\"></td><td width=5></td><td>World Geol. Map (Paris)</td></tr></table></html>");
            this.UNESCORadio.addItemListener(this);
        }
        return this.UNESCORadio;
    }

    private JRadioButton getVariableColorRadio() {
        if (this.variableColorRadio == null) {
            this.variableColorRadio = new JRadioButton();
            this.variableColorRadio.setText("Set to Chronostrat");
            this.variableColorRadio.addItemListener(this);
        }
        return this.variableColorRadio;
    }

    private JRadioButton getCustomRadio() {
        if (this.customRadio == null) {
            this.customRadio = new JRadioButton();
            this.customRadio.setText(SOLID_STROKE);
            this.customRadio.addItemListener(this);
        }
        return this.customRadio;
    }

    private JButton getColorResetButton() {
        if (this.resetColorButton == null) {
            this.resetColorButton = new JButton();
            this.resetColorButton.setText("Reset");
            this.resetColorButton.addActionListener(this);
        }
        return this.resetColorButton;
    }

    private JButton getCustomColor() {
        if (this.customColor == null) {
            this.customColor = new JButton();
            this.customColor.setText("Choose");
            this.customColor.addActionListener(this);
        }
        return this.customColor;
    }

    private JButton getFontOptionsB() {
        if (this.fontOptionsB == null) {
            this.fontOptionsB = new JButton();
            this.fontOptionsB.setText("Fonts");
            this.fontOptionsB.addActionListener(this);
        }
        return this.fontOptionsB;
    }

    private JButton getDataEditB() {
        if (this.dataEditB == null) {
            this.dataEditB = new JButton();
            this.dataEditB.setText("Raw Data");
            this.dataEditB.addActionListener(this);
            this.dataEditB.setEnabled(false);
        }
        return this.dataEditB;
    }

    private ModifyTextField getTitleTF() {
        if (this.titleTF == null) {
            this.titleTF = new ModifyTextField(true, true);
            this.titleTF.addActionListener(this);
        }
        return this.titleTF;
    }

    private ModifyTextField getWidthTF() {
        if (this.widthTF == null) {
            this.widthTF = new ModifyTextField(false, true);
            Dimension d = this.widthTF.getPreferredSize();
            d.width = 40;
            this.widthTF.setPreferredSize(d);
            this.widthTF.addActionListener(this);
        }
        return this.widthTF;
    }

    private JCheckBox getShowTitleCB() {
        if (this.showTitleCB == null) {
            this.showTitleCB = new JCheckBox("Show Title");
            this.showTitleCB.addActionListener(this);
        }
        return this.showTitleCB;
    }

    private JCheckBox getShowAgeLabelsCB() {
        if (this.showAgeLabelsCB == null) {
            this.showAgeLabelsCB = new JCheckBox("Show Age Labels");
            this.showAgeLabelsCB.addActionListener(this);
        }
        return this.showAgeLabelsCB;
    }

    private JButton getMoveUp() {
        if (this.moveUp == null) {
            this.moveUp = new JButton();
            ImageIcon icon = TSCreator.getImageIcon("arrow-up.gif");
            this.moveUp.setIcon(icon);
            this.moveUp.addActionListener(this);
        }
        return this.moveUp;
    }

    private JButton getMoveDown() {
        if (this.moveDown == null) {
            this.moveDown = new JButton();
            ImageIcon icon = TSCreator.getImageIcon("arrow-down.gif");
            this.moveDown.setIcon(icon);
            this.moveDown.addActionListener(this);
        }
        return this.moveDown;
    }

    private ModifyTextField getUnitsPerMaTF() {
        if (this.unitsPerMaTF == null) {
            this.unitsPerMaTF = new ModifyTextField(false, true);
            Dimension d = this.unitsPerMaTF.getPreferredSize();
            d.width = 40;
            this.unitsPerMaTF.setPreferredSize(d);
            this.unitsPerMaTF.setText(Settings.formatDouble(this.unitsPerMY / 30.0));
        }
        return this.unitsPerMaTF;
    }

    private JCheckBox getPopupCheck() {
        if (this.popupCheck == null) {
            this.popupCheck = new JCheckBox();
            this.popupCheck.setText("Add MouseOver info");
            this.popupCheck.setSelected(this.doPopups);
            this.popupCheck.addItemListener(this);
        }
        return this.popupCheck;
    }

    private JCheckBox getSkipEmptyColumnsCheck() {
        if (this.skipEmptyColumnsCheck == null) {
            this.skipEmptyColumnsCheck = new JCheckBox();
            this.skipEmptyColumnsCheck.setText("Gray out (and do not draw) columns which do not have data on the selected time interval");
            this.skipEmptyColumnsCheck.setSelected(this.skipEmptyColumns);
            this.skipEmptyColumnsCheck.addItemListener(this);
        }
        return this.skipEmptyColumnsCheck;
    }

    public void valueChanged(TreeSelectionEvent e) {
        DataColumn node;
        this.curSelectDC = node = (DataColumn)this.zoneTree.getLastSelectedPathComponent();
        this.updateZoneSelectRadios();
    }

    public void updateZoneSelectRadios() {
        if (this.curSelectDC == null) {
            this.colorLabel.setEnabled(false);
            this.variableColorRadio.setEnabled(false);
            this.resetColorButton.setEnabled(false);
            this.customRadio.setEnabled(false);
            this.customColor.setEnabled(false);
            this.customColorBox.setBackground(Color.WHITE);
            this.fontOptionsB.setEnabled(false);
            this.dataEditB.setEnabled(false);
            this.variableColorRadio.setSelected(false);
            this.customRadio.setSelected(true);
            this.titleLabel.setEnabled(false);
            this.titleTF.setEnabled(false);
            this.titleTF.setText(SOLID_STROKE);
            this.showTitleCB.setEnabled(false);
            this.showAgeLabelsCB.setEnabled(false);
            this.widthLabel.setEnabled(false);
            this.widthTF.setEnabled(false);
            this.widthTF.setText(SOLID_STROKE);
            this.colOptionsPanel.removeAll();
            this.colOptionsPanel.repaint();
            this.setColInfoText(null);
            this.colPanel.doLayout();
            this.colPanel.validate();
            this.colPanel.repaint();
        } else if (this.curSelectDC instanceof MetaColumn) {
            this.colorLabel.setEnabled(true);
            this.variableColorRadio.setEnabled(false);
            this.resetColorButton.setEnabled(false);
            this.customRadio.setEnabled(false);
            this.customColor.setEnabled(false);
            this.customColorBox.setBackground(Color.WHITE);
            this.fontOptionsB.setEnabled(true);
            this.dataEditB.setEnabled(false);
            this.variableColorRadio.setSelected(false);
            this.customRadio.setSelected(true);
            this.titleLabel.setEnabled(true);
            this.titleTF.setEnabled(true);
            this.titleTF.setText(this.curSelectDC.name);
            this.showTitleCB.setEnabled(true);
            this.showTitleCB.setSelected(this.curSelectDC.drawTitle);
            this.showAgeLabelsCB.setEnabled(false);
            this.widthLabel.setEnabled(false);
            this.widthTF.setEnabled(false);
            this.widthTF.setText(SOLID_STROKE);
            this.colOptionsPanel.removeAll();
            this.colOptionsPanel.add(this.curSelectDC.getOptionsPanel(this));
            this.colOptionsPanel.validate();
            this.colOptionsPanel.repaint();
            this.setColInfoText(this.curSelectDC.popup);
            this.colPanel.doLayout();
            this.colPanel.validate();
            this.colPanel.repaint();
        } else {
            this.colorLabel.setEnabled(true);
            this.variableColorRadio.setEnabled(true);
            this.resetColorButton.setEnabled(true);
            this.customRadio.setEnabled(true);
            this.customColor.setEnabled(true);
            this.customColorBox.setBackground(this.curSelectDC.guiColor.oneColor);
            this.fontOptionsB.setEnabled(true);
            this.dataEditB.setEnabled(false);
            if (this.curSelectDC.color == Coloring.USGS || this.curSelectDC.color == Coloring.NAMED_USGS || this.curSelectDC.color == Coloring.UNESCO || this.curSelectDC.color == Coloring.NAMED_UNESCO || this.curSelectDC.color == this.variableColoring || this.curSelectDC.color == this.variableNamedColoring) {
                this.variableColorRadio.setSelected(true);
            } else if (this.curSelectDC.color == null) {
                this.variableColorRadio.setSelected(false);
                this.customRadio.setSelected(false);
            } else {
                this.customRadio.setSelected(true);
                this.curSelectDC.guiColor = this.curSelectDC.color;
                this.customColorBox.setBackground(this.curSelectDC.guiColor.oneColor);
            }
            this.titleLabel.setEnabled(true);
            this.titleTF.setEnabled(true);
            this.titleTF.setText(this.curSelectDC.name);
            this.showTitleCB.setEnabled(true);
            this.showTitleCB.setSelected(this.curSelectDC.drawTitle);
            if (this.curSelectDC instanceof PointColumn || this.curSelectDC instanceof AgeAgeColumn || this.curSelectDC instanceof FreehandColumn) {
                this.showAgeLabelsCB.setEnabled(false);
            } else {
                this.showAgeLabelsCB.setEnabled(true);
                this.showAgeLabelsCB.setSelected(this.curSelectDC.drawAgeLabel);
            }
            this.widthLabel.setEnabled(true);
            this.widthTF.setEnabled(true);
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setGroupingUsed(false);
            nf.setMinimumFractionDigits(0);
            if (this.curSelectDC instanceof RulerColumn || this.curSelectDC instanceof AgeAgeColumn) {
                this.widthTF.setText("auto");
                this.widthTF.setEnabled(false);
            } else {
                this.widthTF.setText(nf.format(this.curSelectDC.getMyWidth()));
            }
            this.colOptionsPanel.removeAll();
            this.colOptionsPanel.add(this.curSelectDC.getOptionsPanel(this));
            this.colOptionsPanel.validate();
            this.colOptionsPanel.repaint();
            this.setColInfoText(this.curSelectDC.popup);
            this.colPanel.doLayout();
            this.colPanel.validate();
            this.colPanel.repaint();
        }
    }

    protected void setColInfoText(String t) {
        if (t != null) {
            this.colInfoLabel.setText("<html>" + t + "</html>");
        } else {
            this.colInfoLabel.setText(SOLID_STROKE);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Object source = e.getSource();
        if (source == this.okButton) {
            this.setVisible(false);
        } else if (source == this.generateButton) {
            this.setVisible(false);
            if (this.generateAction != null) {
                this.generateAction.actionPerformed(null);
            }
        } else if (source == this.saveButton) {
            JFileChooser chooser = new JFileChooser();
            ExtensionFileFilter eff = new ExtensionFileFilter();
            eff.setDescription("TSCreator settings file (*.tsc)");
            eff.addExtension("tsc", true);
            chooser.setFileFilter(eff);
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                try {
                    this.setupWrite(TSCreator.appendExtension(chooser.getSelectedFile().getAbsolutePath(), "tsc"));
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, String.valueOf(ex.toString()) + "\n" + ex.getStackTrace().toString());
                }
            }
        } else if (source == this.loadButton) {
            JFileChooser chooser = new JFileChooser();
            ExtensionFileFilter eff = new ExtensionFileFilter();
            eff.setDescription("TSCreator settings file (*.tsc)");
            eff.addExtension("tsc", true);
            chooser.setFileFilter(eff);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                try {
                    this.setupRead(TSCreator.appendExtension(chooser.getSelectedFile().getAbsolutePath(), "tsc"));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(this, String.valueOf(ex.toString()) + "\n" + ex.getStackTrace().toString());
                }
            }
        } else if (source == this.topMY) {
            this.isValid();
        } else if (source == this.baseMY) {
            this.isValid();
        } else if (source == this.customColor) {
            Color chosenColor;
            Color initColor = Color.white;
            if (this.curSelectDC != null) {
                initColor = this.curSelectDC.guiColor.oneColor;
            }
            if ((chosenColor = JColorChooser.showDialog(this, "Choose Column's Background Color", initColor)) != null) {
                this.curSelectDC.guiColor = new Coloring(chosenColor);
                this.customColorBox.setBackground(chosenColor);
                this.curSelectDC.color = this.curSelectDC.guiColor;
                this.customRadio.setSelected(true);
            }
        } else if (source == this.resetColorButton) {
            this.curSelectDC.color = this.curSelectDC.defaultColor;
            if (this.curSelectDC.color != null && this.curSelectDC.color.oneColor != null) {
                this.curSelectDC.guiColor = this.curSelectDC.color;
            }
            this.updateZoneSelectRadios();
        } else if (source == this.fontOptionsB) {
            if (this.curSelectDC.getParent() == null) {
                this.tabbedPane.setSelectedComponent(this.fontTabPanel);
            } else {
                JOptionPane.showOptionDialog(this, this.curSelectDC.getFontOptionsPanel(), "Set Column Font", 0, -1, null, new String[]{"Close"}, null);
            }
        } else if (source == this.dataEditB) {
            if (this.curSelectDC != null && !(this.curSelectDC instanceof MetaColumn)) {
                ColumnDataEditor editor = new ColumnDataEditor(this.curSelectDC);
                editor.setVisible(true);
            }
        } else if (source == this.titleTF) {
            if (this.titleTF.isEnabled()) {
                String nt = this.titleTF.getText();
                if (this.curSelectDC != null) {
                    this.curSelectDC.setName(nt);
                    this.nodeChanged(this.curSelectDC);
                }
            }
        } else if (source == this.showTitleCB) {
            if (this.curSelectDC != null) {
                this.curSelectDC.drawTitle = this.showTitleCB.isSelected();
            }
        } else if (source == this.showAgeLabelsCB) {
            if (this.curSelectDC != null) {
                this.curSelectDC.drawAgeLabel = this.showAgeLabelsCB.isSelected();
            }
        } else if (source == this.widthTF) {
            if (this.widthTF.isEnabled()) {
                double dw;
                String sw = this.widthTF.getText();
                try {
                    dw = Double.parseDouble(sw);
                }
                catch (NumberFormatException nfe) {
                    dw = 0.0;
                }
                if (this.curSelectDC != null) {
                    if (dw < this.curSelectDC.MIN_COL_WIDTH) {
                        dw = this.curSelectDC.MIN_COL_WIDTH;
                    }
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    nf.setGroupingUsed(false);
                    nf.setMinimumFractionDigits(0);
                    sw = nf.format(dw);
                    this.curSelectDC.setWidth(dw);
                    this.widthTF.setText(sw);
                } else {
                    this.widthTF.setText(SOLID_STROKE);
                }
            }
        } else if (source == this.moveUp) {
            MetaColumn p;
            if (this.curSelectDC != null && (p = this.curSelectDC.getColParent()) != null) {
                TreePath selPath = this.zoneTree.getSelectionPath();
                p.moveColumn(this.curSelectDC, -1);
                this.nodeStructureChanged(p);
                this.zoneTree.setSelectionPath(selPath);
            }
        } else if (source == this.moveDown) {
            MetaColumn p;
            if (this.curSelectDC != null && (p = this.curSelectDC.getColParent()) != null) {
                TreePath selPath = this.zoneTree.getSelectionPath();
                p.moveColumn(this.curSelectDC, 1);
                this.nodeStructureChanged(p);
                this.zoneTree.setSelectionPath(selPath);
            }
        } else if (source == this.unitsPerMaTF) {
            double d;
            String s = this.unitsPerMaTF.getText();
            try {
                d = Double.parseDouble(s);
            }
            catch (NumberFormatException nfe) {
                d = 1.0;
            }
            if (d < 0.001) {
                d = 0.001;
            }
            this.unitsPerMaTF.setText(Settings.formatDouble(d));
            this.unitsPerMY = d * 30.0;
        } else {
            System.out.println("actionPerformed: " + command);
        }
    }

    public void nodeChanged(DataColumn dc) {
        ((DefaultTreeModel)this.zoneTree.getModel()).nodeChanged(dc);
    }

    public void nodeStructureChanged(DataColumn dc) {
        ((DefaultTreeModel)this.zoneTree.getModel()).nodeStructureChanged(dc);
    }

    public void itemStateChanged(ItemEvent e) {
        boolean forceValidate = false;
        Object item = e.getItem();
        if (item == this.USGSRadio) {
            this.variableNamedColoring.set(Coloring.NAMED_USGS);
            this.variableColoring.set(Coloring.USGS);
        } else if (item == this.UNESCORadio) {
            this.variableNamedColoring.set(Coloring.NAMED_UNESCO);
            this.variableColoring.set(Coloring.UNESCO);
        } else if (item == this.variableColorRadio) {
            if (this.curSelectDC == null) {
                return;
            }
            this.curSelectDC.color = this.curSelectDC.useNamedColor ? this.variableNamedColoring : this.variableColoring;
        } else if (item == this.customRadio) {
            if (this.curSelectDC == null) {
                return;
            }
            this.curSelectDC.color = this.curSelectDC.guiColor;
        } else if (item == this.popupCheck) {
            this.doPopups = this.popupCheck.isSelected();
        } else if (item == this.skipEmptyColumnsCheck) {
            this.skipEmptyColumns = this.skipEmptyColumnsCheck.isSelected();
            this.grayOutEmptyColumns();
        }
        if (this.errorLabel.getText().length() > 0 || forceValidate) {
            this.isValid();
        }
    }

    public void setErrorString(String e, int severity) {
        switch (severity) {
            case 3: {
                this.errorLabel.setForeground(new Color(0, 128, 0));
                break;
            }
            case 2: {
                this.errorLabel.setForeground(new Color(128, 128, 0));
                break;
            }
            default: {
                this.errorLabel.setForeground(new Color(128, 0, 0));
            }
        }
        this.errorLabel.setText(e);
    }

    public void grayOutEmptyColumns() {
        if (this.ignoreGrayOut) {
            return;
        }
        this.ignoreGrayOut = true;
        this.ds.rootColumn.grayOutIfEmpty(this.topAge, this.baseAge, this.skipEmptyColumns);
        this.nodeStructureChanged(this.ds.rootColumn);
        this.ignoreGrayOut = false;
    }

    public boolean isValid() {
        String s;
        Datapoint p;
        this.isValid = true;
        double oldTopAge = this.topAge;
        double oldBaseAge = this.baseAge;
        if (this.topStageRadio.isSelected()) {
            p = (Datapoint)this.topStage.getSelectedItem();
            if (p == null) {
                this.isValid = false;
                this.setErrorString("Unable to get top age from combo box.", 1);
                return false;
            }
            this.topAge = p.baseAge;
        } else if (this.topMYRadio.isSelected()) {
            s = this.topMY.getText();
            try {
                this.topAge = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                this.isValid = false;
                if (s.length() == 0) {
                    this.setErrorString("Top age not specified.", 1);
                } else {
                    this.setErrorString("Top age is invalid.", 1);
                }
                return false;
            }
            if (!this.topMY.hasFocus()) {
                this.topMY.setText(new Double(this.topAge).toString());
            }
        } else {
            this.isValid = false;
            this.setErrorString("Top age not specified.", 1);
            return false;
        }
        if (this.baseStageRadio.isSelected()) {
            p = (Datapoint)this.baseStage.getSelectedItem();
            if (p == null) {
                this.isValid = false;
                this.setErrorString("Unable to get base age from combo box.", 1);
                return false;
            }
            this.baseAge = p.baseAge;
        } else if (this.baseMYRadio.isSelected()) {
            s = this.baseMY.getText();
            try {
                this.baseAge = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                this.isValid = false;
                if (s.length() == 0) {
                    this.setErrorString("Base age not specified.", 1);
                } else {
                    this.setErrorString("Base age is invalid.", 1);
                }
                return false;
            }
            if (!this.baseMY.hasFocus()) {
                this.baseMY.setText(new Double(this.baseAge).toString());
            }
        } else {
            this.isValid = false;
            this.setErrorString("Base age not specified.", 1);
            return false;
        }
        if (this.topAge >= this.baseAge) {
            this.isValid = false;
            this.setErrorString("Base age must be older than top age!", 1);
            return false;
        }
        if (oldTopAge != this.topAge || oldBaseAge != this.baseAge) {
            this.grayOutEmptyColumns();
        }
        this.setErrorString("Ready to generate!", 3);
        return this.isValid;
    }

    public int getPopupViewportHeight() {
        return this.popupHeight - 2 * this.popupScrollButtonHeight - 4 * this.popupMargin;
    }

    public int getPopupViewportWidth() {
        return this.popupWidth - 2 * this.popupMargin;
    }

    protected void setupRead(String filePath) {
        DOMParser parser = new DOMParser();
        try {
            parser.parse(filePath);
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        Document document = parser.getDocument();
        Element root = document.getDocumentElement();
        this.ds.rootColumn.setLoaded(false);
        NodeList nl = root.getChildNodes();
        int nodeIndex = 0;
        while (nodeIndex < nl.getLength()) {
            Node node = nl.item(nodeIndex);
            if (node.getNodeType() == 1) {
                String name = node.getNodeName();
                if (name.compareToIgnoreCase("settings") == 0) {
                    this.readSettings((Element)node);
                } else if (name.compareToIgnoreCase("fonts") == 0) {
                    this.fonts.readSettings((Element)node);
                } else if (name.compareToIgnoreCase("column") == 0) {
                    this.ds.rootColumn.readSettings((Element)node, this);
                }
            }
            ++nodeIndex;
        }
        this.fontTabPanel.removeAll();
        this.fontPanel = null;
        this.fontTabPanel.add(this.getFontPanel());
        this.zoneTree.setSelectionPath(null);
    }

    protected void setupWrite(String filePath) throws IOException {
        DocumentImpl docImpl = new DocumentImpl();
        DOMImplementation impl = docImpl.getImplementation();
        Document doc = impl.createDocument(SOLID_STROKE, "TSCreator", null);
        Element root = doc.getDocumentElement();
        root.setAttribute("version", "3.0");
        Element settingsE = doc.createElement("settings");
        settingsE.setAttribute("version", "1.0");
        this.writeSettings(settingsE, doc);
        root.appendChild(settingsE);
        Element fontsE = doc.createElement("fonts");
        this.fonts.writeSettings(fontsE, doc);
        root.appendChild(fontsE);
        Element rootColE = doc.createElement("column");
        this.ds.rootColumn.writeSettings(rootColE, doc);
        root.appendChild(rootColE);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8");
        OutputFormat outFormat = new OutputFormat();
        outFormat.setIndenting(true);
        XMLSerializer serializer = new XMLSerializer(writer, outFormat);
        serializer.serialize(doc);
        writer.close();
    }

    public void readSettings(Element element) {
        NodeList nl = element.getChildNodes();
        int elementIndex = 0;
        while (elementIndex < nl.getLength()) {
            block47: {
                Element setting;
                Node node = nl.item(elementIndex);
                if (node.getNodeType() == 1 && (setting = (Element)node).getTagName().compareToIgnoreCase("setting") == 0) {
                    try {
                        int i;
                        String stage;
                        String subName;
                        Element sub;
                        Node subNode;
                        int subIndex;
                        NodeList subNL;
                        String source;
                        String name = setting.getAttribute("name");
                        if (name == null) break block47;
                        if (name.compareToIgnoreCase("topAge") == 0) {
                            source = setting.getAttribute("source");
                            if ("stage".compareToIgnoreCase(source) == 0) {
                                this.topStageRadio.setSelected(true);
                            } else {
                                this.topMYRadio.setSelected(true);
                            }
                            subNL = setting.getChildNodes();
                            subIndex = 0;
                            while (subIndex < subNL.getLength()) {
                                subNode = subNL.item(subIndex);
                                if (subNode.getNodeType() == 1 && (sub = (Element)subNode).getTagName().compareToIgnoreCase("setting") == 0) {
                                    subName = sub.getAttribute("name");
                                    if (sub.getTagName().compareToIgnoreCase("setting") == 0 && subName != null) {
                                        if (subName.compareToIgnoreCase("stage") == 0) {
                                            stage = Settings.getNodeTextContent(sub);
                                            i = 0;
                                            while (i < this.topStage.getItemCount()) {
                                                if (this.topStage.getItemAt(i).toString().compareToIgnoreCase(stage) == 0) {
                                                    this.topStage.setSelectedIndex(i);
                                                    break;
                                                }
                                                ++i;
                                            }
                                        } else if (subName.compareToIgnoreCase("text") == 0) {
                                            this.topMY.setText(Settings.getNodeTextContent(sub));
                                        }
                                    }
                                }
                                ++subIndex;
                            }
                            break block47;
                        }
                        if (name.compareToIgnoreCase("baseAge") == 0) {
                            source = setting.getAttribute("source");
                            if ("stage".compareToIgnoreCase(source) == 0) {
                                this.baseStageRadio.setSelected(true);
                            } else {
                                this.baseMYRadio.setSelected(true);
                            }
                            subNL = setting.getChildNodes();
                            subIndex = 0;
                            while (subIndex < subNL.getLength()) {
                                subNode = subNL.item(subIndex);
                                if (subNode.getNodeType() == 1 && (sub = (Element)subNode).getTagName().compareToIgnoreCase("setting") == 0 && (subName = sub.getAttribute("name")) != null) {
                                    if (subName.compareToIgnoreCase("stage") == 0) {
                                        stage = Settings.getNodeTextContent(sub);
                                        i = 0;
                                        while (i < this.baseStage.getItemCount()) {
                                            if (this.baseStage.getItemAt(i).toString().compareToIgnoreCase(stage) == 0) {
                                                this.baseStage.setSelectedIndex(i);
                                                break;
                                            }
                                            ++i;
                                        }
                                    } else if (subName.compareToIgnoreCase("text") == 0) {
                                        this.baseMY.setText(Settings.getNodeTextContent(sub));
                                    }
                                }
                                ++subIndex;
                            }
                            break block47;
                        }
                        if (name.compareToIgnoreCase("variableColors") == 0) {
                            if (Settings.getNodeTextContent(setting).compareToIgnoreCase("UNESCO") == 0) {
                                this.UNESCORadio.setSelected(true);
                            } else {
                                this.USGSRadio.setSelected(true);
                            }
                        } else if (name.compareToIgnoreCase("unitsPerMY") == 0) {
                            this.unitsPerMY = Double.parseDouble(Settings.getNodeTextContent(setting));
                            this.unitsPerMaTF.setText(SOLID_STROKE + this.unitsPerMY / 30.0);
                        } else if (name.compareToIgnoreCase("doPopups") == 0) {
                            this.doPopups = Boolean.valueOf(Settings.getNodeTextContent(setting));
                            this.popupCheck.setSelected(this.doPopups);
                        } else if (name.compareToIgnoreCase("skipEmptyColumns") == 0) {
                            this.skipEmptyColumns = Boolean.valueOf(Settings.getNodeTextContent(setting));
                            this.skipEmptyColumnsCheck.setSelected(this.skipEmptyColumns);
                        } else if (name.compareToIgnoreCase("popupWidth") == 0) {
                            this.popupWidth = Integer.parseInt(Settings.getNodeTextContent(setting));
                        } else if (name.compareToIgnoreCase("popupHeight") == 0) {
                            this.popupHeight = Integer.parseInt(Settings.getNodeTextContent(setting));
                        } else if (name.compareToIgnoreCase("popupScrollButtonHeight") == 0) {
                            this.popupScrollButtonHeight = Integer.parseInt(Settings.getNodeTextContent(setting));
                        } else if (name.compareToIgnoreCase("popupMargin") == 0) {
                            this.popupMargin = Integer.parseInt(Settings.getNodeTextContent(setting));
                        } else if (name.compareToIgnoreCase("popupMinWidth") == 0) {
                            this.popupMinWidth = Integer.parseInt(Settings.getNodeTextContent(setting));
                        } else if (name.compareToIgnoreCase("popupMinHeight") == 0) {
                            this.popupMinHeight = Integer.parseInt(Settings.getNodeTextContent(setting));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
            ++elementIndex;
        }
    }

    public void writeSettings(Element element, Document doc) {
        Element stage;
        Element setting = doc.createElement("setting");
        setting.setAttribute("name", "topAge");
        if (this.topStage.isEnabled()) {
            stage = doc.createElement("setting");
            stage.setAttribute("name", "stage");
            Settings.setNodeTextContent(stage, this.topStage.getSelectedItem().toString(), doc);
            setting.appendChild(stage);
        }
        if (this.topStageRadio.isSelected()) {
            setting.setAttribute("source", "stage");
        } else {
            setting.setAttribute("source", "text");
        }
        Element text = doc.createElement("setting");
        text.setAttribute("name", "text");
        Settings.setNodeTextContent(text, this.topMY.getText(), doc);
        setting.appendChild(text);
        element.appendChild(setting);
        setting = doc.createElement("setting");
        setting.setAttribute("name", "baseAge");
        if (this.baseStage.isEnabled()) {
            stage = doc.createElement("setting");
            stage.setAttribute("name", "stage");
            Settings.setNodeTextContent(stage, this.baseStage.getSelectedItem().toString(), doc);
            setting.appendChild(stage);
        }
        if (this.baseStageRadio.isSelected()) {
            setting.setAttribute("source", "stage");
        } else {
            setting.setAttribute("source", "text");
        }
        text = doc.createElement("setting");
        text.setAttribute("name", "text");
        Settings.setNodeTextContent(text, this.baseMY.getText(), doc);
        setting.appendChild(text);
        element.appendChild(setting);
        String varCol = "USGS";
        if (this.UNESCORadio.isSelected()) {
            varCol = "UNESCO";
        }
        element.appendChild(Settings.createSimpleSetting(doc, "variableColors", varCol));
        element.appendChild(Settings.createSimpleSetting(doc, "unitsPerMY", SOLID_STROKE + this.unitsPerMY));
        element.appendChild(Settings.createSimpleSetting(doc, "skipEmptyColumns", SOLID_STROKE + this.skipEmptyColumns));
        element.appendChild(Settings.createSimpleSetting(doc, "doPopups", SOLID_STROKE + this.doPopups));
        element.appendChild(Settings.createSimpleSetting(doc, "popupWidth", SOLID_STROKE + this.popupWidth));
        element.appendChild(Settings.createSimpleSetting(doc, "popupHeight", SOLID_STROKE + this.popupHeight));
        element.appendChild(Settings.createSimpleSetting(doc, "popupScrollButtonHeight", SOLID_STROKE + this.popupScrollButtonHeight));
        element.appendChild(Settings.createSimpleSetting(doc, "popupMargin", SOLID_STROKE + this.popupMargin));
        element.appendChild(Settings.createSimpleSetting(doc, "popupMinWidth", SOLID_STROKE + this.popupMinWidth));
        element.appendChild(Settings.createSimpleSetting(doc, "popupMinHeight", SOLID_STROKE + this.popupMinHeight));
    }

    public static Element createSimpleSetting(Document doc, String name, String value) {
        Element e = doc.createElement("setting");
        e.setAttribute("name", name);
        Settings.setNodeTextContent(e, value, doc);
        return e;
    }

    public static void setNodeTextContent(Node n, String s, Document doc) {
        Node sub = n.getFirstChild();
        while (sub != null) {
            switch (sub.getNodeType()) {
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    Node temp = sub.getNextSibling();
                    n.removeChild(sub);
                    sub = temp;
                    break;
                }
                default: {
                    sub = sub.getNextSibling();
                }
            }
        }
        n.appendChild(doc.createTextNode(s));
    }

    public static String getNodeTextContent(Node n) {
        String ret = SOLID_STROKE;
        switch (n.getNodeType()) {
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return n.getNodeValue();
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                Node sub = n.getFirstChild();
                while (sub != null) {
                    ret = String.valueOf(ret) + Settings.getNodeTextContent(sub);
                    sub = sub.getNextSibling();
                }
                return ret;
            }
        }
        return null;
    }

    public void dataAdded() {
        this.grayOutEmptyColumns();
        if (this.noData) {
            if (this.ds.defaultColorScheme == Coloring.UNESCO || this.ds.defaultColorScheme == Coloring.NAMED_UNESCO) {
                this.UNESCORadio.setSelected(true);
            }
            this.noData = false;
        }
    }
}

