/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.SpreadSheetTableModel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class SpreadSheet
extends JTable {
    JScrollPane sp;
    SpreadSheetTableModel dm;
    public ActionListener rowInsertRemoveListener = new ActionListener(){

        public void actionPerformed(ActionEvent ae) {
            int[] selRows;
            String error;
            SpreadSheet table = SpreadSheet.this;
            if (ae.getActionCommand().startsWith("Insert")) {
                String error2 = SpreadSheet.this.dm.addRows(table.getSelectedRowCount(), table.getSelectedRows()[0]);
                if (error2 != null) {
                    JOptionPane.showMessageDialog(table, "<html>" + error2 + "</html>", "Error inserting rows", 0);
                }
            } else if (ae.getActionCommand().startsWith("Remove") && table.getSelectedRowCount() > 0 && (error = SpreadSheet.this.dm.removeRows(selRows = table.getSelectedRows())) != null) {
                JOptionPane.showMessageDialog(table, "<html>" + error + "</html>", "Error removing rows", 0);
            }
        }
    };

    public SpreadSheet(SpreadSheetTableModel dataModel) {
        this.sp = new JScrollPane(this);
        this.dm = dataModel;
        this.setModel(this.dm);
        this.setCellSelectionEnabled(true);
        this.autoResizeMode = 0;
        this.configureEnclosingScrollPane();
    }

    public void setDataModel(SpreadSheetTableModel dataModel) {
        this.dm = dataModel;
        this.setModel(this.dm);
    }

    public JScrollPane getScrollPane() {
        return this.sp;
    }

    public void changeSelection(int row, int col, boolean toggle, boolean extend) {
        super.changeSelection(row, col, false, extend);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer rend = this.dm.getTableCellRenderer(row, column);
        if (rend == null) {
            return super.getCellRenderer(row, column);
        }
        return rend;
    }

    public void enableRowInsertRemove() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                int col;
                SpreadSheet table = SpreadSheet.this;
                int row = table.rowAtPoint(new Point(evt.getX(), evt.getY()));
                if (!table.isCellSelected(row, col = table.columnAtPoint(new Point(evt.getX(), evt.getY())))) {
                    table.clearSelection();
                    table.changeSelection(row, col, false, false);
                }
                if (evt.isPopupTrigger()) {
                    JPopupMenu menu = new JPopupMenu();
                    int selRowCount = table.getSelectedRowCount();
                    JMenuItem item = new JMenuItem("Insert " + selRowCount + (selRowCount == 1 ? " row" : " rows") + " here");
                    item.addActionListener(table.rowInsertRemoveListener);
                    menu.add(item);
                    item = new JMenuItem("Remove selected " + (selRowCount == 1 ? "row" : "rows"));
                    item.addActionListener(table.rowInsertRemoveListener);
                    menu.add(item);
                    menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
    }
}

