/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.JSVGScrollPane;

public class TSCSVGScrollPane
extends JSVGScrollPane {
    public TSCSVGScrollPane(JSVGCanvas c) {
        super(c);
        this.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                TSCSVGScrollPane.this.recenter();
            }

            public void componentHidden(ComponentEvent arg0) {
            }

            public void componentMoved(ComponentEvent arg0) {
            }

            public void componentShown(ComponentEvent arg0) {
            }
        });
    }

    public void zoomBy(double factor) {
        JSVGCanvas.ZoomAction a = new JSVGCanvas.ZoomAction(this.canvas, factor);
        a.actionPerformed(null);
        if (factor < 1.0) {
            this.recenter();
        }
    }

    public void resetTransform() {
        AffineTransform at = this.canvas.getViewingTransform();
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        this.canvas.setRenderingTransform(at);
    }

    public void zoomToFit() {
        this.resetTransform();
        Dimension canvasDim = this.getSize();
        Dimension docSize = this.getImageBounds().getSize();
        double sx = (double)canvasDim.width / ((Dimension2D)docSize).getWidth();
        double sy = (double)canvasDim.height / ((Dimension2D)docSize).getHeight();
        double scale = Math.min(sx, sy);
        this.zoomBy(scale);
        if (scale >= 1.0) {
            this.recenter();
        }
    }

    protected Rectangle getImageBounds() {
        this.checkAndSetViewBoxRect();
        if (this.viewBox == null) {
            return this.getBounds();
        }
        AffineTransform crt = this.canvas.getRenderingTransform();
        AffineTransform vbt = this.canvas.getViewBoxTransform();
        if (crt == null) {
            crt = new AffineTransform();
        }
        if (vbt == null) {
            vbt = new AffineTransform();
        }
        return vbt.createTransformedShape(this.viewBox).getBounds();
    }

    public void recenter() {
        int shouldBe;
        Rectangle img = this.getImageBounds();
        Dimension canvasDim = this.canvas.getSize();
        double translateX = 0.0;
        double translateY = 0.0;
        if (img.width < canvasDim.width) {
            shouldBe = (canvasDim.width - img.width) / 2;
            translateX = shouldBe - img.x;
        } else if (img.x > 0) {
            translateX = -img.x;
        } else if (img.x + img.width < canvasDim.width) {
            translateX = canvasDim.width - img.x - img.width;
        }
        if (img.height < canvasDim.height) {
            shouldBe = (canvasDim.height - img.height) / 2;
            translateY = shouldBe - img.y;
        } else if (img.y > 0) {
            translateY = -img.y;
        } else if (img.y + img.height < canvasDim.height) {
            translateY = canvasDim.height - img.y - img.height;
        }
        AffineTransform at = this.canvas.getRenderingTransform();
        at.preConcatenate(AffineTransform.getTranslateInstance(translateX, translateY));
        this.canvas.setRenderingTransform(at);
    }
}

