/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datastore.Coloring;
import datastore.DatafileCrypto;
import datastore.Datastore;
import datastore.ParseException;
import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.BrowserLauncherRunner;
import edu.stanford.ejalbert.exceptionhandler.BrowserLauncherDefaultErrorHandler;
import gui.DecryptionOptions;
import gui.EncryptionOptions;
import gui.ExtensionFileFilter;
import gui.HTMLViewerDialog;
import gui.ImageGenerator;
import gui.Settings;
import gui.TSCLinkActivationListener;
import gui.TSCSVGCanvas;
import gui.TSCSVGScrollPane;
import gui.WorkerThread;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.transcoder.TranscoderException;
import org.w3c.dom.svg.SVGDocument;

public class TSCreator {
    public static final int DEBUGLEVEL = 1;
    public static final String DEFAULT_DATA_FILE = "default_data.txt";
    public static final String DEFAULT_COLORING_FILE = "coloring.xml";
    public static final int NORMAL = 1;
    public static final int SUCCESS = 2;
    public static final int ERROR = 3;
    public static final int WARNING = 4;
    public static final int GENERATING = 1;
    public static final int LOADING = 2;
    public static final int SAVING = 3;
    public static final String versionString = "3.0";
    public static TSCreator curCreator = null;
    public Datastore db;
    JFrame tscFrame;
    JPanel displayPanel;
    JPanel topPanel;
    JLabel info;
    TSCAction loadReplaceWithBuiltInAction = new TSCAction(this, "Replace Data with Built-In", null, "Load data that came with the program while clearing everything currently loaded.");
    TSCAction clearAction = new TSCAction(this, "Clear", null, "Clear the currently loaded data.");
    TSCAction saveSVGAction = new TSCAction(this, "Save SVG", null, "Save the generated image to an SVG file.");
    TSCAction savePDFAction = new TSCAction(this, "Save PDF", null, "Save the generated image to a PDF file.");
    TSCAction encryptDataAction = new TSCAction(this, "Protect a datafile", null, "Password protect a datafile.");
    TSCAction exitAction = new TSCAction(this, "Exit", null, "Exit");
    TSCAction loadDefaultColoringAction = new TSCAction(this, "Load Default Colorings", null, "Load the default USGS and UNESCO color schemes.");
    TSCAction settingsAction = new TSCAction(this, "Settings...", null, "Show the settings dialog box.");
    TSCAction generateAction = new TSCAction(this, "Generate Chart", null, "Generate the image based on the current settings.");
    TSCAction zoomInAction = new TSCAction(this, "Zoom In", "icons/zoomin.gif", "Zoom in on the image.");
    TSCAction zoomOutAction = new TSCAction(this, "Zoom Out", "icons/zoomout.gif", "Zoom out of the image.");
    TSCAction actualSizeAction = new TSCAction(this, "Actual Size", null, "Set the zoom to 100%.");
    TSCAction fitToWindowAction = new TSCAction(this, "Fit to Window", null, "Zoom the image such that the vertical dimension just fits in the viewing window.");
    TSCAction quickstartAction = new TSCAction(this, "Quick Start Guide", null, "A short guide for getting something to show up.");
    TSCAction tourAction = new TSCAction(this, "Tour", null, "A somewhat longer guide for getting something to show up.");
    TSCAction featureInfoAction = new TSCAction(this, "Features reference", null, "An in-depth look at the options of the program.");
    TSCAction licenseAction = new TSCAction(this, "License", null, "License for using this software.");
    TSCAction fileFormatInfoAction = new TSCAction(this, "File Format info", null, "Information about how the file format for the data file is set up.");
    TSCAction aboutAction = new TSCAction(this, "About", null, "Version info and copyright.");
    JToolBar toolBar;
    JPanel mainView;
    JEditorPane htmlView;
    CardLayout mainViewLayout;
    Settings settings;
    TSCSVGCanvas displayCanvas;
    TSCSVGScrollPane displayCanvasPane;
    SVGDocument svgImage;
    ImageGenerator ig = null;
    static /* synthetic */ Class class$0;

    public TSCreator() {
        curCreator = this;
        this.generateAction.useThread(this);
        this.loadReplaceWithBuiltInAction.useThread(this);
        this.saveSVGAction.useThread(this);
        this.savePDFAction.useThread(this);
        this.tscFrame = new JFrame("Time Scale Creator");
        this.tscFrame.setDefaultCloseOperation(3);
        this.tscFrame.setSize(720, 630);
        this.displayPanel = new JPanel();
        this.topPanel = new JPanel(new FlowLayout(0));
        this.addWidgets();
        this.addMenu();
        this.tscFrame.getContentPane().add((Component)this.topPanel, "North");
        this.mainViewLayout = new CardLayout();
        this.mainView = new JPanel(this.mainViewLayout);
        this.displayCanvas = new TSCSVGCanvas();
        this.displayCanvasPane = new TSCSVGScrollPane(this.displayCanvas);
        this.mainView.add((Component)this.displayCanvasPane, "displayCanvas");
        this.displayCanvas.addSVGDocumentLoaderListener(new SVGDocumentLoaderAdapter(){

            public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
                TSCreator.showInLabel("Rendering Image: Loading...", 1);
            }

            public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
                TSCreator.showInLabel("Document Loaded.", 1);
            }

            public void documentLoadingFailed(SVGDocumentLoaderEvent e) {
                TSCreator.showInLabel("Rendering Failed", 3);
                TSCreator.this.bigError(true);
            }
        });
        this.displayCanvas.addGVTTreeBuilderListener(new GVTTreeBuilderAdapter(){

            public void gvtBuildStarted(GVTTreeBuilderEvent e) {
                TSCreator.showInLabel("Rendering Image: Building...", 1);
            }

            public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
                TSCreator.showInLabel("Build Done.", 1);
            }

            public void gvtBuildFailed(GVTTreeBuilderEvent e) {
                TSCreator.showInLabel("Rendering Failed", 3);
                TSCreator.this.bigError(true);
            }
        });
        this.displayCanvas.addGVTTreeRendererListener(new GVTTreeRendererAdapter(){

            public void gvtRenderingPrepare(GVTTreeRendererEvent e) {
                TSCreator.showInLabel("Rendering Image: Rendering...", 1);
            }

            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                TSCreator.showInLabel("", 2);
                Runtime.getRuntime().gc();
            }

            public void gvtRenderingFailed(GVTTreeRendererEvent e) {
                TSCreator.showInLabel("Rendering Failed", 3);
                TSCreator.this.bigError(true);
            }
        });
        this.displayCanvas.clearLinkListeners();
        this.displayCanvas.addLinkActivationListener(new TSCLinkActivationListener());
        this.htmlView = new JEditorPane();
        this.htmlView.setEditable(false);
        this.htmlView.setContentType("text/html");
        try {
            this.htmlView.setPage(TSCreator.getURL("introscreen.html"));
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.mainView.add((Component)new JScrollPane(this.htmlView), "htmlView");
        this.tscFrame.getContentPane().add(this.mainView);
        this.mainViewLayout.show(this.mainView, "htmlView");
        this.loadSuccessful(false);
        this.saveSVGAction.setEnabled(false);
        this.savePDFAction.setEnabled(false);
        this.zoomInAction.setEnabled(false);
        this.zoomOutAction.setEnabled(false);
        this.actualSizeAction.setEnabled(false);
        this.fitToWindowAction.setEnabled(false);
        this.tscFrame.setVisible(true);
        this.loadDefaultColoringAction.actionPerformed(null);
        TSCreator.logAndShow("Loading built-in data...", 1);
        this.loadReplaceWithBuiltInAction.actionPerformed(null);
    }

    private void addWidgets() {
        this.info = new JLabel("", 2);
        this.info.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.toolBar = new JToolBar("Main");
        this.toolBar.setFloatable(false);
        this.toolBar.add(this.settingsAction);
        this.toolBar.add(this.generateAction);
        this.toolBar.addSeparator();
        this.toolBar.add(this.zoomInAction);
        this.toolBar.add(this.zoomOutAction);
        this.toolBar.addSeparator();
        this.topPanel.add(this.toolBar);
        this.topPanel.add(this.info);
    }

    private void addMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenu image = new JMenu("Image");
        JMenu help = new JMenu("User Guides");
        menuBar.add(file);
        file.add(this.loadReplaceWithBuiltInAction);
        file.addSeparator();
        file.add(this.saveSVGAction);
        file.add(this.savePDFAction);
        file.addSeparator();
        file.add(this.encryptDataAction);
        file.addSeparator();
        file.add(this.exitAction);
        menuBar.add(image);
        image.add(this.settingsAction);
        image.add(this.generateAction);
        image.addSeparator();
        image.add(this.zoomInAction);
        image.add(this.zoomOutAction);
        image.add(this.actualSizeAction);
        image.add(this.fitToWindowAction);
        menuBar.add(help);
        help.add(this.quickstartAction);
        help.add(this.tourAction);
        help.add(this.featureInfoAction);
        help.add(this.licenseAction);
        help.add(this.fileFormatInfoAction);
        help.add(this.aboutAction);
        this.tscFrame.setJMenuBar(menuBar);
    }

    public static ImageIcon getImageIcon(String filename) {
        if (filename == null) {
            return null;
        }
        return new ImageIcon(TSCreator.getURL(filename));
    }

    public static URL getURL(String filename) {
        if (TSCreator.isJarred()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("gui.TSCreator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            URL url = clazz.getResource("/" + filename);
            return url;
        }
        try {
            return new URL("file:" + filename);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static InputStream getInputStream(String filename) {
        InputStream in = null;
        if (TSCreator.isJarred()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("gui.TSCreator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            in = clazz.getResourceAsStream("/" + filename);
        } else {
            try {
                in = new FileInputStream(filename);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return in;
    }

    public static boolean isJarred() {
        URL url;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gui.TSCreator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (url = clazz.getResource("/introscreen.html")) != null;
    }

    public void loadDefaultColoring() {
        try {
            Coloring.readColoring(TSCreator.getInputStream(DEFAULT_COLORING_FILE));
        }
        catch (Exception e) {
            TSCreator.messageBox(e.getMessage(), "Error loading color schemes!", 3);
        }
    }

    public void loadDefaultData() throws Exception {
        try {
            if (this.db == null) {
                this.db = new Datastore();
                this.settings = new Settings(this.db);
                this.settings.setGenerateAction(this.generateAction);
                this.db.addBasicColumns();
            }
            this.doUIChanges(2, true, false);
            if (!this.loadEncrypted(DEFAULT_DATA_FILE, true)) {
                throw new Exception("Nothing loaded.");
            }
            this.db.rootColumn.setParentFontManager(this.settings.fonts);
            this.settings.dataAdded();
            TSCreator.logAndShow("Data loaded successfully!", 2);
            this.loadSuccessful(true);
        }
        catch (Exception e) {
            TSCreator.logAndShow("Error loading data file!", 3);
            TSCreator.log(e.getMessage(), 3);
            TSCreator.messageBox(e.getMessage(), "Error loading file!", 3);
        }
        this.doUIChanges(2, false, false);
    }

    public void loadDataFromFile(boolean clearCurrent) throws Exception {
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter eff = new ExtensionFileFilter();
        eff.setDescription("text files (*.txt)");
        eff.addExtension("txt", true);
        chooser.setFileFilter(eff);
        int returnVal = chooser.showOpenDialog(this.tscFrame);
        if (returnVal == 0) {
            TSCreator.log("Loading data from " + chooser.getSelectedFile().getAbsolutePath());
            try {
                if (clearCurrent) {
                    this.clearData();
                }
                if (this.db == null || clearCurrent) {
                    this.db = new Datastore();
                    this.settings = new Settings(this.db);
                    this.settings.setGenerateAction(this.generateAction);
                    this.db.addBasicColumns();
                }
                this.doUIChanges(2, true, false);
                if (!this.loadEncrypted(chooser.getSelectedFile().getAbsolutePath(), false)) {
                    throw new Exception("Nothing loaded.");
                }
                this.db.rootColumn.setParentFontManager(this.settings.fonts);
                this.settings.dataAdded();
                TSCreator.logAndShow("Data loaded successfully!", 2);
                this.loadSuccessful(true);
            }
            catch (Exception e) {
                TSCreator.logAndShow("Error loading data file!", 3);
                TSCreator.log(e.getMessage(), 3);
                TSCreator.messageBox(e.getMessage(), "Error loading file!", 3);
            }
            this.doUIChanges(2, false, false);
        }
    }

    protected boolean loadEncrypted(String file, boolean resource) throws Exception {
        int totalRead;
        byte[] encFileContents;
        InputStream in;
        try {
            this.db.load(file, resource);
            return true;
        }
        catch (ParseException e) {
            int read;
            in = this.db.getInputStreamForFile(file, resource);
            if (in.available() <= 0) {
                throw new Exception("invalid file");
            }
            encFileContents = new byte[in.available()];
            if (encFileContents == null) {
                throw new Exception("Not enough memory to decrypt file!");
            }
            totalRead = read = in.read(encFileContents, 0, encFileContents.length);
            try {
                while (totalRead < encFileContents.length && in.available() > 0) {
                    read = in.read(encFileContents, totalRead, encFileContents.length - totalRead);
                    if (read != -1) {
                        totalRead += read;
                    }
                }
            }
            catch (Exception ioe) {
                throw new Exception("IO error: " + ioe.getMessage());
            }
        }
        if (totalRead != encFileContents.length) {
            throw new Exception("Entire datafile couldn't be read. Read " + totalRead + " of " + encFileContents.length);
        }
        in.close();
        in = new ByteArrayInputStream(encFileContents);
        DatafileCrypto.HeaderInfo hi = DatafileCrypto.readEncryptedHeader(in);
        if (hi == null) {
            throw new Exception("unknown file");
        }
        boolean found = false;
        int contentStart = 0;
        int i = 3;
        while (i < encFileContents.length && i < 5000) {
            if (encFileContents[i - 3] == 13 && encFileContents[i - 2] == 10 && encFileContents[i - 1] == 13 && encFileContents[i] == 10) {
                found = true;
                in.close();
                contentStart = i + 1;
                break;
            }
            ++i;
        }
        if (!found) {
            throw new Exception("unknown file");
        }
        MessageDigest md = DatafileCrypto.getIntegrityHashFunction();
        md.update(encFileContents, contentStart, encFileContents.length - contentStart);
        byte[] encryptedHash = md.digest();
        if (hi.integrityHash == null || !DatafileCrypto.verifyHash(hi.integrityHash, encryptedHash)) {
            throw new Exception("The integrity of the datafile could not be verified.\r\nheader:    " + DatafileCrypto.byteToHexString(hi.integrityHash) + "\r\ncontents: " + DatafileCrypto.byteToHexString(encryptedHash));
        }
        in = new ByteArrayInputStream(encFileContents, contentStart, encFileContents.length);
        DecryptionOptions opt = new DecryptionOptions(hi, true);
        if (!opt.isOK()) {
            return false;
        }
        Cipher cipher = DatafileCrypto.getCipher(opt.getPassword(), hi);
        CipherInputStream cryptIn = new CipherInputStream(in, cipher);
        while (true) {
            if (DatafileCrypto.isDecryptedFile(cryptIn)) {
                ((InputStream)cryptIn).close();
                in.close();
                cipher = DatafileCrypto.getCipher(opt.getPassword(), hi);
                byte[] decryptedContents = cipher.doFinal(encFileContents, contentStart, encFileContents.length - contentStart);
                if (decryptedContents == null) {
                    throw new Exception("Not enough memory to decrypt file!");
                }
                in = new ByteArrayInputStream(decryptedContents);
                this.db.load(in);
                return true;
            }
            opt = new DecryptionOptions(hi, false);
            if (!opt.isOK()) {
                return false;
            }
            ((InputStream)cryptIn).close();
            in.close();
            in = new ByteArrayInputStream(encFileContents, contentStart, encFileContents.length);
            cipher = DatafileCrypto.getCipher(opt.getPassword(), hi);
            cryptIn = new CipherInputStream(in, cipher);
        }
    }

    public void encryptDatafile() {
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter eff = new ExtensionFileFilter();
        eff.setDescription("text files (*.txt)");
        eff.addExtension("txt", true);
        chooser.setFileFilter(eff);
        int returnVal = chooser.showOpenDialog(this.tscFrame);
        if (returnVal == 0) {
            try {
                String inPath = chooser.getSelectedFile().getAbsolutePath();
                FileInputStream fis = new FileInputStream(inPath);
                if (!DatafileCrypto.isDecryptedFile(fis)) {
                    TSCreator.messageBox("The selected file does not appear to be a TSCreator datafile.", "Cannot protect file", 3);
                    return;
                }
                fis.close();
                EncryptionOptions opt = new EncryptionOptions();
                if (!opt.isOK()) {
                    return;
                }
                DatafileCrypto.HeaderInfo hi = opt.getHeaderInfo();
                returnVal = chooser.showSaveDialog(this.tscFrame);
                if (returnVal == 0) {
                    fis = new FileInputStream(inPath);
                    String outPath = TSCreator.appendExtension(chooser.getSelectedFile().getAbsolutePath(), "txt");
                    FileOutputStream fos = new FileOutputStream(outPath);
                    String error = DatafileCrypto.encrypt(fos, fis, opt.getPassword(), hi);
                    if (error == null) {
                        TSCreator.logAndShow("Protected file created successfully!", 2);
                    } else {
                        TSCreator.logAndShow("Error while protecting file: " + error, 3);
                    }
                    fis.close();
                    fos.close();
                }
            }
            catch (FileNotFoundException e) {
                TSCreator.logAndShow("File not found!", 3);
                TSCreator.log(e.getMessage(), 3);
                TSCreator.messageBox(e.getMessage(), "File not found!", 3);
            }
            catch (IOException e) {
                TSCreator.logAndShow("IO Error!", 3);
                TSCreator.log(e.getMessage(), 3);
                TSCreator.messageBox(e.getMessage(), "I/O error!", 3);
            }
        }
    }

    public void showSettings() {
        if (!this.settings.isPopulated) {
            this.settings.populate(this.db);
        }
        this.settings.setVisible(true);
    }

    public void clearData() {
        if (this.settings != null) {
            this.settings.setVisible(false);
            this.settings = null;
        }
        if (this.db != null) {
            this.db = null;
        }
    }

    public void generateImage() {
        if (!this.settings.isValid()) {
            this.showSettings();
            return;
        }
        this.doUIChanges(1, true, false);
        this.mainViewLayout.show(this.mainView, "displayCanvas");
        TSCreator.logAndShow("Generating Image...", 1);
        try {
            this.displayCanvas.setDocument(null);
            this.ig = new ImageGenerator(this.db.rootColumn, this.settings);
            this.svgImage = this.ig.drawImage();
        }
        catch (Exception e) {
            TSCreator.logAndShow("Internal error while generating!", 3);
            e.printStackTrace();
            this.bigError(false);
            this.doUIChanges(1, false, true);
            return;
        }
        catch (OutOfMemoryError oeme) {
            TSCreator.logAndShow("Out of Memory!", 3);
            this.bigError(false);
            this.doUIChanges(1, false, true);
            return;
        }
        try {
            TSCreator.logAndShow("Displaying Image...", 2);
            this.displayCanvas.setDocument(this.svgImage);
            TSCreator.logAndShow("Image generated! (please wait for it to appear)", 2);
        }
        catch (OutOfMemoryError oeme) {
            TSCreator.logAndShow("Out of Memory.", 3);
            this.bigError(true);
        }
        this.doUIChanges(1, false, false);
    }

    public void doUIChanges(int action, boolean gen, boolean error) {
        this.settings.showGenerating(gen);
        this.loadReplaceWithBuiltInAction.setEnabled(!gen);
        this.generateAction.setEnabled(!gen);
        this.settingsAction.setEnabled(!gen);
        switch (action) {
            case 1: {
                this.saveSVGAction.setEnabled(!gen && !error);
                this.savePDFAction.setEnabled(!gen && !error);
                this.zoomInAction.setEnabled(!gen && !error);
                this.zoomOutAction.setEnabled(!gen && !error);
                this.actualSizeAction.setEnabled(!gen && !error);
                this.fitToWindowAction.setEnabled(!gen && !error);
                break;
            }
            case 2: {
                this.saveSVGAction.setEnabled(false);
                this.savePDFAction.setEnabled(false);
                this.zoomInAction.setEnabled(false);
                this.zoomOutAction.setEnabled(false);
                this.actualSizeAction.setEnabled(false);
                this.fitToWindowAction.setEnabled(false);
                break;
            }
            case 3: {
                this.saveSVGAction.setEnabled(!gen);
                this.savePDFAction.setEnabled(!gen);
            }
        }
    }

    public void loadSuccessful(boolean tf) {
        this.settingsAction.setEnabled(tf);
        this.generateAction.setEnabled(tf);
    }

    public void save(String format) {
        if (format.compareTo("SVG") != 0 && format.compareTo("PDF") != 0) {
            return;
        }
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter eff = new ExtensionFileFilter();
        eff.setDescription(String.valueOf(format) + " file (*." + format.toLowerCase() + ")");
        eff.addExtension(format.toLowerCase(), true);
        chooser.setFileFilter(eff);
        int returnVal = chooser.showSaveDialog(this.tscFrame);
        if (returnVal == 0) {
            block8: {
                String absolutePath = TSCreator.appendExtension(chooser.getSelectedFile().getAbsolutePath(), format.toLowerCase());
                TSCreator.logAndShow("Writing " + format + " to " + absolutePath + "...", 1);
                try {
                    if (format.compareTo("SVG") == 0) {
                        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(absolutePath), "UTF-8");
                        this.ig.write(fw);
                        fw.close();
                        break block8;
                    }
                    if (format.compareTo("PDF") != 0) break block8;
                    Object[] options = new String[]{"Save", "Cancel"};
                    if (JOptionPane.showOptionDialog(null, "<html>Saving a PDF can take a long time for larger images,<br>and currently the text in the PDF will NOT be editable (Though with some encouragement we can add that in..) <br>Continue with save?</html>", "Saving to PDF", -1, 3, null, options, options[0]) == 0) {
                        FileOutputStream fw = new FileOutputStream(absolutePath);
                        this.ig.writePDF(fw);
                        fw.close();
                        break block8;
                    }
                    TSCreator.showInLabel("", 2);
                    return;
                }
                catch (TranscoderException options) {
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Error writing " + format, 0);
                    TSCreator.log("Error writing " + format + ": " + e.getMessage(), 3);
                    TSCreator.showInLabel("", 3);
                    return;
                }
                catch (OutOfMemoryError oome) {
                    TSCreator.logAndShow("Error writing " + format + "! Out of memory!", 3);
                    return;
                }
            }
            TSCreator.logAndShow(String.valueOf(format) + " file successfully written.", 2);
        }
    }

    public static String appendExtension(String path, String ext) {
        if (path.regionMatches(true, path.length() - ext.length() - 1, "." + ext, 0, ext.length())) {
            return path;
        }
        return String.valueOf(path) + "." + ext;
    }

    public void actionPerformed(TSCAction e) throws Exception {
        if (e == this.loadReplaceWithBuiltInAction) {
            this.clearData();
            this.loadDefaultData();
        } else if (e != this.clearAction) {
            if (e == this.saveSVGAction) {
                this.save("SVG");
            } else if (e == this.savePDFAction) {
                this.save("PDF");
            } else if (e == this.encryptDataAction) {
                this.encryptDatafile();
            } else if (e == this.exitAction) {
                System.exit(1);
            } else if (e == this.loadDefaultColoringAction) {
                this.loadDefaultColoring();
            } else if (e == this.settingsAction) {
                this.showSettings();
            } else if (e == this.generateAction) {
                this.generateImage();
            } else if (e == this.zoomInAction) {
                this.displayCanvasPane.zoomBy(1.25);
            } else if (e == this.zoomOutAction) {
                this.displayCanvasPane.zoomBy(0.8);
            } else if (e == this.actualSizeAction) {
                this.displayCanvasPane.resetTransform();
                this.displayCanvasPane.recenter();
            } else if (e == this.fitToWindowAction) {
                this.displayCanvasPane.zoomToFit();
            } else if (e == this.quickstartAction) {
                new HTMLViewerDialog("Quick Start Guide", "quickstart.htm", 600, 400).setVisible(true);
            } else if (e == this.tourAction) {
                new HTMLViewerDialog("Tour", "tour.html", 600, 400).setVisible(true);
            } else if (e == this.featureInfoAction) {
                new HTMLViewerDialog("Features", "featuresSummary.html", 1000, 500).setVisible(true);
            } else if (e == this.licenseAction) {
                new HTMLViewerDialog("License", "license.html", 650, 400).setVisible(true);
            } else if (e == this.fileFormatInfoAction) {
                new HTMLViewerDialog("File Format Info", "file_format_guide.txt", 600, 500).setVisible(true);
            } else if (e == this.aboutAction) {
                new HTMLViewerDialog("About", "about.html", 600, 350).setVisible(true);
            }
        }
    }

    public void bigError(boolean canSave) {
        this.svgImage = null;
        this.displayCanvas.setDocument(null);
        this.saveSVGAction.setEnabled(canSave);
        this.savePDFAction.setEnabled(canSave);
        this.zoomInAction.setEnabled(true);
        this.zoomOutAction.setEnabled(true);
        this.actualSizeAction.setEnabled(true);
        this.fitToWindowAction.setEnabled(true);
        this.htmlView.setEditable(false);
        this.htmlView.setContentType("text/html");
        String filename = "bigerror-cansave.html";
        if (!canSave) {
            filename = "bigerror-cannotsave.html";
        }
        try {
            this.htmlView.setPage(TSCreator.getURL(filename));
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.mainViewLayout.show(this.mainView, "htmlView");
        Runtime.getRuntime().gc();
    }

    public static void log(String s) {
        TSCreator.log(s, 1, 1);
    }

    public static void log(String s, int type) {
        TSCreator.log(s, type, 1);
    }

    public static void log(String s, int type, int minDebugLevel) {
        if (1 >= minDebugLevel) {
            System.out.println(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showInLabel(String s, int type) {
        JLabel jLabel = TSCreator.curCreator.info;
        synchronized (jLabel) {
            switch (type) {
                case 2: {
                    TSCreator.curCreator.info.setForeground(new Color(0, 128, 0));
                    break;
                }
                case 4: {
                    TSCreator.curCreator.info.setForeground(new Color(128, 128, 0));
                    break;
                }
                case 3: {
                    TSCreator.curCreator.info.setForeground(new Color(128, 0, 0));
                    break;
                }
                default: {
                    TSCreator.curCreator.info.setForeground(new Color(0, 0, 0));
                }
            }
            TSCreator.curCreator.info.setText(s);
        }
    }

    public static void logAndShow(String s, int type) {
        TSCreator.showInLabel(s, type);
        TSCreator.log(s, type);
    }

    public static void messageBox(String text, String title, int type) {
        int outType;
        switch (type) {
            case 2: {
                outType = 1;
                break;
            }
            case 4: {
                outType = 2;
                break;
            }
            case 3: {
                outType = 0;
                break;
            }
            default: {
                outType = -1;
            }
        }
        JOptionPane.showMessageDialog(null, text, title, outType);
    }

    public static void launchBrowser(String url) {
        try {
            TSCreator.log("launching " + url);
            BrowserLauncher launcher = new BrowserLauncher(null);
            BrowserLauncherDefaultErrorHandler errorHandler = new BrowserLauncherDefaultErrorHandler();
            BrowserLauncherRunner runner = new BrowserLauncherRunner(launcher, url, errorHandler);
            Thread launcherThread = new Thread(runner);
            launcherThread.start();
        }
        catch (Exception e) {
            TSCreator.logAndShow("Error launching browser.", 3);
        }
    }

    public static void main(String[] args) {
        try {
            String nativeLF = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(nativeLF);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            System.out.println("Available heap memory: " + Runtime.getRuntime().maxMemory() + " bytes.");
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        new TSCreator();
    }

    class TSCAction
    extends AbstractAction {
        TSCreator tsc;
        Object lock = null;

        public TSCAction(TSCreator tsc, String text, String iconFile, String description) {
            super(text, TSCreator.getImageIcon(iconFile));
            this.tsc = tsc;
            this.putValue("ShortDescription", description);
        }

        public TSCAction(TSCreator tsc, String text, String iconFile, String description, char accelerator) {
            this(tsc, text, iconFile, description);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)accelerator, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }

        public void useThread(Object lockObject) {
            this.lock = lockObject;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.lock == null) {
                this.doAction();
            } else {
                WorkerThread wt = new WorkerThread(this);
                wt.start();
            }
        }

        public void doAction() {
            try {
                this.tsc.actionPerformed(this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void setText(String t) {
            this.putValue("Name", t);
        }
    }
}

