/*
 * Decompiled with CFR 0.152.
 */
package net.sf.wraplog;

import net.sf.wraplog.LoggingException;

public abstract class AbstractLogger {
    private int level = 0;
    private int loggedMessageCount;

    protected void checkLevel(int logLevel, String name) {
        String actualName = name == null ? "level" : name;
        if (logLevel < 0 || logLevel > 3) {
            throw new IllegalArgumentException(String.valueOf(actualName) + " must be one of: Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR");
        }
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public void debug(String message, Throwable error) {
        this.log(0, message, error);
    }

    public void error(String message) {
        this.error(message, null);
    }

    public void error(String message, Throwable error) {
        this.log(3, message, error);
    }

    public int getLevel() {
        return this.level;
    }

    public int getLoggedMessageCount() {
        return this.loggedMessageCount;
    }

    public void info(String message) {
        this.info(message, null);
    }

    public void info(String message, Throwable error) {
        this.log(1, message, error);
    }

    public boolean isEnabled(int logLevel) {
        this.checkLevel(this.level, null);
        return logLevel >= this.level;
    }

    protected abstract void reallyLog(int var1, String var2, Throwable var3) throws Exception;

    public void log(int logLevel, String message) {
        this.log(logLevel, message, null);
    }

    public void log(int logLevel, String message, Throwable error) {
        if (this.isEnabled(logLevel)) {
            try {
                this.reallyLog(logLevel, message, error);
                ++this.loggedMessageCount;
            }
            catch (Exception error2) {
                throw new LoggingException("cannot log message: " + message, error2);
            }
        }
    }

    public void setLevel(int newLevel) {
        if (this.level < 0 && this.level > 3) {
            throw new IllegalArgumentException("newLevel must be one of: Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR");
        }
        this.level = newLevel;
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(0);
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(1);
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(2);
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(3);
    }

    public void warn(String message, Throwable error) {
        this.log(2, message, error);
    }
}

