/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FormattingResults;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.BookmarkData;
import org.apache.fop.area.OffDocumentExtensionAttachment;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RenderPagesModel;
import org.apache.fop.area.Resolvable;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.fo.pagination.bookmarks.BookmarkTree;
import org.apache.fop.layoutmgr.LayoutManagerMaker;
import org.apache.fop.layoutmgr.LayoutManagerMapping;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.xml.sax.SAXException;

public class AreaTreeHandler
extends FOEventHandler {
    private boolean outputStatistics;
    private Runtime runtime;
    private long initialMemory;
    private long startTime;
    private LayoutManagerMaker lmMaker;
    protected AreaTreeModel model;
    private Root rootFObj;
    private Map idLocations = new HashMap();
    private Map unresolvedIDRefs = new HashMap();
    private FormattingResults results = new FormattingResults();
    private PageSequenceLayoutManager prevPageSeqLM;
    private static Log log = LogFactory.getLog(class$org$apache$fop$area$AreaTreeHandler == null ? (class$org$apache$fop$area$AreaTreeHandler = AreaTreeHandler.class$("org.apache.fop.area.AreaTreeHandler")) : class$org$apache$fop$area$AreaTreeHandler);
    static /* synthetic */ Class class$org$apache$fop$area$AreaTreeHandler;

    public AreaTreeHandler(FOUserAgent userAgent, String outputFormat, OutputStream stream) throws FOPException {
        super(userAgent);
        this.setupModel(userAgent, outputFormat, stream);
        this.lmMaker = userAgent.getFactory().getLayoutManagerMakerOverride();
        if (this.lmMaker == null) {
            this.lmMaker = new LayoutManagerMapping();
        }
        this.outputStatistics = log.isDebugEnabled();
        if (this.outputStatistics) {
            this.runtime = Runtime.getRuntime();
        }
    }

    protected void setupModel(FOUserAgent userAgent, String outputFormat, OutputStream stream) throws FOPException {
        this.model = new RenderPagesModel(userAgent, outputFormat, this.fontInfo, stream);
    }

    public AreaTreeModel getAreaTreeModel() {
        return this.model;
    }

    public LayoutManagerMaker getLayoutManagerMaker() {
        return this.lmMaker;
    }

    public void associateIDWithPageViewport(String id, PageViewport pv) {
        ArrayList<PageViewport> pvList;
        if (log.isDebugEnabled()) {
            log.debug("associateIDWithPageViewport(" + id + ", " + pv + ")");
        }
        if ((pvList = (ArrayList<PageViewport>)this.idLocations.get(id)) == null) {
            pvList = new ArrayList<PageViewport>();
            this.idLocations.put(id, pvList);
            pvList.add(pv);
            this.tryIDResolution(id, pv, pvList);
        } else {
            pvList.add(pv);
        }
    }

    private void tryIDResolution(String id, PageViewport pv, List pvList) {
        Set todo = (Set)this.unresolvedIDRefs.get(id);
        if (todo != null) {
            Iterator iter = todo.iterator();
            while (iter.hasNext()) {
                Resolvable res = (Resolvable)iter.next();
                res.resolveIDRef(id, pvList);
            }
            this.unresolvedIDRefs.remove(id);
        }
    }

    public void tryIDResolution(PageViewport pv) {
        String[] ids = pv.getIDRefs();
        if (ids != null) {
            int i = 0;
            while (i < ids.length) {
                List pvList = (List)this.idLocations.get(ids[i]);
                if (pvList != null) {
                    this.tryIDResolution(ids[i], pv, pvList);
                }
                ++i;
            }
        }
    }

    public List getPageViewportsContainingID(String id) {
        return (List)this.idLocations.get(id);
    }

    public FormattingResults getResults() {
        return this.results;
    }

    public void addUnresolvedIDRef(String idref, Resolvable res) {
        HashSet<Resolvable> todo = (HashSet<Resolvable>)this.unresolvedIDRefs.get(idref);
        if (todo == null) {
            todo = new HashSet<Resolvable>();
            this.unresolvedIDRefs.put(idref, todo);
        }
        todo.add(res);
    }

    public void startDocument() throws SAXException {
        if (this.outputStatistics) {
            this.initialMemory = this.runtime.totalMemory() - this.runtime.freeMemory();
            this.startTime = System.currentTimeMillis();
        }
    }

    private void finishPrevPageSequence(Numeric initialPageNumber) {
        if (this.prevPageSeqLM != null) {
            this.prevPageSeqLM.doForcePageCount(initialPageNumber);
            this.prevPageSeqLM.finishPageSequence();
            this.prevPageSeqLM = null;
        }
    }

    public void startPageSequence(PageSequence pageSequence) {
        this.rootFObj = pageSequence.getRoot();
        this.finishPrevPageSequence(pageSequence.getInitialPageNumber());
        pageSequence.initPageNumber();
        this.wrapAndAddExtensionAttachments(this.rootFObj.getExtensionAttachments());
        if (this.rootFObj.getDeclarations() != null) {
            this.wrapAndAddExtensionAttachments(this.rootFObj.getDeclarations().getExtensionAttachments());
        }
    }

    private void wrapAndAddExtensionAttachments(List list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ExtensionAttachment attachment = (ExtensionAttachment)i.next();
            this.addOffDocumentItem(new OffDocumentExtensionAttachment(attachment));
        }
    }

    public void endPageSequence(PageSequence pageSequence) {
        if (this.outputStatistics) {
            long memoryNow = this.runtime.totalMemory() - this.runtime.freeMemory();
            log.debug("Current heap size: " + memoryNow / 1024L + "Kb");
        }
        if (pageSequence.getMainFlow() != null) {
            PageSequenceLayoutManager pageSLM = this.getLayoutManagerMaker().makePageSequenceLayoutManager(this, pageSequence);
            pageSLM.activateLayout();
            this.prevPageSeqLM = pageSLM;
        }
    }

    public void notifyPageSequenceFinished(PageSequence pageSequence, int pageCount) {
        this.results.haveFormattedPageSequence(pageSequence, pageCount);
        if (log.isDebugEnabled()) {
            log.debug("Last page-sequence produced " + pageCount + " pages.");
        }
    }

    public void endDocument() throws SAXException {
        this.finishPrevPageSequence(null);
        BookmarkTree bookmarkTree = this.rootFObj.getBookmarkTree();
        if (bookmarkTree != null) {
            BookmarkData data = new BookmarkData(bookmarkTree);
            this.addOffDocumentItem(data);
        }
        this.model.endDocument();
        if (this.outputStatistics) {
            long memoryNow = this.runtime.totalMemory() - this.runtime.freeMemory();
            long memoryUsed = (memoryNow - this.initialMemory) / 1024L;
            long timeUsed = System.currentTimeMillis() - this.startTime;
            int pageCount = this.rootFObj.getTotalPagesGenerated();
            log.debug("Initial heap size: " + this.initialMemory / 1024L + "Kb");
            log.debug("Current heap size: " + memoryNow / 1024L + "Kb");
            log.debug("Total memory used: " + memoryUsed + "Kb");
            log.debug("Total time used: " + timeUsed + "ms");
            log.debug("Pages rendered: " + pageCount);
            if (pageCount > 0) {
                long perPage = timeUsed / (long)pageCount;
                long ppm = timeUsed != 0L ? Math.round((double)(60000 * pageCount) / (double)timeUsed) : -1L;
                log.debug("Avg render time: " + perPage + "ms/page (" + ppm + "pages/min)");
            }
        }
    }

    private void addOffDocumentItem(OffDocumentItem odi) {
        if (odi instanceof Resolvable) {
            Resolvable res = (Resolvable)((Object)odi);
            String[] ids = res.getIDRefs();
            int count = 0;
            while (count < ids.length) {
                if (this.idLocations.containsKey(ids[count])) {
                    res.resolveIDRef(ids[count], (List)this.idLocations.get(ids[count]));
                } else {
                    log.warn(odi.getName() + ": Unresolved id reference \"" + ids[count] + "\" found.");
                    this.addUnresolvedIDRef(ids[count], res);
                }
                ++count;
            }
            if (res.isResolved()) {
                this.model.handleOffDocumentItem(odi);
            }
        } else {
            this.model.handleOffDocumentItem(odi);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

