/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.PageViewport;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.Renderer;
import org.xml.sax.SAXException;

public class RenderPagesModel
extends AreaTreeModel {
    protected Renderer renderer;
    protected List prepared = new ArrayList();
    private List pendingODI = new ArrayList();
    private List endDocODI = new ArrayList();

    public RenderPagesModel(FOUserAgent userAgent, String outputFormat, FontInfo fontInfo, OutputStream stream) throws FOPException {
        this.renderer = userAgent.getRendererFactory().createRenderer(userAgent, outputFormat);
        try {
            this.renderer.setupFontInfo(fontInfo);
            if (!fontInfo.isSetupValid()) {
                throw new FOPException("No default font defined by OutputConverter");
            }
            this.renderer.startRenderer(stream);
        }
        catch (IOException e) {
            throw new FOPException(e);
        }
    }

    public void startPageSequence(LineArea title) {
        super.startPageSequence(title);
        if (this.renderer.supportsOutOfOrder()) {
            this.renderer.startPageSequence(title);
        }
    }

    public void addPage(PageViewport page) {
        boolean ready;
        super.addPage(page);
        boolean bl = ready = this.renderer.supportsOutOfOrder() && page.isResolved();
        if (ready) {
            if (!this.renderer.supportsOutOfOrder() && page.getPageSequence().isFirstPage(page)) {
                this.renderer.startPageSequence(this.currentPageSequence.getTitle());
            }
            try {
                this.renderer.renderPage(page);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                String err = "Error while rendering page " + page.getPageNumberString();
                AreaTreeModel.log.error(err, e);
                throw new IllegalStateException("Fatal error occurred. Cannot continue. " + e.getClass().getName() + ": " + err);
            }
            page.clear();
        } else {
            this.preparePage(page);
        }
        boolean cont = this.checkPreparedPages(page, false);
        if (cont) {
            this.processOffDocumentItems(this.pendingODI);
            this.pendingODI.clear();
        }
    }

    protected boolean checkPreparedPages(PageViewport newpage, boolean renderUnresolved) {
        Iterator iter = this.prepared.iterator();
        while (iter.hasNext()) {
            PageViewport p = (PageViewport)iter.next();
            if (p.isResolved() || renderUnresolved) {
                if (!this.renderer.supportsOutOfOrder() && p.getPageSequence().isFirstPage(p)) {
                    this.renderer.startPageSequence(this.currentPageSequence.getTitle());
                }
                try {
                    this.renderer.renderPage(p);
                    if (!p.isResolved()) {
                        String[] idrefs = p.getIDRefs();
                        int count = 0;
                        while (count < idrefs.length) {
                            AreaTreeModel.log.warn("Page " + p.getPageNumberString() + ": Unresolved id reference \"" + idrefs[count] + "\" found.");
                            ++count;
                        }
                    }
                }
                catch (Exception e) {
                    AreaTreeModel.log.error(e);
                }
                p.clear();
                iter.remove();
                continue;
            }
            if (!this.renderer.supportsOutOfOrder()) break;
        }
        return this.renderer.supportsOutOfOrder() || this.prepared.isEmpty();
    }

    protected void preparePage(PageViewport page) {
        if (this.renderer.supportsOutOfOrder()) {
            this.renderer.preparePage(page);
        }
        this.prepared.add(page);
    }

    public void handleOffDocumentItem(OffDocumentItem oDI) {
        switch (oDI.getWhenToProcess()) {
            case 0: {
                this.renderer.processOffDocumentItem(oDI);
                break;
            }
            case 1: {
                this.pendingODI.add(oDI);
                break;
            }
            case 2: {
                this.endDocODI.add(oDI);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void processOffDocumentItems(List list) {
        int count = 0;
        while (count < list.size()) {
            OffDocumentItem oDI = (OffDocumentItem)list.get(count);
            this.renderer.processOffDocumentItem(oDI);
            ++count;
        }
    }

    public void endDocument() throws SAXException {
        this.checkPreparedPages(null, true);
        this.processOffDocumentItems(this.pendingODI);
        this.pendingODI.clear();
        this.processOffDocumentItems(this.endDocODI);
        try {
            this.renderer.stopRenderer();
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
    }
}

