/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area.inline;

import org.apache.fop.area.inline.AbstractTextArea;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.WordArea;

public class TextArea
extends AbstractTextArea {
    public TextArea() {
    }

    public TextArea(int stretch, int shrink, int adj) {
        super(stretch, shrink, adj);
    }

    public void removeText() {
        this.inlines.clear();
    }

    public void addWord(String word, int offset) {
        this.addWord(word, offset, null);
    }

    public void addWord(String word, int offset, int[] letterAdjust) {
        WordArea wordArea = new WordArea(word, offset, letterAdjust);
        this.addChildArea(wordArea);
        wordArea.setParentArea(this);
    }

    public void addSpace(char space, int offset, boolean adjustable) {
        SpaceArea spaceArea = new SpaceArea(space, offset, adjustable);
        this.addChildArea(spaceArea);
        spaceArea.setParentArea(this);
    }

    public String getText() {
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < this.inlines.size()) {
            InlineArea child = (InlineArea)this.inlines.get(i);
            if (child instanceof WordArea) {
                text.append(((WordArea)child).getWord());
            } else {
                text.append(((SpaceArea)child).getSpace());
            }
            ++i;
        }
        return text.toString();
    }

    public void updateIPD(int newIPD) {
        int oldIPD = this.getIPD();
        this.setIPD(newIPD);
        if (newIPD != oldIPD) {
            this.notifyIPDVariation(newIPD - oldIPD);
        }
    }
}

