/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area.inline;

import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolvable;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.fonts.Font;

public class UnresolvedPageNumber
extends TextArea
implements Resolvable {
    private boolean resolved = false;
    private String pageIDRef;
    private String text;
    private transient Font font;

    public UnresolvedPageNumber(String id, Font f) {
        this.pageIDRef = id;
        this.font = f;
        this.text = "?";
    }

    public String[] getIDRefs() {
        return new String[]{this.pageIDRef};
    }

    public void resolveIDRef(String id, List pages) {
        if (this.pageIDRef.equals(id) && pages != null) {
            this.resolved = true;
            PageViewport page = (PageViewport)pages.get(0);
            this.removeText();
            this.addWord(page.getPageNumberString(), 0);
            if (this.font != null) {
                this.updateIPD(this.font.getWordWidth(this.text));
                this.font = null;
            } else {
                Area.log.warn("Cannot update the IPD of an unresolved page number. No font information avilable.");
            }
        }
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public boolean applyVariationFactor(double variationFactor, int lineStretch, int lineShrink) {
        return true;
    }
}

