/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.AbstractGraphics;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;
import org.xml.sax.Locator;

public class ExternalGraphic
extends AbstractGraphics {
    private String src;
    private String url;
    private FopImage fopimage;

    public ExternalGraphic(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        super.bind(pList);
        this.src = pList.get(210).getString();
        this.url = ImageFactory.getURL(this.getSrc());
        FOUserAgent userAgent = this.getUserAgent();
        ImageFactory fact = userAgent.getFactory().getImageFactory();
        this.fopimage = fact.getImage(this.url, userAgent);
        if (this.fopimage == null) {
            this.getLogger().error("Image not available: " + this.getSrc());
        } else if (!this.fopimage.load(1)) {
            this.getLogger().error("Cannot read image dimensions: " + this.getSrc());
        }
    }

    protected void startOfNode() throws FOPException {
        this.checkId(this.getId());
        this.getFOEventHandler().image(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        this.invalidChildError(loc, nsURI, localName);
    }

    public String getSrc() {
        return this.src;
    }

    public String getURL() {
        return this.url;
    }

    public String getLocalName() {
        return "external-graphic";
    }

    public int getNameId() {
        return 9;
    }

    public int getIntrinsicWidth() {
        if (this.fopimage != null) {
            return this.fopimage.getIntrinsicWidth();
        }
        return 0;
    }

    public int getIntrinsicHeight() {
        if (this.fopimage != null) {
            return this.fopimage.getIntrinsicHeight();
        }
        return 0;
    }
}

