/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CondLengthProperty;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;

public class CommonBorderPaddingBackground
implements Cloneable {
    public int backgroundAttachment;
    public ColorType backgroundColor;
    public String backgroundImage;
    public int backgroundRepeat;
    public Length backgroundPositionHorizontal;
    public Length backgroundPositionVertical;
    private FopImage fopimage;
    public static final int BEFORE = 0;
    public static final int AFTER = 1;
    public static final int START = 2;
    public static final int END = 3;
    private BorderInfo[] borderInfo = new BorderInfo[4];
    private CondLengthProperty[] padding = new CondLengthProperty[4];

    public CommonBorderPaddingBackground() {
    }

    public CommonBorderPaddingBackground(PropertyList pList, FObj fobj) throws PropertyException {
        this.backgroundAttachment = pList.get(8).getEnum();
        this.backgroundColor = pList.get(9).getColorType();
        if (this.backgroundColor.getAlpha() == 0.0f) {
            this.backgroundColor = null;
        }
        this.backgroundImage = pList.get(10).getString();
        if (this.backgroundImage == null || "none".equals(this.backgroundImage)) {
            this.backgroundImage = null;
        } else {
            this.backgroundRepeat = pList.get(14).getEnum();
            this.backgroundPositionHorizontal = pList.get(12).getLength();
            this.backgroundPositionVertical = pList.get(13).getLength();
            String url = ImageFactory.getURL(this.backgroundImage);
            FOUserAgent userAgent = fobj.getUserAgent();
            ImageFactory fact = userAgent.getFactory().getImageFactory();
            this.fopimage = fact.getImage(url, userAgent);
            if (this.fopimage == null) {
                fobj.getLogger().error("Background image not available: " + this.backgroundImage);
            } else if (!this.fopimage.load(1)) {
                fobj.getLogger().error("Cannot read background image dimensions: " + this.backgroundImage);
            }
        }
        this.initBorderInfo(pList, 0, 23, 25, 26, 156);
        this.initBorderInfo(pList, 1, 19, 21, 22, 155);
        this.initBorderInfo(pList, 2, 47, 49, 50, 161);
        this.initBorderInfo(pList, 3, 33, 35, 36, 158);
    }

    private void initBorderInfo(PropertyList pList, int side, int colorProp, int styleProp, int widthProp, int paddingProp) throws PropertyException {
        this.padding[side] = pList.get(paddingProp).getCondLength();
        int style = pList.get(styleProp).getEnum();
        if (style != 95) {
            this.setBorderInfo(new BorderInfo(style, pList.get(widthProp).getCondLength(), pList.get(colorProp).getColorType()), side);
        }
    }

    public void setBorderInfo(BorderInfo info, int side) {
        this.borderInfo[side] = info;
    }

    public BorderInfo getBorderInfo(int side) {
        return this.borderInfo[side];
    }

    public void setPadding(CommonBorderPaddingBackground source) {
        this.padding = source.padding;
    }

    public FopImage getFopImage() {
        return this.fopimage;
    }

    public int getBorderStartWidth(boolean bDiscard) {
        return this.getBorderWidth(2, bDiscard);
    }

    public int getBorderEndWidth(boolean bDiscard) {
        return this.getBorderWidth(3, bDiscard);
    }

    public int getBorderBeforeWidth(boolean bDiscard) {
        return this.getBorderWidth(0, bDiscard);
    }

    public int getBorderAfterWidth(boolean bDiscard) {
        return this.getBorderWidth(1, bDiscard);
    }

    public int getPaddingStart(boolean bDiscard, PercentBaseContext context) {
        return this.getPadding(2, bDiscard, context);
    }

    public int getPaddingEnd(boolean bDiscard, PercentBaseContext context) {
        return this.getPadding(3, bDiscard, context);
    }

    public int getPaddingBefore(boolean bDiscard, PercentBaseContext context) {
        return this.getPadding(0, bDiscard, context);
    }

    public int getPaddingAfter(boolean bDiscard, PercentBaseContext context) {
        return this.getPadding(1, bDiscard, context);
    }

    public int getBorderWidth(int side, boolean bDiscard) {
        if (this.borderInfo[side] == null || this.borderInfo[side].mStyle == 95 || this.borderInfo[side].mStyle == 57 || bDiscard && this.borderInfo[side].mWidth.isDiscard()) {
            return 0;
        }
        return this.borderInfo[side].mWidth.getLengthValue();
    }

    public ColorType getBorderColor(int side) {
        if (this.borderInfo[side] != null) {
            return this.borderInfo[side].mColor;
        }
        return null;
    }

    public int getBorderStyle(int side) {
        if (this.borderInfo[side] != null) {
            return this.borderInfo[side].mStyle;
        }
        return 95;
    }

    public int getPadding(int side, boolean bDiscard, PercentBaseContext context) {
        if (this.padding[side] == null || bDiscard && this.padding[side].isDiscard()) {
            return 0;
        }
        return this.padding[side].getLengthValue(context);
    }

    public CondLengthProperty getPaddingLengthProperty(int side) {
        return this.padding[side];
    }

    public int getIPPaddingAndBorder(boolean bDiscard, PercentBaseContext context) {
        return this.getPaddingStart(bDiscard, context) + this.getPaddingEnd(bDiscard, context) + this.getBorderStartWidth(bDiscard) + this.getBorderEndWidth(bDiscard);
    }

    public int getBPPaddingAndBorder(boolean bDiscard, PercentBaseContext context) {
        return this.getPaddingBefore(bDiscard, context) + this.getPaddingAfter(bDiscard, context) + this.getBorderBeforeWidth(bDiscard) + this.getBorderAfterWidth(bDiscard);
    }

    public String toString() {
        return "CommonBordersAndPadding (Before, After, Start, End):\nBorders: (" + this.getBorderBeforeWidth(false) + ", " + this.getBorderAfterWidth(false) + ", " + this.getBorderStartWidth(false) + ", " + this.getBorderEndWidth(false) + ")\n" + "Border Colors: (" + this.getBorderColor(0) + ", " + this.getBorderColor(1) + ", " + this.getBorderColor(2) + ", " + this.getBorderColor(3) + ")\n" + "Padding: (" + this.getPaddingBefore(false, null) + ", " + this.getPaddingAfter(false, null) + ", " + this.getPaddingStart(false, null) + ", " + this.getPaddingEnd(false, null) + ")\n";
    }

    public boolean hasBackground() {
        return this.backgroundColor != null || this.getFopImage() != null;
    }

    public boolean hasBorder() {
        return this.getBorderBeforeWidth(false) + this.getBorderAfterWidth(false) + this.getBorderStartWidth(false) + this.getBorderEndWidth(false) > 0;
    }

    public boolean hasPadding(PercentBaseContext context) {
        return this.getPaddingBefore(false, context) + this.getPaddingAfter(false, context) + this.getPaddingStart(false, context) + this.getPaddingEnd(false, context) > 0;
    }

    public boolean hasBorderInfo() {
        return this.borderInfo[0] != null || this.borderInfo[1] != null || this.borderInfo[2] != null || this.borderInfo[3] != null;
    }

    public static class BorderInfo
    implements Cloneable {
        private int mStyle;
        private ColorType mColor;
        private CondLengthProperty mWidth;

        BorderInfo(int style, CondLengthProperty width, ColorType color) {
            this.mStyle = style;
            this.mWidth = width;
            this.mColor = color;
        }

        public int getStyle() {
            return this.mStyle;
        }

        public ColorType getColor() {
            return this.mColor;
        }

        public CondLengthProperty getWidth() {
            return this.mWidth;
        }

        public int getRetainedWidth() {
            if (this.mStyle == 95 || this.mStyle == 57) {
                return 0;
            }
            return this.mWidth.getLengthValue();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("BorderInfo");
            sb.append(" {");
            sb.append(this.mStyle);
            sb.append(", ");
            sb.append(this.mColor);
            sb.append(", ");
            sb.append(this.mWidth);
            sb.append("}");
            return sb.toString();
        }
    }
}

