/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.image.ContextImageCache;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageCache;
import org.apache.fop.image.ImageMimeType;
import org.apache.fop.image.ImageProvider;
import org.apache.fop.image.analyser.ImageReaderFactory;

public final class ImageFactory {
    protected static Log log = LogFactory.getLog(class$org$apache$fop$image$FopImage == null ? (class$org$apache$fop$image$FopImage = ImageFactory.class$("org.apache.fop.image.FopImage")) : class$org$apache$fop$image$FopImage);
    private HashMap imageMimeTypes = new HashMap();
    private ImageCache cache = new ContextImageCache(true);
    static /* synthetic */ Class class$org$apache$fop$image$FopImage;
    static /* synthetic */ Class class$org$apache$fop$image$FopImage$ImageInfo;

    public ImageFactory() {
        ImageProvider jaiImage = new ImageProvider("JAIImage", "org.apache.fop.image.JAIImage");
        ImageProvider jimiImage = new ImageProvider("JIMIImage", "org.apache.fop.image.JimiImage");
        ImageProvider imageIoImage = new ImageProvider("ImageIOImage", "org.apache.fop.image.ImageIOImage");
        ImageProvider gifImage = new ImageProvider("GIFImage", "org.apache.fop.image.GifImage");
        ImageProvider jpegImage = new ImageProvider("JPEGImage", "org.apache.fop.image.JpegImage");
        ImageProvider jpegImageIOImage = new ImageProvider("JPEGImage", "org.apache.fop.image.JpegImageIOImage");
        ImageProvider bmpImage = new ImageProvider("BMPImage", "org.apache.fop.image.BmpImage");
        ImageProvider epsImage = new ImageProvider("EPSImage", "org.apache.fop.image.EPSImage");
        ImageProvider pngImage = new ImageProvider("PNGImage", "org.apache.fop.image.PNGImage");
        ImageProvider tiffImage = new ImageProvider("TIFFImage", "org.apache.fop.image.TIFFImage");
        ImageProvider xmlImage = new ImageProvider("XMLImage", "org.apache.fop.image.XMLImage");
        ImageProvider emfImage = new ImageProvider("EMFImage", "org.apache.fop.image.EmfImage");
        ImageMimeType imt = new ImageMimeType("image/gif");
        this.imageMimeTypes.put(imt.getMimeType(), imt);
        imt.addProvider(jaiImage);
        imt.addProvider(imageIoImage);
        imt.addProvider(jimiImage);
        imt.addProvider(gifImage);
        imt = new ImageMimeType("image/jpeg");
        this.imageMimeTypes.put(imt.getMimeType(), imt);
        imt.addProvider(jpegImageIOImage);
        imt.addProvider(jpegImage);
        imt = new ImageMimeType("image/bmp");
        this.imageMimeTypes.put(imt.getMimeType(), imt);
        imt.addProvider(bmpImage);
        imt = new ImageMimeType("image/eps");
        this.imageMimeTypes.put(imt.getMimeType(), imt);
        imt.addProvider(epsImage);
        imt = new ImageMimeType("image/png");
        this.imageMimeTypes.put(imt.getMimeType(), imt);
        imt.addProvider(pngImage);
        imt = new ImageMimeType("image/tga");
        this.imageMimeTypes.put(imt.getMimeType(), imt);
        imt.addProvider(jaiImage);
        imt.addProvider(imageIoImage);
        imt.addProvider(jimiImage);
        imt = new ImageMimeType("image/tiff");
        this.imageMimeTypes.put(imt.getMimeType(), imt);
        imt.addProvider(tiffImage);
        imt.addProvider(jaiImage);
        imt = new ImageMimeType("image/svg+xml");
        this.imageMimeTypes.put(imt.getMimeType(), imt);
        imt.addProvider(xmlImage);
        imt = new ImageMimeType("text/xml");
        this.imageMimeTypes.put(imt.getMimeType(), imt);
        imt.addProvider(xmlImage);
        imt = new ImageMimeType("image/emf");
        this.imageMimeTypes.put(imt.getMimeType(), imt);
        imt.addProvider(emfImage);
    }

    public static String getURL(String href) {
        return URISpecification.getURL(href);
    }

    public FopImage getImage(String url, FOUserAgent context) {
        return this.cache.getImage(url, context);
    }

    public void releaseImage(String url, FOUserAgent context) {
        this.cache.releaseImage(url, context);
    }

    public void removeContext(FOUserAgent context) {
        this.cache.removeContext(context);
    }

    public FopImage loadImage(String href, FOUserAgent ua) {
        Source source = ua.resolveURI(href);
        if (source == null) {
            return null;
        }
        InputStream in = null;
        if (source instanceof StreamSource) {
            in = ((StreamSource)source).getInputStream();
        }
        if (in == null) {
            try {
                in = new URL(source.getSystemId()).openStream();
            }
            catch (Exception ex) {
                log.error("Unable to obtain stream from id '" + source.getSystemId() + "'");
            }
        }
        if (in == null) {
            return null;
        }
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        FopImage.ImageInfo imgInfo = null;
        try {
            imgInfo = ImageReaderFactory.make(source.getSystemId(), in, ua);
        }
        catch (Exception e) {
            log.error("Error while recovering image information (" + href + ") : " + e.getMessage(), e);
            return null;
        }
        if (imgInfo == null) {
            try {
                in.close();
                in = null;
            }
            catch (Exception e) {
                log.debug("Error closing the InputStream for the image", e);
            }
            log.error("No ImageReader for this type of image (" + href + ")");
            return null;
        }
        String imgMimeType = imgInfo.mimeType;
        Class imageClass = this.getImageClass(imgMimeType);
        if (imageClass == null) {
            log.error("Unsupported image type (" + href + "): " + imgMimeType);
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Loading " + imgMimeType + " with " + imageClass.getName() + ": " + href);
        }
        Object imageInstance = null;
        try {
            Class[] imageConstructorParameters = new Class[]{class$org$apache$fop$image$FopImage$ImageInfo == null ? (class$org$apache$fop$image$FopImage$ImageInfo = ImageFactory.class$("org.apache.fop.image.FopImage$ImageInfo")) : class$org$apache$fop$image$FopImage$ImageInfo};
            Constructor imageConstructor = imageClass.getDeclaredConstructor(imageConstructorParameters);
            Object[] initArgs = new Object[]{imgInfo};
            imageInstance = imageConstructor.newInstance(initArgs);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            String msg = t != null ? t.getMessage() : ex.getMessage();
            log.error("Error creating FopImage object (" + href + "): " + msg, t == null ? ex : t);
            return null;
        }
        catch (InstantiationException ie) {
            log.error("Error creating FopImage object (" + href + "): Could not instantiate " + imageClass.getName() + " instance");
            return null;
        }
        catch (Exception ex) {
            log.error("Error creating FopImage object (" + href + "): " + ex.getMessage(), ex);
            return null;
        }
        if (!(imageInstance instanceof FopImage)) {
            log.error("Error creating FopImage object (" + href + "): " + "class " + imageClass.getName() + " doesn't implement org.apache.fop.image.FopImage interface");
            return null;
        }
        return imageInstance;
    }

    private Class getImageClass(String imgMimeType) {
        ImageMimeType imt = (ImageMimeType)this.imageMimeTypes.get(imgMimeType);
        if (imt == null) {
            return null;
        }
        return imt.getFirstImplementingClass();
    }

    public void clearCaches() {
        this.cache.clearAll();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

