/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;

public abstract class AbstractBaseLayoutManager
implements LayoutManager,
PercentBaseContext {
    protected boolean generatesReferenceArea = false;
    protected boolean generatesBlockArea = false;
    protected FObj fobj = null;
    protected static Log log = LogFactory.getLog(class$org$apache$fop$layoutmgr$LayoutManager == null ? (class$org$apache$fop$layoutmgr$LayoutManager = AbstractBaseLayoutManager.class$("org.apache.fop.layoutmgr.LayoutManager")) : class$org$apache$fop$layoutmgr$LayoutManager);
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$LayoutManager;

    public AbstractBaseLayoutManager() {
    }

    public AbstractBaseLayoutManager(FObj fo) {
        this.fobj = fo;
        this.setGeneratesReferenceArea(fo.generatesReferenceAreas());
        if (this.getGeneratesReferenceArea()) {
            this.setGeneratesBlockArea(true);
        }
    }

    public int getBaseLength(int lengthBase, FObj fobj) {
        if (fobj == this.getFObj()) {
            switch (lengthBase) {
                case 5: {
                    return this.getAncestorBlockAreaIPD();
                }
                case 6: {
                    return this.getAncestorBlockAreaBPD();
                }
                case 3: {
                    return this.getParentAreaIPD();
                }
                case 4: {
                    return this.getReferenceAreaIPD();
                }
            }
            log.error(new Exception("Unknown base type for LengthBase:" + lengthBase));
            return 0;
        }
        LayoutManager lm = this.getParent();
        while (lm != null && fobj != lm.getFObj()) {
            lm = lm.getParent();
        }
        if (lm != null) {
            return lm.getBaseLength(lengthBase, fobj);
        }
        log.error("Cannot find LM to handle given FO for LengthBase.");
        return 0;
    }

    protected int getAncestorBlockAreaIPD() {
        LayoutManager lm = this.getParent();
        while (lm != null) {
            if (lm.getGeneratesBlockArea() && !lm.getGeneratesLineArea()) {
                return lm.getContentAreaIPD();
            }
            lm = lm.getParent();
        }
        if (lm == null) {
            log.error("No parent LM found");
        }
        return 0;
    }

    protected int getAncestorBlockAreaBPD() {
        LayoutManager lm = this.getParent();
        while (lm != null) {
            if (lm.getGeneratesBlockArea() && !lm.getGeneratesLineArea()) {
                return lm.getContentAreaBPD();
            }
            lm = lm.getParent();
        }
        if (lm == null) {
            log.error("No parent LM found");
        }
        return 0;
    }

    protected int getParentAreaIPD() {
        LayoutManager lm = this.getParent();
        if (lm != null) {
            return lm.getContentAreaIPD();
        }
        log.error("No parent LM found");
        return 0;
    }

    protected int getParentAreaBPD() {
        LayoutManager lm = this.getParent();
        if (lm != null) {
            return lm.getContentAreaBPD();
        }
        log.error("No parent LM found");
        return 0;
    }

    public int getReferenceAreaIPD() {
        LayoutManager lm = this.getParent();
        while (lm != null) {
            if (lm.getGeneratesReferenceArea()) {
                return lm.getContentAreaIPD();
            }
            lm = lm.getParent();
        }
        if (lm == null) {
            log.error("No parent LM found");
        }
        return 0;
    }

    protected int getReferenceAreaBPD() {
        LayoutManager lm = this.getParent();
        while (lm != null) {
            if (lm.getGeneratesReferenceArea()) {
                return lm.getContentAreaBPD();
            }
            lm = lm.getParent();
        }
        if (lm == null) {
            log.error("No parent LM found");
        }
        return 0;
    }

    public int getContentAreaIPD() {
        log.error("getContentAreaIPD called when it should have been overwritten");
        return 0;
    }

    public int getContentAreaBPD() {
        log.error("getContentAreaBPD called when it should have been overwritten");
        return 0;
    }

    public boolean getGeneratesReferenceArea() {
        return this.generatesReferenceArea;
    }

    protected void setGeneratesReferenceArea(boolean generatesReferenceArea) {
        this.generatesReferenceArea = generatesReferenceArea;
    }

    public boolean getGeneratesBlockArea() {
        return this.generatesBlockArea;
    }

    protected void setGeneratesBlockArea(boolean generatesBlockArea) {
        this.generatesBlockArea = generatesBlockArea;
    }

    public boolean getGeneratesLineArea() {
        return false;
    }

    public FObj getFObj() {
        return this.fobj;
    }

    public abstract Position notifyPos(Position var1);

    public abstract LinkedList getChangedKnuthElements(List var1, int var2);

    public abstract LinkedList getNextKnuthElements(LayoutContext var1, int var2);

    public abstract void addChildLMs(List var1);

    public abstract void addChildLM(LayoutManager var1);

    public abstract List getChildLMs();

    public abstract boolean createNextChildLMs(int var1);

    public abstract void addAreas(PositionIterator var1, LayoutContext var2);

    public abstract void addChildArea(Area var1);

    public abstract Area getParentArea(Area var1);

    public abstract void setFinished(boolean var1);

    public abstract boolean isFinished();

    public abstract void resetPosition(Position var1);

    public abstract PageSequenceLayoutManager getPSLM();

    public abstract void initialize();

    public abstract LayoutManager getParent();

    public abstract void setParent(LayoutManager var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

