/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.CTM;
import org.apache.fop.area.Trait;
import org.apache.fop.datatypes.FODimension;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.properties.CommonAbsolutePosition;
import org.apache.fop.layoutmgr.AbstractBaseLayoutManager;
import org.apache.fop.layoutmgr.AbstractBreaker;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.ConditionalElementListener;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.RelSide;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class BlockContainerLayoutManager
extends BlockStackingLayoutManager
implements ConditionalElementListener {
    private BlockViewport viewportBlockArea;
    private Block referenceArea;
    private CommonAbsolutePosition abProps;
    private FODimension relDims;
    private CTM absoluteCTM;
    private Length width;
    private Length height;
    private int vpContentBPD;
    private boolean autoHeight = true;
    private MinOptMax foBlockSpaceBefore;
    private MinOptMax foBlockSpaceAfter;
    private boolean discardBorderBefore;
    private boolean discardBorderAfter;
    private boolean discardPaddingBefore;
    private boolean discardPaddingAfter;
    private MinOptMax effSpaceBefore;
    private MinOptMax effSpaceAfter;

    public BlockContainerLayoutManager(BlockContainer node) {
        super(node);
    }

    public void initialize() {
        boolean rotated;
        this.abProps = this.getBlockContainerFO().getCommonAbsolutePosition();
        this.foBlockSpaceBefore = new SpaceVal(this.getBlockContainerFO().getCommonMarginBlock().spaceBefore, this).getSpace();
        this.foBlockSpaceAfter = new SpaceVal(this.getBlockContainerFO().getCommonMarginBlock().spaceAfter, this).getSpace();
        this.startIndent = this.getBlockContainerFO().getCommonMarginBlock().startIndent.getValue(this);
        this.endIndent = this.getBlockContainerFO().getCommonMarginBlock().endIndent.getValue(this);
        boolean bl = rotated = this.getBlockContainerFO().getReferenceOrientation() % 180 != 0;
        if (rotated) {
            this.height = this.getBlockContainerFO().getInlineProgressionDimension().getOptimum(this).getLength();
            this.width = this.getBlockContainerFO().getBlockProgressionDimension().getOptimum(this).getLength();
        } else {
            this.height = this.getBlockContainerFO().getBlockProgressionDimension().getOptimum(this).getLength();
            this.width = this.getBlockContainerFO().getInlineProgressionDimension().getOptimum(this).getLength();
        }
        this.bpUnit = 0;
        if (this.bpUnit == 0) {
            this.adjustedSpaceBefore = this.getBlockContainerFO().getCommonMarginBlock().spaceBefore.getSpace().getOptimum(this).getLength().getValue(this);
            this.adjustedSpaceAfter = this.getBlockContainerFO().getCommonMarginBlock().spaceAfter.getSpace().getOptimum(this).getLength().getValue(this);
        } else {
            this.adjustedSpaceBefore = this.getBlockContainerFO().getCommonMarginBlock().spaceBefore.getSpace().getMinimum(this).getLength().getValue(this);
            this.adjustedSpaceAfter = this.getBlockContainerFO().getCommonMarginBlock().spaceAfter.getSpace().getMinimum(this).getLength().getValue(this);
        }
    }

    private void resetSpaces() {
        this.discardBorderBefore = false;
        this.discardBorderAfter = false;
        this.discardPaddingBefore = false;
        this.discardPaddingAfter = false;
        this.effSpaceBefore = null;
        this.effSpaceAfter = null;
    }

    protected int getRotatedIPD() {
        return this.getBlockContainerFO().getInlineProgressionDimension().getOptimum(this).getLength().getValue(this);
    }

    private boolean needClip() {
        int overflow = this.getBlockContainerFO().getOverflow();
        return overflow == 57 || overflow == 42;
    }

    private int getSpaceBefore() {
        return this.foBlockSpaceBefore.opt;
    }

    private int getBPIndents() {
        int indents = 0;
        return indents += this.getBlockContainerFO().getCommonBorderPaddingBackground().getBPPaddingAndBorder(false, this);
    }

    private boolean isAbsoluteOrFixed() {
        return this.abProps.absolutePosition == 1 || this.abProps.absolutePosition == 51;
    }

    private boolean isFixed() {
        return this.abProps.absolutePosition == 51;
    }

    public int getContentAreaBPD() {
        if (this.autoHeight) {
            return -1;
        }
        return this.vpContentBPD;
    }

    /*
     * WARNING - void declaration
     */
    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        int allocBPD;
        this.resetSpaces();
        if (this.isAbsoluteOrFixed()) {
            return this.getNextKnuthElementsAbsolute(context, alignment);
        }
        this.autoHeight = false;
        int maxbpd = context.getStackLimit().opt;
        if (this.height.getEnum() == 9 || !this.height.isAbsolute() && this.getAncestorBlockAreaBPD() <= 0) {
            allocBPD = maxbpd;
            this.autoHeight = true;
        } else {
            allocBPD = this.height.getValue(this);
            allocBPD += this.getBPIndents();
        }
        this.vpContentBPD = allocBPD - this.getBPIndents();
        this.referenceIPD = context.getRefIPD();
        if (this.width.getEnum() == 9) {
            this.updateContentAreaIPDwithOverconstrainedAdjust();
        } else {
            int contentWidth = this.width.getValue(this);
            this.updateContentAreaIPDwithOverconstrainedAdjust(contentWidth);
        }
        double contentRectOffsetX = 0.0;
        double contentRectOffsetY = 0.0;
        contentRectOffsetY += (double)this.getBlockContainerFO().getCommonBorderPaddingBackground().getBorderBeforeWidth(false);
        Rectangle2D.Double rect = new Rectangle2D.Double(contentRectOffsetX += (double)this.getBlockContainerFO().getCommonMarginBlock().startIndent.getValue(this), contentRectOffsetY += (double)this.getBlockContainerFO().getCommonBorderPaddingBackground().getPaddingBefore(false, this), this.getContentAreaIPD(), this.getContentAreaBPD());
        this.relDims = new FODimension(0, 0);
        this.absoluteCTM = CTM.getCTMandRelDims(this.getBlockContainerFO().getReferenceOrientation(), this.getBlockContainerFO().getWritingMode(), rect, this.relDims);
        int availableIPD = this.referenceIPD - this.getIPIndents();
        if (((RectangularShape)rect).getWidth() > (double)availableIPD) {
            AbstractBaseLayoutManager.log.warn(FONode.decorateWithContextInfo("The extent in inline-progression-direction (width) of a block-container is bigger than the available space (" + ((RectangularShape)rect).getWidth() + "mpt > " + context.getRefIPD() + "mpt)", this.getBlockContainerFO()));
        }
        MinOptMax stackLimit = new MinOptMax(this.relDims.bpd);
        LinkedList returnedList = null;
        LinkedList contentList = new LinkedList();
        LinkedList<KnuthBox> returnList = new LinkedList<KnuthBox>();
        if (!this.breakBeforeServed) {
            try {
                if (this.addKnuthElementsForBreakBefore(returnList, context)) {
                    LinkedList<KnuthBox> linkedList = returnList;
                    Object var17_17 = null;
                    this.breakBeforeServed = true;
                    return linkedList;
                }
                Object var17_18 = null;
                this.breakBeforeServed = true;
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                this.breakBeforeServed = true;
                throw throwable;
            }
        }
        if (!this.firstVisibleMarkServed) {
            this.addKnuthElementsForSpaceBefore(returnList, alignment);
        }
        this.addKnuthElementsForBorderPaddingBefore(returnList, !this.firstVisibleMarkServed);
        this.firstVisibleMarkServed = true;
        if (this.autoHeight) {
            BlockLevelLayoutManager curLM;
            this.addPendingMarks(context);
            BlockLevelLayoutManager prevLM = null;
            while ((curLM = (BlockLevelLayoutManager)this.getChildLM()) != null) {
                void var15_15;
                LayoutContext childLC = new LayoutContext(0);
                childLC.copyPendingMarksFrom(context);
                childLC.setStackLimit(MinOptMax.subtract(context.getStackLimit(), stackLimit));
                childLC.setRefIPD(this.relDims.ipd);
                childLC.setWritingMode(this.getBlockContainerFO().getWritingMode());
                returnedList = var15_15.getNextKnuthElements(childLC, alignment);
                if (returnedList.size() == 1 && ((ListElement)returnedList.getFirst()).isForcedBreak()) {
                    contentList.addAll(returnedList);
                    returnedList = new LinkedList();
                    this.wrapPositionElements(contentList, returnList);
                    return returnList;
                }
                if (prevLM != null) {
                    if (this.mustKeepTogether() || prevLM.mustKeepWithNext() || var15_15.mustKeepWithPrevious()) {
                        contentList.add(new BreakElement(new Position(this), 1000, context));
                    } else if (!((ListElement)contentList.getLast()).isGlue()) {
                        contentList.add(new BreakElement(new Position(this), 0, context));
                    }
                }
                contentList.addAll(returnedList);
                if (returnedList.size() == 0) continue;
                if (((ListElement)returnedList.getLast()).isForcedBreak()) {
                    if (var15_15.isFinished()) {
                        this.setFinished(true);
                    }
                    returnedList = new LinkedList();
                    this.wrapPositionElements(contentList, returnList);
                    return returnList;
                }
                prevLM = var15_15;
            }
            returnedList = new LinkedList();
            this.wrapPositionElements(contentList, returnList);
        } else {
            MinOptMax range = new MinOptMax(this.relDims.ipd);
            BlockContainerBreaker breaker = new BlockContainerBreaker(this, range);
            breaker.doLayout(this.relDims.bpd, this.autoHeight);
            boolean contentOverflows = false;
            if (!breaker.isEmpty()) {
                contentOverflows = breaker.deferredAlg.getPageBreaks().size() > 1;
            }
            BlockContainerPosition bcPosition = new BlockContainerPosition(this, breaker);
            returnList.add(new KnuthBox(this.vpContentBPD, this.notifyPos(bcPosition), false));
            if (contentOverflows) {
                AbstractBaseLayoutManager.log.warn("Contents overflow block-container viewport: clipping");
                if (this.getBlockContainerFO().getOverflow() == 42) {
                    // empty if block
                }
            }
        }
        this.addKnuthElementsForBorderPaddingAfter(returnList, true);
        this.addKnuthElementsForSpaceAfter(returnList, alignment);
        this.addKnuthElementsForBreakAfter(returnList, context);
        this.setFinished(true);
        return returnList;
    }

    private LinkedList getNextKnuthElementsAbsolute(LayoutContext context, int alignment) {
        int allocIPD;
        int allocBPD;
        this.autoHeight = false;
        Point offset = this.getAbsOffset();
        if (this.height.getEnum() == 9 || !this.height.isAbsolute() && this.getAncestorBlockAreaBPD() <= 0) {
            allocBPD = 0;
            if (this.abProps.bottom.getEnum() != 9) {
                int availHeight = this.isFixed() ? (int)this.getCurrentPV().getViewArea().getHeight() : context.getStackLimit().opt;
                allocBPD = availHeight;
                allocBPD -= offset.y;
                if (this.abProps.bottom.getEnum() != 9) {
                    if ((allocBPD -= this.abProps.bottom.getValue(this)) < 0) {
                        allocBPD = 0;
                    }
                } else if (allocBPD < 0) {
                    allocBPD = 0;
                }
            } else {
                this.autoHeight = true;
            }
        } else {
            allocBPD = this.height.getValue(this);
            allocBPD += this.getBPIndents();
        }
        if (this.width.getEnum() == 9) {
            int availWidth = this.isFixed() ? (int)this.getCurrentPV().getViewArea().getWidth() : context.getRefIPD();
            allocIPD = availWidth;
            if (this.abProps.left.getEnum() != 9) {
                allocIPD -= this.abProps.left.getValue(this);
            }
            if (this.abProps.right.getEnum() != 9) {
                if ((allocIPD -= this.abProps.right.getValue(this)) < 0) {
                    allocIPD = 0;
                }
            } else if (allocIPD < 0) {
                allocIPD = 0;
            }
        } else {
            allocIPD = this.width.getValue(this);
            allocIPD += this.getIPIndents();
        }
        this.vpContentBPD = allocBPD - this.getBPIndents();
        this.setContentAreaIPD(allocIPD - this.getIPIndents());
        double contentRectOffsetX = offset.getX();
        double contentRectOffsetY = offset.getY();
        contentRectOffsetY += (double)this.getSpaceBefore();
        contentRectOffsetY += (double)this.getBlockContainerFO().getCommonBorderPaddingBackground().getBorderBeforeWidth(false);
        Rectangle2D.Double rect = new Rectangle2D.Double(contentRectOffsetX += (double)this.getBlockContainerFO().getCommonMarginBlock().startIndent.getValue(this), contentRectOffsetY += (double)this.getBlockContainerFO().getCommonBorderPaddingBackground().getPaddingBefore(false, this), this.getContentAreaIPD(), this.vpContentBPD);
        this.relDims = new FODimension(0, 0);
        this.absoluteCTM = CTM.getCTMandRelDims(this.getBlockContainerFO().getReferenceOrientation(), this.getBlockContainerFO().getWritingMode(), rect, this.relDims);
        MinOptMax range = new MinOptMax(this.relDims.ipd);
        BlockContainerBreaker breaker = new BlockContainerBreaker(this, range);
        breaker.doLayout(this.relDims.bpd, this.autoHeight);
        boolean contentOverflows = breaker.isOverflow();
        LinkedList<KnuthBox> returnList = new LinkedList<KnuthBox>();
        if (!breaker.isEmpty()) {
            BlockContainerPosition bcPosition = new BlockContainerPosition(this, breaker);
            returnList.add(new KnuthBox(0, this.notifyPos(bcPosition), false));
            if (!this.autoHeight & contentOverflows) {
                AbstractBaseLayoutManager.log.warn("Contents overflow block-container viewport: clipping");
                if (this.getBlockContainerFO().getOverflow() == 42) {
                    // empty if block
                }
            }
        }
        this.setFinished(true);
        return returnList;
    }

    private Point getAbsOffset() {
        int x = 0;
        int y = 0;
        if (this.abProps.left.getEnum() != 9) {
            x = this.abProps.left.getValue(this);
        }
        if (this.abProps.top.getEnum() != 9) {
            y = this.abProps.top.getValue(this);
        }
        return new Point(x, y);
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        this.getParentArea(null);
        if (layoutContext.getSpaceBefore() > 0) {
            this.addBlockSpacing(0.0, new MinOptMax(layoutContext.getSpaceBefore()));
        }
        LayoutManager childLM = null;
        LayoutManager lastLM = null;
        LayoutContext lc = new LayoutContext(0);
        lc.setSpaceAdjust(layoutContext.getSpaceAdjust());
        if (layoutContext.getSpaceAfter() > 0) {
            lc.setSpaceAfter(layoutContext.getSpaceAfter());
        }
        BlockContainerPosition bcpos = null;
        LinkedList<Position> positionList = new LinkedList<Position>();
        boolean bSpaceBefore = false;
        boolean bSpaceAfter = false;
        Position firstPos = null;
        Position lastPos = null;
        while (parentIter.hasNext()) {
            Position pos = (Position)parentIter.next();
            if (pos.getIndex() >= 0) {
                if (firstPos == null) {
                    firstPos = pos;
                }
                lastPos = pos;
            }
            Position innerPosition = null;
            if (pos instanceof NonLeafPosition) {
                innerPosition = ((NonLeafPosition)pos).getPosition();
            }
            if (pos instanceof BlockContainerPosition) {
                if (bcpos != null) {
                    throw new IllegalStateException("Only one BlockContainerPosition allowed");
                }
                bcpos = (BlockContainerPosition)pos;
                continue;
            }
            if (innerPosition == null) {
                if (!(pos instanceof NonLeafPosition)) continue;
                if (positionList.size() == 0 && bcpos == null) {
                    bSpaceBefore = true;
                    continue;
                }
                bSpaceAfter = true;
                continue;
            }
            if (innerPosition.getLM() == this && !(innerPosition instanceof BlockStackingLayoutManager.MappingPosition)) continue;
            positionList.add(innerPosition);
            lastLM = innerPosition.getLM();
        }
        this.getPSLM().addIDToPage(this.getBlockContainerFO().getId());
        if (this.markers != null) {
            this.getCurrentPV().addMarkers(this.markers, true, this.isFirst(firstPos), this.isLast(lastPos));
        }
        if (bcpos == null) {
            PositionIterator childPosIter;
            if (this.bpUnit == 0) {
                childPosIter = new BlockStackingLayoutManager.StackingIter(positionList.listIterator());
            } else {
                LinkedList<KnuthElement> splitList = new LinkedList<KnuthElement>();
                int splitLength = 0;
                int iFirst = ((BlockStackingLayoutManager.MappingPosition)positionList.getFirst()).getFirstIndex();
                int iLast = ((BlockStackingLayoutManager.MappingPosition)positionList.getLast()).getLastIndex();
                ListIterator storedListIterator = this.storedList.listIterator(iFirst);
                while (storedListIterator.nextIndex() <= iLast) {
                    KnuthElement element = (KnuthElement)storedListIterator.next();
                    if (element.getLayoutManager() == this) continue;
                    splitList.add(element);
                    splitLength += element.getW();
                    lastLM = element.getLayoutManager();
                }
                if (bSpaceBefore && bSpaceAfter) {
                    this.foBlockSpaceBefore = new SpaceVal(this.getBlockContainerFO().getCommonMarginBlock().spaceBefore, this).getSpace();
                    this.foBlockSpaceAfter = new SpaceVal(this.getBlockContainerFO().getCommonMarginBlock().spaceAfter, this).getSpace();
                    this.adjustedSpaceBefore = (this.neededUnits(splitLength + this.foBlockSpaceBefore.min + this.foBlockSpaceAfter.min) * this.bpUnit - splitLength) / 2;
                    this.adjustedSpaceAfter = this.neededUnits(splitLength + this.foBlockSpaceBefore.min + this.foBlockSpaceAfter.min) * this.bpUnit - splitLength - this.adjustedSpaceBefore;
                } else if (bSpaceBefore) {
                    this.adjustedSpaceBefore = this.neededUnits(splitLength + this.foBlockSpaceBefore.min) * this.bpUnit - splitLength;
                } else {
                    this.adjustedSpaceAfter = this.neededUnits(splitLength + this.foBlockSpaceAfter.min) * this.bpUnit - splitLength;
                }
                childPosIter = new KnuthPossPosIter(splitList, 0, splitList.size());
            }
            while ((childLM = childPosIter.getNextChildLM()) != null) {
                lc.setFlags(128, layoutContext.isLastArea() && childLM == lastLM);
                lc.setStackLimit(layoutContext.getStackLimit());
                childLM.addAreas(childPosIter, lc);
            }
        } else {
            bcpos.getBreaker().addContainedAreas();
        }
        if (this.markers != null) {
            this.getCurrentPV().addMarkers(this.markers, false, this.isFirst(firstPos), this.isLast(lastPos));
        }
        TraitSetter.addSpaceBeforeAfter(this.viewportBlockArea, layoutContext.getSpaceAdjust(), this.effSpaceBefore, this.effSpaceAfter);
        this.flush();
        this.viewportBlockArea = null;
        this.referenceArea = null;
        this.resetSpaces();
    }

    public Area getParentArea(Area childArea) {
        if (this.referenceArea == null) {
            this.viewportBlockArea = new BlockViewport();
            this.viewportBlockArea.addTrait(Trait.IS_VIEWPORT_AREA, Boolean.TRUE);
            this.viewportBlockArea.setIPD(this.getContentAreaIPD());
            if (this.autoHeight) {
                this.viewportBlockArea.setBPD(0);
            } else {
                this.viewportBlockArea.setBPD(this.getContentAreaBPD());
            }
            TraitSetter.setProducerID(this.viewportBlockArea, this.getBlockContainerFO().getId());
            TraitSetter.addBorders(this.viewportBlockArea, this.getBlockContainerFO().getCommonBorderPaddingBackground(), this.discardBorderBefore, this.discardBorderAfter, false, false, this);
            TraitSetter.addPadding(this.viewportBlockArea, this.getBlockContainerFO().getCommonBorderPaddingBackground(), this.discardPaddingBefore, this.discardPaddingAfter, false, false, this);
            TraitSetter.addMargins(this.viewportBlockArea, this.getBlockContainerFO().getCommonBorderPaddingBackground(), this.startIndent, this.endIndent, this);
            this.viewportBlockArea.setCTM(this.absoluteCTM);
            this.viewportBlockArea.setClip(this.needClip());
            if (this.abProps.absolutePosition == 1 || this.abProps.absolutePosition == 51) {
                Point offset = this.getAbsOffset();
                this.viewportBlockArea.setXOffset(offset.x);
                this.viewportBlockArea.setYOffset(offset.y);
            }
            this.referenceArea = new Block();
            this.referenceArea.addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
            TraitSetter.setProducerID(this.referenceArea, this.getBlockContainerFO().getId());
            if (this.abProps.absolutePosition == 1) {
                this.viewportBlockArea.setPositioning(2);
            } else if (this.abProps.absolutePosition == 51) {
                this.viewportBlockArea.setPositioning(3);
            }
            this.parentLM.getParentArea(this.referenceArea);
            this.referenceArea.setIPD(this.relDims.ipd);
            this.setCurrentArea(this.viewportBlockArea);
        }
        return this.referenceArea;
    }

    public void addChildArea(Area childArea) {
        if (this.referenceArea != null) {
            this.referenceArea.addBlock((Block)childArea);
        }
    }

    public void resetPosition(Position resetPos) {
        if (resetPos == null) {
            this.reset(null);
        }
    }

    protected void flush() {
        this.viewportBlockArea.addBlock(this.referenceArea, this.autoHeight);
        TraitSetter.addBackground(this.viewportBlockArea, this.getBlockContainerFO().getCommonBorderPaddingBackground(), this);
        int saveBPD = this.viewportBlockArea.getBPD();
        if (this.viewportBlockArea.getPositioning() == 2) {
            this.viewportBlockArea.setBPD(0);
        }
        super.flush();
        if (this.viewportBlockArea.getPositioning() == 2) {
            this.viewportBlockArea.setBPD(saveBPD);
        }
    }

    public int negotiateBPDAdjustment(int adj, KnuthElement lastElement) {
        return 0;
    }

    public void discardSpace(KnuthGlue spaceGlue) {
    }

    public boolean mustKeepTogether() {
        return ((BlockLevelLayoutManager)this.getParent()).mustKeepTogether() || !this.getBlockContainerFO().getKeepTogether().getWithinPage().isAuto() || !this.getBlockContainerFO().getKeepTogether().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithPrevious() {
        return !this.getBlockContainerFO().getKeepWithPrevious().getWithinPage().isAuto() || !this.getBlockContainerFO().getKeepWithPrevious().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithNext() {
        return !this.getBlockContainerFO().getKeepWithNext().getWithinPage().isAuto() || !this.getBlockContainerFO().getKeepWithNext().getWithinColumn().isAuto();
    }

    protected BlockContainer getBlockContainerFO() {
        return (BlockContainer)this.fobj;
    }

    public boolean getGeneratesReferenceArea() {
        return true;
    }

    public boolean getGeneratesBlockArea() {
        return true;
    }

    public void notifySpace(RelSide side, MinOptMax effectiveLength) {
        if (RelSide.BEFORE == side) {
            if (AbstractBaseLayoutManager.log.isDebugEnabled()) {
                AbstractBaseLayoutManager.log.debug(this + ": Space " + side + ", " + this.effSpaceBefore + "-> " + effectiveLength);
            }
            this.effSpaceBefore = effectiveLength;
        } else {
            if (AbstractBaseLayoutManager.log.isDebugEnabled()) {
                AbstractBaseLayoutManager.log.debug(this + ": Space " + side + ", " + this.effSpaceAfter + "-> " + effectiveLength);
            }
            this.effSpaceAfter = effectiveLength;
        }
    }

    public void notifyBorder(RelSide side, MinOptMax effectiveLength) {
        if (effectiveLength == null) {
            if (RelSide.BEFORE == side) {
                this.discardBorderBefore = true;
            } else {
                this.discardBorderAfter = true;
            }
        }
        if (AbstractBaseLayoutManager.log.isDebugEnabled()) {
            AbstractBaseLayoutManager.log.debug(this + ": Border " + side + " -> " + effectiveLength);
        }
    }

    public void notifyPadding(RelSide side, MinOptMax effectiveLength) {
        if (effectiveLength == null) {
            if (RelSide.BEFORE == side) {
                this.discardPaddingBefore = true;
            } else {
                this.discardPaddingAfter = true;
            }
        }
        if (AbstractBaseLayoutManager.log.isDebugEnabled()) {
            AbstractBaseLayoutManager.log.debug(this + ": Padding " + side + " -> " + effectiveLength);
        }
    }

    private class BlockContainerBreaker
    extends AbstractBreaker {
        private BlockContainerLayoutManager bclm;
        private MinOptMax ipd;
        private PageBreakingAlgorithm deferredAlg;
        private AbstractBreaker.BlockSequence deferredOriginalList;
        private AbstractBreaker.BlockSequence deferredEffectiveList;

        public BlockContainerBreaker(BlockContainerLayoutManager bclm, MinOptMax ipd) {
            this.bclm = bclm;
            this.ipd = ipd;
        }

        protected void observeElementList(List elementList) {
            ElementListObserver.observe(elementList, "block-container", this.bclm.getBlockContainerFO().getId());
        }

        protected boolean isPartOverflowRecoveryActivated() {
            return false;
        }

        public int getDifferenceOfFirstPart() {
            AbstractBreaker.PageBreakPosition pbp = (AbstractBreaker.PageBreakPosition)this.deferredAlg.getPageBreaks().getFirst();
            return pbp.difference;
        }

        public boolean isOverflow() {
            if (this.isEmpty()) {
                return false;
            }
            return this.deferredAlg.getPageBreaks().size() > 1;
        }

        protected LayoutManager getTopLevelLM() {
            return this.bclm;
        }

        protected LayoutContext createLayoutContext() {
            LayoutContext lc = super.createLayoutContext();
            lc.setRefIPD(this.ipd.opt);
            lc.setWritingMode(BlockContainerLayoutManager.this.getBlockContainerFO().getWritingMode());
            return lc;
        }

        /*
         * WARNING - void declaration
         */
        protected LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
            LayoutManager curLM;
            LinkedList returnList = new LinkedList();
            while ((curLM = BlockContainerLayoutManager.this.getChildLM()) != null) {
                void var3_4;
                LayoutContext childLC = new LayoutContext(0);
                childLC.setStackLimit(context.getStackLimit());
                childLC.setRefIPD(context.getRefIPD());
                childLC.setWritingMode(BlockContainerLayoutManager.this.getBlockContainerFO().getWritingMode());
                LinkedList returnedList = null;
                if (!var3_4.isFinished()) {
                    returnedList = var3_4.getNextKnuthElements(childLC, alignment);
                }
                if (returnedList == null) continue;
                this.bclm.wrapPositionElements(returnedList, returnList);
            }
            SpaceResolver.resolveElementList(returnList);
            BlockContainerLayoutManager.this.setFinished(true);
            return returnList;
        }

        protected int getCurrentDisplayAlign() {
            return BlockContainerLayoutManager.this.getBlockContainerFO().getDisplayAlign();
        }

        protected boolean hasMoreContent() {
            return !BlockContainerLayoutManager.this.isFinished();
        }

        protected void addAreas(PositionIterator posIter, LayoutContext context) {
            AreaAdditionUtil.addAreas(this.bclm, posIter, context);
        }

        protected void doPhase3(PageBreakingAlgorithm alg, int partCount, AbstractBreaker.BlockSequence originalList, AbstractBreaker.BlockSequence effectiveList) {
            this.deferredAlg = alg;
            this.deferredOriginalList = originalList;
            this.deferredEffectiveList = effectiveList;
        }

        protected void finishPart(PageBreakingAlgorithm alg, AbstractBreaker.PageBreakPosition pbp) {
        }

        protected LayoutManager getCurrentChildLM() {
            return BlockContainerLayoutManager.this.curChildLM;
        }

        public void addContainedAreas() {
            if (this.isEmpty()) {
                return;
            }
            this.addAreas(this.deferredAlg, this.deferredAlg.getPageBreaks().size(), this.deferredOriginalList, this.deferredEffectiveList);
        }
    }

    private class BlockContainerPosition
    extends NonLeafPosition {
        private BlockContainerBreaker breaker;

        public BlockContainerPosition(LayoutManager lm, BlockContainerBreaker breaker) {
            super(lm, null);
            this.breaker = breaker;
        }

        public BlockContainerBreaker getBreaker() {
            return this.breaker;
        }
    }
}

