/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class SpaceSpecifier
implements Cloneable {
    private boolean startsReferenceArea;
    private boolean hasForcing = false;
    private List spaceVals = new ArrayList();

    public SpaceSpecifier(boolean startsReferenceArea) {
        this.startsReferenceArea = startsReferenceArea;
    }

    public Object clone() {
        try {
            SpaceSpecifier ss = (SpaceSpecifier)super.clone();
            ss.startsReferenceArea = this.startsReferenceArea;
            ss.hasForcing = this.hasForcing;
            ss.spaceVals = new ArrayList();
            ss.spaceVals.addAll(this.spaceVals);
            return ss;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public void clear() {
        this.hasForcing = false;
        this.spaceVals.clear();
    }

    public boolean hasSpaces() {
        return this.spaceVals.size() > 0;
    }

    public void addSpace(SpaceVal moreSpace) {
        if (!(this.startsReferenceArea && moreSpace.isConditional() && this.spaceVals.isEmpty())) {
            if (moreSpace.isForcing()) {
                if (!this.hasForcing) {
                    this.spaceVals.clear();
                    this.hasForcing = true;
                }
                this.spaceVals.add(moreSpace);
            } else if (!(this.hasForcing || moreSpace.getSpace().min == 0 && moreSpace.getSpace().opt == 0 && moreSpace.getSpace().max == 0)) {
                this.spaceVals.add(moreSpace);
            }
        }
    }

    public MinOptMax resolve(boolean endsReferenceArea) {
        int lastIndex = this.spaceVals.size();
        if (endsReferenceArea) {
            while (lastIndex > 0) {
                SpaceVal spaceVal = (SpaceVal)this.spaceVals.get(lastIndex - 1);
                if (!spaceVal.isConditional()) break;
                --lastIndex;
            }
        }
        MinOptMax resolvedSpace = new MinOptMax(0);
        int maxPrecedence = -1;
        int index = 0;
        while (index < lastIndex) {
            SpaceVal spaceVal = (SpaceVal)this.spaceVals.get(index);
            if (this.hasForcing) {
                resolvedSpace.add(spaceVal.getSpace());
            } else if (spaceVal.getPrecedence() > maxPrecedence) {
                maxPrecedence = spaceVal.getPrecedence();
                resolvedSpace = spaceVal.getSpace();
            } else if (spaceVal.getPrecedence() == maxPrecedence) {
                if (spaceVal.getSpace().opt > resolvedSpace.opt) {
                    resolvedSpace = spaceVal.getSpace();
                } else if (spaceVal.getSpace().opt == resolvedSpace.opt) {
                    if (resolvedSpace.min < spaceVal.getSpace().min) {
                        resolvedSpace.min = spaceVal.getSpace().min;
                    }
                    if (resolvedSpace.max > spaceVal.getSpace().max) {
                        resolvedSpace.max = spaceVal.getSpace().max;
                    }
                }
            }
            ++index;
        }
        return resolvedSpace;
    }

    public String toString() {
        return "Space Specifier (resolved at begin/end of ref. area:):\n" + this.resolve(false).toString() + "\n" + this.resolve(true).toString();
    }
}

