/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import org.apache.fop.area.Area;
import org.apache.fop.area.inline.Viewport;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.AbstractGraphics;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;

public abstract class AbstractGraphicsLayoutManager
extends LeafNodeLayoutManager {
    protected AbstractGraphics fobj;

    public AbstractGraphicsLayoutManager(AbstractGraphics node) {
        super(node);
        this.fobj = node;
    }

    private Viewport getInlineArea() {
        int scaling;
        Length len;
        boolean hasLH = false;
        int bpd = -1;
        int ipd = -1;
        if (hasLH) {
            bpd = this.fobj.getLineHeight().getOptimum(this).getLength().getValue(this);
        } else {
            len = this.fobj.getBlockProgressionDimension().getOptimum(this).getLength();
            if (len.getEnum() != 9) {
                bpd = len.getValue(this);
            } else {
                len = this.fobj.getHeight();
                if (len.getEnum() != 9) {
                    bpd = len.getValue(this);
                }
            }
        }
        len = this.fobj.getInlineProgressionDimension().getOptimum(this).getLength();
        if (len.getEnum() != 9) {
            ipd = len.getValue(this);
        } else {
            len = this.fobj.getWidth();
            if (len.getEnum() != 9) {
                ipd = len.getValue(this);
            }
        }
        int cwidth = -1;
        int cheight = -1;
        len = this.fobj.getContentWidth();
        if (len.getEnum() != 9) {
            if (len.getEnum() == 125) {
                if (ipd != -1) {
                    cwidth = ipd;
                }
            } else {
                cwidth = len.getValue(this);
            }
        }
        if ((len = this.fobj.getContentHeight()).getEnum() != 9) {
            if (len.getEnum() == 125) {
                if (bpd != -1) {
                    cheight = bpd;
                }
            } else {
                cheight = len.getValue(this);
            }
        }
        if ((scaling = this.fobj.getScaling()) == 154 || cwidth == -1 || cheight == -1) {
            if (cwidth == -1 && cheight == -1) {
                cwidth = this.fobj.getIntrinsicWidth();
                cheight = this.fobj.getIntrinsicHeight();
            } else if (cwidth == -1) {
                cwidth = this.fobj.getIntrinsicHeight() == 0 ? 0 : (int)((double)this.fobj.getIntrinsicWidth() * (double)cheight / (double)this.fobj.getIntrinsicHeight());
            } else if (cheight == -1) {
                cheight = this.fobj.getIntrinsicWidth() == 0 ? 0 : (int)((double)this.fobj.getIntrinsicHeight() * (double)cwidth / (double)this.fobj.getIntrinsicWidth());
            } else if (this.fobj.getIntrinsicWidth() == 0 || this.fobj.getIntrinsicHeight() == 0) {
                cwidth = 0;
                cheight = 0;
            } else {
                double rat2;
                double rat1 = (double)cwidth / (double)this.fobj.getIntrinsicWidth();
                if (rat1 < (rat2 = (double)cheight / (double)this.fobj.getIntrinsicHeight())) {
                    cheight = (int)(rat1 * (double)this.fobj.getIntrinsicHeight());
                } else if (rat1 > rat2) {
                    cwidth = (int)(rat2 * (double)this.fobj.getIntrinsicWidth());
                }
            }
        }
        if (ipd == -1) {
            ipd = cwidth;
        }
        if (bpd == -1) {
            bpd = cheight;
        }
        boolean clip = false;
        if (cwidth > ipd || cheight > bpd) {
            int overflow = this.fobj.getOverflow();
            if (overflow == 57) {
                clip = true;
            } else if (overflow == 42) {
                this.fobj.getLogger().error("Object overflows the viewport: clipping");
                clip = true;
            }
        }
        int xoffset = this.fobj.computeXOffset(ipd, cwidth);
        int yoffset = this.fobj.computeYOffset(bpd, cheight);
        CommonBorderPaddingBackground borderProps = this.fobj.getCommonBorderPaddingBackground();
        int beforeBPD = borderProps.getPadding(0, false, this);
        int afterBPD = borderProps.getPadding(1, false, this);
        afterBPD += borderProps.getBorderWidth(1, false);
        int startIPD = borderProps.getPadding(2, false, this);
        int endIPD = borderProps.getPadding(3, false, this);
        endIPD += borderProps.getBorderWidth(3, false);
        Rectangle2D.Float placement = new Rectangle2D.Float(xoffset += (startIPD += borderProps.getBorderWidth(2, false)), yoffset += (beforeBPD += borderProps.getBorderWidth(0, false)), cwidth, cheight);
        Area viewportArea = this.getChildArea();
        TraitSetter.setProducerID(viewportArea, this.fobj.getId());
        Viewport vp = new Viewport(viewportArea);
        TraitSetter.setProducerID(vp, this.fobj.getId());
        vp.setIPD(ipd);
        vp.setBPD(bpd);
        vp.setContentPosition(placement);
        vp.setClip(clip);
        vp.setOffset(0);
        TraitSetter.addBorders(vp, this.fobj.getCommonBorderPaddingBackground(), false, false, false, false, this);
        TraitSetter.addPadding(vp, this.fobj.getCommonBorderPaddingBackground(), false, false, false, false, this);
        TraitSetter.addBackground(vp, this.fobj.getCommonBorderPaddingBackground(), this);
        return vp;
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        Viewport areaCurrent = this.getInlineArea();
        this.setCurrentArea(areaCurrent);
        return super.getNextKnuthElements(context, alignment);
    }

    protected AlignmentContext makeAlignmentContext(LayoutContext context) {
        return new AlignmentContext(this.get(context).getAllocBPD(), this.fobj.getAlignmentAdjust(), this.fobj.getAlignmentBaseline(), this.fobj.getBaselineShift(), this.fobj.getDominantBaseline(), context.getAlignmentContext());
    }

    protected void addId() {
        this.getPSLM().addIDToPage(this.fobj.getId());
    }

    abstract Area getChildArea();

    public int getBaseLength(int lengthBase, FObj fobj) {
        switch (lengthBase) {
            case 7: {
                return this.getIntrinsicWidth();
            }
            case 8: {
                return this.getIntrinsicHeight();
            }
            case 12: {
                return this.get(null).getBPD();
            }
        }
        return super.getBaseLength(lengthBase, fobj);
    }

    protected int getIntrinsicWidth() {
        return this.fobj.getIntrinsicWidth();
    }

    protected int getIntrinsicHeight() {
        return this.fobj.getIntrinsicHeight();
    }
}

