/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.LinkedList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.AbstractBaseLayoutManager;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.traits.MinOptMax;

public abstract class LeafNodeLayoutManager
extends AbstractLayoutManager
implements InlineLevelLayoutManager {
    protected InlineArea curArea = null;
    protected CommonBorderPaddingBackground commonBorderPaddingBackground = null;
    protected AlignmentContext alignmentContext = null;
    private MinOptMax ipd;
    protected boolean isSomethingChanged = false;
    protected AreaInfo areaInfo = null;

    public LeafNodeLayoutManager(FObj node) {
        super(node);
    }

    public LeafNodeLayoutManager() {
    }

    public InlineArea get(LayoutContext context) {
        return this.curArea;
    }

    public boolean resolved() {
        return false;
    }

    public void setCurrentArea(InlineArea ia) {
        this.curArea = ia;
    }

    public void addChildArea(Area childArea) {
    }

    public Area getParentArea(Area childArea) {
        return null;
    }

    protected void setCommonBorderPaddingBackground(CommonBorderPaddingBackground commonBorderPaddingBackground) {
        this.commonBorderPaddingBackground = commonBorderPaddingBackground;
    }

    protected MinOptMax getAllocationIPD(int refIPD) {
        return new MinOptMax(this.curArea.getIPD());
    }

    public void addAreas(PositionIterator posIter, LayoutContext context) {
        this.addId();
        InlineArea area = this.getEffectiveArea();
        if (area.getAllocIPD() > 0 || area.getAllocBPD() > 0) {
            this.offsetArea(area, context);
            this.widthAdjustArea(area, context);
            if (this.commonBorderPaddingBackground != null) {
                TraitSetter.setBorderPaddingTraits(area, this.commonBorderPaddingBackground, false, false, this);
                TraitSetter.addBackground(area, this.commonBorderPaddingBackground, this);
            }
            this.parentLM.addChildArea(area);
        }
        while (posIter.hasNext()) {
            posIter.next();
        }
    }

    protected InlineArea getEffectiveArea() {
        return this.curArea;
    }

    protected void addId() {
    }

    protected void offsetArea(InlineArea area, LayoutContext context) {
        area.setOffset(this.alignmentContext.getOffset());
    }

    protected AlignmentContext makeAlignmentContext(LayoutContext context) {
        return context.getAlignmentContext();
    }

    protected void widthAdjustArea(InlineArea area, LayoutContext context) {
        double dAdjust = context.getIPDAdjust();
        int width = this.areaInfo.ipdArea.opt;
        if (dAdjust < 0.0) {
            width = (int)((double)width + dAdjust * (double)(this.areaInfo.ipdArea.opt - this.areaInfo.ipdArea.min));
        } else if (dAdjust > 0.0) {
            width = (int)((double)width + dAdjust * (double)(this.areaInfo.ipdArea.max - this.areaInfo.ipdArea.opt));
        }
        area.setIPD(width);
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        this.curArea = this.get(context);
        if (this.curArea == null) {
            this.setFinished(true);
            return null;
        }
        this.alignmentContext = this.makeAlignmentContext(context);
        MinOptMax ipd = this.getAllocationIPD(context.getRefIPD());
        this.areaInfo = new AreaInfo(0, ipd, false, this.alignmentContext);
        InlineKnuthSequence seq = new InlineKnuthSequence();
        this.addKnuthElementsForBorderPaddingStart(seq);
        seq.add(new KnuthInlineBox(this.areaInfo.ipdArea.opt, this.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), false));
        this.addKnuthElementsForBorderPaddingEnd(seq);
        LinkedList<InlineKnuthSequence> returnList = new LinkedList<InlineKnuthSequence>();
        returnList.add(seq);
        this.setFinished(true);
        return returnList;
    }

    public List addALetterSpaceTo(List oldList) {
        return oldList;
    }

    public void removeWordSpace(List oldList) {
        AbstractBaseLayoutManager.log.warn(this.getClass().getName() + " should not receive a call to removeWordSpace(list)");
    }

    public void getWordChars(StringBuffer sbChars, Position pos) {
    }

    public void hyphenate(Position pos, HyphContext hc) {
    }

    public boolean applyChanges(List oldList) {
        this.setFinished(false);
        return false;
    }

    public LinkedList getChangedKnuthElements(List oldList, int alignment) {
        if (this.isFinished()) {
            return null;
        }
        LinkedList<KnuthInlineBox> returnList = new LinkedList<KnuthInlineBox>();
        this.addKnuthElementsForBorderPaddingStart(returnList);
        returnList.add(new KnuthInlineBox(this.areaInfo.ipdArea.opt, this.areaInfo.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), true));
        this.addKnuthElementsForBorderPaddingEnd(returnList);
        this.setFinished(true);
        return returnList;
    }

    protected void addKnuthElementsForBorderPaddingStart(List returnList) {
        int ipStart;
        if (this.commonBorderPaddingBackground != null && (ipStart = this.commonBorderPaddingBackground.getBorderStartWidth(false) + this.commonBorderPaddingBackground.getPaddingStart(false, this)) > 0) {
            returnList.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
            returnList.add(new KnuthGlue(ipStart, 0, 0, new LeafPosition(this, -1), true));
        }
    }

    protected void addKnuthElementsForBorderPaddingEnd(List returnList) {
        int ipEnd;
        if (this.commonBorderPaddingBackground != null && (ipEnd = this.commonBorderPaddingBackground.getBorderEndWidth(false) + this.commonBorderPaddingBackground.getPaddingEnd(false, this)) > 0) {
            returnList.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
            returnList.add(new KnuthGlue(ipEnd, 0, 0, new LeafPosition(this, -1), true));
        }
    }

    protected class AreaInfo {
        protected short iLScount;
        protected MinOptMax ipdArea;
        protected boolean bHyphenated;
        protected AlignmentContext alignmentContext;

        public AreaInfo(short iLS, MinOptMax ipd, boolean bHyph, AlignmentContext alignmentContext) {
            this.iLScount = iLS;
            this.ipdArea = ipd;
            this.bHyphenated = bHyph;
            this.alignmentContext = alignmentContext;
        }
    }
}

