/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.layoutmgr.table.ColumnSetup;
import org.apache.fop.layoutmgr.table.EffRow;
import org.apache.fop.layoutmgr.table.EmptyGridUnit;
import org.apache.fop.layoutmgr.table.GridUnit;
import org.apache.fop.layoutmgr.table.PrimaryGridUnit;

public class TableRowIterator {
    public static final int BODY = 0;
    public static final int HEADER = 1;
    public static final int FOOTER = 2;
    private static Log log = LogFactory.getLog(class$org$apache$fop$layoutmgr$table$TableRowIterator == null ? (class$org$apache$fop$layoutmgr$table$TableRowIterator = TableRowIterator.class$("org.apache.fop.layoutmgr.table.TableRowIterator")) : class$org$apache$fop$layoutmgr$table$TableRowIterator);
    protected Table table;
    private ColumnSetup columns;
    private int type;
    private List currentRow = new ArrayList();
    private List lastRowsSpanningCells = new ArrayList();
    private int currentRowIndex = -1;
    private List rows = new ArrayList();
    private int currentIndex = -1;
    private int pendingRowSpans;
    private ListIterator bodyIterator = null;
    private ListIterator childInBodyIterator = null;
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$table$TableRowIterator;

    public TableRowIterator(Table table, ColumnSetup columns, int what) {
        this.table = table;
        this.columns = columns;
        this.type = what;
        switch (what) {
            case 1: {
                ArrayList<TableBody> bodyList = new ArrayList<TableBody>();
                bodyList.add(table.getTableHeader());
                this.bodyIterator = bodyList.listIterator();
                break;
            }
            case 2: {
                ArrayList<TableBody> bodyList = new ArrayList<TableBody>();
                bodyList.add(table.getTableFooter());
                this.bodyIterator = bodyList.listIterator();
                break;
            }
            default: {
                this.bodyIterator = table.getChildNodes();
            }
        }
    }

    public void prefetchAll() {
        while (this.prefetchNext()) {
            log.trace("found row...");
        }
    }

    public EffRow[] getNextRowGroup() {
        boolean allFinished;
        EffRow firstRowInGroup = this.getNextRow();
        if (firstRowInGroup == null) {
            return null;
        }
        EffRow lastRowInGroup = firstRowInGroup;
        int lastIndex = lastRowInGroup.getIndex();
        do {
            allFinished = true;
            Iterator iter = lastRowInGroup.getGridUnits().iterator();
            while (iter.hasNext()) {
                GridUnit gu = (GridUnit)iter.next();
                if (gu.isLastGridUnitRowSpan()) continue;
                allFinished = false;
                break;
            }
            lastIndex = lastRowInGroup.getIndex();
            if (allFinished || (lastRowInGroup = this.getNextRow()) != null) continue;
            allFinished = true;
        } while (!allFinished);
        int rowCount = lastIndex - firstRowInGroup.getIndex() + 1;
        EffRow[] rowGroup = new EffRow[rowCount];
        int i = 0;
        while (i < rowCount) {
            rowGroup[i] = this.getCachedRow(i + firstRowInGroup.getIndex());
            ++i;
        }
        return rowGroup;
    }

    public EffRow getNextRow() {
        ++this.currentIndex;
        boolean moreRows = true;
        while (moreRows && this.rows.size() < this.currentIndex + 1) {
            moreRows = this.prefetchNext();
        }
        if (this.currentIndex < this.rows.size()) {
            return this.getCachedRow(this.currentIndex);
        }
        return null;
    }

    public void backToPreviousRow() {
        --this.currentIndex;
    }

    public EffRow getFirstRow() {
        if (this.rows.size() == 0) {
            this.prefetchNext();
        }
        return this.getCachedRow(0);
    }

    public EffRow getLastRow() {
        while (this.prefetchNext()) {
        }
        return this.getCachedRow(this.rows.size() - 1);
    }

    public EffRow getCachedRow(int index) {
        if (index < 0 || index >= this.rows.size()) {
            return null;
        }
        return (EffRow)this.rows.get(index);
    }

    private boolean prefetchNext() {
        boolean firstInTable = false;
        boolean firstInBody = false;
        if (this.childInBodyIterator != null && !this.childInBodyIterator.hasNext()) {
            if (this.pendingRowSpans > 0) {
                this.currentRow.clear();
                ++this.currentRowIndex;
                EffRow gridUnits = this.buildGridRow(this.currentRow, null);
                log.debug(gridUnits);
                this.rows.add(gridUnits);
                return true;
            }
            this.childInBodyIterator = null;
            if (this.rows.size() > 0) {
                this.getCachedRow(this.rows.size() - 1).setFlagForAllGridUnits(4, true);
            }
        }
        if (this.childInBodyIterator == null) {
            if (this.bodyIterator.hasNext()) {
                this.childInBodyIterator = ((TableBody)this.bodyIterator.next()).getChildNodes();
                if (this.rows.size() == 0) {
                    firstInTable = true;
                }
                firstInBody = true;
            } else {
                if (this.rows.size() > 0) {
                    this.getCachedRow(this.rows.size() - 1).setFlagForAllGridUnits(4, true);
                    if ((this.type == 2 || this.table.getTableFooter() == null) && this.type != 1) {
                        this.getCachedRow(this.rows.size() - 1).setFlagForAllGridUnits(5, true);
                    }
                }
                return false;
            }
        }
        Object node = this.childInBodyIterator.next();
        while (node instanceof Marker) {
            node = this.childInBodyIterator.next();
        }
        this.currentRow.clear();
        ++this.currentRowIndex;
        TableRow rowFO = null;
        if (node instanceof TableRow) {
            rowFO = (TableRow)node;
            ListIterator cellIterator = rowFO.getChildNodes();
            while (cellIterator.hasNext()) {
                this.currentRow.add(cellIterator.next());
            }
        } else if (node instanceof TableCell) {
            this.currentRow.add(node);
            if (!((TableCell)node).endsRow()) {
                while (this.childInBodyIterator.hasNext()) {
                    TableCell cell = (TableCell)this.childInBodyIterator.next();
                    if (cell.startsRow()) {
                        this.childInBodyIterator.previous();
                    } else {
                        this.currentRow.add(cell);
                        if (!cell.endsRow()) {
                            continue;
                        }
                    }
                    break;
                }
            }
        } else {
            throw new IllegalStateException("Illegal class found: " + node.getClass().getName());
        }
        EffRow gridUnits = this.buildGridRow(this.currentRow, rowFO);
        if (firstInBody) {
            gridUnits.setFlagForAllGridUnits(3, true);
        }
        if (firstInTable && (this.type == 1 || this.table.getTableHeader() == null) && this.type != 2) {
            gridUnits.setFlagForAllGridUnits(2, true);
        }
        log.debug(gridUnits);
        this.rows.add(gridUnits);
        return true;
    }

    private void safelySetListItem(List list, int position, Object obj) {
        while (position >= list.size()) {
            list.add(null);
        }
        list.set(position, obj);
    }

    private Object safelyGetListItem(List list, int position) {
        if (position >= list.size()) {
            return null;
        }
        return list.get(position);
    }

    private EffRow buildGridRow(List cells, TableRow rowFO) {
        EffRow row = new EffRow(this.currentRowIndex, this.type);
        List gridUnits = row.getGridUnits();
        TableBody bodyFO = null;
        int colnum = 1;
        GridUnit[] horzSpan = null;
        if (this.pendingRowSpans > 0) {
            ListIterator<GridUnit> spanIter = this.lastRowsSpanningCells.listIterator();
            while (spanIter.hasNext()) {
                GridUnit gu = (GridUnit)spanIter.next();
                if (gu != null) {
                    if (gu.getColSpanIndex() == 0) {
                        horzSpan = new GridUnit[gu.getCell().getNumberColumnsSpanned()];
                    }
                    GridUnit newGU = gu.createNextRowSpanningGridUnit();
                    newGU.setRow(rowFO);
                    this.safelySetListItem(gridUnits, colnum - 1, newGU);
                    horzSpan[newGU.getColSpanIndex()] = newGU;
                    if (newGU.isLastGridUnitColSpan()) {
                        newGU.getPrimary().addRow(horzSpan);
                        horzSpan = null;
                    }
                    if (newGU.isLastGridUnitRowSpan()) {
                        spanIter.set(null);
                        --this.pendingRowSpans;
                    } else {
                        spanIter.set(newGU);
                    }
                }
                ++colnum;
            }
        }
        if (this.pendingRowSpans < 0) {
            throw new IllegalStateException("pendingRowSpans must not become negative!");
        }
        colnum = 1;
        ListIterator iter = cells.listIterator();
        while (iter.hasNext()) {
            boolean hasRowSpanningLeft;
            TableCell cell = (TableCell)iter.next();
            colnum = cell.getColumnNumber();
            GridUnit other = (GridUnit)this.safelyGetListItem(gridUnits, colnum - 1);
            if (other != null) {
                String err = "A table-cell (" + cell.getContextInfo() + ") is overlapping with another (" + other.getCell().getContextInfo() + ") in column " + colnum;
                throw new IllegalStateException(err + " (this should have been catched by FO tree validation)");
            }
            TableColumn col = this.columns.getColumn(colnum);
            PrimaryGridUnit gu = new PrimaryGridUnit(cell, col, colnum - 1, this.currentRowIndex);
            this.safelySetListItem(gridUnits, colnum - 1, gu);
            boolean bl = hasRowSpanningLeft = !gu.isLastGridUnitRowSpan();
            if (hasRowSpanningLeft) {
                ++this.pendingRowSpans;
                this.safelySetListItem(this.lastRowsSpanningCells, colnum - 1, gu);
            }
            if (gu.hasSpanning()) {
                horzSpan = new GridUnit[cell.getNumberColumnsSpanned()];
                horzSpan[0] = gu;
                int j = 1;
                while (j < cell.getNumberColumnsSpanned()) {
                    GridUnit guSpan = new GridUnit(gu, this.columns.getColumn(++colnum), colnum - 1, j);
                    other = (GridUnit)this.safelyGetListItem(gridUnits, colnum - 1);
                    if (other != null) {
                        String err = "A table-cell (" + cell.getContextInfo() + ") is overlapping with another (" + other.getCell().getContextInfo() + ") in column " + colnum;
                        throw new IllegalStateException(err + " (this should have been catched by FO tree validation)");
                    }
                    this.safelySetListItem(gridUnits, colnum - 1, guSpan);
                    if (hasRowSpanningLeft) {
                        ++this.pendingRowSpans;
                        this.safelySetListItem(this.lastRowsSpanningCells, colnum - 1, gu);
                    }
                    horzSpan[j] = guSpan;
                    ++j;
                }
                gu.addRow(horzSpan);
            }
            if (bodyFO == null) {
                bodyFO = gu.getBody();
            }
            ++colnum;
        }
        this.fillEmptyGridUnits(gridUnits, rowFO, bodyFO);
        this.resolveStartEndBorders(gridUnits);
        return row;
    }

    private void fillEmptyGridUnits(List gridUnits, TableRow row, TableBody body) {
        int pos = 1;
        while (pos <= gridUnits.size()) {
            GridUnit gu = (GridUnit)gridUnits.get(pos - 1);
            if (gu == null) {
                gu = new EmptyGridUnit(row, this.columns.getColumn(pos), body, pos - 1);
                gridUnits.set(pos - 1, gu);
            }
            gu.setFlag(0, pos == 1);
            gu.setFlag(1, pos == gridUnits.size());
            ++pos;
        }
    }

    private void resolveStartEndBorders(List gridUnits) {
        int pos = 1;
        while (pos <= gridUnits.size()) {
            GridUnit starting = (GridUnit)gridUnits.get(pos - 1);
            if (this.table.isSeparateBorderModel()) {
                starting.assignBorderForSeparateBorderModel();
            } else {
                GridUnit start = null;
                int find = pos - 1;
                while (find >= 1) {
                    GridUnit candidate = (GridUnit)gridUnits.get(find - 1);
                    if (candidate.isLastGridUnitColSpan()) {
                        start = candidate;
                        break;
                    }
                    --find;
                }
                GridUnit ending = null;
                if (starting.getCell() != null) {
                    pos += starting.getCell().getNumberColumnsSpanned() - 1;
                }
                ending = (GridUnit)gridUnits.get(pos - 1);
                GridUnit end = null;
                find = pos + 1;
                while (find <= gridUnits.size()) {
                    GridUnit candidate = (GridUnit)gridUnits.get(find - 1);
                    if (candidate.isPrimary()) {
                        end = candidate;
                        break;
                    }
                    ++find;
                }
                starting.resolveBorder(start, 2);
                ending.resolveBorder(end, 3);
            }
            ++pos;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

