/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.FONode;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.table.EffRow;
import org.apache.fop.layoutmgr.table.GridUnit;
import org.apache.fop.layoutmgr.table.PrimaryGridUnit;
import org.apache.fop.layoutmgr.table.TableContentLayoutManager;
import org.apache.fop.layoutmgr.table.TableLayoutManager;

public class TableStepper {
    private static Log log = LogFactory.getLog(class$org$apache$fop$layoutmgr$table$TableStepper == null ? (class$org$apache$fop$layoutmgr$table$TableStepper = TableStepper.class$("org.apache.fop.layoutmgr.table.TableStepper")) : class$org$apache$fop$layoutmgr$table$TableStepper);
    private TableContentLayoutManager tclm;
    private EffRow[] rowGroup;
    private int totalHeight;
    private int activeRow;
    private List[] elementLists;
    private int[] startRow;
    private int[] start;
    private int[] end;
    private int[] widths;
    private int[] baseWidth;
    private int[] borderBefore;
    private int[] paddingBefore;
    private int[] borderAfter;
    private int[] paddingAfter;
    private boolean rowBacktrackForLastStep;
    private boolean skippedStep;
    private boolean[] keepWithNextSignals;
    private boolean[] forcedBreaks;
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$table$TableStepper;

    public TableStepper(TableContentLayoutManager tclm) {
        this.tclm = tclm;
        this.activeRow = 0;
    }

    private void setup(int columnCount) {
        this.elementLists = new List[columnCount];
        this.startRow = new int[columnCount];
        this.start = new int[columnCount];
        this.end = new int[columnCount];
        this.widths = new int[columnCount];
        this.baseWidth = new int[columnCount];
        this.borderBefore = new int[columnCount];
        this.paddingBefore = new int[columnCount];
        this.borderAfter = new int[columnCount];
        this.paddingAfter = new int[columnCount];
        this.keepWithNextSignals = new boolean[columnCount];
        this.forcedBreaks = new boolean[columnCount];
        Arrays.fill(this.end, -1);
    }

    private void clearBreakCondition() {
        Arrays.fill(this.forcedBreaks, false);
    }

    private boolean isBreakCondition() {
        int i = 0;
        while (i < this.forcedBreaks.length) {
            if (this.forcedBreaks[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private EffRow getActiveRow() {
        return this.rowGroup[this.activeRow];
    }

    private GridUnit getActiveGridUnit(int column) {
        return this.getActiveRow().safelyGetGridUnit(column);
    }

    private PrimaryGridUnit getActivePrimaryGridUnit(int column) {
        GridUnit gu = this.getActiveGridUnit(column);
        if (gu == null) {
            return null;
        }
        return gu.getPrimary();
    }

    private void calcTotalHeight() {
        this.totalHeight = 0;
        int i = 0;
        while (i < this.rowGroup.length) {
            this.totalHeight += this.rowGroup[i].getHeight().opt;
            ++i;
        }
        log.debug("totalHeight=" + this.totalHeight);
    }

    private int getMaxRemainingHeight() {
        int i;
        int maxW = 0;
        if (!this.rowBacktrackForLastStep) {
            i = 0;
            while (i < this.widths.length) {
                GridUnit gu;
                if (this.elementLists[i] != null && this.end[i] != this.elementLists[i].size() - 1 && (gu = this.getActiveGridUnit(i)).isLastGridUnitRowSpan()) {
                    int len = this.widths[i];
                    if (len > 0) {
                        len += 2 * this.getTableLM().getHalfBorderSeparationBPD();
                        len += this.borderBefore[i] + this.borderAfter[i];
                        len += this.paddingBefore[i] + this.paddingAfter[i];
                    }
                    int nominalHeight = this.rowGroup[this.activeRow].getHeight().opt;
                    int r = 0;
                    while (r < gu.getRowSpanIndex()) {
                        nominalHeight += this.rowGroup[this.activeRow - r - 1].getHeight().opt;
                        ++r;
                    }
                    if (len == nominalHeight) {
                        maxW = 0;
                        break;
                    }
                    maxW = Math.max(maxW, nominalHeight - len);
                }
                ++i;
            }
        }
        i = this.activeRow + 1;
        while (i < this.rowGroup.length) {
            maxW += this.rowGroup[i].getHeight().opt;
            ++i;
        }
        return maxW;
    }

    private void setupElementList(int column) {
        GridUnit gu = this.getActiveGridUnit(column);
        EffRow row = this.getActiveRow();
        if (gu == null || gu.isEmpty()) {
            this.elementLists[column] = null;
            this.start[column] = 0;
            this.end[column] = -1;
            this.widths[column] = 0;
            this.startRow[column] = this.activeRow;
            this.keepWithNextSignals[column] = false;
            this.forcedBreaks[column] = false;
        } else if (gu.isPrimary()) {
            boolean contentsSmaller;
            PrimaryGridUnit pgu = (PrimaryGridUnit)gu;
            boolean makeBoxForWholeRow = false;
            if (row.getExplicitHeight().min > 0 && (contentsSmaller = ElementListUtils.removeLegalBreaks(pgu.getElements(), row.getExplicitHeight()))) {
                makeBoxForWholeRow = true;
            }
            if (pgu.isLastGridUnitRowSpan() && pgu.getRow() != null) {
                makeBoxForWholeRow |= pgu.getRow().mustKeepTogether();
                makeBoxForWholeRow |= pgu.getTable().mustKeepTogether();
            }
            if (makeBoxForWholeRow) {
                ArrayList<KnuthBoxCellWithBPD> list = new ArrayList<KnuthBoxCellWithBPD>(1);
                int height = row.getExplicitHeight().opt;
                if (height == 0) {
                    height = row.getHeight().opt;
                }
                list.add(new KnuthBoxCellWithBPD(height, pgu));
                this.elementLists[column] = list;
            } else {
                this.elementLists[column] = new ArrayList(pgu.getElements());
            }
            this.borderBefore[column] = this.isSeparateBorderModel() ? pgu.getBorders().getBorderBeforeWidth(false) : pgu.getBorders().getBorderBeforeWidth(false) / 2;
            this.paddingBefore[column] = pgu.getBorders().getPaddingBefore(false, pgu.getCellLM());
            this.paddingAfter[column] = pgu.getBorders().getPaddingAfter(false, pgu.getCellLM());
            this.start[column] = 0;
            this.end[column] = -1;
            this.widths[column] = 0;
            this.startRow[column] = this.activeRow;
            this.keepWithNextSignals[column] = false;
            this.forcedBreaks[column] = false;
        }
    }

    private void initializeElementLists() {
        int i = 0;
        while (i < this.start.length) {
            this.setupElementList(i);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public LinkedList getCombinedKnuthElementsForRowGroup(LayoutContext context, EffRow[] rowGroup, int maxColumnCount, int bodyType) {
        int step;
        this.rowGroup = rowGroup;
        this.setup(maxColumnCount);
        this.initializeElementLists();
        this.calcTotalHeight();
        boolean signalKeepWithNext = false;
        int laststep = 0;
        int addedBoxLen = 0;
        TableContentLayoutManager.TableContentPosition lastTCPos = null;
        LinkedList<ListElement> returnList = new LinkedList<ListElement>();
        while ((step = this.getNextStep(laststep)) >= 0) {
            void var7_10;
            int normalRow = this.activeRow--;
            if (this.rowBacktrackForLastStep) {
                // empty if block
            }
            void increase = var7_10 - laststep;
            void penaltyLen = var7_10 + this.getMaxRemainingHeight() - this.totalHeight;
            void boxLen = var7_10 - addedBoxLen - penaltyLen;
            addedBoxLen += boxLen;
            ArrayList<TableContentLayoutManager.GridUnitPart> gridUnitParts = new ArrayList<TableContentLayoutManager.GridUnitPart>(maxColumnCount);
            int i = 0;
            while (i < this.start.length) {
                if (this.end[i] >= this.start[i]) {
                    PrimaryGridUnit pgu = rowGroup[this.startRow[i]].getGridUnit(i).getPrimary();
                    if (this.start[i] == 0 && this.end[i] == 0 && this.elementLists[i].size() == 1 && this.elementLists[i].get(0) instanceof KnuthBoxCellWithBPD) {
                        gridUnitParts.add(new TableContentLayoutManager.GridUnitPart(pgu, 0, pgu.getElements().size() - 1));
                    } else {
                        gridUnitParts.add(new TableContentLayoutManager.GridUnitPart(pgu, this.start[i], this.end[i]));
                    }
                    if (this.end[i] + 1 == this.elementLists[i].size()) {
                        if (pgu.getFlag(6)) {
                            log.debug("PGU has pending keep-with-next");
                            this.keepWithNextSignals[i] = true;
                        }
                        if (pgu.getRow() != null && pgu.getRow().mustKeepWithNext()) {
                            log.debug("table-row causes keep-with-next");
                            this.keepWithNextSignals[i] = true;
                        }
                    }
                    if (this.start[i] == 0 && this.end[i] >= 0) {
                        if (pgu.getFlag(7)) {
                            log.debug("PGU has pending keep-with-previous");
                            if (returnList.size() == 0) {
                                context.setFlags(1024);
                            }
                        }
                        if (pgu.getRow() != null && pgu.getRow().mustKeepWithPrevious()) {
                            log.debug("table-row causes keep-with-previous");
                            if (returnList.size() == 0) {
                                context.setFlags(1024);
                            }
                        }
                    }
                }
                ++i;
            }
            void effPenaltyLen = penaltyLen;
            TableContentLayoutManager.TableContentPosition tcpos = new TableContentLayoutManager.TableContentPosition(this.getTableLM(), gridUnitParts, rowGroup[normalRow]);
            if (returnList.size() == 0) {
                tcpos.setFlag(1, true);
            }
            lastTCPos = tcpos;
            if (log.isDebugEnabled()) {
                log.debug(" - backtrack=" + this.rowBacktrackForLastStep + " - row=" + this.activeRow + " - " + tcpos);
            }
            returnList.add(new KnuthBox((int)boxLen, tcpos, false));
            TableContentLayoutManager.TableHFPenaltyPosition penaltyPos = new TableContentLayoutManager.TableHFPenaltyPosition(this.getTableLM());
            if (bodyType == 0) {
                if (!this.getTableLM().getTable().omitHeaderAtBreak()) {
                    effPenaltyLen += this.tclm.getHeaderNetHeight();
                    penaltyPos.headerElements = this.tclm.getHeaderElements();
                }
                if (!this.getTableLM().getTable().omitFooterAtBreak()) {
                    effPenaltyLen += this.tclm.getFooterNetHeight();
                    penaltyPos.footerElements = this.tclm.getFooterElements();
                }
            }
            int p = 0;
            boolean allCellsHaveContributed = true;
            signalKeepWithNext = false;
            int i2 = 0;
            while (i2 < this.start.length) {
                if (this.start[i2] == 0 && this.end[i2] < 0 && this.elementLists[i2] != null) {
                    allCellsHaveContributed = false;
                }
                signalKeepWithNext |= this.keepWithNextSignals[i2];
                ++i2;
            }
            if (!allCellsHaveContributed) {
                p = 900;
            }
            if (signalKeepWithNext || this.getTableLM().mustKeepTogether()) {
                p = 1000;
            }
            if (this.skippedStep) {
                p = 1000;
            }
            if (this.isBreakCondition()) {
                if (this.skippedStep) {
                    log.error("This is a conflict situation. The output may be wrong. Please send your FO file to fop-dev@xmlgraphics.apache.org!");
                }
                p = -1000;
                this.clearBreakCondition();
            }
            returnList.add(new BreakElement(penaltyPos, (int)effPenaltyLen, p, 0, context));
            log.debug("step=" + (int)var7_10 + " (+" + (int)increase + ")" + " box=" + (int)boxLen + " penalty=" + (int)penaltyLen + " effPenalty=" + (int)effPenaltyLen);
            laststep = var7_10;
            if (!this.rowBacktrackForLastStep) continue;
            ++this.activeRow;
        }
        if (signalKeepWithNext) {
            context.setFlags(512);
        }
        if (this.isBreakCondition()) {
            ((BreakElement)returnList.getLast()).setPenaltyValue(-1000);
        }
        if (lastTCPos != null) {
            lastTCPos.setFlag(2, true);
        }
        return returnList;
    }

    /*
     * Unable to fully structure code
     */
    private int getNextStep(int lastStep) {
        backupWidths = new int[this.start.length];
        System.arraycopy(this.widths, 0, backupWidths, 0, backupWidths.length);
        rowPendingIndicator = 0;
        i = 0;
        while (i < this.start.length) {
            if (this.elementLists[i] != null) {
                if (this.end[i] < this.elementLists[i].size()) {
                    this.start[i] = this.end[i] + 1;
                    if (this.end[i] + 1 < this.elementLists[i].size() && this.getActiveGridUnit(i).isLastGridUnitRowSpan()) {
                        ++rowPendingIndicator;
                    }
                } else {
                    this.start[i] = -1;
                    this.end[i] = -1;
                }
            }
            ++i;
        }
        if (rowPendingIndicator == 0 && this.activeRow < this.rowGroup.length - 1) {
            rowFO = this.getActiveRow().getTableRow();
            if (rowFO != null && rowFO.getBreakAfter() != 9) {
                TableStepper.log.warn(FONode.decorateWithContextInfo("break-after ignored on table-row because of row spanning in progress (See XSL 1.0, 7.19.1)", rowFO));
            }
            ++this.activeRow;
            if (TableStepper.log.isDebugEnabled()) {
                TableStepper.log.debug("===> new row: " + this.activeRow);
            }
            this.initializeElementLists();
            i = 0;
            while (i < backupWidths.length) {
                if (this.end[i] < 0) {
                    backupWidths[i] = 0;
                }
                ++i;
            }
            rowFO = this.getActiveRow().getTableRow();
            if (rowFO != null && rowFO.getBreakBefore() != 9) {
                TableStepper.log.warn(FONode.decorateWithContextInfo("break-before ignored on table-row because of row spanning in progress (See XSL 1.0, 7.19.2)", rowFO));
            }
        }
        seqCount = 0;
        i = 0;
        while (i < this.start.length) {
            block33: {
                if (this.elementLists[i] != null) ** GOTO lbl55
                break block33;
lbl-1000:
                // 1 sources

                {
                    v0 = i;
                    this.end[v0] = this.end[v0] + 1;
                    el = (KnuthElement)this.elementLists[i].get(this.end[i]);
                    if (el.isPenalty()) {
                        if (el.getP() <= -1000) {
                            TableStepper.log.debug("FORCED break encountered!");
                            this.forcedBreaks[i] = true;
                            break;
                        }
                        if (el.getP() >= 1000) continue;
                        break;
                    }
                    if (el.isGlue()) {
                        if (this.end[i] > 0 && (prev = (KnuthElement)this.elementLists[i].get(this.end[i] - 1)).isBox()) break;
                        v1 = i;
                        this.widths[v1] = this.widths[v1] + el.getW();
                        continue;
                    }
                    v2 = i;
                    this.widths[v2] = this.widths[v2] + el.getW();
lbl55:
                    // 4 sources

                    ** while (this.end[i] + 1 < this.elementLists[i].size())
                }
lbl56:
                // 4 sources

                if (this.end[i] < this.start[i]) {
                    this.widths[i] = backupWidths[i];
                } else {
                    ++seqCount;
                }
                this.borderAfter[i] = this.end[i] + 1 >= this.elementLists[i].size() ? (this.isSeparateBorderModel() ? this.getActivePrimaryGridUnit(i).getBorders().getBorderAfterWidth(false) : this.getActivePrimaryGridUnit(i).getHalfMaxAfterBorderWidth()) : (this.isSeparateBorderModel() != false ? this.getActivePrimaryGridUnit(i).getBorders().getBorderAfterWidth(false) : this.getActivePrimaryGridUnit(i).getHalfMaxAfterBorderWidth());
                if (TableStepper.log.isTraceEnabled()) {
                    TableStepper.log.trace("borders before=" + this.borderBefore[i] + " after=" + this.borderAfter[i]);
                    TableStepper.log.trace("padding before=" + this.paddingBefore[i] + " after=" + this.paddingAfter[i]);
                }
            }
            ++i;
        }
        if (seqCount == 0) {
            return -1;
        }
        minStep = 0x7FFFFFFF;
        sb = new StringBuffer();
        i = 0;
        while (i < this.widths.length) {
            this.baseWidth[i] = 0;
            prevRow = 0;
            while (prevRow < this.startRow[i]) {
                v3 = i;
                this.baseWidth[v3] = this.baseWidth[v3] + this.rowGroup[prevRow].getHeight().opt;
                ++prevRow;
            }
            v4 = i;
            this.baseWidth[v4] = this.baseWidth[v4] + 2 * this.getTableLM().getHalfBorderSeparationBPD();
            v5 = i;
            this.baseWidth[v5] = this.baseWidth[v5] + (this.borderBefore[i] + this.borderAfter[i]);
            v6 = i;
            this.baseWidth[v6] = this.baseWidth[v6] + (this.paddingBefore[i] + this.paddingAfter[i]);
            if (this.end[i] >= this.start[i]) {
                len = this.baseWidth[i] + this.widths[i];
                sb.append(len + " ");
                minStep = Math.min(len, minStep);
            }
            ++i;
        }
        if (TableStepper.log.isDebugEnabled()) {
            TableStepper.log.debug("candidate steps: " + sb + " lastStep=" + lastStep);
        }
        this.rowBacktrackForLastStep = false;
        this.skippedStep = false;
        i = 0;
        while (i < this.widths.length) {
            len = this.baseWidth[i] + this.widths[i];
            if (len > minStep) {
                this.widths[i] = backupWidths[i];
                this.end[i] = this.start[i] - 1;
                if (this.baseWidth[i] + this.widths[i] > minStep) {
                    TableStepper.log.debug("minStep vs. border/padding increase conflict:");
                    if (this.activeRow == 0) {
                        TableStepper.log.debug("  First row. Skip this step.");
                        this.skippedStep = true;
                    } else {
                        TableStepper.log.debug("  row-span situation: backtracking to last row");
                        this.rowBacktrackForLastStep = true;
                    }
                }
            }
            ++i;
        }
        if (TableStepper.log.isDebugEnabled()) {
            sb = new StringBuffer();
            i = 0;
            while (i < this.widths.length) {
                if (this.end[i] >= this.start[i]) {
                    sb.append(i + ": " + this.start[i] + "-" + this.end[i] + "(" + this.widths[i] + "), ");
                } else {
                    sb.append(i + ": skip, ");
                }
                ++i;
            }
            TableStepper.log.debug(sb.toString());
        }
        return minStep;
    }

    private boolean isSeparateBorderModel() {
        return this.getTableLM().getTable().isSeparateBorderModel();
    }

    private TableLayoutManager getTableLM() {
        return this.tclm.getTableLM();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class KnuthBoxCellWithBPD
    extends KnuthBox {
        private PrimaryGridUnit pgu;

        public KnuthBoxCellWithBPD(int w, PrimaryGridUnit pgu) {
            super(w, null, true);
            this.pgu = pgu;
        }
    }
}

