/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.pdf.PDFMetadata;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFOutputIntent;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPages;

public class PDFRoot
extends PDFObject {
    public static final int PAGEMODE_USENONE = 0;
    public static final int PAGEMODE_USEOUTLINES = 1;
    public static final int PAGEMODE_USETHUMBS = 2;
    public static final int PAGEMODE_FULLSCREEN = 3;
    protected PDFPages rootPages;
    private PDFOutline outline;
    private PDFMetadata metadata;
    private List outputIntents;
    private int pageMode = 0;

    public PDFRoot(int objnum, PDFPages pages) {
        this.setObjectNumber(objnum);
        this.setRootPages(pages);
    }

    public void setPageMode(int mode) {
        this.pageMode = mode;
    }

    public void addPage(PDFPage page) {
        this.rootPages.addPage(page);
    }

    public void setRootPages(PDFPages pages) {
        this.rootPages = pages;
    }

    public void setRootOutline(PDFOutline out) {
        this.outline = out;
    }

    public PDFOutline getRootOutline() {
        return this.outline;
    }

    public void setMetadata(PDFMetadata meta) {
        this.metadata = meta;
    }

    public PDFMetadata getMetadata() {
        return this.metadata;
    }

    public void addOutputIntent(PDFOutputIntent outputIntent) {
        if (this.outputIntents == null) {
            this.outputIntents = new ArrayList();
        }
        this.outputIntents.add(outputIntent);
    }

    public String toPDFString() {
        StringBuffer p = new StringBuffer(128);
        p.append(this.getObjectID());
        p.append("<< /Type /Catalog\n/Pages " + this.rootPages.referencePDF() + "\n");
        if (this.outline != null) {
            p.append(" /Outlines " + this.outline.referencePDF() + "\n");
            p.append(" /PageMode /UseOutlines\n");
        } else {
            switch (this.pageMode) {
                case 1: {
                    p.append(" /PageMode /UseOutlines\n");
                    break;
                }
                case 2: {
                    p.append(" /PageMode /UseThumbs\n");
                    break;
                }
                case 3: {
                    p.append(" /PageMode /FullScreen\n");
                    break;
                }
            }
        }
        if (this.getMetadata() != null && this.getDocumentSafely().getPDFVersion() >= 4) {
            p.append("/Metadata " + this.getMetadata().referencePDF() + "\n");
        }
        if (this.outputIntents != null && this.outputIntents.size() > 0 && this.getDocumentSafely().getPDFVersion() >= 4) {
            p.append("/OutputIntents [");
            int i = 0;
            int c = this.outputIntents.size();
            while (i < c) {
                PDFOutputIntent outputIntent = (PDFOutputIntent)this.outputIntents.get(i);
                if (i > 0) {
                    p.append(" ");
                }
                p.append(outputIntent.referencePDF());
                ++i;
            }
            p.append("]\n");
        }
        p.append(">>\nendobj\n");
        return p.toString();
    }
}

