/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.XMLHandler;
import org.apache.xmlgraphics.util.Service;

public class XMLHandlerRegistry {
    private static Log log = LogFactory.getLog(class$org$apache$fop$render$XMLHandlerRegistry == null ? (class$org$apache$fop$render$XMLHandlerRegistry = XMLHandlerRegistry.class$("org.apache.fop.render.XMLHandlerRegistry")) : class$org$apache$fop$render$XMLHandlerRegistry);
    private Map handlers = new HashMap();
    static /* synthetic */ Class class$org$apache$fop$render$XMLHandlerRegistry;
    static /* synthetic */ Class class$org$apache$fop$render$XMLHandler;

    public XMLHandlerRegistry() {
        this.discoverXMLHandlers();
    }

    private void setDefaultXMLHandler(XMLHandler handler) {
        this.addXMLHandler("*", handler);
    }

    public void addXMLHandler(String classname) {
        try {
            XMLHandler handlerInstance = (XMLHandler)Class.forName(classname).newInstance();
            this.addXMLHandler(handlerInstance);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find " + classname);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate " + classname);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access " + classname);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(classname + " is not an " + (class$org$apache$fop$render$XMLHandler == null ? (class$org$apache$fop$render$XMLHandler = XMLHandlerRegistry.class$("org.apache.fop.render.XMLHandler")) : class$org$apache$fop$render$XMLHandler).getName());
        }
    }

    public void addXMLHandler(XMLHandler handler) {
        String ns = handler.getNamespace();
        if (ns == null) {
            this.setDefaultXMLHandler(handler);
        } else {
            this.addXMLHandler(ns, handler);
        }
    }

    private void addXMLHandler(String ns, XMLHandler handler) {
        ArrayList<XMLHandler> lst = (ArrayList<XMLHandler>)this.handlers.get(ns);
        if (lst == null) {
            lst = new ArrayList<XMLHandler>();
            this.handlers.put(ns, lst);
        }
        lst.add(handler);
    }

    public XMLHandler getXMLHandler(Renderer renderer, String ns) {
        List lst = (List)this.handlers.get(ns);
        XMLHandler handler = this.getXMLHandler(renderer, lst);
        if (handler == null) {
            lst = (List)this.handlers.get("*");
            handler = this.getXMLHandler(renderer, lst);
        }
        return handler;
    }

    private XMLHandler getXMLHandler(Renderer renderer, List lst) {
        if (lst != null) {
            int i = 0;
            int c = lst.size();
            while (i < c) {
                XMLHandler handler = (XMLHandler)lst.get(i);
                if (handler.supportsRenderer(renderer)) {
                    return handler;
                }
                ++i;
            }
        }
        return null;
    }

    private void discoverXMLHandlers() {
        Iterator providers = Service.providers(class$org$apache$fop$render$XMLHandler == null ? (class$org$apache$fop$render$XMLHandler = XMLHandlerRegistry.class$("org.apache.fop.render.XMLHandler")) : class$org$apache$fop$render$XMLHandler);
        if (providers != null) {
            while (providers.hasNext()) {
                XMLHandler handler = (XMLHandler)providers.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Dynamically adding XMLHandler: " + handler.getClass().getName());
                    }
                    this.addXMLHandler(handler);
                }
                catch (IllegalArgumentException e) {
                    log.error("Error while adding XMLHandler", e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

