/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.CTM;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineBlockParent;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.Viewport;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.image.XMLImage;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.java2d.FontSetup;
import org.apache.fop.render.java2d.Java2DGraphics2DAdapter;
import org.apache.fop.render.java2d.Java2DGraphicsState;
import org.apache.fop.render.pdf.CTMHelper;
import org.apache.fop.traits.BorderProps;
import org.w3c.dom.Document;

public abstract class Java2DRenderer
extends AbstractRenderer
implements Printable {
    protected double scaleFactor = 1.0;
    protected int pageWidth = 0;
    protected int pageHeight = 0;
    protected List pageViewportList = new ArrayList();
    private int currentPageNumber = 0;
    private int numberOfPages;
    protected boolean antialiasing = true;
    protected boolean qualityRendering = true;
    protected Java2DGraphicsState state;
    protected Line2D.Float line = new Line2D.Float();
    protected FontInfo fontInfo;
    protected Map fontNames = new Hashtable();
    protected Map fontStyles = new Hashtable();
    public boolean renderingDone;

    public void setUserAgent(FOUserAgent foUserAgent) {
        super.setUserAgent(foUserAgent);
        this.userAgent.setRendererOverride(this);
    }

    public FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    public void setupFontInfo(FontInfo inFontInfo) {
        this.fontInfo = inFontInfo;
        BufferedImage fontImage = new BufferedImage(100, 100, 1);
        FontSetup.setup(this.fontInfo, fontImage.createGraphics());
    }

    public Graphics2DAdapter getGraphics2DAdapter() {
        return new Java2DGraphics2DAdapter(this.state);
    }

    public void setScaleFactor(double newScaleFactor) {
        this.scaleFactor = newScaleFactor;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void startRenderer(OutputStream out) throws IOException {
    }

    public void stopRenderer() throws IOException {
        AbstractRenderer.log.debug("Java2DRenderer stopped");
        this.renderingDone = true;
        this.numberOfPages = this.currentPageNumber;
        if (this.numberOfPages == 0) {
            new FOPException("No page could be rendered");
        }
    }

    public int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public void setCurrentPageNumber(int c) {
        this.currentPageNumber = c;
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public void clearViewportList() {
        this.pageViewportList.clear();
        this.setCurrentPageNumber(0);
    }

    public void renderPage(PageViewport pageViewport) throws IOException, FOPException {
        this.pageViewportList.add(pageViewport.clone());
        ++this.currentPageNumber;
    }

    public BufferedImage getPageImage(PageViewport pageViewport) {
        this.currentPageViewport = pageViewport;
        try {
            Rectangle2D bounds = pageViewport.getViewArea();
            this.pageWidth = (int)Math.round(bounds.getWidth() / 1000.0);
            this.pageHeight = (int)Math.round(bounds.getHeight() / 1000.0);
            AbstractRenderer.log.info("Rendering Page " + pageViewport.getPageNumberString() + " (pageWidth " + this.pageWidth + ", pageHeight " + this.pageHeight + ")");
            double scaleX = this.scaleFactor * 0.35277777777777775 / (double)this.userAgent.getTargetPixelUnitToMillimeter();
            double scaleY = this.scaleFactor * 0.35277777777777775 / (double)this.userAgent.getTargetPixelUnitToMillimeter();
            int bitmapWidth = (int)((double)this.pageWidth * scaleX + 0.5);
            int bitmapHeight = (int)((double)this.pageHeight * scaleY + 0.5);
            BufferedImage currentPageImage = new BufferedImage(bitmapWidth, bitmapHeight, 2);
            Graphics2D graphics = currentPageImage.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            if (this.antialiasing) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (this.qualityRendering) {
                graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            AffineTransform at = graphics.getTransform();
            at.scale(scaleX, scaleY);
            graphics.setTransform(at);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.pageWidth, this.pageHeight);
            graphics.setColor(Color.black);
            graphics.drawRect(-1, -1, this.pageWidth + 2, this.pageHeight + 2);
            graphics.drawLine(this.pageWidth + 2, 0, this.pageWidth + 2, this.pageHeight + 2);
            graphics.drawLine(this.pageWidth + 3, 1, this.pageWidth + 3, this.pageHeight + 3);
            graphics.drawLine(0, this.pageHeight + 2, this.pageWidth + 2, this.pageHeight + 2);
            graphics.drawLine(1, this.pageHeight + 3, this.pageWidth + 3, this.pageHeight + 3);
            this.state = new Java2DGraphicsState(graphics, this.fontInfo, at);
            this.currentBPPosition = 0;
            this.currentIPPosition = 0;
            this.renderPageAreas(pageViewport.getPage());
            BufferedImage bufferedImage = currentPageImage;
            Object var14_11 = null;
            this.currentPageViewport = null;
            return bufferedImage;
        }
        catch (Throwable throwable) {
            Object var14_12 = null;
            this.currentPageViewport = null;
            throw throwable;
        }
    }

    public PageViewport getPageViewport(int pageNum) throws FOPException {
        if (pageNum < 0 || pageNum >= this.pageViewportList.size()) {
            throw new FOPException("Requested page number is out of range: " + pageNum + "; only " + this.pageViewportList.size() + " page(s) available.");
        }
        return (PageViewport)this.pageViewportList.get(pageNum);
    }

    public BufferedImage getPageImage(int pageNum) throws FOPException {
        return this.getPageImage(this.getPageViewport(pageNum));
    }

    protected void handleRegionTraits(RegionViewport region) {
        Rectangle2D viewArea = region.getViewArea();
        float startx = (float)(viewArea.getX() / 1000.0);
        float starty = (float)(viewArea.getY() / 1000.0);
        float width = (float)(viewArea.getWidth() / 1000.0);
        float height = (float)(viewArea.getHeight() / 1000.0);
        if (region.getRegionReference().getRegionClass() == 36) {
            this.currentBPPosition = region.getBorderAndPaddingWidthBefore();
            this.currentIPPosition = region.getBorderAndPaddingWidthStart();
        }
        this.drawBackAndBorders(region, startx, starty, width, height);
    }

    public void renderViewport(Viewport viewport) {
        float x = (float)this.currentIPPosition / 1000.0f;
        float y = (float)(this.currentBPPosition + viewport.getOffset()) / 1000.0f;
        float width = (float)viewport.getIPD() / 1000.0f;
        float height = (float)viewport.getBPD() / 1000.0f;
        float borderPaddingStart = (float)viewport.getBorderAndPaddingWidthStart() / 1000.0f;
        float borderPaddingBefore = (float)viewport.getBorderAndPaddingWidthBefore() / 1000.0f;
        float bpwidth = borderPaddingStart + (float)viewport.getBorderAndPaddingWidthEnd() / 1000.0f;
        float bpheight = borderPaddingBefore + (float)viewport.getBorderAndPaddingWidthAfter() / 1000.0f;
        this.drawBackAndBorders(viewport, x, y, width + bpwidth, height + bpheight);
        if (viewport.getClip()) {
            this.saveGraphicsState();
            this.clipRect(x + borderPaddingStart, y + borderPaddingBefore, width, height);
        }
        super.renderViewport(viewport);
        if (viewport.getClip()) {
            this.restoreGraphicsState();
        }
    }

    protected void saveGraphicsState() {
        this.state.push();
    }

    protected void restoreGraphicsState() {
        this.state.pop();
    }

    protected void startVParea(CTM ctm, Rectangle2D clippingRect) {
        this.saveGraphicsState();
        if (clippingRect != null) {
            this.clipRect((float)clippingRect.getX() / 1000.0f, (float)clippingRect.getY() / 1000.0f, (float)clippingRect.getWidth() / 1000.0f, (float)clippingRect.getHeight() / 1000.0f);
        }
        this.state.transform(new AffineTransform(CTMHelper.toPDFArray(ctm)));
    }

    protected void endVParea() {
        this.restoreGraphicsState();
    }

    protected void renderInlineSpace(Space space) {
        space.setBPD(0);
        this.renderInlineAreaBackAndBorders(space);
        super.renderInlineSpace(space);
    }

    protected void renderInlineParent(InlineParent ip) {
        this.renderInlineAreaBackAndBorders(ip);
        super.renderInlineParent(ip);
    }

    protected void renderInlineBlockParent(InlineBlockParent ibp) {
        this.renderInlineAreaBackAndBorders(ibp);
        super.renderInlineBlockParent(ibp);
    }

    protected void renderBlockViewport(BlockViewport bv, List children) {
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        CTM ctm = bv.getCTM();
        int borderPaddingStart = bv.getBorderAndPaddingWidthStart();
        int borderPaddingBefore = bv.getBorderAndPaddingWidthBefore();
        float x = (float)(bv.getXOffset() + this.containingIPPosition) / 1000.0f;
        float y = (float)(bv.getYOffset() + this.containingBPPosition) / 1000.0f;
        float width = (float)bv.getIPD() / 1000.0f;
        float height = (float)bv.getBPD() / 1000.0f;
        if (bv.getPositioning() == 2 || bv.getPositioning() == 3) {
            this.currentIPPosition = bv.getXOffset();
            this.currentBPPosition = bv.getYOffset();
            ArrayList<Graphics2D> breakOutList = null;
            if (bv.getPositioning() == 3) {
                AbstractRenderer.log.debug("Block.FIXED --> break out");
                breakOutList = new ArrayList<Graphics2D>();
                while (true) {
                    Graphics2D graph = this.state.getGraph();
                    if (this.state.pop() == null) break;
                    breakOutList.add(0, graph);
                    AbstractRenderer.log.debug("Adding to break out list: " + graph);
                }
            }
            CTM tempctm = new CTM(this.containingIPPosition, this.containingBPPosition);
            ctm = tempctm.multiply(ctm);
            this.currentIPPosition += bv.getSpaceStart();
            this.currentBPPosition += bv.getSpaceBefore();
            float bpwidth = (float)(borderPaddingStart + bv.getBorderAndPaddingWidthEnd()) / 1000.0f;
            float bpheight = (float)(borderPaddingBefore + bv.getBorderAndPaddingWidthAfter()) / 1000.0f;
            this.drawBackAndBorders(bv, x += (float)bv.getSpaceStart() / 1000.0f, y += (float)bv.getSpaceBefore() / 1000.0f, width + bpwidth, height + bpheight);
            this.currentIPPosition += borderPaddingStart;
            this.currentBPPosition += borderPaddingBefore;
            Rectangle clippingRect = null;
            if (bv.getClip()) {
                clippingRect = new Rectangle(this.currentIPPosition, this.currentBPPosition, bv.getIPD(), bv.getBPD());
            }
            this.startVParea(ctm, clippingRect);
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.renderBlocks(bv, children);
            this.endVParea();
            if (breakOutList != null) {
                AbstractRenderer.log.debug("Block.FIXED --> restoring context after break-out");
                Iterator i = breakOutList.iterator();
                while (i.hasNext()) {
                    Graphics2D graph = (Graphics2D)i.next();
                    AbstractRenderer.log.debug("Restoring: " + graph);
                    this.state.push();
                }
            }
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
        } else {
            this.currentBPPosition += bv.getSpaceBefore();
            this.handleBlockTraits(bv);
            this.currentIPPosition += bv.getStartIndent();
            CTM tempctm = new CTM(this.containingIPPosition, this.currentBPPosition + this.containingBPPosition);
            ctm = tempctm.multiply(ctm);
            x += (float)borderPaddingStart / 1000.0f;
            y += (float)borderPaddingBefore / 1000.0f;
            Rectangle clippingRect = null;
            if (bv.getClip()) {
                clippingRect = new Rectangle(this.currentIPPosition, this.currentBPPosition, bv.getIPD(), bv.getBPD());
            }
            this.startVParea(ctm, clippingRect);
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.renderBlocks(bv, children);
            this.endVParea();
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
            this.currentBPPosition += bv.getAllocBPD();
        }
    }

    protected void clipRect(float x, float y, float width, float height) {
        Rectangle2D.Float rect = new Rectangle2D.Float(x, y, width, height);
        this.state.updateClip(rect);
    }

    protected void drawBackAndBorders(Area area, float startx, float starty, float width, float height) {
        float sy;
        BorderProps bpsBefore = (BorderProps)area.getTrait(Trait.BORDER_BEFORE);
        BorderProps bpsAfter = (BorderProps)area.getTrait(Trait.BORDER_AFTER);
        BorderProps bpsStart = (BorderProps)area.getTrait(Trait.BORDER_START);
        BorderProps bpsEnd = (BorderProps)area.getTrait(Trait.BORDER_END);
        Trait.Background back = (Trait.Background)area.getTrait(Trait.BACKGROUND);
        if (back != null) {
            float sx = startx;
            sy = starty;
            float paddRectWidth = width;
            float paddRectHeight = height;
            if (bpsStart != null) {
                sx += (float)bpsStart.width / 1000.0f;
                paddRectWidth -= (float)bpsStart.width / 1000.0f;
            }
            if (bpsBefore != null) {
                sy += (float)bpsBefore.width / 1000.0f;
                paddRectHeight -= (float)bpsBefore.width / 1000.0f;
            }
            if (bpsEnd != null) {
                paddRectWidth -= (float)bpsEnd.width / 1000.0f;
            }
            if (bpsAfter != null) {
                paddRectHeight -= (float)bpsAfter.width / 1000.0f;
            }
            if (back.getColor() != null) {
                this.drawBackground(back, sx, sy, paddRectWidth, paddRectHeight);
            }
            if (back.getFopImage() != null) {
                FopImage fopimage = back.getFopImage();
                if (fopimage != null && fopimage.load(1)) {
                    this.saveGraphicsState();
                    this.clipRect(sx, sy, paddRectWidth, paddRectHeight);
                    int horzCount = (int)(paddRectWidth * 1000.0f / (float)fopimage.getIntrinsicWidth() + 1.0f);
                    int vertCount = (int)(paddRectHeight * 1000.0f / (float)fopimage.getIntrinsicHeight() + 1.0f);
                    if (back.getRepeat() == 96) {
                        horzCount = 1;
                        vertCount = 1;
                    } else if (back.getRepeat() == 113) {
                        vertCount = 1;
                    } else if (back.getRepeat() == 114) {
                        horzCount = 1;
                    }
                    sx *= 1000.0f;
                    sy *= 1000.0f;
                    if (horzCount == 1) {
                        sx += (float)back.getHoriz();
                    }
                    if (vertCount == 1) {
                        sy += (float)back.getVertical();
                    }
                    int x = 0;
                    while (x < horzCount) {
                        int y = 0;
                        while (y < vertCount) {
                            Rectangle2D.Float pos = new Rectangle2D.Float(sx + (float)(x * fopimage.getIntrinsicWidth()), sy + (float)(y * fopimage.getIntrinsicHeight()), fopimage.getIntrinsicWidth(), fopimage.getIntrinsicHeight());
                            this.putImage(back.getURL(), pos);
                            ++y;
                        }
                        ++x;
                    }
                    this.restoreGraphicsState();
                } else {
                    AbstractRenderer.log.warn("Can't find background image: " + back.getURL());
                }
            }
        }
        if (bpsBefore != null) {
            int borderWidth = Math.round((float)bpsBefore.width / 1000.0f);
            this.state.updateColor(bpsBefore.color);
            this.state.getGraph().fillRect((int)startx, (int)starty, (int)width, borderWidth);
        }
        if (bpsAfter != null) {
            int borderWidth = Math.round((float)bpsAfter.width / 1000.0f);
            sy = starty + height;
            this.state.updateColor(bpsAfter.color);
            this.state.getGraph().fillRect((int)startx, (int)(starty + height - (float)borderWidth), (int)width, borderWidth);
        }
        if (bpsStart != null) {
            int borderWidth = Math.round((float)bpsStart.width / 1000.0f);
            this.state.updateColor(bpsStart.color);
            this.state.getGraph().fillRect((int)startx, (int)starty, borderWidth, (int)height);
        }
        if (bpsEnd != null) {
            int borderWidth = Math.round((float)bpsEnd.width / 1000.0f);
            float sx = startx + width;
            this.state.updateColor(bpsEnd.color);
            this.state.getGraph().fillRect((int)(startx + width - (float)borderWidth), (int)starty, borderWidth, (int)height);
        }
    }

    protected void drawBackground(Trait.Background back, float sx, float sy, float paddRectWidth, float paddRectHeight) {
        this.state.updateColor(back.getColor());
        this.state.getGraph().fillRect((int)sx, (int)sy, (int)paddRectWidth, (int)paddRectHeight);
    }

    protected void renderInlineAreaBackAndBorders(InlineArea area) {
        float x = (float)this.currentIPPosition / 1000.0f;
        float y = (float)(this.currentBPPosition + area.getOffset()) / 1000.0f;
        float width = (float)area.getIPD() / 1000.0f;
        float height = (float)area.getBPD() / 1000.0f;
        float borderPaddingStart = (float)area.getBorderAndPaddingWidthStart() / 1000.0f;
        float borderPaddingBefore = (float)area.getBorderAndPaddingWidthBefore() / 1000.0f;
        float bpwidth = borderPaddingStart + (float)area.getBorderAndPaddingWidthEnd() / 1000.0f;
        float bpheight = borderPaddingBefore + (float)area.getBorderAndPaddingWidthAfter() / 1000.0f;
        if (height != 0.0f || bpheight != 0.0f && bpwidth != 0.0f) {
            this.drawBackAndBorders(area, x, y - borderPaddingBefore, width + bpwidth, height + bpheight);
        }
    }

    protected void handleBlockTraits(Block block) {
        int borderPaddingStart = block.getBorderAndPaddingWidthStart();
        int borderPaddingBefore = block.getBorderAndPaddingWidthBefore();
        float startx = (float)this.currentIPPosition / 1000.0f;
        float starty = (float)this.currentBPPosition / 1000.0f;
        float width = (float)block.getIPD() / 1000.0f;
        float height = (float)block.getBPD() / 1000.0f;
        startx += (float)block.getStartIndent() / 1000.0f;
        width += (float)borderPaddingStart / 1000.0f;
        height += (float)borderPaddingBefore / 1000.0f;
        this.drawBackAndBorders(block, startx -= (float)block.getBorderAndPaddingWidthStart() / 1000.0f, starty, width += (float)block.getBorderAndPaddingWidthEnd() / 1000.0f, height += (float)block.getBorderAndPaddingWidthAfter() / 1000.0f);
    }

    protected Font getFontFromArea(Area area) {
        FontTriplet triplet = (FontTriplet)area.getTrait(Trait.FONT);
        int size = (Integer)area.getTrait(Trait.FONT_SIZE);
        return this.fontInfo.getFontInstance(triplet, size);
    }

    public void renderText(TextArea text) {
        this.renderInlineAreaBackAndBorders(text);
        float x = this.currentIPPosition + text.getBorderAndPaddingWidthStart();
        float y = this.currentBPPosition + text.getOffset() + text.getBaselineOffset();
        Font font = this.getFontFromArea(text);
        this.state.updateFont(font.getFontName(), font.getFontSize(), null);
        ColorType ct = (ColorType)text.getTrait(Trait.COLOR);
        this.state.updateColor(ct, false, null);
        String s = text.getText();
        this.state.getGraph().drawString(s, x / 1000.0f, y / 1000.0f);
        super.renderText(text);
        this.renderTextDecoration(font, text, y, x);
    }

    protected void renderTextDecoration(Font fs, InlineArea inline, float baseline, float startIPD) {
        boolean hasTextDeco;
        boolean bl = hasTextDeco = inline.hasUnderline() || inline.hasOverline() || inline.hasLineThrough();
        if (hasTextDeco) {
            float y;
            ColorType ct;
            this.state.updateStroke((float)fs.getDescender() / -8000.0f, 133);
            float endIPD = startIPD + (float)inline.getIPD();
            if (inline.hasUnderline()) {
                ct = (ColorType)inline.getTrait(Trait.UNDERLINE_COLOR);
                this.state.updateColor(ct, false, null);
                y = baseline - (float)(fs.getDescender() / 2);
                this.line.setLine(startIPD / 1000.0f, y / 1000.0f, endIPD / 1000.0f, y / 1000.0f);
                this.state.getGraph().draw(this.line);
            }
            if (inline.hasOverline()) {
                ct = (ColorType)inline.getTrait(Trait.OVERLINE_COLOR);
                this.state.updateColor(ct, false, null);
                y = (float)((double)baseline - 1.1 * (double)fs.getCapHeight());
                this.line.setLine(startIPD / 1000.0f, y / 1000.0f, endIPD / 1000.0f, y / 1000.0f);
                this.state.getGraph().draw(this.line);
            }
            if (inline.hasLineThrough()) {
                ct = (ColorType)inline.getTrait(Trait.LINETHROUGH_COLOR);
                this.state.updateColor(ct, false, null);
                y = (float)((double)baseline - 0.45 * (double)fs.getCapHeight());
                this.line.setLine(startIPD / 1000.0f, y / 1000.0f, endIPD / 1000.0f, y / 1000.0f);
                this.state.getGraph().draw(this.line);
            }
        }
    }

    public void renderLeader(Leader area) {
        this.renderInlineAreaBackAndBorders(area);
        float startx = (float)(this.currentIPPosition + area.getBorderAndPaddingWidthStart()) / 1000.0f;
        float starty = (float)(this.currentBPPosition + area.getOffset()) / 1000.0f;
        float endx = (float)(this.currentIPPosition + area.getBorderAndPaddingWidthStart() + area.getIPD()) / 1000.0f;
        ColorType ct = (ColorType)area.getTrait(Trait.COLOR);
        this.state.updateColor(ct, true, null);
        this.line.setLine(startx, starty, endx, starty);
        float thickness = (float)area.getRuleThickness() / 1000.0f;
        int style = area.getRuleStyle();
        switch (style) {
            case 31: 
            case 36: 
            case 133: {
                this.state.updateStroke(thickness, style);
                this.state.getGraph().draw(this.line);
                break;
            }
            case 37: {
                this.state.updateStroke(thickness / 3.0f, 133);
                this.line.setLine(startx, starty, endx, starty);
                this.state.getGraph().draw(this.line);
                this.line.setLine(startx, starty + 2.0f * thickness, endx, starty + 2.0f * thickness);
                this.state.getGraph().draw(this.line);
                break;
            }
            case 55: {
                this.state.updateStroke(thickness / 2.0f, 133);
                this.line.setLine(startx, starty, endx, starty);
                this.state.getGraph().draw(this.line);
                this.line.setLine(startx, starty + thickness, endx, starty + thickness);
                this.state.getGraph().setColor(Color.white);
                this.state.getGraph().draw(this.line);
                break;
            }
            case 119: {
                this.state.updateStroke(thickness / 2.0f, 133);
                this.line.setLine(startx, starty + thickness, endx, starty + thickness);
                this.state.getGraph().draw(this.line);
                this.line.setLine(startx, starty, endx, starty);
                this.state.getGraph().setColor(Color.white);
                this.state.getGraph().draw(this.line);
                break;
            }
        }
        super.renderLeader(area);
    }

    public void renderImage(org.apache.fop.area.inline.Image image, Rectangle2D pos) {
        String url = image.getURL();
        this.putImage(url, pos);
    }

    protected void putImage(String pUrl, Rectangle2D pos) {
        int x = this.currentIPPosition;
        int y = this.currentBPPosition;
        String url = ImageFactory.getURL(pUrl);
        ImageFactory fact = this.userAgent.getFactory().getImageFactory();
        FopImage fopimage = fact.getImage(url, this.userAgent);
        if (fopimage == null) {
            return;
        }
        if (!fopimage.load(1)) {
            return;
        }
        int w = fopimage.getWidth();
        int h = fopimage.getHeight();
        String mime = fopimage.getMimeType();
        if ("text/xml".equals(mime)) {
            if (!fopimage.load(2)) {
                return;
            }
            Document doc = ((XMLImage)fopimage).getDocument();
            String ns = ((XMLImage)fopimage).getNameSpace();
            this.renderDocument(doc, ns, pos);
        } else if ("image/svg+xml".equals(mime)) {
            if (!fopimage.load(2)) {
                return;
            }
            Document doc = ((XMLImage)fopimage).getDocument();
            String ns = ((XMLImage)fopimage).getNameSpace();
            this.renderDocument(doc, ns, pos);
        } else if ("image/eps".equals(mime)) {
            AbstractRenderer.log.warn("EPS images are not supported by this renderer");
        } else if ("image/jpeg".equals(mime)) {
            if (!fopimage.load(2)) {
                return;
            }
            Image awtImage = new ImageIcon(url).getImage();
            this.state.getGraph().drawImage(awtImage, (int)((float)x / 1000.0f), (int)((float)y / 1000.0f), (int)(pos.getWidth() / 1000.0), (int)(pos.getHeight() / 1000.0), null);
        } else {
            if (!fopimage.load(4)) {
                AbstractRenderer.log.warn("Loading of bitmap failed: " + url);
                return;
            }
            byte[] raw = fopimage.getBitmaps();
            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1004), new int[]{8, 8, 8}, false, false, 1, 0);
            PixelInterleavedSampleModel sampleModel = new PixelInterleavedSampleModel(0, w, h, 3, w * 3, new int[]{0, 1, 2});
            DataBufferByte dbuf = new DataBufferByte(raw, w * h * 3);
            WritableRaster raster = Raster.createWritableRaster(sampleModel, dbuf, null);
            BufferedImage awtImage = new BufferedImage(cm, raster, false, null);
            this.state.getGraph().drawImage(awtImage, (int)((float)x / 1000.0f), (int)((float)y / 1000.0f), (int)(pos.getWidth() / 1000.0), (int)(pos.getHeight() / 1000.0), null);
        }
    }

    public void renderForeignObject(ForeignObject fo, Rectangle2D pos) {
        Document doc = fo.getDocument();
        String ns = fo.getNameSpace();
        this.renderDocument(doc, ns, pos);
    }

    public void renderDocument(Document doc, String ns, Rectangle2D pos) {
        RendererContext context = new RendererContext(this, this.getMimeType());
        context.setUserAgent(this.userAgent);
        context.setProperty("state", this.state);
        context.setProperty("xpos", new Integer(this.currentIPPosition + (int)pos.getX()));
        context.setProperty("ypos", new Integer(this.currentBPPosition + (int)pos.getY()));
        context.setProperty("width", new Integer((int)pos.getWidth()));
        context.setProperty("height", new Integer((int)pos.getHeight()));
        context.setProperty("pageViewport", this.getCurrentPageViewport());
        this.renderXML(context, doc, ns);
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.getNumberOfPages()) {
            return 1;
        }
        Graphics2D graphics = (Graphics2D)g;
        Java2DGraphicsState oldState = this.state;
        try {
            try {
                PageViewport viewport = this.getPageViewport(pageIndex);
                AffineTransform at = graphics.getTransform();
                this.state = new Java2DGraphicsState(graphics, this.fontInfo, at);
                this.currentBPPosition = 0;
                this.currentIPPosition = 0;
                this.renderPageAreas(viewport.getPage());
                int n = 0;
                Object var11_11 = null;
                oldState = this.state;
                return n;
            }
            catch (FOPException e) {
                AbstractRenderer.log.error(e);
                int n = 1;
                Object var11_12 = null;
                oldState = this.state;
                return n;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            oldState = this.state;
            throw throwable;
        }
    }
}

