/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.util.ContentHandlerFactory;
import org.apache.xmlgraphics.util.Service;

public class ContentHandlerFactoryRegistry {
    private static Log log = LogFactory.getLog(class$org$apache$fop$util$ContentHandlerFactoryRegistry == null ? (class$org$apache$fop$util$ContentHandlerFactoryRegistry = ContentHandlerFactoryRegistry.class$("org.apache.fop.util.ContentHandlerFactoryRegistry")) : class$org$apache$fop$util$ContentHandlerFactoryRegistry);
    private Map factories = new HashMap();
    static /* synthetic */ Class class$org$apache$fop$util$ContentHandlerFactoryRegistry;
    static /* synthetic */ Class class$org$apache$fop$util$ContentHandlerFactory;

    public ContentHandlerFactoryRegistry() {
        this.discover();
    }

    public void addContentHandlerFactory(String classname) {
        try {
            ContentHandlerFactory factory = (ContentHandlerFactory)Class.forName(classname).newInstance();
            this.addContentHandlerFactory(factory);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find " + classname);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate " + classname);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access " + classname);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(classname + " is not an " + (class$org$apache$fop$util$ContentHandlerFactory == null ? (class$org$apache$fop$util$ContentHandlerFactory = ContentHandlerFactoryRegistry.class$("org.apache.fop.util.ContentHandlerFactory")) : class$org$apache$fop$util$ContentHandlerFactory).getName());
        }
    }

    public void addContentHandlerFactory(ContentHandlerFactory factory) {
        String[] ns = factory.getSupportedNamespaces();
        int i = 0;
        while (i < ns.length) {
            this.factories.put(ns[i], factory);
            ++i;
        }
    }

    public ContentHandlerFactory getFactory(String namespaceURI) {
        ContentHandlerFactory factory = (ContentHandlerFactory)this.factories.get(namespaceURI);
        return factory;
    }

    private void discover() {
        Iterator providers = Service.providers(class$org$apache$fop$util$ContentHandlerFactory == null ? (class$org$apache$fop$util$ContentHandlerFactory = ContentHandlerFactoryRegistry.class$("org.apache.fop.util.ContentHandlerFactory")) : class$org$apache$fop$util$ContentHandlerFactory);
        if (providers != null) {
            while (providers.hasNext()) {
                ContentHandlerFactory factory = (ContentHandlerFactory)providers.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Dynamically adding ContentHandlerFactory: " + factory.getClass().getName());
                    }
                    this.addContentHandlerFactory(factory);
                }
                catch (IllegalArgumentException e) {
                    log.error("Error while adding ContentHandlerFactory", e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

