/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class DOM2SAX {
    private static final String EMPTYSTRING = "";
    private static final String XMLNS_PREFIX = "xmlns";
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private Map prefixes = new HashMap();

    public DOM2SAX(ContentHandler handler) {
        this.contentHandler = handler;
        if (handler instanceof LexicalHandler) {
            this.lexicalHandler = (LexicalHandler)((Object)handler);
        }
    }

    public void writeDocument(Document doc, boolean fragment) throws SAXException {
        if (!fragment) {
            this.contentHandler.startDocument();
        }
        Node n = doc.getFirstChild();
        while (n != null) {
            this.writeNode(n);
            n = n.getNextSibling();
        }
        if (!fragment) {
            this.contentHandler.endDocument();
        }
    }

    private boolean startPrefixMapping(String prefix, String uri) throws SAXException {
        boolean pushed = true;
        Stack<String> uriStack = (Stack<String>)this.prefixes.get(prefix);
        if (uriStack != null) {
            if (uriStack.isEmpty()) {
                this.contentHandler.startPrefixMapping(prefix, uri);
                uriStack.push(uri);
            } else {
                String lastUri = (String)uriStack.peek();
                if (!lastUri.equals(uri)) {
                    this.contentHandler.startPrefixMapping(prefix, uri);
                    uriStack.push(uri);
                } else {
                    pushed = false;
                }
            }
        } else {
            this.contentHandler.startPrefixMapping(prefix, uri);
            uriStack = new Stack<String>();
            this.prefixes.put(prefix, uriStack);
            uriStack.push(uri);
        }
        return pushed;
    }

    private void endPrefixMapping(String prefix) throws SAXException {
        Stack uriStack = (Stack)this.prefixes.get(prefix);
        if (uriStack != null) {
            this.contentHandler.endPrefixMapping(prefix);
            uriStack.pop();
        }
    }

    private static String getLocalName(Node node) {
        String localName = node.getLocalName();
        if (localName == null) {
            String qname = node.getNodeName();
            int col = qname.lastIndexOf(58);
            return col > 0 ? qname.substring(col + 1) : qname;
        }
        return localName;
    }

    private void writeNode(Node node) throws SAXException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                String cdata = node.getNodeValue();
                if (this.lexicalHandler != null) {
                    this.lexicalHandler.startCDATA();
                    this.contentHandler.characters(cdata.toCharArray(), 0, cdata.length());
                    this.lexicalHandler.endCDATA();
                    break;
                }
                this.contentHandler.characters(cdata.toCharArray(), 0, cdata.length());
                break;
            }
            case 8: {
                if (this.lexicalHandler == null) break;
                String value = node.getNodeValue();
                this.lexicalHandler.comment(value.toCharArray(), 0, value.length());
                break;
            }
            case 9: {
                this.contentHandler.startDocument();
                Node next = node.getFirstChild();
                while (next != null) {
                    this.writeNode(next);
                    next = next.getNextSibling();
                }
                this.contentHandler.endDocument();
                break;
            }
            case 1: {
                int colon;
                String prefix;
                ArrayList<String> pushedPrefixes = new ArrayList<String>();
                AttributesImpl attrs = new AttributesImpl();
                NamedNodeMap map = node.getAttributes();
                int length = map.getLength();
                int i = 0;
                while (i < length) {
                    Node attr = map.item(i);
                    String qnameAttr = attr.getNodeName();
                    if (qnameAttr.startsWith(XMLNS_PREFIX)) {
                        String uriAttr = attr.getNodeValue();
                        int colon2 = qnameAttr.lastIndexOf(58);
                        String string = prefix = colon2 > 0 ? qnameAttr.substring(colon2 + 1) : EMPTYSTRING;
                        if (this.startPrefixMapping(prefix, uriAttr)) {
                            pushedPrefixes.add(prefix);
                        }
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < length) {
                    Node attr = map.item(i2);
                    String qnameAttr = attr.getNodeName();
                    if (!qnameAttr.startsWith(XMLNS_PREFIX)) {
                        String uriAttr = attr.getNamespaceURI();
                        if (uriAttr != null) {
                            colon = qnameAttr.lastIndexOf(58);
                            String string = prefix = colon > 0 ? qnameAttr.substring(0, colon) : EMPTYSTRING;
                            if (this.startPrefixMapping(prefix, uriAttr)) {
                                pushedPrefixes.add(prefix);
                            }
                        }
                        attrs.addAttribute(attr.getNamespaceURI(), DOM2SAX.getLocalName(attr), qnameAttr, "CDATA", attr.getNodeValue());
                    }
                    ++i2;
                }
                String qname = node.getNodeName();
                String uri = node.getNamespaceURI();
                String localName = DOM2SAX.getLocalName(node);
                if (uri != null) {
                    colon = qname.lastIndexOf(58);
                    String string = prefix = colon > 0 ? qname.substring(0, colon) : EMPTYSTRING;
                    if (this.startPrefixMapping(prefix, uri)) {
                        pushedPrefixes.add(prefix);
                    }
                }
                this.contentHandler.startElement(uri, localName, qname, attrs);
                Node next = node.getFirstChild();
                while (next != null) {
                    this.writeNode(next);
                    next = next.getNextSibling();
                }
                this.contentHandler.endElement(uri, localName, qname);
                int nPushedPrefixes = pushedPrefixes.size();
                int i3 = 0;
                while (i3 < nPushedPrefixes) {
                    this.endPrefixMapping((String)pushedPrefixes.get(i3));
                    ++i3;
                }
                break;
            }
            case 7: {
                this.contentHandler.processingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 3: {
                String data = node.getNodeValue();
                this.contentHandler.characters(data.toCharArray(), 0, data.length());
                break;
            }
        }
    }
}

