/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.ChronColumn;
import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import datastore.FaciesColumn;
import datastore.MetaColumn;
import datastore.ParseException;
import datastore.ZoneColumn;
import java.awt.Color;
import java.util.AbstractList;
import java.util.Iterator;

public class BlockSeriesMetaColumn
extends MetaColumn {
    public String PATTERN_TITLE = "Chron";
    public String LABEL_TITLE = "Chron Label";
    public String SERIES_TITLE = "Series Label";
    public static final int CHRON_TYPE = 1;
    public static final int FACIES_TYPE = 2;
    String curSeries = "";
    MetaColumn curSection = null;
    int type;

    public BlockSeriesMetaColumn(String colName, int type) {
        super(colName);
        switch (type) {
            case 1: {
                this.PATTERN_TITLE = "Chron";
                this.LABEL_TITLE = "Chron Label";
                this.SERIES_TITLE = "Series Label";
                this.type = 1;
                break;
            }
            default: {
                this.PATTERN_TITLE = "Facies";
                this.LABEL_TITLE = "Facies Label";
                this.SERIES_TITLE = "Series Label";
                this.type = 2;
            }
        }
    }

    public void setCurrent(String section, String series, String sWidth, int showColumn, String popup) {
        if (series == null && this.curSeries == null) {
            series = "";
        }
        double width = 0.0;
        try {
            width = Double.parseDouble(sWidth);
        }
        catch (Exception e) {
            width = 0.0;
        }
        this.setCurrentSection(section, showColumn, popup);
        if (width > 0.0) {
            this.stretchSection(width);
        }
        this.curSeries = series;
    }

    protected void setCurrentSection(String section, int showColumn, String popup) {
        if (section == null || section.length() == 0) {
            if (this.curSection == null) {
                section = "Default";
            } else {
                return;
            }
        }
        if (this.curSection != null && this.curSection.name.compareToIgnoreCase(section) == 0) {
            return;
        }
        MetaColumn findSec = null;
        Iterator iter = ((AbstractList)this.subColumns).iterator();
        while (iter.hasNext()) {
            findSec = (MetaColumn)iter.next();
            if (findSec.name.compareToIgnoreCase(section) == 0) break;
            findSec = null;
        }
        if (findSec != null) {
            this.curSection = findSec;
            this.curSection.popup = this.curSection.popup != null && popup != null ? String.valueOf(this.curSection.popup) + "\n" + popup : popup;
        } else {
            this.curSection = new MetaColumn(section);
            if (showColumn != 3) {
                this.curSection.setSelected(showColumn == 1);
            }
            this.curSection.popup = popup;
            DataColumn patternCol = this.type == 1 ? new ChronColumn(this.PATTERN_TITLE) : new FaciesColumn(this.PATTERN_TITLE);
            ZoneColumn labelCol = new ZoneColumn(this.LABEL_TITLE);
            ZoneColumn seriesCol = new ZoneColumn(this.SERIES_TITLE);
            patternCol.drawTitle = false;
            labelCol.drawTitle = false;
            seriesCol.drawTitle = false;
            seriesCol.setOrientation(4);
            labelCol.color = new Coloring(Color.white);
            seriesCol.color = new Coloring(Color.white);
            labelCol.setWidth(40.0);
            seriesCol.setWidth(40.0);
            this.curSection.addColumn(patternCol, true);
            this.curSection.addColumn(labelCol, true);
            this.curSection.addColumn(seriesCol, true);
            this.addColumn(this.curSection, true);
        }
    }

    protected void stretchSection(double newWidth) {
        if (this.curSection == null) {
            return;
        }
        DataColumn seriesCol = this.curSection.getColumnByName(this.SERIES_TITLE);
        if (seriesCol == null) {
            return;
        }
        if (seriesCol.myWidth < newWidth) {
            seriesCol.setWidth(newWidth);
        }
    }

    public void addData(Datapoint dp) {
        if (this.curSection == null) {
            this.setCurrentSection(null, 3, null);
        }
        dp.series = this.curSeries;
        this.curSection.addData(dp);
    }

    public DataColumn finalizeLoading() throws ParseException {
        if (this.subColumns.size() == 1) {
            ((DataColumn)this.subColumns.get((int)0)).drawTitle = false;
        }
        MetaColumn sec = null;
        DataColumn chronCol = null;
        DataColumn labelCol = null;
        DataColumn seriesCol = null;
        Iterator secIter = ((AbstractList)this.subColumns).iterator();
        while (secIter.hasNext()) {
            sec = (MetaColumn)secIter.next();
            chronCol = sec.getColumnByName(this.PATTERN_TITLE);
            labelCol = sec.getColumnByName(this.LABEL_TITLE);
            seriesCol = sec.getColumnByName(this.SERIES_TITLE);
            if (chronCol == null || labelCol == null || seriesCol == null) {
                throw new ParseException("Internal Error: Chron Section's subcolumns aren't in the vector!");
            }
            Iterator pIter = sec.getData();
            String lastSeries = null;
            String lastLabel = null;
            double lastBase = Double.NEGATIVE_INFINITY;
            double lastSeriesBase = Double.NEGATIVE_INFINITY;
            boolean newSeries = false;
            while (pIter.hasNext()) {
                Datapoint tempP;
                Datapoint p = (Datapoint)pIter.next();
                newSeries = false;
                if (lastSeries == null) {
                    tempP = new Datapoint(p);
                    tempP.label = "";
                    tempP.baseAge = p.baseAge;
                    tempP.breaker = true;
                    seriesCol.addData(tempP);
                    lastSeries = p.series;
                    lastSeriesBase = p.baseAge;
                } else if (lastSeries != null && p.series.compareToIgnoreCase(lastSeries) != 0) {
                    tempP = new Datapoint(p);
                    tempP.label = lastSeries;
                    tempP.baseAge = lastSeriesBase;
                    tempP.breaker = false;
                    seriesCol.addData(tempP);
                    lastSeries = null;
                    lastSeriesBase = p.baseAge;
                    newSeries = true;
                    if (p.breaker) {
                        tempP = new Datapoint(p);
                        tempP.label = "";
                        tempP.baseAge = p.baseAge;
                        tempP.breaker = true;
                        seriesCol.addData(tempP);
                        lastSeries = p.series;
                        lastSeriesBase = p.baseAge;
                    }
                }
                if (!pIter.hasNext()) {
                    tempP = new Datapoint(p);
                    tempP.label = p.series;
                    tempP.baseAge = p.baseAge;
                    tempP.breaker = false;
                    seriesCol.addData(tempP);
                    lastSeries = null;
                    lastSeriesBase = p.baseAge;
                }
                if (lastLabel != null && p.label.compareToIgnoreCase(lastLabel) != 0 && !p.breaker || newSeries) {
                    tempP = new Datapoint(p);
                    tempP.label = lastLabel;
                    tempP.baseAge = lastBase;
                    tempP.breaker = false;
                    labelCol.addData(tempP);
                    lastLabel = null;
                    lastBase = p.baseAge;
                }
                if (p.breaker) {
                    if (lastLabel != null) {
                        tempP = new Datapoint(p);
                        tempP.label = lastLabel;
                        tempP.baseAge = lastBase;
                        tempP.breaker = false;
                        labelCol.addData(tempP);
                        lastLabel = null;
                        lastBase = p.baseAge;
                    }
                    tempP = new Datapoint(p);
                    tempP.label = "";
                    tempP.baseAge = p.baseAge;
                    tempP.breaker = true;
                    labelCol.addData(tempP);
                    lastLabel = null;
                    lastBase = p.baseAge;
                }
                if (!pIter.hasNext()) {
                    tempP = new Datapoint(p);
                    tempP.label = p.label;
                    tempP.baseAge = p.baseAge;
                    tempP.breaker = false;
                    labelCol.addData(tempP);
                    lastLabel = null;
                    lastBase = p.baseAge;
                }
                if (!p.breaker) {
                    lastLabel = p.label;
                }
                lastBase = p.baseAge;
                lastSeriesBase = p.baseAge;
                lastSeries = p.series;
                chronCol.addData(p);
                pIter.remove();
            }
        }
        return chronCol;
    }
}

