/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.Datapoint;
import gui.Settings;
import gui.StringWrappingInfo;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class CollisionAvoider {
    public static final int PREF_CENTER = 1;
    public static final int PREF_TOP = 2;
    public static final int PREF_BOTTOM = 3;
    Vector nodeVector = new Vector();
    double top;
    double base;
    double lineWidth = 1.0;
    double regWidth;
    double crunchWidth;
    int prefBorrowDir = 1;
    boolean allowFlip = false;

    public CollisionAvoider(double top, double base, double lineWidth, double regWidth, double crunchWidth) {
        this.top = top;
        this.base = base;
        this.lineWidth = lineWidth;
        this.regWidth = regWidth;
        this.crunchWidth = crunchWidth;
    }

    public void setWidths(double regWidth, double crunchWidth) {
        this.regWidth = regWidth;
        this.crunchWidth = crunchWidth;
    }

    public void setPrefBorrowDir(int newDir) {
        this.prefBorrowDir = newDir;
    }

    public Node getAt(int i) {
        return (Node)this.nodeVector.get(i);
    }

    public int getNumNodes() {
        return this.nodeVector.size();
    }

    public boolean getAllowFlip() {
        return this.allowFlip;
    }

    public void setAllowFlip(boolean b) {
        this.allowFlip = b;
    }

    public void add(Datapoint dp, double top, double base, double topAge, double baseAge, StringWrappingInfo swi) {
        this.add(dp, top, base, topAge, baseAge, swi, 0.0);
    }

    public void add(Datapoint dp, double top, double base, double topAge, double baseAge, StringWrappingInfo swi, double constHeight) {
        Node n = new Node(dp, top, base, topAge, baseAge, swi, constHeight);
        n.allowFlip = this.allowFlip;
        this.nodeVector.add(n);
    }

    public int fillHoles() {
        Node n;
        if (this.nodeVector.size() < 1) {
            return 0;
        }
        Collections.sort(this.nodeVector, new Node());
        Node[] nodes = new Node[this.nodeVector.size()];
        this.nodeVector.toArray(nodes);
        int addCount = 0;
        if (nodes[0].origTop - 1.0E-6 > this.top) {
            n = this.getFillerNode(this.top, nodes[0].origTop, 0.0, nodes[0].origTopAge);
            this.nodeVector.add(n);
            ++addCount;
        }
        int i = 0;
        while (i < nodes.length - 1) {
            if (nodes[i].origBase + 1.0E-6 < nodes[i + 1].origTop) {
                n = this.getFillerNode(nodes[i].origBase, nodes[i + 1].origTop, nodes[i].origBaseAge, nodes[i + 1].origTopAge);
                this.nodeVector.add(n);
                ++addCount;
            }
            ++i;
        }
        if (nodes[nodes.length - 1].origBase + 1.0E-6 < this.base) {
            n = this.getFillerNode(nodes[nodes.length - 1].origBase, this.base, nodes[nodes.length - 1].origBaseAge, 999999.0);
            this.nodeVector.add(n);
            ++addCount;
        }
        return addCount;
    }

    protected Node getFillerNode(double top, double base, double topAge, double baseAge) {
        Datapoint p = new Datapoint();
        p.breaker = true;
        p.baseAge = baseAge;
        Node n = new Node(p, top, base, topAge, baseAge, null, 0.0);
        return n;
    }

    public void scaleToFit() {
        Collections.sort(this.nodeVector, new Node());
        Node[] nodes = new Node[this.nodeVector.size()];
        this.nodeVector.toArray(nodes);
        double curTop = this.top;
        int i = 0;
        while (i < nodes.length) {
            Node node = nodes[i];
            double curBase = node.origBase;
            if (curBase > this.base) {
                curBase = this.base;
            }
            node.rewrap(this.crunchWidth);
            double nodeHeight = curBase - curTop;
            node.freeSpace = nodeHeight - node.getLabelHeight() - this.lineWidth - node.constHeight;
            if (node.flipIfItHelps(this.crunchWidth)) {
                nodeHeight = curBase - curTop;
                node.freeSpace = nodeHeight - node.getLabelHeight() - this.lineWidth - node.constHeight;
            }
            node.calcTop = curTop;
            node.calcBase = curBase;
            curTop = curBase;
            ++i;
        }
        i = 0;
        while (i < nodes.length) {
            if (nodes[i].freeSpace < 0.0) {
                double scaleFactor = (nodes[i].getOrigHeight() + nodes[i].freeSpace - nodes[i].constHeight) / nodes[i].getLabelHeight();
                nodes[i].scale(scaleFactor, this.crunchWidth);
                this.recalcNodeFreeSpace(nodes, i);
            }
            ++i;
        }
    }

    public void pack() {
        Collections.sort(this.nodeVector, new Node());
        Node[] nodes = new Node[this.nodeVector.size()];
        this.nodeVector.toArray(nodes);
        double curTop = this.top;
        int i = 0;
        while (i < nodes.length) {
            Node node = nodes[i];
            double curBase = node.origBase;
            if (curBase > this.base) {
                curBase = this.base;
            }
            node.rewrap(this.crunchWidth);
            double nodeHeight = curBase - curTop;
            node.freeSpace = nodeHeight - node.getLabelHeight() - this.lineWidth - node.constHeight;
            if (node.flipIfItHelps(this.crunchWidth)) {
                nodeHeight = curBase - curTop;
                node.freeSpace = nodeHeight - node.getLabelHeight() - this.lineWidth - node.constHeight;
            }
            node.calcTop = curTop;
            node.calcBase = curBase;
            curTop = curBase;
            ++i;
        }
        double totalFreeSpace = 0.0;
        double totalVariable = 0.0;
        double totalConst = 0.0;
        i = 0;
        while (i < nodes.length) {
            totalFreeSpace += nodes[i].freeSpace;
            totalVariable += nodes[i].getLabelHeight();
            totalConst += this.lineWidth + nodes[i].getConstHeight();
            ++i;
        }
        if (totalFreeSpace < 0.0) {
            double scaleFactor = Math.max(this.base - this.top - totalConst, 0.1) / totalVariable;
            i = 0;
            while (i < nodes.length) {
                nodes[i].scale(scaleFactor, this.crunchWidth);
                this.recalcNodeFreeSpace(nodes, i);
                ++i;
            }
        }
        i = 0;
        while (i < nodes.length) {
            if (nodes[i].freeSpace < 0.0) {
                double borrowBase;
                double borrowTop;
                double neededSpace = -nodes[i].freeSpace;
                double prefTop = this.getPreferredFreeSpaceLeft(nodes, i);
                double prefBase = this.getPreferredFreeSpaceRight(nodes, i);
                if (this.prefBorrowDir == 2) {
                    borrowTop = Math.min(prefTop, neededSpace);
                    borrowBase = Math.min(prefBase, neededSpace - borrowTop);
                } else if (this.prefBorrowDir == 3) {
                    borrowBase = Math.min(prefBase, neededSpace);
                    borrowTop = Math.min(prefTop, neededSpace - borrowBase);
                } else {
                    borrowTop = Math.min(prefTop, neededSpace / 2.0);
                    if (borrowTop + (borrowBase = Math.min(prefBase, neededSpace - borrowTop)) < neededSpace - 1.0E-6) {
                        borrowTop = Math.min(prefTop, neededSpace - borrowBase);
                    }
                }
                if (borrowTop + borrowBase < neededSpace - 1.0E-6) {
                    double totalNeededSpace;
                    double totalTop = this.getFreeSpaceLeft(nodes, i) - prefTop;
                    double totalBase = this.getFreeSpaceRight(nodes, i) - prefBase;
                    if ((borrowTop += Math.min(totalTop, (totalNeededSpace = neededSpace - (borrowTop + borrowBase)) / 2.0)) + (borrowBase += Math.min(totalBase, neededSpace - borrowTop - borrowBase)) < neededSpace - 1.0E-6) {
                        borrowTop += Math.min(totalTop - borrowTop, neededSpace - borrowTop - borrowBase);
                    }
                }
                if (Math.abs(borrowTop) > 1.0E-6) {
                    this.borrowFromLeft(nodes, i, borrowTop, true);
                }
                if (Math.abs(borrowBase) > 1.0E-6) {
                    this.borrowFromRight(nodes, i, borrowBase, true);
                }
            }
            ++i;
        }
    }

    protected double getFreeSpaceLeft(Node[] nodes, int node) {
        if (node == 0) {
            return 0.0;
        }
        double space = 0.0;
        int i = 0;
        while (i < nodes.length && i < node) {
            space += nodes[i].lendableFreeSpace();
            ++i;
        }
        return space;
    }

    protected double getPreferredFreeSpaceLeft(Node[] nodes, int node) {
        if (node == 0 || node >= nodes.length) {
            return 0.0;
        }
        return nodes[node - 1].lendableFreeSpace();
    }

    protected double getFreeSpaceRight(Node[] nodes, int node) {
        if (node + 1 >= nodes.length) {
            return 0.0;
        }
        double space = 0.0;
        int i = node + 1;
        while (i < nodes.length) {
            space += nodes[i].lendableFreeSpace();
            ++i;
        }
        return space;
    }

    protected double getPreferredFreeSpaceRight(Node[] nodes, int node) {
        if (node + 1 >= nodes.length) {
            return 0.0;
        }
        return nodes[node + 1].lendableFreeSpace();
    }

    protected void recalcNodeFreeSpace(Node[] nodes, int whichNode) {
        Node node = nodes[whichNode];
        double nodeHeight = node.calcBase - node.calcTop;
        node.freeSpace = nodeHeight - node.getLabelHeight() - this.lineWidth - node.constHeight;
    }

    protected double borrowFromLeft(Node[] nodes, int node, double howMuch, boolean first) {
        if (node < 0 || Math.abs(howMuch) < 1.0E-6) {
            return 0.0;
        }
        double borrowFromThisNode = 0.0;
        double borrowFromLeftNodes = 0.0;
        borrowFromThisNode = Math.max(0.0, Math.min(nodes[node].lendableFreeSpace(), howMuch));
        nodes[node].calcBase -= borrowFromThisNode;
        this.recalcNodeFreeSpace(nodes, node);
        if (borrowFromThisNode + 1.0E-6 < howMuch) {
            borrowFromLeftNodes = this.borrowFromLeft(nodes, node - 1, howMuch - borrowFromThisNode, false);
            nodes[node].calcTop -= borrowFromLeftNodes;
            if (!first) {
                nodes[node].calcBase -= borrowFromLeftNodes;
            }
            this.recalcNodeFreeSpace(nodes, node);
        }
        return borrowFromThisNode + borrowFromLeftNodes;
    }

    protected double borrowFromRight(Node[] nodes, int node, double howMuch, boolean first) {
        if (node >= nodes.length || Math.abs(howMuch) < 1.0E-6) {
            return 0.0;
        }
        double borrowFromThisNode = 0.0;
        double borrowFromRightNodes = 0.0;
        borrowFromThisNode = Math.max(0.0, Math.min(nodes[node].lendableFreeSpace(), howMuch));
        nodes[node].calcTop += borrowFromThisNode;
        this.recalcNodeFreeSpace(nodes, node);
        if (borrowFromThisNode + 1.0E-6 < howMuch) {
            borrowFromRightNodes = this.borrowFromRight(nodes, node + 1, howMuch - borrowFromThisNode, false);
            nodes[node].calcBase += borrowFromRightNodes;
            if (!first) {
                nodes[node].calcTop += borrowFromRightNodes;
            }
            this.recalcNodeFreeSpace(nodes, node);
        }
        return borrowFromThisNode + borrowFromRightNodes;
    }

    public static class Node
    implements Comparator {
        public Datapoint dp;
        public double calcTop;
        public double calcBase;
        public double origTop;
        public double origBase;
        public double origTopAge;
        public double origBaseAge;
        public StringWrappingInfo swi;
        public double constHeight;
        public double freeSpace;
        public boolean allowFlip;

        public double lendableFreeSpace() {
            return Math.max(0.0, this.freeSpace);
        }

        public Node(Datapoint dp, double top, double base, double topAge, double baseAge, StringWrappingInfo swi, double constHeight) {
            this.dp = dp;
            this.origBase = base;
            this.origTop = top;
            this.origTopAge = topAge;
            this.origBaseAge = baseAge;
            this.swi = swi;
            this.constHeight = constHeight;
            this.freeSpace = 0.0;
            this.calcBase = Double.NaN;
            this.calcTop = Double.NaN;
            this.allowFlip = false;
        }

        public boolean hasTabUp() {
            return !Settings.isEqual(this.origTop, this.calcTop);
        }

        public boolean hasTabDown() {
            return !Settings.isEqual(this.origBase, this.calcBase);
        }

        public double getOrigHeight() {
            return this.origBase - this.origTop;
        }

        public double getCalcHeight() {
            return this.calcBase - this.calcTop;
        }

        public double getLabelHeight() {
            if (this.swi == null) {
                return 0.0;
            }
            return this.swi.getHeight();
        }

        public double getConstHeight() {
            return this.constHeight;
        }

        public void rewrap(double width) {
            if (this.swi == null) {
                return;
            }
            this.swi.rewrap(width);
        }

        public void scale(double factor, double windowWidth) {
            if (this.swi == null) {
                return;
            }
            this.swi.setFontSize((int)(this.swi.getFontSize() * factor));
            this.swi.rewrap(windowWidth);
        }

        public boolean flipIfItHelps(double width) {
            if (!this.allowFlip || this.swi == null) {
                return false;
            }
            if (this.swi.s.getNumLines() <= 1 || this.swi.s.getVis(0).length() <= 1) {
                return false;
            }
            StringWrappingInfo flipped = new StringWrappingInfo(this.swi);
            flipped.flipOrientation();
            flipped.rewrap(width);
            boolean shouldFlip = false;
            double unflippedHeight = this.swi.getHeight() + this.constHeight;
            double flippedHeight = flipped.getHeight() + this.constHeight;
            if (flippedHeight < this.getOrigHeight() && (unflippedHeight >= this.getOrigHeight() || !this.swi.cleanBreaks && flipped.cleanBreaks)) {
                shouldFlip = true;
            }
            if (flippedHeight < this.getOrigHeight() && flipped.getNumLines() < this.swi.getNumLines()) {
                shouldFlip = true;
            }
            if (unflippedHeight > this.getOrigHeight() && flippedHeight < this.getOrigHeight()) {
                shouldFlip = true;
            }
            if (!flipped.cleanBreaks) {
                shouldFlip = false;
            }
            if (shouldFlip) {
                this.swi = flipped;
            }
            return shouldFlip;
        }

        public Node() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof Node) || !(o2 instanceof Node)) {
                return 0;
            }
            Node left = (Node)o1;
            Node right = (Node)o2;
            double val = left.origBase - right.origBase;
            if (val < 1.0E-6 && val > -1.0E-6) {
                return 0;
            }
            if (val < 0.0) {
                return -1;
            }
            return 1;
        }
    }
}

