/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import gui.TSCreator;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DatafileCrypto {
    public static final String[] hashFiles = new String[]{"datastore/AgeAgeColumn.class", "datastore/BlockSeriesMetaColumn.class", "datastore/CollisionAvoider.class", "datastore/Coloring.class", "datastore/DataColumn.class", "datastore/DatafileCrypto.class", "datastore/Datapoint.class", "datastore/Datastore.class", "datastore/EventColumn.class", "datastore/FaciesColumn.class", "datastore/FreehandColumn.class", "datastore/Loader1.class", "datastore/MetaColumn.class", "datastore/PointColumn.class", "datastore/RichTextParser.class", "datastore/RulerColumn.class", "datastore/SequenceColumn.class", "datastore/ZoneColumn.class"};
    public static final String[] decryptedHeaders = new String[]{"format version:", "date:", "age units:"};
    public static final String ENCRYPTED_MARKER_STRING = "TSCreator Encrypted Datafile";

    public static String encrypt(OutputStream outStream, InputStream dataStream, String password, HeaderInfo header) throws IOException {
        int read;
        OutputStreamWriter out = new OutputStreamWriter(outStream);
        byte[] b = new byte[dataStream.available()];
        int totalRead = read = dataStream.read(b, 0, b.length);
        while (totalRead < b.length && dataStream.available() > 0) {
            read = dataStream.read(b, totalRead, b.length - totalRead);
            if (read == -1) break;
            totalRead += read;
        }
        if (totalRead != b.length) {
            return "Entire datafile couldn't be read. Read " + totalRead + " of " + b.length + " bytes.";
        }
        KeyIV keyIv = DatafileCrypto.getKeyFromPassword(password);
        try {
            Cipher cipher = Cipher.getInstance("AES/CFB/PKCS5Padding");
            IvParameterSpec ips = new IvParameterSpec(keyIv.iv);
            cipher.init(1, keyIv.key, ips);
            b = cipher.doFinal(b);
        }
        catch (NoSuchPaddingException e) {
            return "No such padding";
        }
        catch (BadPaddingException e) {
            return "bad padding";
        }
        catch (IllegalBlockSizeException e) {
            return "No such padding";
        }
        catch (InvalidKeyException e) {
            return "Invalid key";
        }
        catch (NoSuchAlgorithmException e) {
            return "AES not available";
        }
        catch (InvalidAlgorithmParameterException e) {
            return "Bad Initialization Vector";
        }
        MessageDigest md = DatafileCrypto.getIntegrityHashFunction();
        md.update(b);
        byte[] encryptedHash = md.digest();
        out.write("TSCreator Encrypted Datafile\r\n");
        out.write("content hash:\t" + DatafileCrypto.byteToHexString(encryptedHash) + "\r\n");
        if (header.message != null && header.message.trim().length() > 0) {
            out.write("message:\t" + header.message + "\r\n");
        }
        out.write("\r\n");
        out.flush();
        outStream.write(b);
        return null;
    }

    public static Cipher getCipher(String password, HeaderInfo header) throws Exception {
        KeyIV keyIv = DatafileCrypto.getKeyFromPassword(password);
        try {
            Cipher cipher = Cipher.getInstance("AES/CFB/PKCS5Padding");
            IvParameterSpec ips = new IvParameterSpec(keyIv.iv);
            cipher.init(2, keyIv.key, ips);
            return cipher;
        }
        catch (NoSuchPaddingException e) {
            throw new Exception("No such padding");
        }
        catch (InvalidKeyException e) {
            throw new Exception("Invalid key");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("AES not available");
        }
    }

    public static MessageDigest getIntegrityHashFunction() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static boolean verifyHash(byte[] hash1, byte[] hash2) {
        if (hash1 != null && hash2 != null && hash1.length == hash2.length) {
            int i = 0;
            while (i < hash1.length) {
                if (hash1[i] != hash2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static String byteToHexString(byte[] b) {
        BigInteger bi = new BigInteger(b);
        return bi.toString(16);
    }

    public static byte[] hexStringToByte(String s) {
        BigInteger bi = new BigInteger(s, 16);
        return bi.toByteArray();
    }

    protected byte[] getProgramHash() {
        Vector<InputStream> streams = new Vector<InputStream>();
        String fileList = "";
        int i22 = 0;
        while (i22 < hashFiles.length) {
            InputStream fis = TSCreator.getInputStream(hashFiles[i22]);
            streams.add(fis);
            fileList = String.valueOf(fileList) + hashFiles[i22];
            ++i22;
        }
        try {
            streams.add(new ByteArrayInputStream(fileList.getBytes("UTF8")));
        }
        catch (UnsupportedEncodingException i22) {
            // empty catch block
        }
        IteratorEnumeration streamEnum = new IteratorEnumeration(((AbstractList)streams).iterator());
        SequenceInputStream hashStream = new SequenceInputStream(streamEnum);
        try {
            int num;
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            DigestInputStream dis = new DigestInputStream(hashStream, md);
            byte[] b = new byte[10240];
            while ((num = dis.available()) > 0) {
                if (num > b.length) {
                    num = b.length;
                }
                dis.read(b, 0, num);
            }
            byte[] hash = md.digest();
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static KeyIV getKeyFromPassword(String password) {
        byte[] pass;
        try {
            pass = password == null || password.length() == 0 ? new byte[]{0} : password.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hash = md.digest(pass);
            int i = 0;
            while (i < 1024) {
                md.reset();
                hash = md.digest(hash);
                ++i;
            }
            byte[] key = new byte[16];
            byte[] iv = new byte[16];
            int i2 = 0;
            while (i2 < 32) {
                if (i2 < 16) {
                    key[i2] = hash[i2];
                } else {
                    iv[i2 - 16] = hash[i2];
                }
                ++i2;
            }
            return new KeyIV(new SecretKeySpec(key, "AES"), iv);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static HeaderInfo readEncryptedHeader(InputStream file) {
        String line;
        BufferedReader in;
        HeaderInfo header;
        block6: {
            header = new HeaderInfo();
            in = new BufferedReader(new InputStreamReader(file));
            line = in.readLine().trim();
            if (line.compareTo(ENCRYPTED_MARKER_STRING) == 0) break block6;
            return null;
        }
        try {
            line = in.readLine().trim();
            while (line.length() > 0) {
                String[] split = DatafileCrypto.splitHeaderLine(line);
                if (split[0].compareToIgnoreCase("message:") == 0) {
                    header.message = split[1];
                }
                if (split[0].compareToIgnoreCase("content hash:") == 0) {
                    header.integrityHash = DatafileCrypto.hexStringToByte(split[1]);
                }
                line = in.readLine().trim();
            }
        }
        catch (IOException e) {
            return null;
        }
        return header;
    }

    public static boolean isDecryptedFile(InputStream file) {
        BufferedReader in = new BufferedReader(new InputStreamReader(file));
        try {
            String line = in.readLine().trim();
            boolean found = false;
            int i = 0;
            while (i < 10 && line.length() > 0) {
                String[] split = DatafileCrypto.splitHeaderLine(line);
                if (split[0].compareToIgnoreCase("format version:") == 0) {
                    found = true;
                    break;
                }
                line = in.readLine().trim();
                ++i;
            }
            return found;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected static String[] splitHeaderLine(String line) {
        String[] stringArray = new String[2];
        stringArray[0] = line;
        String[] ret = stringArray;
        int tabPos = line.indexOf(9);
        if (tabPos < 0) {
            return ret;
        }
        ret[0] = line.substring(0, tabPos);
        if (tabPos + 1 < line.length()) {
            ret[1] = line.substring(tabPos + 1);
        }
        return ret;
    }

    public static class HeaderInfo {
        public String message;
        public byte[] integrityHash = null;
    }

    public static class KeyIV {
        public Key key;
        public byte[] iv;

        public KeyIV(Key key, byte[] iv) {
            this.key = key;
            this.iv = iv;
        }
    }

    public static class IteratorEnumeration
    implements Enumeration {
        Iterator iter;

        public IteratorEnumeration(Iterator iterator) {
            this.iter = iterator;
        }

        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        public Object nextElement() {
            return this.iter.next();
        }
    }
}

