/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.Coloring;
import datastore.DataColumn;
import datastore.Loader1;
import datastore.MetaColumn;
import datastore.ParseException;
import datastore.RulerColumn;
import gui.TSCreator;
import gui.UnicodeInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;

public class Datastore {
    public Date oldestDataDate;
    public String errors;
    public MetaColumn rootColumn;
    public String units = null;
    public Coloring defaultColorScheme = Coloring.USGS;

    public Datastore() {
        this.rootColumn = new MetaColumn("Chart title");
    }

    public int addMetaDecl(String metaName, String newColName) {
        return this.rootColumn.associate(metaName, newColName, true);
    }

    public void addColumn(DataColumn col) {
        this.rootColumn.addColumn(col, true);
    }

    public DataColumn getColumnByName(String name) {
        return this.rootColumn.getColumnByName(name);
    }

    public void setDate(Date d) {
        this.oldestDataDate = d;
    }

    public void clear() {
        this.rootColumn = new MetaColumn("Chart title");
        this.addBasicColumns();
        this.oldestDataDate = null;
        this.clearErrors();
    }

    public void addBasicColumns() {
        RulerColumn age = new RulerColumn("Age");
        this.rootColumn.addColumn(age, true);
    }

    public void clearErrors() {
        this.errors = null;
    }

    public void error(String err) {
        this.errors = this.errors == null ? new String(err) : String.valueOf(this.errors) + "\n" + err;
    }

    public boolean setUnits(String u) {
        u.trim();
        if (this.units != null) {
            return this.units.compareToIgnoreCase(u) == 0;
        }
        this.units = u;
        return true;
    }

    public String getUnits() {
        return this.units;
    }

    public void setDefaultColorScheme(Coloring scheme) {
        if (scheme == Coloring.USGS || scheme == Coloring.NAMED_USGS || scheme == Coloring.UNESCO || scheme == Coloring.NAMED_UNESCO) {
            this.defaultColorScheme = scheme;
        }
    }

    public void load(String filename, boolean resource) throws Exception, ParseException {
        InputStream in = this.getInputStreamForFile(filename, resource);
        try {
            this.load(in);
        }
        catch (ParseException e) {
            in.close();
            throw e;
        }
        in.close();
    }

    public InputStream getInputStreamForFile(String filename, boolean resource) throws Exception {
        InputStream in;
        if (resource) {
            in = TSCreator.getInputStream(filename);
            if (in == null) {
                throw new Exception("failed to open resource!");
            }
        } else {
            try {
                in = new FileInputStream(filename);
            }
            catch (Exception e) {
                throw new Exception("open file failed:\n" + e.toString());
            }
        }
        return in;
    }

    public void load(InputStream input) throws ParseException {
        String enc = null;
        UnicodeInputStream uin = new UnicodeInputStream(input, enc);
        enc = uin.getEncoding();
        new Loader1(uin, enc).loadData(this);
        this.rootColumn.clearPlaceholders();
    }
}

