/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.AgeAgeColumn;
import datastore.BlockSeriesMetaColumn;
import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import datastore.Datastore;
import datastore.EventColumn;
import datastore.FreehandColumn;
import datastore.JavaCharStream;
import datastore.Loader1Constants;
import datastore.Loader1TokenManager;
import datastore.ParseException;
import datastore.PointColumn;
import datastore.SequenceColumn;
import datastore.Token;
import datastore.ZoneColumn;
import gui.TSCreator;
import java.awt.Color;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Vector;

public class Loader1
implements Loader1Constants {
    Datastore ds;
    public Loader1TokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[97];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[10];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    static {
        Loader1.jj_la1_0();
    }

    public void error(String e) {
        this.ds.error(e);
    }

    public final void loadData(Datastore ds) throws ParseException {
        DataColumn prevCol;
        block33: {
            String date;
            String version;
            Coloring chronostrat;
            String units_token;
            block32: {
                units_token = "";
                chronostrat = null;
                prevCol = null;
                this.jj_consume_token(1);
                this.jj_consume_token(7);
                version = this.stringNoQuotes();
                this.newline();
                this.jj_consume_token(2);
                this.jj_consume_token(7);
                date = this.stringNoQuotes();
                this.newline();
                block22: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 3: 
                        case 4: {
                            break;
                        }
                        default: {
                            this.jj_la1[0] = this.jj_gen;
                            break block32;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 3: {
                            this.jj_consume_token(3);
                            this.jj_consume_token(7);
                            units_token = this.stringNoQuotes();
                            this.newline();
                            continue block22;
                        }
                        case 4: {
                            this.jj_consume_token(4);
                            this.jj_consume_token(7);
                            chronostrat = this.columnColor();
                            this.newline();
                            continue block22;
                        }
                    }
                    break;
                }
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.ds = ds;
            double v = Double.parseDouble(version);
            if (v > 1.2) {
                throw new ParseException("Format too new (" + v + "). Only file format versions 1, 1.1 and 1.2 supported with this version of TSCreator. Please use the latest TSCreator to open this file.");
            }
            SimpleDateFormat df = new SimpleDateFormat();
            try {
                ds.setDate(df.parse(date));
            }
            catch (Exception exception) {
                // empty catch block
            }
            String units = "Ma";
            if (units_token != null && units_token.length() > 0) {
                units = units_token;
            }
            if (!ds.setUnits(units)) {
                throw new ParseException("Units of the datafile (" + units + ") don't match the currently loaded data's units: " + ds.getUnits());
            }
            if (chronostrat != null) {
                ds.setDefaultColorScheme(chronostrat);
            }
            block23: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        break block33;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        continue block23;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        this.justNewline();
                        continue block23;
                    }
                }
                break;
            }
            this.jj_la1[3] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        block24: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block24;
                }
            }
            if (this.jj_2_1(3)) {
                prevCol = this.metaColumnDecl(ds, prevCol);
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        prevCol = this.columnDecl(ds, prevCol);
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            while (true) {
                if (!this.jj_2_2(Integer.MAX_VALUE)) continue block24;
                this.newlineNoEOF();
            }
            break;
        }
        this.jj_consume_token(0);
    }

    public final DataColumn metaColumnDecl(Datastore ds, DataColumn prevCol) throws ParseException {
        DataColumn dc;
        String metaName = this.stringNoQuotes();
        this.jj_consume_token(7);
        this.jj_consume_token(5);
        do {
            this.jj_consume_token(7);
            String subName = this.stringNoQuotes();
            if (subName.compareToIgnoreCase("_METACOLUMN_OFF") == 0) {
                dc = ds.getColumnByName(metaName);
                if (dc == null) continue;
                dc.setSelected(false);
                continue;
            }
            if (subName.compareToIgnoreCase("_METACOLUMN_ON") == 0) {
                dc = ds.getColumnByName(metaName);
                if (dc == null) continue;
                dc.setSelected(true);
                continue;
            }
            ds.addMetaDecl(metaName, subName);
        } while (this.jj_2_3(2));
        if (this.jj_2_4(3)) {
            this.jj_consume_token(7);
            this.jj_consume_token(7);
            String popup = this.stringNoQuotes();
            dc = ds.getColumnByName(metaName);
            if (dc != null) {
                dc.popup = popup;
            }
        }
        this.newline();
        return null;
    }

    public final DataColumn columnDecl(Datastore ds, DataColumn prevCol) throws ParseException {
        String width = null;
        Coloring color = null;
        String showTitle = "";
        boolean bShowTitle = true;
        String showColumn = "";
        int iShowColumn = 3;
        String popup = null;
        DataColumn overlay = null;
        String name = this.stringNoQuotes();
        this.jj_consume_token(7);
        String type = this.stringNoQuotes();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        width = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 6: {
                                color = this.columnColor();
                                break;
                            }
                            default: {
                                this.jj_la1[7] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                this.jj_consume_token(7);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 6: {
                                        showTitle = this.stringNoQuotes();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[8] = this.jj_gen;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 7: {
                                        this.jj_consume_token(7);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 6: {
                                                showColumn = this.stringNoQuotes();
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[9] = this.jj_gen;
                                            }
                                        }
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 7: {
                                                this.jj_consume_token(7);
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 6: {
                                                        popup = this.stringNoQuotes();
                                                        break;
                                                    }
                                                    default: {
                                                        this.jj_la1[10] = this.jj_gen;
                                                    }
                                                }
                                                while (true) {
                                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                        case 7: {
                                                            break;
                                                        }
                                                        default: {
                                                            this.jj_la1[11] = this.jj_gen;
                                                            break block0;
                                                        }
                                                    }
                                                    this.jj_consume_token(7);
                                                }
                                            }
                                        }
                                        this.jj_la1[12] = this.jj_gen;
                                        break block0;
                                    }
                                }
                                this.jj_la1[13] = this.jj_gen;
                                break block0;
                            }
                        }
                        this.jj_la1[14] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[15] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        if (showTitle.compareToIgnoreCase("no") == 0 || showTitle.compareToIgnoreCase("notitle") == 0) {
            bShowTitle = false;
        }
        if (showColumn.compareToIgnoreCase("off") == 0) {
            iShowColumn = 2;
        }
        if (showColumn.compareToIgnoreCase("on") == 0) {
            iShowColumn = 1;
        }
        if (type.toString().compareToIgnoreCase("chron") == 0) {
            prevCol = this.columnDataChron(ds, name.toString(), width, color, bShowTitle, iShowColumn, popup, 1);
        } else if (type.toString().compareToIgnoreCase("facies") == 0) {
            prevCol = this.columnDataChron(ds, name.toString(), width, color, bShowTitle, iShowColumn, popup, 2);
        } else if (type.toString().compareToIgnoreCase("block") == 0) {
            prevCol = this.columnDataBlock(ds, name.toString(), width, color, bShowTitle, iShowColumn, popup);
        } else if (type.toString().compareToIgnoreCase("event") == 0) {
            prevCol = this.columnDataEvent(ds, name.toString(), width, color, bShowTitle, iShowColumn, popup);
        } else if (type.toString().compareToIgnoreCase("point") == 0) {
            prevCol = this.columnDataPoint(ds, name.toString(), width, color, bShowTitle, iShowColumn, popup);
        } else if (type.toString().compareToIgnoreCase("sequence") == 0) {
            prevCol = this.columnDataSequence(ds, name.toString(), width, color, bShowTitle, iShowColumn, popup, 1);
        } else if (type.toString().compareToIgnoreCase("trend") == 0) {
            prevCol = this.columnDataSequence(ds, name.toString(), width, color, bShowTitle, iShowColumn, popup, 2);
        } else if (type.toString().compareToIgnoreCase("ageage") == 0) {
            prevCol = this.columnDataAgeAge(ds, name.toString(), width, color, bShowTitle, iShowColumn, popup);
        } else if (type.toString().compareToIgnoreCase("freehand") == 0) {
            prevCol = this.columnDataFreehand(ds, name.toString(), width, color, bShowTitle, iShowColumn, popup, null, true);
        } else if (type.toString().compareToIgnoreCase("freehand-underlay") == 0) {
            overlay = this.columnDataFreehand(ds, name.toString(), width, color, bShowTitle, iShowColumn, popup, prevCol, false);
            if (prevCol == null) {
                throw new ParseException("Freehand underlay without a host column");
            }
            prevCol.addUnderlay(overlay);
        } else if (type.toString().compareToIgnoreCase("freehand-overlay") == 0) {
            overlay = this.columnDataFreehand(ds, name.toString(), width, color, bShowTitle, iShowColumn, popup, prevCol, false);
            if (prevCol == null) {
                throw new ParseException("Freehand overlay without a host column");
            }
            prevCol.addOverlay(overlay);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        TSCreator.logAndShow("column " + name.toString() + " (type: " + type.toString() + ") done!", 1);
        return prevCol;
    }

    public final Coloring columnColor() throws ParseException {
        String color = this.stringNoQuotes();
        if ((color = color.toString().trim()).compareToIgnoreCase("USGS") == 0) {
            return Coloring.USGS;
        }
        if (color.compareToIgnoreCase("USGS-NAMED") == 0) {
            return Coloring.NAMED_USGS;
        }
        if (color.compareToIgnoreCase("UNESCO") == 0) {
            return Coloring.UNESCO;
        }
        if (color.compareToIgnoreCase("UNESCO-NAMED") == 0) {
            return Coloring.NAMED_UNESCO;
        }
        if (color.compareToIgnoreCase("nocolor") == 0) {
            return null;
        }
        if (color.length() > 1) {
            Coloring c = Coloring.getColoring(color);
            if (c == null) {
                throw new ParseException("Error parsing color: " + color + ".\nMust be in the format 'r/g/b' where r, g, and b are between 0 and 255.");
            }
            return c;
        }
        return null;
    }

    public final DataColumn columnDataChron(Datastore ds, String name, String width, Coloring color, boolean showTitle, int showColumn, String popup, int type) throws ParseException {
        BlockSeriesMetaColumn col;
        block10: {
            col = new BlockSeriesMetaColumn(name, type);
            col.drawTitle = showTitle;
            if (showColumn != 3) {
                col.setSelected(showColumn == 1);
            }
            if (width != null) {
                col.setWidth(Double.parseDouble(width));
            }
            col.popup = popup;
            col.setColor(color);
            ds.addColumn(col);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: 
                    case 7: {
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                        break block10;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        this.chronSeriesLabel(col);
                        continue block7;
                    }
                    case 7: {
                        this.columnDataChronTab(col);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[18] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.justNewlineEOF();
        return col.finalizeLoading();
    }

    public final void columnDataChronTab(BlockSeriesMetaColumn col) throws ParseException {
        this.jj_consume_token(7);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.chronSeriesData(col);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 7: {
                            break;
                        }
                        default: {
                            this.jj_la1[19] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(7);
                }
            }
        }
    }

    public final void chronSeriesLabel(BlockSeriesMetaColumn col) throws ParseException {
        String section = null;
        String width = null;
        String showColumn = "";
        String popup = null;
        int iShowColumn = 3;
        String series = this.stringNoQuotes();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        section = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 6: {
                                width = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[22] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                this.jj_consume_token(7);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 6: {
                                        showColumn = this.stringNoQuotes();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[23] = this.jj_gen;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 7: {
                                        this.jj_consume_token(7);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 6: {
                                                popup = this.stringNoQuotes();
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[24] = this.jj_gen;
                                            }
                                        }
                                        while (true) {
                                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                case 7: {
                                                    break;
                                                }
                                                default: {
                                                    this.jj_la1[25] = this.jj_gen;
                                                    break block0;
                                                }
                                            }
                                            this.jj_consume_token(7);
                                        }
                                    }
                                }
                                this.jj_la1[26] = this.jj_gen;
                                break block0;
                            }
                        }
                        this.jj_la1[27] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[28] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        if (showColumn != null) {
            if (showColumn.compareToIgnoreCase("off") == 0) {
                iShowColumn = 2;
            }
            if (showColumn.compareToIgnoreCase("on") == 0) {
                iShowColumn = 1;
            }
        }
        col.setCurrent(section, series, width, iShowColumn, popup);
    }

    public final void chronSeriesData(BlockSeriesMetaColumn col) throws ParseException {
        String label = "";
        String popup = null;
        Datapoint dp = new Datapoint();
        String polarity = this.stringNoQuotes();
        this.jj_consume_token(7);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                label = this.stringNoQuotes();
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
            }
        }
        this.jj_consume_token(7);
        String age = this.stringNoQuotes();
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                block15: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 7: {
                            break;
                        }
                        default: {
                            this.jj_la1[31] = this.jj_gen;
                            break block15;
                        }
                    }
                    this.jj_consume_token(7);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        popup = this.stringNoQuotes();
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 7: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[32] = this.jj_gen;
                                    break block3;
                                }
                            }
                            this.jj_consume_token(7);
                        }
                    }
                }
                this.jj_la1[33] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        dp.value = polarity;
        dp.label = label;
        dp.baseAge = Double.valueOf(age);
        dp.popup = popup;
        if (polarity.compareToIgnoreCase("top") == 0) {
            dp.breaker = true;
        }
        col.addData(dp);
    }

    public final DataColumn columnDataBlock(Datastore ds, String name, String width, Coloring color, boolean showTitle, int showColumn, String popup) throws ParseException {
        ZoneColumn col = new ZoneColumn(name);
        col.drawTitle = showTitle;
        if (showColumn != 3) {
            col.setSelected(showColumn == 1);
        }
        if (width != null) {
            col.setWidth(Double.parseDouble(width));
        }
        col.popup = popup;
        col.setColor(color);
        ds.addColumn(col);
        while (this.jj_2_5(2)) {
            this.jj_consume_token(7);
            this.blockData(col);
        }
        this.newline();
        return col;
    }

    public final void blockData(ZoneColumn col) throws ParseException {
        String line = null;
        String popup = null;
        Datapoint dp = new Datapoint();
        String label = this.stringNoQuotes();
        this.jj_consume_token(7);
        String age = this.stringNoQuotes();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        line = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[35] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 6: {
                                popup = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[36] = this.jj_gen;
                            }
                        }
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 7: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[37] = this.jj_gen;
                                    break block0;
                                }
                            }
                            this.jj_consume_token(7);
                        }
                    }
                }
                this.jj_la1[38] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        dp.label = label;
        dp.baseAge = Double.parseDouble(age);
        dp.lineType = this.getLineType(line);
        dp.popup = popup;
        if (label.compareToIgnoreCase("top") == 0) {
            dp.breaker = true;
        }
        col.addData(dp);
    }

    public final int getLineType(String s) throws ParseException {
        int i;
        block6: {
            if (s == null || s.length() == 0) {
                return 1;
            }
            i = 1;
            try {
                i = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                if (s.compareToIgnoreCase("solid") == 0) {
                    return 1;
                }
                if (s.compareToIgnoreCase("dashed") == 0) {
                    return 2;
                }
                if (s.compareToIgnoreCase("dotted") != 0) break block6;
                return 3;
            }
        }
        if (i == 1 || i == 2 || i == 3) {
            return i;
        }
        return 1;
    }

    public final DataColumn columnDataEvent(Datastore ds, String name, String width, Coloring color, boolean showTitle, int showColumn, String popup) throws ParseException {
        EventColumn col;
        block11: {
            col = new EventColumn(name);
            col.drawTitle = showTitle;
            if (showColumn != 3) {
                col.setSelected(showColumn == 1);
            }
            if (width != null) {
                col.setWidth(Double.parseDouble(width));
            }
            col.popup = popup;
            if (color != null) {
                col.setColor(color);
            }
            ds.addColumn(col);
            String header = this.eventHeader();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: 
                    case 7: {
                        break;
                    }
                    default: {
                        this.jj_la1[40] = this.jj_gen;
                        break block11;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        header = this.eventHeader();
                        continue block7;
                    }
                    case 7: {
                        this.columnDataEventTab(col, header);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[41] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.justNewlineEOF();
        return col;
    }

    public final void columnDataEventTab(EventColumn col, String header) throws ParseException {
        this.jj_consume_token(7);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.eventData(col, header);
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 7: {
                            break;
                        }
                        default: {
                            this.jj_la1[42] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(7);
                }
            }
        }
    }

    public final String eventHeader() throws ParseException {
        String header = this.stringNoQuotes();
        this.newline();
        return header;
    }

    public final void eventData(EventColumn col, String header) throws ParseException {
        String line = null;
        String popup = null;
        Datapoint dp = new Datapoint();
        String label = this.stringNoQuotes();
        this.jj_consume_token(7);
        String age = this.stringNoQuotes();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        line = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[44] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 6: {
                                popup = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[45] = this.jj_gen;
                            }
                        }
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 7: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[46] = this.jj_gen;
                                    break block0;
                                }
                            }
                            this.jj_consume_token(7);
                        }
                    }
                }
                this.jj_la1[47] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        dp.value = header;
        dp.label = label;
        dp.baseAge = Double.valueOf(age);
        dp.lineType = this.getLineType(line);
        dp.popup = popup;
        col.addData(dp);
    }

    public final DataColumn columnDataPoint(Datastore ds, String name, String width, Coloring color, boolean showTitle, int showColumn, String popup) throws ParseException {
        PointColumn col = new PointColumn(name);
        col.drawTitle = showTitle;
        if (showColumn != 3) {
            col.setSelected(showColumn == 1);
        }
        if (width != null) {
            col.setWidth(Double.parseDouble(width));
        }
        col.popup = popup;
        if (color != null) {
            col.setColor(color);
        }
        ds.addColumn(col);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.pointOptions(col);
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
            }
        }
        while (this.jj_2_6(2)) {
            this.pointData(col);
        }
        this.newline();
        return col;
    }

    public final void pointOptions(PointColumn col) throws ParseException {
        String pointType = null;
        String line = null;
        String fill = null;
        String rangeLow = null;
        String rangeHigh = null;
        String smooth = null;
        pointType = this.stringNoQuotes();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        line = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[50] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 6: {
                                fill = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[51] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                this.jj_consume_token(7);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 6: {
                                        rangeLow = this.stringNoQuotes();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[52] = this.jj_gen;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 7: {
                                        this.jj_consume_token(7);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 6: {
                                                rangeHigh = this.stringNoQuotes();
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[53] = this.jj_gen;
                                            }
                                        }
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 7: {
                                                this.jj_consume_token(7);
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 6: {
                                                        smooth = this.stringNoQuotes();
                                                        break;
                                                    }
                                                    default: {
                                                        this.jj_la1[54] = this.jj_gen;
                                                    }
                                                }
                                                while (true) {
                                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                        case 7: {
                                                            break;
                                                        }
                                                        default: {
                                                            this.jj_la1[55] = this.jj_gen;
                                                            break block0;
                                                        }
                                                    }
                                                    this.jj_consume_token(7);
                                                }
                                            }
                                        }
                                        this.jj_la1[56] = this.jj_gen;
                                        break block0;
                                    }
                                }
                                this.jj_la1[57] = this.jj_gen;
                                break block0;
                            }
                        }
                        this.jj_la1[58] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[59] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        if (pointType != null) {
            if (pointType.compareToIgnoreCase("nopoints") == 0) {
                col.drawPoints = false;
            } else if (pointType.compareToIgnoreCase("rect") == 0) {
                col.drawPoints = true;
                col.pointType = 1;
            } else if (pointType.compareToIgnoreCase("circle") == 0) {
                col.drawPoints = true;
                col.pointType = 2;
            } else if (pointType.compareToIgnoreCase("cross") == 0) {
                col.drawPoints = true;
                col.pointType = 3;
            }
        }
        if (line != null) {
            if (line.compareToIgnoreCase("noline") == 0) {
                col.drawLine = false;
            } else if (line.compareToIgnoreCase("line") == 0) {
                col.drawLine = true;
            }
        }
        if (fill != null) {
            if (fill.compareToIgnoreCase("nofill") == 0) {
                col.drawFill = false;
            } else {
                Coloring coloring = Coloring.getColoring(fill);
                if (coloring == null) {
                    throw new ParseException("Error parsing color: " + fill + ".\nMust be in the format 'r/g/b' where r, g, and b are between 0 and 255.");
                }
                Color c = coloring.oneColor;
                col.drawFill = true;
                col.fillColor = c;
            }
        }
        if (rangeLow != null) {
            col.doNotSetWindowAuto = true;
            col.minWindow = Double.parseDouble(rangeLow);
            col.scaleStep = (col.maxWindow - col.minWindow) * 0.2;
        }
        if (rangeHigh != null) {
            col.doNotSetWindowAuto = true;
            col.maxWindow = Double.parseDouble(rangeHigh);
            col.scaleStep = (col.maxWindow - col.minWindow) * 0.2;
        }
        if (smooth != null) {
            if (smooth.compareToIgnoreCase("smoothed") == 0) {
                col.drawSmooth = true;
            } else if (smooth.compareToIgnoreCase("notsmoothed") == 0) {
                col.drawSmooth = false;
            }
        }
    }

    public final void pointData(PointColumn col) throws ParseException {
        String label = null;
        String popup = null;
        Datapoint dp = new Datapoint();
        this.jj_consume_token(7);
        String age = this.stringNoQuotes();
        this.jj_consume_token(7);
        String point = this.stringNoQuotes();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        label = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[61] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 6: {
                                popup = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[62] = this.jj_gen;
                            }
                        }
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 7: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[63] = this.jj_gen;
                                    break block0;
                                }
                            }
                            this.jj_consume_token(7);
                        }
                    }
                }
                this.jj_la1[64] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        dp.value = Double.valueOf(point);
        dp.label = label;
        dp.baseAge = Double.valueOf(age);
        dp.popup = popup;
        col.addData(dp);
    }

    public final DataColumn columnDataSequence(Datastore ds, String name, String width, Coloring color, boolean showTitle, int showColumn, String popup, int type) throws ParseException {
        SequenceColumn col = new SequenceColumn(name, type);
        col.drawTitle = showTitle;
        if (showColumn != 3) {
            col.setSelected(showColumn == 1);
        }
        if (width != null) {
            col.setWidth(Double.parseDouble(width));
        }
        col.popup = popup;
        if (color != null) {
            col.setColor(color);
        }
        ds.addColumn(col);
        while (this.jj_2_7(2)) {
            this.sequenceData(col);
        }
        this.newline();
        return col;
    }

    public final void sequenceData(SequenceColumn col) throws ParseException {
        String label = null;
        String popup = null;
        Datapoint dp = new Datapoint();
        this.jj_consume_token(7);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                label = this.stringNoQuotes();
                break;
            }
            default: {
                this.jj_la1[66] = this.jj_gen;
            }
        }
        this.jj_consume_token(7);
        String direction = this.stringNoQuotes();
        this.jj_consume_token(7);
        String age = this.stringNoQuotes();
        this.jj_consume_token(7);
        String strength = this.stringNoQuotes();
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        popup = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[67] = this.jj_gen;
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 7: {
                            break;
                        }
                        default: {
                            this.jj_la1[68] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(7);
                }
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        double mag = 0.0;
        if (strength.compareToIgnoreCase("Minor") == 0) {
            mag = col.type == 1 ? 0.25 : 0.33;
        } else if (strength.compareToIgnoreCase("Medium") == 0) {
            mag = col.type == 1 ? 0.5 : 0.66;
        } else if (strength.compareToIgnoreCase("Moderate") == 0) {
            mag = col.type == 1 ? 0.5 : 0.66;
        } else if (strength.compareToIgnoreCase("Major") == 0) {
            mag = col.type == 1 ? 0.75 : 1.0;
        }
        dp.value = new Double(mag);
        dp.direction = direction;
        dp.label = label;
        dp.baseAge = Double.valueOf(age);
        dp.popup = popup;
        col.addData(dp);
    }

    public final DataColumn columnDataAgeAge(Datastore ds, String name, String width, Coloring color, boolean showTitle, int showColumn, String popup) throws ParseException {
        AgeAgeColumn col = new AgeAgeColumn(name);
        col.drawTitle = showTitle;
        if (showColumn != 3) {
            col.setSelected(showColumn == 1);
        }
        if (width != null) {
            col.setWidth(Double.parseDouble(width));
        }
        col.popup = popup;
        if (color != null) {
            col.setColor(color);
        }
        ds.addColumn(col);
        while (this.jj_2_8(2)) {
            this.ageAgeData(col);
        }
        this.newline();
        return col;
    }

    public final void ageAgeData(AgeAgeColumn col) throws ParseException {
        String label = null;
        String chronAge = null;
        String type = null;
        String popup = null;
        AgeAgeColumn.AgeAgeDatapoint dp = new AgeAgeColumn.AgeAgeDatapoint();
        this.jj_consume_token(7);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                label = this.stringNoQuotes();
                break;
            }
            default: {
                this.jj_la1[70] = this.jj_gen;
            }
        }
        this.jj_consume_token(7);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                chronAge = this.stringNoQuotes();
                break;
            }
            default: {
                this.jj_la1[71] = this.jj_gen;
            }
        }
        this.jj_consume_token(7);
        String age = this.stringNoQuotes();
        this.jj_consume_token(7);
        String yErrorUp = this.stringNoQuotes();
        this.jj_consume_token(7);
        String yErrorDown = this.stringNoQuotes();
        this.jj_consume_token(7);
        String xErrorRight = this.stringNoQuotes();
        this.jj_consume_token(7);
        String xErrorLeft = this.stringNoQuotes();
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        type = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[72] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 6: {
                                popup = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[73] = this.jj_gen;
                            }
                        }
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 7: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[74] = this.jj_gen;
                                    break block6;
                                }
                            }
                            this.jj_consume_token(7);
                        }
                    }
                }
                this.jj_la1[75] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[76] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        dp.label = label;
        dp.age = Double.valueOf(age);
        if (xErrorRight.charAt(xErrorRight.length() - 1) == '?') {
            dp.xErrorRightQ = true;
            xErrorRight = xErrorRight.substring(0, xErrorRight.length() - 1);
        }
        if (xErrorLeft.charAt(xErrorLeft.length() - 1) == '?') {
            dp.xErrorLeftQ = true;
            xErrorLeft = xErrorLeft.substring(0, xErrorLeft.length() - 1);
        }
        if (yErrorUp.charAt(yErrorUp.length() - 1) == '?') {
            dp.yErrorUpQ = true;
            yErrorUp = yErrorUp.substring(0, yErrorUp.length() - 1);
        }
        if (yErrorDown.charAt(yErrorDown.length() - 1) == '?') {
            dp.yErrorDownQ = true;
            yErrorDown = yErrorDown.substring(0, yErrorDown.length() - 1);
        }
        dp.xErrorRight = Double.valueOf(xErrorRight);
        dp.xErrorLeft = Double.valueOf(xErrorLeft);
        dp.yErrorUp = Math.abs(Double.valueOf(yErrorUp));
        dp.yErrorDown = Math.abs(Double.valueOf(yErrorDown));
        dp.baseAge = chronAge == null ? (dp.chronAge = (dp.yErrorUp + dp.yErrorDown) / 2.0) : (dp.chronAge = Double.valueOf(chronAge).doubleValue());
        if (type == null) {
            dp.pointType = 0;
        } else if (type.compareToIgnoreCase("A") == 0) {
            dp.pointType = 1;
        } else if (type.compareToIgnoreCase("U") == 0) {
            dp.pointType = 2;
        } else if (type.compareToIgnoreCase("O") == 0) {
            dp.pointType = 3;
        }
        dp.popup = popup;
        col.addData(dp);
    }

    public final DataColumn columnDataFreehand(Datastore ds, String name, String width, Coloring color, boolean showTitle, int showColumn, String popup, DataColumn underlay, boolean addToDS) throws ParseException {
        FreehandColumn col = new FreehandColumn(name, underlay);
        col.drawTitle = showTitle;
        if (showColumn != 3) {
            col.setSelected(showColumn == 1);
        }
        if (width != null) {
            col.setWidth(Double.parseDouble(width));
        }
        col.popup = popup;
        if (color != null) {
            col.setColor(color);
        }
        if (addToDS) {
            ds.addColumn(col);
        }
        while (this.jj_2_9(2)) {
            this.freehandHeader(col);
        }
        this.newline();
        return col;
    }

    public final void freehandHeader(FreehandColumn col) throws ParseException {
        String header = this.stringNoQuotes();
        if (header.compareToIgnoreCase("polygon") == 0) {
            this.freehandPolygon(col);
        }
    }

    public final void freehandPolygon(FreehandColumn col) throws ParseException {
        String closed = null;
        String smoothed = null;
        String pattern = null;
        String style = null;
        String popup = null;
        String sx = null;
        String sy = null;
        String smoothedPoint = null;
        FreehandColumn.Polygon poly = new FreehandColumn.Polygon(col);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: {
                        closed = this.stringNoQuotes();
                        break;
                    }
                    default: {
                        this.jj_la1[77] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: {
                        this.jj_consume_token(7);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 6: {
                                smoothed = this.stringNoQuotes();
                                break;
                            }
                            default: {
                                this.jj_la1[78] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                this.jj_consume_token(7);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 6: {
                                        pattern = this.stringNoQuotes();
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[79] = this.jj_gen;
                                    }
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 7: {
                                        this.jj_consume_token(7);
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 6: {
                                                style = this.stringNoQuotes();
                                                break;
                                            }
                                            default: {
                                                this.jj_la1[80] = this.jj_gen;
                                            }
                                        }
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 7: {
                                                this.jj_consume_token(7);
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 6: {
                                                        popup = this.stringNoQuotes();
                                                        break;
                                                    }
                                                    default: {
                                                        this.jj_la1[81] = this.jj_gen;
                                                    }
                                                }
                                                while (true) {
                                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                        case 7: {
                                                            break;
                                                        }
                                                        default: {
                                                            this.jj_la1[82] = this.jj_gen;
                                                            break block0;
                                                        }
                                                    }
                                                    this.jj_consume_token(7);
                                                }
                                            }
                                        }
                                        this.jj_la1[83] = this.jj_gen;
                                        break block0;
                                    }
                                }
                                this.jj_la1[84] = this.jj_gen;
                                break block0;
                            }
                        }
                        this.jj_la1[85] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[86] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[87] = this.jj_gen;
            }
        }
        this.justNewlineEOF();
        if (closed == null || closed.compareToIgnoreCase("closed") == 0) {
            poly.closed = true;
        } else if (closed.compareToIgnoreCase("open") == 0) {
            poly.closed = false;
        } else {
            throw new ParseException("Should the polygon be 'open' or 'closed'? '" + closed + "' is invalid.");
        }
        poly.smoothed = smoothed != null && (smoothed.compareToIgnoreCase("smoothed") == 0 || smoothed.compareToIgnoreCase("smooth") == 0);
        poly.setPattern(pattern);
        poly.setStyle(style);
        if (popup != null) {
            poly.popup = popup;
        }
        while (this.jj_2_10(2)) {
            this.jj_consume_token(7);
            sx = this.stringNoQuotes();
            this.jj_consume_token(7);
            sy = this.stringNoQuotes();
            block33 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: {
                    this.jj_consume_token(7);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 6: {
                            smoothedPoint = this.stringNoQuotes();
                            break;
                        }
                        default: {
                            this.jj_la1[88] = this.jj_gen;
                        }
                    }
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 7: {
                                break;
                            }
                            default: {
                                this.jj_la1[89] = this.jj_gen;
                                break block33;
                            }
                        }
                        this.jj_consume_token(7);
                    }
                }
                default: {
                    this.jj_la1[90] = this.jj_gen;
                }
            }
            this.justNewlineEOF();
            double x = Double.parseDouble(sx);
            double y = Double.parseDouble(sy);
            boolean s = poly.smoothed;
            if (smoothedPoint != null) {
                if (smoothedPoint.compareToIgnoreCase("smooth") == 0 || smoothedPoint.compareToIgnoreCase("smoothed") == 0) {
                    s = true;
                } else if (smoothedPoint.compareToIgnoreCase("sharp") == 0) {
                    s = false;
                }
                smoothedPoint = null;
            }
            poly.addPoint(x, y, s);
        }
        col.addPrimitive(poly);
    }

    public final void justNewline() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[91] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String stringNoQuotes() throws ParseException {
        Token t = this.jj_consume_token(6);
        String s = t.toString();
        while (s.length() >= 2 && s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            s = s.substring(1, s.length() - 1);
        }
        s = s.replaceAll("\"\"", "\"").trim();
        return s;
    }

    public final void justNewlineEOF() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[92] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void newline() throws ParseException {
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[93] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(7);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[94] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void newlineNoEOF() throws ParseException {
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[95] = this.jj_gen;
                    break block8;
                }
            }
            this.jj_consume_token(7);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[96] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            Object var3_3 = null;
            this.jj_save(0, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                Object var3_4 = null;
                this.jj_save(0, xla);
                return true;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.jj_save(0, xla);
                throw throwable;
            }
        }
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            Object var3_3 = null;
            this.jj_save(1, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                Object var3_4 = null;
                this.jj_save(1, xla);
                return true;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.jj_save(1, xla);
                throw throwable;
            }
        }
    }

    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            Object var3_3 = null;
            this.jj_save(2, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                Object var3_4 = null;
                this.jj_save(2, xla);
                return true;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.jj_save(2, xla);
                throw throwable;
            }
        }
    }

    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            Object var3_3 = null;
            this.jj_save(3, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                Object var3_4 = null;
                this.jj_save(3, xla);
                return true;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.jj_save(3, xla);
                throw throwable;
            }
        }
    }

    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            Object var3_3 = null;
            this.jj_save(4, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                Object var3_4 = null;
                this.jj_save(4, xla);
                return true;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.jj_save(4, xla);
                throw throwable;
            }
        }
    }

    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            Object var3_3 = null;
            this.jj_save(5, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                Object var3_4 = null;
                this.jj_save(5, xla);
                return true;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.jj_save(5, xla);
                throw throwable;
            }
        }
    }

    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            Object var3_3 = null;
            this.jj_save(6, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                Object var3_4 = null;
                this.jj_save(6, xla);
                return true;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.jj_save(6, xla);
                throw throwable;
            }
        }
    }

    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            Object var3_3 = null;
            this.jj_save(7, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                Object var3_4 = null;
                this.jj_save(7, xla);
                return true;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.jj_save(7, xla);
                throw throwable;
            }
        }
    }

    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            Object var3_3 = null;
            this.jj_save(8, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                Object var3_4 = null;
                this.jj_save(8, xla);
                return true;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.jj_save(8, xla);
                throw throwable;
            }
        }
    }

    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            Object var3_3 = null;
            this.jj_save(9, xla);
            return bl;
        }
        catch (LookaheadSuccess ls) {
            try {
                Object var3_4 = null;
                this.jj_save(9, xla);
                return true;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.jj_save(9, xla);
                throw throwable;
            }
        }
    }

    private final boolean jj_3_4() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_32();
    }

    private final boolean jj_3R_43() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(8)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(10)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(9)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(0)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_36() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_39()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(7);
    }

    private final boolean jj_3R_38() {
        return this.jj_3R_32();
    }

    private final boolean jj_3R_40() {
        return this.jj_3R_41();
    }

    private final boolean jj_3R_35() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_38()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(7);
    }

    private final boolean jj_3_10() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_32();
    }

    private final boolean jj_3R_37() {
        if (this.jj_3R_32()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_40()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_33() {
        return this.jj_3R_32();
    }

    private final boolean jj_3R_34() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_32();
    }

    private final boolean jj_3R_32() {
        return this.jj_scan_token(6);
    }

    private final boolean jj_3_2() {
        return this.jj_3R_31();
    }

    private final boolean jj_3_8() {
        return this.jj_3R_36();
    }

    private final boolean jj_3_3() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_32();
    }

    private final boolean jj_3_6() {
        return this.jj_3R_34();
    }

    private final boolean jj_3R_30() {
        if (this.jj_3R_32()) {
            return true;
        }
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_scan_token(5);
    }

    private final boolean jj_3_5() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_33();
    }

    private final boolean jj_3_7() {
        return this.jj_3R_35();
    }

    private final boolean jj_3_9() {
        return this.jj_3R_37();
    }

    private final boolean jj_3_1() {
        return this.jj_3R_30();
    }

    private final boolean jj_3R_31() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(7));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_scan_token(8)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(10)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(9)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_39() {
        return this.jj_3R_32();
    }

    private final boolean jj_3R_42() {
        return this.jj_scan_token(7);
    }

    private final boolean jj_3R_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_42()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_43();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{24, 24, 1920, 1920, 64, 64, 64, 64, 64, 64, 64, 128, 128, 128, 128, 128, 128, 192, 192, 128, 64, 64, 64, 64, 64, 128, 128, 128, 128, 128, 64, 128, 128, 64, 128, 64, 64, 128, 128, 128, 192, 192, 128, 64, 64, 64, 128, 128, 128, 64, 64, 64, 64, 64, 64, 128, 128, 128, 128, 128, 128, 64, 64, 128, 128, 128, 64, 64, 128, 128, 64, 64, 64, 64, 128, 128, 128, 64, 64, 64, 64, 64, 128, 128, 128, 128, 128, 128, 64, 128, 128, 1792, 1793, 128, 1793, 128, 1792};
    }

    public Loader1(InputStream stream) {
        this(stream, null);
    }

    public Loader1(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new Loader1TokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 97) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 97) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public Loader1(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new Loader1TokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 97) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 97) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public Loader1(Loader1TokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 97) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(Loader1TokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 97) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int i = 0;
                while (i < this.jj_2_rtns.length) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int i = 0;
            while (i < this.jj_endpos) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
                ++i;
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                int i2 = 0;
                while (i2 < this.jj_expentry.length) {
                    if (oldentry[i2] != this.jj_expentry[i2]) {
                        exists = false;
                        break;
                    }
                    ++i2;
                }
                if (exists) break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[12];
        int i = 0;
        while (i < 12) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        i = 0;
        while (i < 97) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 12) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, Loader1Constants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int i = 0;
        while (i < 10) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                        }
                    }
                } while ((p = p.next) != null);
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
            ++i;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

