/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.DataColumn;
import datastore.EventColumn;
import datastore.RulerColumn;
import gui.FontManager;
import gui.FontOptions;
import gui.ImageGenerator;
import gui.Settings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetaColumn
extends DataColumn {
    public static final int ADDED = 1;
    public static final int REPLACED = 2;
    public static final int DIDNOTHING = 3;
    public static final int CLAIMED = 4;
    protected Vector subColumns = new Vector();
    protected static int blankCount = 1;
    public static final double HEADER_BORDER_WIDTH = Settings.BORDER_WIDTH;
    public static final double COLUMN_BORDER_WIDTH = Settings.BORDER_WIDTH;
    public static final String HEADER_BORDER_STYLE = "stroke-width: 3; stroke: black; shape-rendering: geometricPrecision; ";
    public static final String COLUMN_BORDER_STYLE = "stroke-width: 3; stroke: black; shape-rendering: geometricPrecision; ";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public MetaColumn(String colName) {
        this(colName, false);
    }

    public MetaColumn(String colName, boolean ph) {
        super(colName, ph);
        this.setAllowsChildren(true);
    }

    public JPanel getOptionsPanel(Settings s) {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
            this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
            final MetaColumn thisMC = this;
            final Settings set = s;
            JButton addCol = new JButton("Add Blank Column");
            addCol.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    thisMC.addColumn(new DataColumn("Blank" + blankCount++), true);
                    set.nodeStructureChanged(thisMC);
                }
            });
            JButton addRuler = new JButton("Add Age Column");
            addRuler.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    thisMC.addColumn(new RulerColumn("Age", true), true);
                    set.nodeStructureChanged(thisMC);
                }
            });
            this.optionsPanel.add(addCol);
            this.optionsPanel.add(addRuler);
        }
        return this.optionsPanel;
    }

    public int associate(String metaName, String newColName, boolean defaultHandler) {
        MetaColumn mc;
        Iterator iter = ((AbstractList)this.subColumns).iterator();
        int ret = 3;
        while (iter.hasNext()) {
            int recurRec;
            DataColumn dc = (DataColumn)iter.next();
            if (!(dc instanceof MetaColumn) || (recurRec = (mc = (MetaColumn)dc).associate(metaName, newColName, false)) != 4) continue;
            ret = 4;
        }
        if (this.name.compareToIgnoreCase(metaName) == 0) {
            this.subColumns.add(new MetaColumn(newColName, true));
            ret = 4;
        }
        if (ret != 4 && defaultHandler) {
            mc = new MetaColumn(metaName, true);
            this.subColumns.add(mc);
            ret = mc.associate(metaName, newColName, false);
        }
        return ret;
    }

    public int addColumn(DataColumn newCol, boolean addNotClaimed) {
        Iterator iter = ((AbstractList)this.subColumns).iterator();
        int ret = 3;
        boolean needToAdd = false;
        while (iter.hasNext()) {
            DataColumn dc = (DataColumn)iter.next();
            if (dc.name.compareToIgnoreCase(newCol.name) == 0) {
                if (dc.placeHolder) {
                    iter.remove();
                }
                needToAdd = true;
                if (!dc.placeHolder) {
                    ret = 2;
                    continue;
                }
                if (ret != 3) continue;
                ret = 1;
                continue;
            }
            if (!(dc instanceof MetaColumn)) continue;
            MetaColumn mc = (MetaColumn)dc;
            int recurRet = mc.addColumn(newCol, false);
            if (recurRet == 2) {
                ret = 2;
                continue;
            }
            if (recurRet != 1 || ret == 2) continue;
            ret = 1;
        }
        if (needToAdd || addNotClaimed && ret == 3) {
            this.subColumns.add(newCol);
            super.add(newCol);
            newCol.fonts.setParent(this.fonts);
        }
        return ret;
    }

    public void clearPlaceholders() {
        Iterator iter = ((AbstractList)this.subColumns).iterator();
        int i = 0;
        while (iter.hasNext()) {
            DataColumn dc = (DataColumn)iter.next();
            if (dc.placeHolder) {
                if (dc instanceof MetaColumn) {
                    MetaColumn mc = (MetaColumn)dc;
                    mc.clearPlaceholders();
                    if (mc.subColumns.size() != 0) {
                        mc.stabilizePlaceHolder(this, i);
                    } else {
                        iter.remove();
                    }
                } else {
                    iter.remove();
                }
            }
            ++i;
        }
    }

    protected void stabilizePlaceHolder(MetaColumn parent, int treeIndex) {
        this.placeHolder = false;
        parent.insert(this, treeIndex);
    }

    /*
     * Unable to fully structure code
     */
    public DataColumn getColumnByName(String searchName) {
        iter = this.subColumns.iterator();
        if (this.name.compareTo(searchName) != 0) ** GOTO lbl9
        return this;
lbl-1000:
        // 1 sources

        {
            dc = (DataColumn)iter.next();
            if (dc.name.compareTo(searchName) == 0) {
                return dc;
            }
            if (!(dc instanceof MetaColumn) || (recurRet = (mc = (MetaColumn)dc).getColumnByName(searchName)) == null) continue;
            return recurRet;
lbl9:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl10:
        // 1 sources

        return null;
    }

    public DataColumn getColumnByID(String searchID, boolean recurse, boolean onlyNotLoaded) {
        Iterator iter = ((AbstractList)this.subColumns).iterator();
        while (iter.hasNext()) {
            MetaColumn mc;
            DataColumn recurRet;
            DataColumn dc = (DataColumn)iter.next();
            if ((onlyNotLoaded && !dc.isLoaded || !onlyNotLoaded) && dc.id.compareTo(searchID) == 0) {
                return dc;
            }
            if (!(dc instanceof MetaColumn) || !recurse || (recurRet = (mc = (MetaColumn)dc).getColumnByID(searchID, recurse, onlyNotLoaded)) == null) continue;
            return recurRet;
        }
        return null;
    }

    public void moveColumn(DataColumn col, int howFar) {
        int curI = this.subColumns.indexOf(col);
        if (curI < 0) {
            return;
        }
        int newI = (curI + howFar) % this.subColumns.size();
        while (newI < 0) {
            newI += this.subColumns.size();
        }
        col.removeFromParent();
        this.insert(col, newI);
        Object c = this.subColumns.remove(curI);
        this.subColumns.add(newI, c);
    }

    public void setParentFontManager(FontManager parentFM) {
        this.fonts.setParent(parentFM);
        Iterator iter = ((AbstractList)this.subColumns).iterator();
        int i = 0;
        while (iter.hasNext()) {
            DataColumn dc = (DataColumn)iter.next();
            dc.setParentFontManager(this.fonts);
            ++i;
        }
    }

    public void setVariableColoring(Settings s) {
        super.setVariableColoring(s);
        Iterator iter = ((AbstractList)this.subColumns).iterator();
        int i = 0;
        while (iter.hasNext()) {
            DataColumn dc = (DataColumn)iter.next();
            dc.setVariableColoring(s);
            ++i;
        }
    }

    public int[] getRelevantFonts() {
        int[] ret = FontManager.getRelevantFonts(this.getClass());
        Iterator iter = ((AbstractList)this.subColumns).iterator();
        int i = 0;
        while (iter.hasNext()) {
            DataColumn dc = (DataColumn)iter.next();
            ret = FontManager.uniqueArrayUnion(ret, dc.getRelevantFonts());
            ++i;
        }
        return ret;
    }

    public FontOptions getFontOptionsPanel() {
        int[] fontsToDo;
        FontOptions fo = super.getFontOptionsPanel();
        int[] nArray = this.getRelevantFonts();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("datastore.MetaColumn");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((fontsToDo = FontManager.uniqueArraySubtract(nArray, FontManager.getRelevantFonts(clazz))).length > 0) {
            JPanel p = fo.addNestedAddPanel();
            p.setBorder(BorderFactory.createTitledBorder("Additional fonts for child columns"));
            fo.addOptions(fontsToDo, true);
        }
        return fo;
    }

    public double getWidth(Settings settings, ImageGenerator ig) {
        DataColumn col;
        Iterator iter = ((AbstractList)this.subColumns).iterator();
        int ret = 0;
        DataColumn lastSelColumn = null;
        while (iter.hasNext()) {
            col = (DataColumn)iter.next();
            if (!col.shouldDraw()) continue;
            lastSelColumn = col;
        }
        iter = ((AbstractList)this.subColumns).iterator();
        while (iter.hasNext()) {
            col = (DataColumn)iter.next();
            if (!col.shouldDraw()) continue;
            ret = (int)((double)ret + col.getWidth(settings, ig));
            if (col == lastSelColumn) continue;
            ret = (int)((double)ret + Settings.BORDER_WIDTH);
        }
        this.myWidth = ret;
        return ret;
    }

    public double getHeaderHeight(Settings settings, ImageGenerator ig) {
        DataColumn col;
        Iterator iter = ((AbstractList)this.subColumns).iterator();
        double maxSubHeight = 0.0;
        while (iter.hasNext()) {
            col = (DataColumn)iter.next();
            if (!col.shouldDraw()) continue;
            maxSubHeight = Math.max(maxSubHeight, col.getHeaderHeight(settings, ig));
        }
        iter = ((AbstractList)this.subColumns).iterator();
        while (iter.hasNext()) {
            col = (DataColumn)iter.next();
            if (!col.shouldDraw()) continue;
            col.setHeaderHeight(maxSubHeight);
        }
        this.nameWrap = ig.wrapString(this.name, this.myWidth, this.fonts.getFont(0));
        if (this.name.length() != 0 && this.drawTitle) {
            Rectangle2D textBounds = ig.getStringBounds(this.nameWrap);
            this.myOwnHeaderHeight = textBounds.getHeight();
        } else {
            this.myOwnHeaderHeight = 0.0;
        }
        this.myHeaderHeight = maxSubHeight + this.myOwnHeaderHeight;
        return this.myHeaderHeight;
    }

    public void setHeaderHeight(double newHeight) {
        this.myOwnHeaderHeight += newHeight - this.myHeaderHeight;
        this.myHeaderHeight = newHeight;
    }

    public void drawHeader(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        DataColumn col;
        if (this.myWidth < 0.0) {
            this.myWidth = this.getWidth(settings, ig);
        }
        if (this.myHeaderHeight < 0.0) {
            this.myHeaderHeight = this.getHeaderHeight(settings, ig);
        }
        Iterator iter = ((AbstractList)this.subColumns).iterator();
        if (this.name.length() != 0 && this.drawTitle) {
            ig.drawString(this.nameWrap, startx, starty, width, this.myOwnHeaderHeight, 3);
        }
        if (this.popup != null && settings.doPopups) {
            ig.pushGrouping();
            ig.doPopupThings(this.popup);
            ig.drawRect(startx, starty, width, this.myOwnHeaderHeight, "stroke-width: 0; opacity: 0.5; fill: red;");
            ig.popGrouping();
        }
        double saveStartx = startx;
        DataColumn lastSelColumn = null;
        while (iter.hasNext()) {
            col = (DataColumn)iter.next();
            if (!col.shouldDraw()) continue;
            col.drawHeader(ig, startx, starty + this.myOwnHeaderHeight, col.myWidth, height - this.myOwnHeaderHeight, settings);
            startx += col.myWidth;
            startx += Settings.BORDER_WIDTH;
            lastSelColumn = col;
        }
        startx = saveStartx;
        iter = ((AbstractList)this.subColumns).iterator();
        while (iter.hasNext()) {
            col = (DataColumn)iter.next();
            if (!col.shouldDraw()) continue;
            startx += col.myWidth;
            if (col != lastSelColumn) {
                ig.drawLine(startx + HEADER_BORDER_WIDTH / 2.0, starty + this.myOwnHeaderHeight + col.myHeaderHeight / 2.0, startx + HEADER_BORDER_WIDTH / 2.0, starty + height + HEADER_BORDER_WIDTH / 2.0, "stroke-width: 3; stroke: black; shape-rendering: geometricPrecision; ");
            }
            startx += Settings.BORDER_WIDTH;
        }
    }

    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        DataColumn col;
        if (this.myWidth < 0.0) {
            this.myWidth = this.getWidth(settings, ig);
        }
        if (this.myHeaderHeight < 0.0) {
            this.myHeaderHeight = this.getHeaderHeight(settings, ig);
        }
        Iterator iter = ((AbstractList)this.subColumns).iterator();
        double saveStartx = startx;
        DataColumn lastSelColumn = null;
        iter = ((AbstractList)this.subColumns).iterator();
        while (iter.hasNext()) {
            col = (DataColumn)iter.next();
            if (!col.shouldDraw()) continue;
            col.drawData(ig, startx, starty, col.myWidth, height, settings);
            startx += col.myWidth;
            startx += Settings.BORDER_WIDTH;
            lastSelColumn = col;
        }
        startx = saveStartx;
        iter = ((AbstractList)this.subColumns).iterator();
        while (iter.hasNext()) {
            col = (DataColumn)iter.next();
            if (col.shouldDraw()) {
                startx += col.myWidth;
                if (col != lastSelColumn) {
                    ig.drawLine(startx + COLUMN_BORDER_WIDTH / 2.0, starty - COLUMN_BORDER_WIDTH / 2.0, startx + COLUMN_BORDER_WIDTH / 2.0, starty + height + COLUMN_BORDER_WIDTH / 2.0, "stroke-width: 3; stroke: black; shape-rendering: geometricPrecision; ");
                    startx += Settings.BORDER_WIDTH;
                }
            }
            if (!(col instanceof EventColumn)) continue;
            ((EventColumn)col).cleanupDrawing();
        }
    }

    public boolean grayOutIfEmpty(double topAge, double baseAge, boolean en) {
        boolean lastGO = this.grayedOut;
        this.grayedOut = !this.isRoot();
        Iterator iter = ((AbstractList)this.subColumns).iterator();
        while (iter.hasNext()) {
            DataColumn dc = (DataColumn)iter.next();
            if (dc.grayOutIfEmpty(topAge, baseAge, en)) continue;
            this.grayedOut = false;
        }
        if (lastGO != this.grayedOut) {
            this.setName(this.name);
        }
        return this.grayedOut;
    }

    public boolean shouldDraw() {
        boolean sup = super.shouldDraw();
        if (!sup) {
            return sup;
        }
        Iterator iter = ((AbstractList)this.subColumns).iterator();
        while (iter.hasNext()) {
            DataColumn dc = (DataColumn)iter.next();
            if (!dc.shouldDraw()) continue;
            return true;
        }
        return false;
    }

    public void setLoaded(boolean l) {
        this.isLoaded = l;
        Iterator iter = ((AbstractList)this.subColumns).iterator();
        while (iter.hasNext()) {
            DataColumn dc = (DataColumn)iter.next();
            dc.setLoaded(l);
        }
    }

    public void readSettings(Element element, Settings settings) {
        super.readSettings(element, settings);
        NodeList nl = element.getChildNodes();
        int numReadColumns = 0;
        int nodeIndex = 0;
        while (nodeIndex < nl.getLength()) {
            Node node = nl.item(nodeIndex);
            if (node.getNodeType() == 1 && node.getNodeName().compareToIgnoreCase("column") == 0) {
                Element column = (Element)node;
                try {
                    String colID = column.getAttribute("id");
                    DataColumn loadee = this.getColumnByID(colID, false, true);
                    if (loadee == null) {
                        StringTokenizer st = new StringTokenizer(colID, ":");
                        try {
                            String colType = st.nextToken();
                            String colName = st.nextToken();
                            Class<?> clazz = class$1;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("datastore.DataColumn");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (colType.compareTo(clazz.toString()) == 0) {
                                loadee = new DataColumn(colName);
                            } else {
                                Class<?> clazz2 = class$2;
                                if (clazz2 == null) {
                                    try {
                                        clazz2 = Class.forName("datastore.RulerColumn");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (colType.compareTo(clazz2.toString()) == 0) {
                                    loadee = new RulerColumn(colName);
                                }
                            }
                            if (loadee != null) {
                                this.addColumn(loadee, true);
                                settings.nodeStructureChanged(this);
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            // empty catch block
                        }
                    }
                    if (loadee != null) {
                        loadee.readSettings(column, settings);
                        loadee.fonts.setParent(this.fonts);
                        int curIndex = this.subColumns.indexOf(loadee);
                        if (curIndex > 0) {
                            this.moveColumn(loadee, numReadColumns - curIndex + 1);
                            ++numReadColumns;
                            settings.nodeStructureChanged(this);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            ++nodeIndex;
        }
    }

    public void writeSettings(Element element, Document doc) {
        super.writeSettings(element, doc);
        Iterator iter = ((AbstractList)this.subColumns).iterator();
        int i = 0;
        while (iter.hasNext()) {
            DataColumn dc = (DataColumn)iter.next();
            Element dcE = doc.createElement("column");
            dc.writeSettings(dcE, doc);
            element.appendChild(dcE);
            ++i;
        }
    }
}

