/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.Coloring;
import datastore.DataColumn;
import gui.ImageGenerator;
import gui.Settings;
import gui.StringWrappingInfo;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RulerColumn
extends DataColumn {
    public double minorInterval;
    public double majorInterval;
    public double labelInterval;
    public static double UNITS_PER_TICK = 6.0;
    public static double[] SUBDIVISIONS = new double[]{2.0, 5.0, 10.0};
    public static double[] SUBDIVISION_FACTOR = new double[]{0.5, 0.4, 0.5};
    public boolean mirrored = false;
    public boolean transposed = false;
    public static double MINOR_TICK_LENGTH = 5.0;
    public static String MINOR_TICK_STYLE = "stroke-width: 1; stroke: black;";
    public static double MAJOR_TICK_LENGTH = 10.0;
    public static String MAJOR_TICK_STYLE = "stroke-width: 3; stroke: black;";
    public static double LABEL_LEFT_SPACE = 2.0;
    public static double LABEL_RIGHT_SPACE = 2.0;
    public static double LABEL_TOP_SPACE = 0.0;
    public static double LABEL_BOTTOM_SPACE = 1.0;
    double maxLabelWidth;

    public RulerColumn(String colName) {
        super(colName);
        this.color = new Coloring(Color.white);
    }

    public RulerColumn(String colName, boolean mirrored) {
        this(colName);
        this.mirrored = mirrored;
    }

    public boolean grayOutIfEmpty(double topAge, double baseAge, boolean en) {
        this.grayedOut = false;
        return this.grayedOut;
    }

    public JPanel getOptionsPanel(Settings s) {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
            this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
            final RulerColumn thisRC = this;
            JRadioButton leftR = new JRadioButton("Left Justified");
            JRadioButton rightR = new JRadioButton("Right Justified");
            ButtonGroup group = new ButtonGroup();
            group.add(leftR);
            group.add(rightR);
            if (thisRC.mirrored) {
                leftR.setSelected(true);
            } else {
                rightR.setSelected(true);
            }
            leftR.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent ie) {
                    if (((JRadioButton)ie.getItem()).isSelected()) {
                        thisRC.mirrored = true;
                    }
                }
            });
            rightR.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent ie) {
                    if (((JRadioButton)ie.getItem()).isSelected()) {
                        thisRC.mirrored = false;
                    }
                }
            });
            this.optionsPanel.add(leftR);
            this.optionsPanel.add(rightR);
        }
        return this.optionsPanel;
    }

    public double getWidth(Settings settings, ImageGenerator ig) {
        int numChars = (int)Math.ceil(Math.log(settings.baseAge) / Math.log(10.0));
        if (numChars <= 0) {
            numChars = 1;
        }
        String testLabel = "";
        int i = 0;
        while (i < numChars) {
            testLabel = String.valueOf(testLabel) + "0";
            ++i;
        }
        StringWrappingInfo testLabelSWI = ig.getSWIOneLine(testLabel, this.fonts.getFont(6), 1);
        this.maxLabelWidth = testLabelSWI.getWidth();
        this.myWidth = LABEL_LEFT_SPACE + this.maxLabelWidth + LABEL_RIGHT_SPACE + Math.max(MINOR_TICK_LENGTH, MAJOR_TICK_LENGTH);
        if (this.drawTitle) {
            testLabelSWI = ig.getSWIOneLine("Age ", this.fonts.getFont(0), 1);
            this.myWidth = Math.max(testLabelSWI.getWidth(), this.myWidth);
        }
        return this.myWidth;
    }

    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        int mulIndex;
        double MYperTick;
        super.drawData(ig, startx, starty, width, height, settings);
        this.minorInterval = 0.2;
        this.majorInterval = 1.0;
        this.labelInterval = 5.0;
        if (this.transposed) {
            double temp = startx;
            startx = starty;
            starty = temp;
            temp = width;
            width = height;
            height = temp;
        }
        if ((MYperTick = UNITS_PER_TICK / settings.unitsPerMY) < 1.0) {
            this.minorInterval = 1.0;
            mulIndex = 0;
            while (this.minorInterval > MYperTick) {
                if (this.minorInterval * SUBDIVISION_FACTOR[mulIndex] < MYperTick) break;
                this.minorInterval *= SUBDIVISION_FACTOR[mulIndex];
                mulIndex = (mulIndex + 1) % SUBDIVISION_FACTOR.length;
            }
            if (this.minorInterval == 1.0) {
                this.minorInterval = -1.0;
            }
            this.labelInterval = this.majorInterval * 5.0;
        } else {
            this.minorInterval = -1.0;
            mulIndex = 0;
            while (this.majorInterval < MYperTick) {
                this.majorInterval /= SUBDIVISION_FACTOR[mulIndex];
                mulIndex = (mulIndex + 1) % SUBDIVISION_FACTOR.length;
            }
            this.labelInterval = this.majorInterval * 5.0;
        }
        if ((settings.baseAge - settings.topAge) / this.labelInterval <= 2.0 || this.majorInterval / this.minorInterval >= 10.0) {
            this.labelInterval = this.majorInterval;
        }
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(0);
        double lastLabelBottom = starty;
        double majorTickX = this.mirrored ? startx + MAJOR_TICK_LENGTH : startx + width - MAJOR_TICK_LENGTH;
        double minorTickX = this.mirrored ? startx + MINOR_TICK_LENGTH : startx + width - MINOR_TICK_LENGTH;
        double sideX = this.mirrored ? startx : startx + width;
        double scaleStart = 0.0;
        double scaleStep = this.minorInterval < 0.0 ? this.majorInterval : this.minorInterval;
        double tickMY = 0.0;
        tickMY = scaleStart > settings.topAge ? scaleStart - Math.floor((scaleStart - settings.topAge) / scaleStep) * scaleStep : scaleStart + Math.ceil((settings.topAge - scaleStart) / scaleStep) * scaleStep;
        while (tickMY < settings.baseAge) {
            block22: {
                double tickX;
                block21: {
                    block20: {
                        if (!Settings.isMultiple(tickMY, this.majorInterval)) break block20;
                        if (!this.transposed) {
                            ig.drawLineYear(sideX, tickMY, majorTickX, tickMY, MAJOR_TICK_STYLE, starty);
                        } else {
                            double tickY = (tickMY - settings.topAge) * settings.unitsPerMY + starty;
                            ig.drawLine(tickY, sideX, tickY, majorTickX, MAJOR_TICK_STYLE);
                        }
                        tickX = majorTickX;
                        break block21;
                    }
                    if (!(this.minorInterval > 0.0)) break block22;
                    if (!this.transposed) {
                        ig.drawLineYear(sideX, tickMY, minorTickX, tickMY, MINOR_TICK_STYLE, starty);
                    } else {
                        double tickY = (tickMY - settings.topAge) * settings.unitsPerMY + starty;
                        ig.drawLine(tickY, sideX, tickY, minorTickX, MINOR_TICK_STYLE);
                    }
                    tickX = minorTickX;
                }
                if (Settings.isMultiple(tickMY, this.labelInterval)) {
                    double labelTop;
                    String label = nf.format(tickMY);
                    StringWrappingInfo labelSWI = ig.getSWIOneLine(label, this.fonts.getFont(6), 1);
                    double labelAgeSideSize = labelSWI.getHeight() + LABEL_BOTTOM_SPACE + LABEL_TOP_SPACE;
                    double labelPerpSize = labelSWI.getWidth();
                    if (this.transposed) {
                        labelAgeSideSize = labelSWI.getWidth() + LABEL_BOTTOM_SPACE + LABEL_TOP_SPACE;
                        labelPerpSize = labelSWI.getHeight();
                    }
                    if (!((labelTop = Math.max(lastLabelBottom, Math.min(starty + height - labelAgeSideSize, ImageGenerator.getYFromYear(tickMY, starty, settings) - labelAgeSideSize / 2.0))) + labelAgeSideSize > starty + height) && !(labelTop + labelAgeSideSize > ImageGenerator.getYFromYear(tickMY + this.labelInterval, starty, settings))) {
                        double labelLeft;
                        double d = labelLeft = this.mirrored ? tickX + LABEL_LEFT_SPACE : tickX - LABEL_RIGHT_SPACE - labelPerpSize;
                        if (!this.transposed) {
                            ig.drawString(labelSWI, labelLeft, labelTop, labelPerpSize, labelAgeSideSize, 2);
                        } else {
                            ig.drawString(labelSWI, labelTop, labelLeft, labelAgeSideSize, labelPerpSize, 2);
                        }
                        lastLabelBottom = labelTop + labelPerpSize;
                    }
                }
            }
            tickMY += scaleStep;
        }
        this.drawOverlays(ig, startx, starty, width, height, settings);
    }

    public void readOneSetting(Element setting, Settings settings) {
        super.readOneSetting(setting, settings);
        String name = setting.getAttribute("name");
        if (name != null && name.compareToIgnoreCase("justification") == 0) {
            String t = setting.getAttribute("justification");
            this.mirrored = t.compareToIgnoreCase("left") == 0;
        }
    }

    public void writeSettings(Element element, Document doc) {
        super.writeSettings(element, doc);
        Element typeE = Settings.createSimpleSetting(doc, "justification", null);
        if (this.mirrored) {
            typeE.setAttribute("justification", "left");
        } else {
            typeE.setAttribute("justification", "right");
        }
        element.appendChild(typeE);
    }
}

