/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.CollisionAvoider;
import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import gui.ImageGenerator;
import gui.RichText;
import gui.Settings;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ZoneColumn
extends DataColumn {
    public static int LINE_WIDTH = 1;
    public static String LINE_STYLE = "stroke-width: 1; stroke: black;";
    public static int DEFAULT_CRUNCH_OUTER_MARGIN = 5;
    public static int DEFAULT_CRUNCH_INNER_MARGIN = 1;
    public static int DEFAULT_CRUNCH_ASCEND_WIDTH = 4;
    public static int DEFAULT_CRUNCH_ONE_SIDE_SPACE_USE = DEFAULT_CRUNCH_OUTER_MARGIN + DEFAULT_CRUNCH_ASCEND_WIDTH + DEFAULT_CRUNCH_INNER_MARGIN;
    public static int SMALLER_CRUNCH_OUTER_MARGIN = 0;
    public static int SMALLER_CRUNCH_INNER_MARGIN = 1;
    public static int SMALLER_CRUNCH_ASCEND_WIDTH = 3;
    public static int SMALLER_CRUNCH_ONE_SIDE_SPACE_USE = SMALLER_CRUNCH_OUTER_MARGIN + SMALLER_CRUNCH_INNER_MARGIN + SMALLER_CRUNCH_ASCEND_WIDTH;
    public int crunchOuterMargin = DEFAULT_CRUNCH_OUTER_MARGIN;
    public int crunchInnerMargin = DEFAULT_CRUNCH_INNER_MARGIN;
    public int crunchAscendWidth = DEFAULT_CRUNCH_ASCEND_WIDTH;
    public int crunchOneSideSpaceUse = DEFAULT_CRUNCH_ONE_SIDE_SPACE_USE;
    public int orientation = 1;
    public boolean autoFlip = true;

    public ZoneColumn(String colName) {
        super(colName);
        this.MIN_COL_WIDTH = 20.0;
        if (this.name.compareToIgnoreCase("Sub-Era") == 0) {
            this.maxChronostratLevel = 3;
        } else if (this.name.compareToIgnoreCase("Sub-Period") == 0) {
            this.maxChronostratLevel = 5;
        }
    }

    public JPanel getOptionsPanel(Settings s) {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
            this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 3));
            final ZoneColumn thisZC = this;
            final JRadioButton rNormal = new JRadioButton("Horizontal");
            final JRadioButton rVertical = new JRadioButton("Vertical");
            ButtonGroup orientGroup = new ButtonGroup();
            orientGroup.add(rNormal);
            orientGroup.add(rVertical);
            final JCheckBox bAutoFlip = new JCheckBox("Auto Flip Label");
            ItemListener il = new ItemListener(){

                public void itemStateChanged(ItemEvent ie) {
                    Object source = ie.getSource();
                    if (source == bAutoFlip) {
                        thisZC.autoFlip = bAutoFlip.isSelected();
                    } else if (source == rNormal || source == rVertical) {
                        if (rVertical.isSelected()) {
                            thisZC.setOrientation(4);
                        } else {
                            thisZC.setOrientation(1);
                        }
                    }
                }
            };
            bAutoFlip.addItemListener(il);
            rNormal.addItemListener(il);
            rVertical.addItemListener(il);
            bAutoFlip.setSelected(this.autoFlip);
            if (this.getOrientation() == 4) {
                rVertical.setSelected(true);
            } else {
                rNormal.setSelected(true);
            }
            this.optionsPanel.add(new JLabel("Labels:"));
            this.optionsPanel.add(rNormal);
            this.optionsPanel.add(rVertical);
            this.optionsPanel.add(bAutoFlip);
        }
        return this.optionsPanel;
    }

    public void setOrientation(int newOrientation) {
        this.orientation = newOrientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        Datapoint p;
        super.drawData(ig, startx, starty, width, height, settings);
        if (this.myWidth - (double)(this.crunchOneSideSpaceUse * 2) < 30.0) {
            this.crunchOuterMargin = SMALLER_CRUNCH_OUTER_MARGIN;
            this.crunchInnerMargin = SMALLER_CRUNCH_INNER_MARGIN;
            this.crunchAscendWidth = SMALLER_CRUNCH_ASCEND_WIDTH;
            this.crunchOneSideSpaceUse = SMALLER_CRUNCH_ONE_SIDE_SPACE_USE;
        }
        Iterator iter = this.getData();
        double topAge = settings.topAge;
        double pointTopAge = 0.0;
        double baseAge = settings.baseAge;
        double largestBaseSoFar = 0.0;
        double unitToAgeFactor = height / (settings.baseAge - settings.topAge);
        double ageLabelHeight = 0.0;
        if (this.drawAgeLabel) {
            FontMetrics fm = ig.getFontMetrics(this.fonts.getFont(1));
            ageLabelHeight = fm.getAscent();
        }
        CollisionAvoider ca = new CollisionAvoider(0.0, height, LINE_WIDTH, width, width - (double)(2 * this.crunchOneSideSpaceUse));
        ca.setAllowFlip(this.autoFlip);
        while (iter.hasNext() && largestBaseSoFar + 1.0E-6 <= settings.baseAge) {
            p = (Datapoint)iter.next();
            if (p.baseAge - 1.0E-6 <= settings.topAge) {
                pointTopAge = p.baseAge;
                continue;
            }
            largestBaseSoFar = p.baseAge;
            baseAge = Math.min(p.baseAge, settings.baseAge);
            String pLabel = p.label;
            if (p.breaker) {
                pLabel = "";
            }
            ca.add(p, unitToAgeFactor * (topAge - settings.topAge), unitToAgeFactor * (baseAge - settings.topAge), pointTopAge, p.baseAge, ig.getSWI(new RichText(pLabel, false), this.fonts.getFont(2), this.orientation), ageLabelHeight);
            topAge = baseAge;
            pointTopAge = baseAge;
        }
        if (largestBaseSoFar + 1.0E-6 < settings.baseAge) {
            p = new Datapoint();
            p.baseAge = settings.baseAge;
            p.breaker = true;
            ca.add(p, unitToAgeFactor * (largestBaseSoFar - settings.topAge), unitToAgeFactor * (settings.baseAge - settings.topAge), pointTopAge, p.baseAge, ig.getSWI(new RichText(p.label, false), this.fonts.getFont(2), this.orientation));
        }
        ca.pack();
        this.drawItems(ig, startx, starty, width, height, settings, ca, 0, ca.getNumNodes() - 1, ageLabelHeight);
        this.drawOverlays(ig, startx, starty, width, height, settings);
    }

    public void drawItems(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings, CollisionAvoider ca, int first, int last, double ageLabelHeight) {
        if (last < first) {
            return;
        }
        int cur = last;
        while (cur >= first) {
            CollisionAvoider.Node node = ca.getAt(cur);
            this.drawItem(ig, startx, starty, width, height, settings, node, ageLabelHeight);
            --cur;
        }
    }

    protected void drawItem(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings, CollisionAvoider.Node node, double ageLabelHeight) {
        Color c = null;
        Datapoint p = node.dp;
        double[] tabX = new double[12];
        double[] tabY = new double[12];
        double[] baselineX = new double[6];
        double[] baselineY = new double[6];
        String fillStyle = "stroke-width: 0; fill: none;";
        if (this.color != null && !p.breaker) {
            if (this.color.useNamed) {
                if (p != null) {
                    c = this.color.getColor(p.label);
                }
                if (c == null && p != null) {
                    c = this.color.getColor(p.popup);
                }
            }
            if (c == null) {
                c = this.color.getColor(node.origTopAge, node.origBaseAge);
            }
            if (c != null) {
                fillStyle = Coloring.getStyle(c);
            }
        }
        tabX[0] = tabX[11] = startx;
        tabX[1] = tabX[10] = startx + (double)this.crunchOuterMargin;
        tabX[2] = tabX[9] = startx + (double)this.crunchOuterMargin + (double)this.crunchAscendWidth;
        tabX[3] = tabX[8] = startx + width - (double)(this.crunchOuterMargin + this.crunchAscendWidth);
        tabX[4] = tabX[7] = startx + width - (double)this.crunchOuterMargin;
        tabX[5] = tabX[6] = startx + width;
        tabY[4] = tabY[5] = Math.max(starty + node.origTop, starty);
        tabY[1] = tabY[5];
        tabY[0] = tabY[5];
        tabY[2] = tabY[3] = starty + node.calcTop;
        tabY[9] = tabY[8] = starty + node.calcBase;
        tabY[7] = tabY[6] = Math.min(starty + node.origBase, starty + height);
        tabY[10] = tabY[6];
        tabY[11] = tabY[6];
        ig.drawPolygon(tabX, tabY, String.valueOf(LINE_STYLE) + fillStyle);
        if (node.origBaseAge + 1.0E-6 < settings.baseAge) {
            baselineX[0] = tabX[11];
            baselineX[1] = tabX[10];
            baselineX[2] = tabX[9];
            baselineX[3] = tabX[8];
            baselineX[4] = tabX[7];
            baselineX[5] = tabX[6];
            baselineY[4] = baselineY[5] = tabY[11];
            baselineY[1] = baselineY[5];
            baselineY[0] = baselineY[5];
            baselineY[2] = baselineY[3] = tabY[9];
            ig.drawPolyline(baselineX, baselineY, String.valueOf(LINE_STYLE) + "fill:none; " + Settings.getStroke(p == null ? 1 : p.lineType));
        }
        if (node.dp == null || !node.dp.breaker) {
            double sx = startx + (double)this.crunchOneSideSpaceUse;
            double wx = width - (double)(2 * this.crunchOneSideSpaceUse);
            if (!node.hasTabDown() && !node.hasTabUp()) {
                sx = startx;
                wx = width;
            }
            if (p == null || p.label == null || p.label.compareToIgnoreCase("Triassic") == 0) {
                // empty if block
            }
            ig.drawString(node.swi, sx, node.calcTop + starty, wx, node.getCalcHeight() - ageLabelHeight, 2, node.calcTop + starty, 10, fillStyle);
            if (this.drawAgeLabel) {
                ig.drawString(ig.getSWIOneLine(DataColumn.getAgeLabel(node.origBaseAge), this.fonts.getFont(1), 1), sx + 2.0, node.calcTop + starty, 20.0, node.getCalcHeight() - (double)LINE_WIDTH, 3, node.calcTop + starty, 10, fillStyle);
            }
        }
        if (p.popup != null && settings.doPopups) {
            ig.pushGrouping();
            ig.doPopupThings(p.popup);
            ig.drawPolygon(tabX, tabY, "stroke-width: 0; opacity: 0.5; fill: red;");
            ig.popGrouping();
        }
    }

    public void readOneSetting(Element setting, Settings settings) {
        super.readOneSetting(setting, settings);
        String name = setting.getAttribute("name");
        if (name != null) {
            if (name.compareToIgnoreCase("orientation") == 0) {
                String orient = setting.getAttribute("orientation");
                this.orientation = orient.compareToIgnoreCase("vertical") == 0 ? 4 : 1;
            } else if (name.compareToIgnoreCase("autoFlip") == 0) {
                this.autoFlip = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("crunchOuterMargin") == 0) {
                this.crunchOuterMargin = Integer.parseInt(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("crunchInnerMargin") == 0) {
                this.crunchInnerMargin = Integer.parseInt(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("crunchAscendWidth") == 0) {
                this.crunchAscendWidth = Integer.parseInt(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("crunchOneSideSpaceUse") == 0) {
                this.crunchOneSideSpaceUse = Integer.parseInt(Settings.getNodeTextContent(setting));
            }
        }
    }

    public void writeSettings(Element element, Document doc) {
        super.writeSettings(element, doc);
        element.appendChild(Settings.createSimpleSetting(doc, "crunchOuterMargin", "" + this.crunchOuterMargin));
        element.appendChild(Settings.createSimpleSetting(doc, "crunchInnerMargin", "" + this.crunchInnerMargin));
        element.appendChild(Settings.createSimpleSetting(doc, "crunchAscendWidth", "" + this.crunchAscendWidth));
        element.appendChild(Settings.createSimpleSetting(doc, "crunchOneSideSpaceUse", "" + this.crunchOneSideSpaceUse));
        element.appendChild(Settings.createSimpleSetting(doc, "autoFlip", "" + this.autoFlip));
        Element orientE = Settings.createSimpleSetting(doc, "orientation", "");
        if (this.orientation == 4) {
            orientE.setAttribute("orientation", "vertical");
        } else {
            orientE.setAttribute("orientation", "normal");
        }
        element.appendChild(orientE);
    }
}

