/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Settings;
import gui.TSCFont;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FontManager {
    public static final TSCFont[] defaultFonts = new TSCFont[]{new TSCFont("Arial", 0, 14.0), new TSCFont("Arial", 0, 6.0), new TSCFont("Arial", 0, 12.0), new TSCFont("Arial", 0, 12.0), new TSCFont("Arial", 2, 7.0), new TSCFont("Arial", 0, 12.0), new TSCFont("Arial", 0, 12.0), new TSCFont("Arial", 0, 6.0), new TSCFont("Arial", 0, 7.0), new TSCFont("Arial", 0, 12.0)};
    public static final String[] fontFunctions = new String[]{"Column Header", "Age Label", "Zone Column Label", "Sequence Column Label", "Event Column Label", "Popup Body", "Ruler Label", "Point Column Scale Label", "Range Label", "AgeAge Item Label"};
    public static final int COLUMN_HEADER_FONT = 0;
    public static final int AGE_LABEL_FONT = 1;
    public static final int ZONE_COL_LABEL_FONT = 2;
    public static final int SEQUENCE_COL_LABEL_FONT = 3;
    public static final int EVENT_COL_LABEL_FONT = 4;
    public static final int POPUP_FONT = 5;
    public static final int RULER_LABEL_FONT = 6;
    public static final int POINT_COL_SCALE_LABEL_FONT = 7;
    public static final int RANGE_LABEL_FONT = 8;
    public static final int AGEAGE_ITEM_LABEL_FONT = 9;
    public TSCFont[] chosenFonts = new TSCFont[defaultFonts.length];
    public FontManager parent = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    public static int[] getRelevantFonts(Class column) {
        block47: {
            block46: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("datastore.ChronColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (column == clazz) {
                    int[] nArray = new int[2];
                    nArray[1] = 1;
                    return nArray;
                }
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("datastore.PointColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (column == clazz2) {
                    int[] nArray = new int[2];
                    nArray[1] = 7;
                    return nArray;
                }
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("datastore.EventColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (column == clazz3) {
                    int[] nArray = new int[4];
                    nArray[1] = 1;
                    nArray[2] = 4;
                    nArray[3] = 8;
                    return nArray;
                }
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$3 = Class.forName("datastore.SequenceColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (column == clazz4) {
                    int[] nArray = new int[3];
                    nArray[1] = 1;
                    nArray[2] = 3;
                    return nArray;
                }
                Class<?> clazz5 = class$4;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$4 = Class.forName("datastore.ZoneColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (column == clazz5) {
                    int[] nArray = new int[3];
                    nArray[1] = 1;
                    nArray[2] = 2;
                    return nArray;
                }
                Class<?> clazz6 = class$5;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$5 = Class.forName("datastore.RulerColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (column == clazz6) {
                    int[] nArray = new int[2];
                    nArray[1] = 6;
                    return nArray;
                }
                Class<?> clazz7 = class$6;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$6 = Class.forName("datastore.AgeAgeColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (column == clazz7) {
                    int[] nArray = new int[3];
                    nArray[1] = 9;
                    nArray[2] = 6;
                    return nArray;
                }
                Class<?> clazz8 = class$7;
                if (clazz8 == null) {
                    try {
                        clazz8 = class$7 = Class.forName("datastore.MetaColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (column == clazz8) break block46;
                Class<?> clazz9 = class$8;
                if (clazz9 == null) {
                    try {
                        clazz9 = class$8 = Class.forName("datastore.BlockSeriesMetaColumn");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (column != clazz9) break block47;
            }
            return new int[1];
        }
        int[] nArray = new int[10];
        nArray[1] = 1;
        nArray[2] = 6;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 4;
        nArray[6] = 8;
        nArray[7] = 5;
        nArray[8] = 7;
        nArray[9] = 9;
        return nArray;
    }

    public static int[] uniqueArrayUnion(int[] a, int[] b) {
        int length = a.length;
        boolean[] bAdditions = new boolean[b.length];
        int i = 0;
        while (i < b.length) {
            int j = 0;
            while (j < a.length) {
                if (a[j] == b[i]) break;
                ++j;
            }
            if (j == a.length) {
                ++length;
                bAdditions[i] = true;
            } else {
                bAdditions[i] = false;
            }
            ++i;
        }
        int[] ret = new int[length];
        int i2 = 0;
        while (i2 < a.length) {
            ret[i2] = a[i2];
            ++i2;
        }
        int j = 0;
        while (j < bAdditions.length) {
            if (bAdditions[j]) {
                ret[i2] = b[j];
                ++i2;
            }
            ++j;
        }
        return ret;
    }

    public static int[] uniqueArraySubtract(int[] a, int[] b) {
        int length = 0;
        boolean[] aKeep = new boolean[a.length];
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < b.length) {
                if (a[i] == b[j]) break;
                ++j;
            }
            if (j == b.length) {
                aKeep[i] = true;
                ++length;
            } else {
                aKeep[i] = false;
            }
            ++i;
        }
        int[] ret = new int[length];
        int retIndex = 0;
        int i2 = 0;
        while (i2 < aKeep.length) {
            if (aKeep[i2]) {
                ret[retIndex] = a[i2];
                ++retIndex;
            }
            ++i2;
        }
        return ret;
    }

    public FontManager() {
    }

    public FontManager(FontManager parent) {
        this.parent = parent;
    }

    public void setParent(FontManager parent) {
        this.parent = parent;
    }

    public FontManager getParent() {
        return this.parent;
    }

    public void setFont(int which, TSCFont newFont) {
        this.chosenFonts[which] = newFont;
    }

    public void resetFont(int which) {
        this.chosenFonts[which] = this.parent == null ? defaultFonts[which] : null;
    }

    public void resetFonts() {
        if (this.parent == null) {
            int i = 0;
            while (i < this.chosenFonts.length) {
                this.chosenFonts[i] = defaultFonts[i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.chosenFonts.length) {
                this.chosenFonts[i] = null;
                ++i;
            }
        }
    }

    public TSCFont getFont(int which) {
        if (this.chosenFonts[which] != null) {
            return this.chosenFonts[which];
        }
        if (this.parent != null) {
            return this.parent.getFont(which);
        }
        return defaultFonts[which];
    }

    public TSCFont getDefaultFont(int which) {
        if (this.parent == null) {
            return defaultFonts[which];
        }
        return this.parent.getFont(which);
    }

    public String getFontSVGStyle(int which) {
        return this.getFont(which).getSVGStyle();
    }

    public static int getIndexByFunction(String func) {
        int i = 0;
        while (i < fontFunctions.length) {
            if (fontFunctions[i].compareToIgnoreCase(func) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void readSettings(Element element) {
        this.resetFonts();
        NodeList nl = element.getElementsByTagName("font");
        int elementIndex = 0;
        while (elementIndex < nl.getLength()) {
            int fontIndex;
            Element font = (Element)nl.item(elementIndex);
            String function = font.getAttribute("function");
            if (function != null && (fontIndex = FontManager.getIndexByFunction(function)) >= 0) {
                String fontSVGStyle = Settings.getNodeTextContent(font).trim();
                if (fontSVGStyle == null || fontSVGStyle.length() == 0) {
                    this.setFont(fontIndex, null);
                } else {
                    this.setFont(fontIndex, new TSCFont(fontSVGStyle));
                }
            }
            ++elementIndex;
        }
    }

    public void writeSettings(Element element, Document doc) {
        int i = 0;
        while (i < this.chosenFonts.length) {
            Element cf = doc.createElement("font");
            cf.setAttribute("function", fontFunctions[i]);
            if (this.chosenFonts[i] != null) {
                Settings.setNodeTextContent(cf, this.chosenFonts[i].getSVGStyle(), doc);
            }
            element.appendChild(cf);
            ++i;
        }
    }
}

