/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datastore.JavaCharStream;
import datastore.ParseException;
import datastore.RichTextParser;
import datastore.RichTextParserTokenManager;
import gui.TSCreator;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

public class RichText {
    String orig;
    boolean parsed;
    List lines = new Vector();
    protected static char[] breakChars = new char[]{' ', '-', ',', '/', '\\'};

    public RichText(String s) {
        this(s, false);
    }

    public RichText(String s, boolean parse) {
        this.orig = s == null ? "" : s;
        this.parsed = parse;
        this.restore();
    }

    public RichText(RichText other) {
        this(other.orig, other.parsed);
    }

    public void restore() {
        this.lines = new Vector();
        if (this.parsed && this.orig.length() > 0) {
            ByteArrayInputStream in = new ByteArrayInputStream(this.orig.getBytes());
            JavaCharStream jcs = null;
            jcs = new JavaCharStream(in);
            RichTextParserTokenManager lexer = new RichTextParserTokenManager(jcs);
            try {
                new RichTextParser(lexer).parseRichText(this);
                this.matchTags();
            }
            catch (ParseException e) {
                TSCreator.log("parse failed:\n" + e.toString());
                TSCreator.log("string:\n" + this.orig);
                TSCreator.log("endstring\n");
            }
        } else {
            Line l = new Line();
            l.addElement(new StringElement(this.orig));
            this.lines.add(l);
        }
    }

    protected void matchTags() {
        EndTagElement end;
        Stack s;
        BeginTagElement begin;
        Element e;
        Line l = this.getLine(0);
        HashMap<String, Stack<BeginTagElement>> types = new HashMap<String, Stack<BeginTagElement>>();
        int i = 0;
        while (i < l.elements.size()) {
            e = (Element)l.elements.get(i);
            if (e instanceof BeginTagElement) {
                begin = (BeginTagElement)e;
                if (begin.needsEnd) {
                    s = (Stack)types.get(begin.tagName);
                    if (s == null) {
                        s = new Stack();
                        types.put(begin.tagName, s);
                    }
                    s.push(begin);
                }
            } else if (e instanceof EndTagElement) {
                end = (EndTagElement)e;
                s = (Stack)types.get(end.tagName);
                if (s == null || s.size() == 0) {
                    l.elements.set(i, new StringElement(end.codeString()));
                } else {
                    BeginTagElement begin2 = (BeginTagElement)s.pop();
                    begin2.endTag = end;
                }
            }
            ++i;
        }
        s = new Stack();
        i = 0;
        while (i < l.elements.size()) {
            e = (Element)l.elements.get(i);
            if (e instanceof BeginTagElement) {
                begin = (BeginTagElement)e;
                if (begin.needsEnd && begin.endTag == null) {
                    l.elements.set(i, new StringElement(begin.codeString()));
                } else if (begin.needsEnd) {
                    s.push(begin);
                }
            } else if (e instanceof EndTagElement) {
                end = (EndTagElement)e;
                s.pop();
            } else if (e instanceof StringElement) {
                StringElement string = (StringElement)e;
                string.openTags.addAll(s);
            }
            ++i;
        }
    }

    public Line getLine(int i) {
        return (Line)this.lines.get(i);
    }

    public String getVis(int i) {
        return ((Line)this.lines.get(i)).getVisibleString();
    }

    public int getNumLines() {
        return this.lines.size();
    }

    public void splitOnNewlines(int maxLines) {
        int i = 0;
        while (i < this.lines.size() && (maxLines < 0 || this.lines.size() < maxLines)) {
            Line l = (Line)this.lines.get(i);
            int newline = l.getNewline();
            Line line = l.splitVisibleLine(newline, false);
            ++i;
        }
    }

    void insertAfter(Line curLine, Line newLine) {
        int i = this.lines.indexOf(curLine);
        this.lines.add(i + 1, newLine);
    }

    public void addElement(Element e) {
        if (this.lines.size() == 0) {
            this.lines.add(new Line());
        }
        Line l = (Line)this.lines.get(this.lines.size() - 1);
        l.addElement(e);
    }

    public static int getBreak(String s, int start) {
        int ret = s.indexOf(breakChars[0], start);
        int i = 1;
        while (i < breakChars.length) {
            int index = s.indexOf(breakChars[i], start);
            if (index >= 0 && index <= s.length() - 2) {
                ret = Math.min(ret, index + 1);
            }
            ++i;
        }
        return ret;
    }

    public static int getLastBreak(String s, int start) {
        int ret = s.lastIndexOf(breakChars[0], start);
        int i = 1;
        while (i < breakChars.length) {
            int index = s.lastIndexOf(breakChars[i], start);
            if (index >= 0 && index <= s.length() - 2) {
                ret = Math.max(ret, index + 1);
            }
            ++i;
        }
        return ret;
    }

    public class Line {
        List elements = new Vector(5);
        String cachedVisible = null;

        public Line splitVisibleLine(int where, boolean trim) {
            if (where <= 0) {
                return null;
            }
            this.cachedVisible = null;
            int splitStartIndex = 0;
            String vis = "";
            int lastVisLength = 0;
            Iterator iter = this.elements.iterator();
            while (iter.hasNext()) {
                Element e = (Element)iter.next();
                ++splitStartIndex;
                lastVisLength = vis.length();
                if ((vis = String.valueOf(vis) + e.visibleString()).length() - 1 >= where) {
                    if ((e = e.splitVisible(where - lastVisLength, trim)) == null) break;
                    this.elements.add(splitStartIndex, e);
                    break;
                }
                if (vis.length() != where) continue;
                trim = false;
                break;
            }
            if (splitStartIndex >= this.elements.size()) {
                return null;
            }
            Line rest = new Line();
            while (splitStartIndex < this.elements.size()) {
                rest.addElement((Element)this.elements.remove(splitStartIndex));
            }
            RichText.this.insertAfter(this, rest);
            return rest;
        }

        public int getNewline() {
            String s = this.getVisibleString();
            int i = s.indexOf(10);
            if (i < 0) {
                i = s.indexOf(13);
            }
            return i;
        }

        public int getBreak() {
            return RichText.getBreak(this.getVisibleString(), 0);
        }

        public int getBreak(int start) {
            return RichText.getBreak(this.getVisibleString(), start);
        }

        public int getLastBreak() {
            String s = this.getVisibleString();
            return RichText.getLastBreak(s, s.length());
        }

        public int getLastBreak(int start) {
            String s = this.getVisibleString();
            return RichText.getLastBreak(s, start);
        }

        public String getVisibleString() {
            if (this.cachedVisible != null) {
                return this.cachedVisible;
            }
            Iterator iter = this.elements.iterator();
            String ret = "";
            while (iter.hasNext()) {
                Element e = (Element)iter.next();
                ret = String.valueOf(ret) + e.visibleString();
            }
            this.cachedVisible = ret;
            return ret;
        }

        public String getCodeString() {
            Iterator iter = this.elements.iterator();
            String ret = "";
            while (iter.hasNext()) {
                Element e = (Element)iter.next();
                ret = String.valueOf(ret) + e.visibleString();
            }
            return ret;
        }

        public void addElement(Element e) {
            this.elements.add(e);
            this.cachedVisible = null;
        }
    }

    public static class Element {
        double width = 0.0;

        public String visibleString() {
            return "";
        }

        public String codeString() {
            return "";
        }

        public Element splitVisible(int where, boolean trim) {
            return null;
        }
    }

    public static class StringElement
    extends Element {
        public String s;
        public List openTags = new Vector();

        public StringElement(String s) {
            this.s = s;
        }

        public String visibleString() {
            return this.s;
        }

        public String codeString() {
            return this.s;
        }

        public Element splitVisible(int where, boolean trim) {
            if (where >= this.s.length()) {
                return null;
            }
            String rest = this.s.substring(where);
            this.s = this.s.substring(0, where);
            if (trim) {
                while (this.s.length() > 0 && this.s.charAt(this.s.length() - 1) == ' ') {
                    this.s = this.s.substring(0, this.s.length() - 1);
                }
                while (rest.length() > 0 && rest.charAt(0) == ' ') {
                    rest = rest.substring(1);
                }
            }
            StringElement ret = new StringElement(rest);
            return ret;
        }
    }

    public static class BeginTagElement
    extends Element {
        String tagName;
        boolean meaningful = false;
        boolean needsEnd = false;
        EndTagElement endTag = null;
        Map attributes = new HashMap();
        String styleChanges = null;

        public BeginTagElement(String tag) {
            this.tagName = tag;
            if (this.tagName.compareToIgnoreCase("a") == 0) {
                this.meaningful = true;
                this.needsEnd = true;
                this.styleChanges = "text-decoration: underline;";
                this.setAttribute("xlink:show", "other");
                this.setAttribute("visibility", "visible");
            }
        }

        public boolean isMeaningful() {
            return this.meaningful;
        }

        public void setAttribute(String attrib, String value) {
            this.attributes.put(attrib, value);
        }

        public String codeString() {
            String ret = "<" + this.tagName;
            Iterator iter = this.attributes.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                Object value = this.attributes.get(key);
                ret = String.valueOf(ret) + " " + key.toString() + "=\"" + value.toString() + "\"";
            }
            return String.valueOf(ret) + ">";
        }
    }

    public static class EndTagElement
    extends Element {
        String tagName;

        public EndTagElement(String tag) {
            this.tagName = tag;
        }

        public String codeString() {
            return "</" + this.tagName + ">";
        }
    }
}

